#ifndef NO_BULK_STATS

extern struct bulk_statlist
{
	/*
	 * Connection management.
	 */
	KSTAT_DCLMSTAT(connections);	/* Active connections */
	KSTAT_DCLSTAT(creates);		/* Connections created */
	KSTAT_DCLSTAT(starts);		/* Connections explicitly started */

	/*
	 * Sending side.
	 */
	KSTAT_DCLMSTAT(sendPackets);	/* Active send packets */
	KSTAT_DCLMSTAT(sendBytes);	/* Active send bytes */
	KSTAT_DCLSTAT(flushed);		/* Send packets flushed */
	KSTAT_DCLMSTAT(sends);		/* Active send requests */
	KSTAT_DCLSTAT(resends);		/* Packets re-sent because missed */
	KSTAT_DCLSTAT(outputs);		/* Packets transmitted */
	KSTAT_DCLSTAT(empty);		/* Senders hitting completely empty */
	KSTAT_DCLSTAT(sendacks);	/* Explicit sendacks */

	/*
	 * Receiving side.
	 */
	KSTAT_DCLSTAT(inputs);		/* Packets received */
	KSTAT_DCLSTAT(dropped);		/* Packets dropped */
	KSTAT_DCLSTAT(dups);		/* Duplicate packets */
	KSTAT_DCLSTAT(acks);		/* Acknowledges received */
	KSTAT_DCLSTAT(missed);		/* Missed detections */
	KSTAT_DCLSTAT(recvData);	/* Data packets received */
	KSTAT_DCLSTAT(recvBytes);	/* Data bytes received */
} bulk_statlist;

#ifdef BULK_STAT_INIT
struct bulk_statlist bulk_statlist =
{
	/*
	 * Connection management.
	 */
	KSTAT_INITMSTAT(connections),	/* Active connections */
	KSTAT_INITSTAT(creates),	/* Connections created */
	KSTAT_INITSTAT(starts),		/* Connections explicitly started */

	/*
	 * Sending side.
	 */
	KSTAT_INITMSTAT(sendPackets),	/* Active send packets */
	KSTAT_INITMSTAT(sendBytes),	/* Active send bytes */
	KSTAT_INITSTAT(flushed),	/* Send packets flushed */
	KSTAT_INITMSTAT(sends),		/* Active send requests */
	KSTAT_INITSTAT(resends),	/* Packets re-sent because missed */
	KSTAT_INITSTAT(outputs),	/* Packets transmitted */
	KSTAT_INITSTAT(empty),		/* Senders hitting completely empty */
	KSTAT_INITSTAT(sendacks),	/* Explicit sendacks */

	/*
	 * Receiving side.
	 */
	KSTAT_INITSTAT(inputs),		/* Packets received */
	KSTAT_INITSTAT(dropped),	/* Packets dropped */
	KSTAT_INITSTAT(dups),		/* Duplicate packets */
	KSTAT_INITSTAT(acks),		/* Acknowledges received */
	KSTAT_INITSTAT(missed),		/* Missed detections */
	KSTAT_INITSTAT(recvData),	/* Data packets received */
	KSTAT_INITSTAT(recvBytes),	/* Data bytes received */
};
KSTAT_HEAD(bulk, "BULK");
#endif BULK_STAT_INIT

#define BULK_INCSTAT(name)	KSTAT_INCSTAT(bulk,name)
#define BULK_ADDSTAT(name,value) KSTAT_ADDSTAT(bulk,name,value)
#define BULK_INCMSTAT(name)	KSTAT_INCMSTAT(bulk,name)
#define BULK_DECMSTAT(name)	KSTAT_DECMSTAT(bulk,name)
#define BULK_ADDMSTAT(name,value) KSTAT_ADDMSTAT(bulk,name,value)
#define BULK_SUBMSTAT(name,value) KSTAT_SUBMSTAT(bulk,name,value)

#else NO_BULK_STATS

#define BULK_INCSTAT(name)
#define BULK_ADDSTAT(name,value)
#define BULK_INCMSTAT(name)
#define BULK_DECMSTAT(name)
#define BULK_ADDMSTAT(name,value)
#define BULK_SUBMSTAT(name,value)

#endif NO_BULK_STATS
