static char rcsid[] = "$Header: via.c,v 800.0 85/08/06 14:17:57 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Synertek SY6522
 * See data sheet for details
 */
#include "../h/param.h"
#include "../h/time.h"
#include "../h/kernel.h"
#include "../white/config.h"
#include "../white/via.h"

int	via_bcount;

#define BELLCOUNT	80
#define BELLTIC		(hz/10)

viabstop()
{
	if (--via_bcount > 0)
		timeout(viabstop, 0, BELLTIC);
	else
		VIAADDR->v_acr = VIAADDR->v_acr & ~ACR_SR | ACR_SR0;
}

/*
 * Ring the bell for 1/2 second
 */
viabell()
{
	if (via_bcount++ > 0) {
		if (via_bcount > 5)
			via_bcount = 5;
		return;
	}
	VIAADDR->v_t2cl = BELLCOUNT;
	VIAADDR->v_t2ch = BELLCOUNT >> 8;
	VIAADDR->v_acr = VIAADDR->v_acr&~(ACR_SR|ACR_T2) | ACR_SR4|ACR_T2OS;
	VIAADDR->v_sr = 0xf0;
	timeout(viabstop, 0, BELLTIC);
}
