static char rcsid[] = "$Header: efs_host.c,v 820.1 86/12/04 19:47:37 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Maintain the list of hosts known to the
 * extended file system including changing
 * the table and looking up names.
 *
 * jam 840207-28-0424
 * jht 850426	Give unnamed bit in p_rpcflags a name: RPCFLAG_EFS_VCD
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#ifdef EFS_VCD
#include "../h/proc.h"
#endif EFS_VCD

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

/*
 * Look up the host from u.u_dirp just
 * as namei() would.  Return a pointer
 * to the host table entry for the host
 * if it exists, else return NULL.  Also
 * return NULL if the host name is too
 * long.
 */
connection_t *
efs_uhostLookup()
{
	char hostname[20];
	register char *cp = &hostname[0];

#ifdef EFS_VCD
	if ((u.u_procp->p_rpcflags & RPCFLAG_EFS_VCD) && fubyte(u.u_ap[0]) != '/') {
		register char *cwdp = (char *)u.u_stack + 5;

		while ((*cp = *cwdp++) && *cp != '/')
			if (++cp == &hostname[20])
				return(NULL);
		++u.u_dirp;
	}
	else
#endif EFS_VCD
	while ((*cp = uchar()) && *cp != '/')
		if (++cp == &hostname[20])
			return(NULL);
	--u.u_dirp;
	*cp = '\0';
	return(efs_hostLookup(hostname));
}
