static char rcsid[] = "$Header: main.c,v 800.1 85/09/24 15:50:51 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

#
/****************************************************************************

	DEBUGGER - main entry loop 

****************************************************************************/
#include "defs.h"

#ifdef KERNEL
/* Use the kernel's own includes. */
#include "../../h/stat.h"
#include "../../usr.include/setjmp.h"
#else  KERNEL
/* Use standard includes. */
#include <sys/stat.h>
#include <setjmp.h>
#endif KERNEL

MSG		NOEOR;
INT		mkfault;
INT		executing;
FILE		*infile = stdin;
FILE		*outfile = stdout;
CHAR		*lp;
ADDR		maxoff = MAXOFF;
INT		maxpos = 80;
INT		(*sigint)();
INT		(*sigqit)();
INT		wtflag;
L_INT		maxfile = 1L<<24;
STRING		errflg;
INT		exitflg;
INT		magic;
CHAR		lastc;
INT		eof;
jmp_buf		env;
INT		lastcom;
L_INT		var[36];
STRING		symfil;
STRING		corfil;
CHAR		printbuf[];
CHAR		*printptr;
CHAR		outbuf[512];
INT		argcount;

#ifdef ADB_DEBUG
int adbdebug = 1;
#endif ADB_DEBUG

long
round(a, b)
long	a, b;
{
	return(((a + b - 1)/b) * b);
}

chkerr()
{
	if (errflg || mkfault) error(errflg);
}

error(n)
char	*n;
{
	errflg = n;
	iclose(); oclose();
	longjmp(env);
}

fault(sig)
{
	signal(sig, fault);
	fseek(infile, 0L, 2);
	error(DBNAME);
}

/* nondestructive concatenation.*/
char *
concat(str1,str2)
char *str1,*str2;
{
#define BUFLEN 128
	char	buf[BUFLEN];
	register char *p;

	if (strlen(str1)+strlen(str2)>BUFLEN-2)
	{
		fprintf(stderr,"Strings (\"%s\",\"%s\") too long\n",str1,str2);
		return(NULL);
	}
	else
	{
		p = buf;
		do 
		{
			*p = *str1++;
		}
		while (*p++);
		*--p = '/';
		do
		{
			*++p = *str2++;
		}
		while (*p);
		return(buf);
	}
}

main(argc, argv)
int	argc;
char	**argv;
{
	struct stat stbuf; /* for -I option */
	lastincl = Idirs;
	if (!(stat(ADBINCLUDES,&stbuf)) && (stbuf.st_mode&S_IFDIR))
		*lastincl++ = ADBINCLUDES;

#ifdef s32
	/*
	 * Determine page just above user stack.
	 * Assumes that no more than 1 page of
	 * arguments have been passed to adb.
	 */
	usrtop = mytop = ((int)&argc >> 12) + 1;
#endif s32
	ioctl(0, TIOCGETP, &adbtty);
	ioctl(0, TIOCGETP, &subtty);
	ioctl(0, TIOCGETC, &adbtch);
	ioctl(0, TIOCGETC, &subtch);

	while (argc > 1)
		/* if we have an argument of the form "-?", ? a non-null */
		if ((*argv[1] == '-')&&(*(argv[1]+1) != '\0'))
		{
			switch (*(argv[1]+1)) 
			{
				default:
					fprintf(stderr,"Bad option \"%s\"\n",argv[1]);
					break;
				case 'I':
					/* sanity check -- new stuff for adb */
					if ((stat(argv[1]+2,&stbuf)==-1)||(!(stbuf.st_mode&S_IFDIR)))
					{
						fprintf(stderr,"Bad directory \"%s\"\n",argv[1]+2);
					}
					else
					{
						/* push(include directory,include stack); */
						if ((lastincl - Idirs) / sizeof(CHAR *) > MAXINCLS)
							fprintf(stderr,"Too many -I directories\n");
						else
							*(lastincl++) = argv[1]+2;
					}
					break;
				case 'w':
					wtflag = 2;
					break;
			}
			argc--; argv++;
		}
		else break;
	if (argc > 1) symfil = argv[1];
	if (argc > 2) corfil = argv[2];
	argcount = argc;

	setsym(); setcor(); setvar();

	printf("ready\n");
	if ((sigint = signal(SIGINT, SIG_IGN)) != SIG_IGN)
	{
		sigint = fault;
		signal(SIGINT, fault);
	}
	sigqit = signal(SIGQUIT, SIG_IGN);
	setjmp(env);

	if (executing == TRUE) delbp();
	executing = FALSE;

	while(1)
	{
		flushbuf();
		if (errflg)
		{
			printf("%s\n", errflg);
			exitflg = (int)errflg;
			errflg = 0;
		}
		if (mkfault)
		{
			mkfault=0; printc(EOR); prints(DBNAME);
		}
		lp = 0; rdc(); lp--;
		if (eof)
		{
			if (infile != stdin)
			{
				iclose(); eof=0;
				longjmp(env);
			} else done();
		} else exitflg = 0;
		command(0, lastcom);
		if (lp && (lastc != EOR)) error(NOEOR);
	}
}

done()
{
	endpcs();
	exit(exitflg);
}

