/* rcsid[]="$Header: cmap.h,v 820.1 86/12/04 19:48:40 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	cmap.h	6.1	83/07/29	*/

/*
 * core map entry
 */
struct cmap
{
unsigned int 	c_next:13,	/* index of next free list entry */
		c_prev:13,	/* index of previous free list entry */
		c_mdev:4,	/* which mounted dev this is from */
		c_lock:1,	/* locked for raw i/o or pagein */
		c_want:1,	/* wanted */

		c_page:16,	/* virtual page number in segment */
		c_hlink:13,	/* hash link for <blkno,mdev> */
		c_intrans:1,	/* intransit bit */
		c_free:1,	/* on the free list */
		c_gone:1,	/* associated page has been released */

		c_type:2,	/* type CSYS or CTEXT or CSTACK or CDATA */
		c_blkno:20,	/* disk block this is a copy of */
		c_ndx:10;	/* index of owner proc or text */
#ifdef s32
unsigned int	c_shcount:6,	/* count of processes sharing this page */
		c_pcsize:13,	/* size in clicks of physically contiguous
				   group that this click is the tail of
				   (zero if this click is not the tail) */
		c_pctail:13;	/* cmap index of last click of physically
				   continguous group that this click is
				   contained in */
#endif s32
};

#define	CMHEAD	0

/*
 * Shared text pages are not totally abandoned when a process
 * exits, but are remembered while in the free list hashed by <mdev,blkno>
 * off the cmhash structure so that they can be reattached
 * if another instance of the program runs again soon.
 */
#define	CMHSIZ	512		/* SHOULD BE DYNAMIC */
#define	CMHASH(bn)	((bn)&(CMHSIZ-1))

#ifdef	KERNEL
struct	cmap *cmap;
struct	cmap *ecmap;
int	ncmap;
struct	cmap *mfind();
int	firstfree, maxfree;
int	ecmx;			/* cmap index of ecmap */
short	cmhash[CMHSIZ];
#endif	KERNEL
#ifdef s32
int	wantpcmem;		/* min of number of physically contiguous
				   clicks being slept for at makpcont.  The
				   sleep is for the address of this variable */

int	maxpcmem;		/* size of biggest block of physically
				   contiguous memory (only true approximately--
				   don't rely on this value */

short	sizeofcmapEntry;	/* # bytes in an entry */
#endif s32

/* bits defined in c_type */

#define	CSYS		0		/* none of below */
#define	CTEXT		1		/* belongs to shared text segment */
#define	CDATA		2		/* belongs to data segment */
#define	CSTACK		3		/* belongs to stack segment */

#define	pgtocm(x)	((((x)-firstfree) / CLSIZE) + 1)
#define	cmtopg(x)	((((x)-1) * CLSIZE) + firstfree)
