/*
 * bvs 841101
 * jht 860324	Fix rpc_clientClass initialization values
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"

#define RPC_CLASS_TIME	5
#define RPC_TIME_GET	0
#define RPC_TIME_SET	1

int timeClient_exception();

extern caddr_t prpc_call();
extern int prpc_return();
extern int prpc_error();

rpc_clientClass_t timeClientClass =
{
	(struct rpc_clientClass *) 0,	/* Forward ptr to next class in list */
	(struct rpc_clientClass *) 0,	/* Bkward  ptr to next class in list */
	"time",				/* Class name			     */
	RPC_CLASS_TIME,			/* Class number			     */
	prpc_return,			/* Function to call with return pkt  */
	prpc_error,			/* Function to call with error	     */
	timeClient_exception,		/* Function to call on exception     */
	0,				/* Maximum failure rate (exponent)   */
	60				/* Maximum wait (in HZ) for a call   */
};

timeClient_exception()
{
}

timeClient_get(conn, t)
	connection_t * conn;
	struct timeval * t;
{
	register caddr_t timeresults;

	u.u_error = 0;
	timeresults = prpc_call(&timeClientClass, conn, RPC_CLASS_TIME,
					RPC_TIME_GET, NULL);
	if (!u.u_error)
		bcopy((struct timeval *)timeresults, t, sizeof(*t));
	rpc_freeResults(timeresults);
	return u.u_error;
}

timeClient_set(conn, t)
	connection_t * conn;
	struct timeval * t;
{
	register caddr_t timeresults;
	struct timeval * param;

	param = (struct timeval *)rpc_allocParams(sizeof *t, 0);
	bcopy(t, param, sizeof(*t));
	u.u_error = 0;
	timeresults = prpc_call(&timeClientClass, conn, RPC_CLASS_TIME,
					RPC_TIME_SET, (caddr_t)param);
	rpc_freeResults(timeresults);
	return u.u_error;
}

timeClient_setlocal(conn, t)
	connection_t * conn;
	struct timeval * t;
{
	register caddr_t timeresults;

	timeresults = prpc_call(&timeClientClass, conn, RPC_CLASS_TIME,
					RPC_TIME_GET, NULL);
	if (!u.u_error) {
		bcopy((struct timeval *)timeresults, t, sizeof(*t));
		setthetime((struct timeval *)timeresults);
	}
	rpc_freeResults(timeresults);
	return u.u_error;
}
