/* rcsid[] = "$Header: exreg.h,v 820.1 86/12/04 19:55:28 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1985				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/* EXOS 201 Multibus Ethernet Controller Definitions */

/* This file reflects 4.4,5.0 ROM and EXOS/201 documentation 9/20/84 */

/*
 * N.B. Communication structures below are carefully constructed so
 *	that they correspond to the message formats that NX firmware
 *	defines.  None of them should contain any compiler-instigated
 *	padding.  Be especially careful about longword alignment!
 */

/****************************************************************
 * I/O Port Definitions						*
 *								*
 *	Port	Read	  Write					*
 *	----	----	  -----					*
 *	  A	 Reset	   Clear Interrupt from EXOS		*
 *	  B	 Status	   1 byte Data (Int to EXOS)		*
 *								*
 *	Note: The order of the ports in the structure below is	*
 *	non-intuitively backwards.  The I/O space is mapped	*
 *	through the memory mapping hardware.  The 68000 inverts	*
 *	the sense of the LSB of addresses on byte accesses.	*
 *	Thus the port definitions here are swapped to		*
 *	compensate.						*
 *								*
 ****************************************************************/

struct exdevice
    {
    u_char portb;
    u_char porta;	
    };

/* I/O PORT B status bit definitions */

#define	EX_TESTOK	0x01	/* Set when self-diagnostics passed */
#define EX_INTERRUPT	0x02	/* Set when interrupt pending from EXOS */
#define	EX_UNREADY	0x08	/* Set until EXOS ready to read from B */

/************************************************************************
 * Configuration Message						*
 *									*
 *	This is sent to the EXOS 201 after a reset has been		*
 *	executed.  It selects the controller mode and points to		*	
 *	the circular queues for request and reply messages.		*
 *	It also contains information that is used to negotiate		*
 *	the byte swapping and address interpretation of each message.	*
 *									*
 ************************************************************************/

struct confmsg
    {
/*00*/	u_short	rsrv1;		/* Reserved, must be 1 */
/*02*/	char	vc[4];		/* Returns ASCII version code */
/*06*/	u_char	cc;		/* Returns config completion code */
/*07*/	u_char	opmode;		/* Specifies operation mode */
/*08*/	u_char	dfo[2];		/* Specifies host data format option */
/*10*/	u_char	dcn[3];		/* Reserved, must be 1,0,0 */
/*13*/	u_char	ham;		/* Specifies host address mode */
/*14*/	u_char	rsrv3;		/* Reserved, must be 0 */
/*15*/	u_char	mapsiz;		/* Reserved, must be 0 */
/*16*/	u_char	byteptrn[4];	/* Host data format option test pattern */
/*20*/	u_short	wordptrn[2];
/*24*/	u_long	lwordptrn;
/*28*/	u_char	rsrvd[20];
/*48*/	u_long	mba;		/* Use 0xFFFFFFFF in link level mode */
/*52*/	u_char	nproc;		/* Use 0xFF in link level mode */
/*53*/	u_char	nmbox;		/* Use 0xFF in link level mode */
/*54*/	u_char	nmcast;		/* Use 0xFF in link level mode */
/*55*/	u_char	nhost;		/* Use 1 in link level mode */

    /* Request message queue */

/*56*/	u_long	h2xba;		/* Base address of message queue */
/*60*/	u_short	h2xhdr;		/* Address offset of msg Q header */
/*62*/	u_char	h2xtyp;		/* Interrupt type */
/*63*/	u_char	h2xval;		/* Interrupt value (not used) */
/*64*/	u_short	h2xaddr;	/* Interrupt vector */
/*66*/	u_short	h2xpad;		/* Pad out unused portion of vector */

    /* Reply message queue */

/*68*/	u_long	x2hba;		/* Base address of message queue */
/*72*/	u_short	x2hhdr;		/* Address offset of msg Q header */
/*74*/	u_char	x2htyp;		/* Interrupt type */
/*75*/	u_char	x2hval;		/* Interrupt value (not used) */
/*76*/	u_short	x2haddr;	/* Interrupt vector */
/*78*/	u_short	x2hpad;		/* Pad out unused portion of vector */
/*80*/
    };


/* confmsg.opmode definitions */

#define EX_OPMDLL	0	/* Data Link Mode */
#define EX_OPMFEP	1	/* Host downloaded Front End Processor */
#define EX_OPMNET	2	/* Net downloaded Front End Processor */


/* confmsg.dfo definitions */

#define EX_DFOadapt	0x01	/* Adapt to host's data representation */


/* confmsg.ham definitions */

#define EX_HAMset	0x01	/* Set host address mode */
#define EX_HAMabsolute	0x02	/* Select absolute mode */


/* confmsg.h2xtyp and confmsg.x2htyp definitions */

#define EX_INTnone	0	/* No interrupt will be used */
#define EX_INTio	1	/* Interrupt by writing to I/O space */
#define EX_INTmem	2	/* Interrupt by writing to memory space */
#define EX_INTlevel	3	/* Multibus level interrupt */

/************************************************************************
 * Standard EXOS message header						*
 *									*
 *	Each message in the request and reply message queues has the	*
 *	following message header.  Note that the EXOS controller does	*
 *	not see the "next" field.  The next field is contains a virtual	*
 *	address queue link; the "link" field contains an EXOS format	*
 *	queue link offset.						*
 *									*
 ************************************************************************/

struct exMessage
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of rest of message */

/*06*/	u_char	exsap;		/* EXOS Service Access Point */
/*07*/	u_char	hsap;		/* Host Service Access Point */

/*08*/				/* Start of data portion  */
    };

/* Definitions for exMessage.status */

#define	MH_OWNER	0x01	/* Mask for status bit for owner */
#define	MH_HOST		0	    /* (MH_OWNER) The host owns the buffer */
#define	MH_EXOS		1	    /* (MH_OWNER) The EXOS owns the buffer */
#define MH_DONE		0x02	/* 0 => New buffer, 1 => processed buffer */

/* Definitions for exMessage.exsap and exMessage.hsap */

#define EXSAP_DLL	0	/* Data Link Level */
#define EXSAP_TCI	4	/* TCI DECnet */

#define HSAP_DLL	0	/* Data Link Level */
#define HSAP_TCI	1	/* TCI DECnet */

/************************************************************************
 ************************************************************************
 **								       **
 **		Data Link Level INTERFACE DEFINITIONS		       **
 **								       **
 ************************************************************************
 ************************************************************************/

/************************************************************************
 * Standard EXOS DLL mode message header				*
 *									*
 *	Each DLL message in the request and reply message queues has 	*
 *	the following message header.					*
 *									*
 ************************************************************************/

struct exDLLhdr
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code */
/*13*/	u_char	reply;		/* Reply code */

/*14*/				/* Start of request specific portion */
    };


/* Link Level request codes for exDLLhdr.request */

#define NET_DLOAD	0x00	/* Write download data into EXOS memory */
#define NET_START	0x02	/* Jump to start address of downloaded code */

#define	LLNET_MODE	0x08	/* Read/write mode control objects */
#define	LLNET_ADDRS	0x09	/* Read/write receive address slots */
#define	LLNET_RECV	0x0A	/* Read/alter receive slot enable bit */
#define	LLNET_STSTCS	0x0B	/* Read/reset network statistics objects */
#define	LLTRANSMIT	0x0C	/* Send a packet */
#define	LLRECEIVE	0x0D	/* Receive a packet */
#define	LLRTRANSMIT	0x0E	/* Send a packet, and self-receive */


/* Common Link Level return codes exDLLhdr.reply */

#define	LL_OK		0	/* Successful completion */
#define	LLX_MODE	0xA1	/* EXOS not in correct mode for request */


/* Request mask bit definitions */

#define	WRITE_OBJ	0x01	/* Write the object */
#define	READ_OBJ	0x02	/* Read the object */
#define	ENABLE_RCV	0x04	/* Enable reception on designated slot */

/************************************************************************
 * LLNET_MODE request/reply						*
 *									*
 *	This message is used to read/write the network controller mode	*
 *	and options mask.						*
 *									*
 ************************************************************************/

struct net_mode
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LLNET_MODE) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	mask;		/* Bit-wise switches for read, write */
/*15*/	u_char	options;	/* Acceptable packet reception errors */
/*16*/	u_char	mode;		/* Packet transmit/receive modes */
/*17*/
    };

/* net_mode.options mask bit definitions */

#define	OPT_ALIGN	0x10	/* Receive packets with alignment errors */
#define	OPT_CRC		0x20	/* Receive packets with CRC errors */
#define	OPT_DSABLE	0x80	/* Disconnect controller hardware */


/* net_mode.mode field value definitions */

#define	MODE_OFF	0	/* Stop transmission and reception */
#define	MODE_PERF	1	/* Perfect multicast address filtering */
#define	MODE_HW		2	/* Hardware-only multicast address filtering */
#define	MODE_PROM	3	/* Promiscuous reception */

/************************************************************************
 * LLNET_ADDRS request/reply						*
 *									*
 *	This request is used to read/write an Ethernet address into a	*
 *	specified address (match) slot.					*
 *									*
 ************************************************************************/

struct net_addrs
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LLNET_ADDRS) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	mask;		/* Bit-wise switches for read, write */
/*15*/	u_char	slot;		/* Index of address slot */
/*16*/	u_char	addrs[6];	/* Ethernet address read and/or written */
/*22*/
    };

/* LLNET_ADDRS unique reply codes (net_addrs.reply) */

#define	LLNA_BADSLOT	0xD1	/* Slot doesn't exist or can't be accessed */
#define	LLNA_BADADDR	0xD3	/* Invalid address for designated slot */


/* address slot object indices */

#define	NULLSLOT	0	/* The null slot */
#define	MINMCSLOT	1	/* Minimum multicast slot index */
#define	MAXMCSLOT	8	/* Default maximum multicast slot index */
#define	PHYSSLOT	253	/* Physical slot index */
#define	UNVRSSLOT	254	/* Universal slot index */
#define	BROADSLOT	255	/* Broadcast slot index */

/************************************************************************
 * LLNET_RECV request/reply						*
 *									*
 *	This request is used to read/write the receive status of an	*
 *	address (match) slot.						*
 *									*
 ************************************************************************/

struct net_recv
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LLNET_RECV) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	mask;		/* Bit-wise switches for read, write */
/*15*/	u_char	slot;		/* Index of address slot (see NET_ADDRS) */
/*16*/
    };

/* LLNET_RECV unique reply codes (net_recv.reply) */

#define	LLNR_BADSLOT	0xD1	/* Slot doesn't exist or can't be accessed */
#define	LLNR_BADADDR	0xD2	/* Designated slot was empty */

/************************************************************************
 * LLNET_STSTCS request/reply						*
 *									*
 *	This request reads/resets the statistics objects maintained by	*
 *	the EXOS controller.						*
 *									*
 ************************************************************************/

struct	net_ststcs
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LLNET_STSTCS) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	mask;		/* Bit-wise switches for read, write */
/*15*/	u_char	rsrv2;		/* Reserved for EXOS */
/*16*/	u_short	numobj;		/* Number of objects to work on */
/*18*/	u_short	objindx;	/* Index of first object to work on */
/*20*/	u_long	bufptr;		/* Pointer to statistics array (stat_array) */
/*24*/
    };


struct stat_array
    {
    u_long fsent;	/* Frames sent without errors */
    u_long xsclsn;	/* Frames aborted w/excess collisions */
    u_long nsqe;	/* Frames subject to heartbeat failure */
    u_long undef;	/* Undefined (TDR on EXOS 101) */
    u_long frcvd;	/* Frames received w/no errors */
    u_long align;	/* Frames received w/alignment error */
    u_long crc;		/* Frames received w/crc error */
    u_long flost;	/* Frames lost */
    };

/************************************************************************
 * LLTRANSMIT and LLRTRANSMIT request/reply				*
 *									*
 *	These requests transmit packets onto the Ethernet.  The		*
 *	LLRTRANSMIT also specifies that the packet should be "self-	*
 *	received" by the EXOS controller.				*
 *									*
 ************************************************************************/

/* Ethernet packet data size constants */

#define	NFRAGMENTS 8	/* Number fragments that the EXOS will scatter/gather */
#define	EXMAXRBUF 1520	/* Per EXOS 101 manual 5.3.7 (maybe 1518 would do) */

/*
 * Array below is really a single u_long field.
 * It is kludged to defeat word-alignment.
 * Access would look like:
 *     longaddr = *(u_long *)bp->et.blks[0].address;
 */

struct	buf_blk
    {
    u_short	length;		/* Length of block, in bytes */
    u_short	address[2];	/* Address of data */
    };


struct enet_xmit
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LL[R]TRANSMIT) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	slot;		/* Address slot matching dest address */
/*15*/	u_char	nblock;		/* Number of blocks composing packet */
/*16*/	struct	buf_blk blks[NFRAGMENTS];	/* Array of block descriptors */
/*22-64*/
    };


/* LLTRANSMIT and LLRTRANSMIT unique reply codes (enet_xmit.reply) */

#define	LLXM_1RTRY	0x01	/* Successful transmission, 1 retry */
#define	LLXM_RTRYS	0x02	/* Successful transmission, more than 1 retry */
#define	LLXM_NSQE	0x08	/* Successful transmission, no SQE TEST signl */
#define	LLXM_CLSN	0x10	/* Transmission failed, excess retries */
#define	LLXM_NCS	0x20	/* Transmission failed, no carrier sense */
#define	LLXM_LNGTH	0x40	/* Transmission failed, bad packet length */
#define	XMIT_BITS	"\7\7LENGTH\6CARRIER\5XCLSNS\4SQETST"
#define	LLXM_ERROR	(LLXM_NSQE|LLXM_CLSN|LLXM_NCS|LLXM_LNGTH)

/************************************************************************
 * LLRECEIVE request/reply						*
 *									*
 *	This request posts a set of buffers for the EXOS processor to	*
 *	receive an incoming packet into.				*
 *									*
 ************************************************************************/

struct enet_recv
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= LLRECEIVE) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_char	slot;		/* Address slot matching dest address */
/*15*/	u_char	nblock;		/* Number of blocks composing buffer */
/*16*/	struct	buf_blk blks[NFRAGMENTS];	/* Array of block descriptors */
/*22-64*/
    };

/* LLRECEIVE unique reply codes (enet_recv.reply) */

#define	LLRC_TRUNC	0x04	/* Pkt received, but truncated to fit buffer */
#define	LLRC_ALIGN	0x10	/* Pkt received, but with alignment error */
#define	LLRC_CRC	0x20	/* Pkt received, but with CRC error */
#define	LLRC_BUFLEN	0x40	/* No pkt received, buffer less than 64 bytes */
				/*   This should never happen here */

#define	RECV_BITS	"\7\7BUFLEN\6CRC\5ALIGN\3TRUNC"

/************************************************************************
 * NET_DLOAD request/reply						*
 *									*
 *	This message sends a packet of data from host memory into EXOS	*
 *	memory.  This is normally used to download code.		*
 *									*
 ************************************************************************/

struct net_load
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= NET_DLOAD) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_short	count;		/* Number of bytes to down load */
/*16*/	caddr_t	source;		/* Address of data source in host memory */
/*20*/	u_long	dest;		/* Segmented address of destination in EXOS */
/*24*/	u_char	xmbyte;		/* Buffer for one byte transfers */
/*25*/
    };

/* NET_DLOAD unique reply codes (net_load.reply) */

#define NETDL_OVRLAP	0xa3	/* Destination overlaps NX200 memory */

/************************************************************************
 * NET_START request/reply						*
 *									*
 *	This message causes the NX to start execution at the specified	*
 *	address.							*
 *									*
 ************************************************************************/

struct net_start
    {
	struct exMessage *next;	/* (Virtual space) pointer to next message */

    /* Standard EXOS message header */

/*00*/	u_short	link;		/* Link to next buffer in 64k segment */
/*02*/	u_char	rsrv;		/* Reserved for use by EXOS */
/*03*/	u_char	status;		/* Message buffer status (see below) */
/*04*/	u_short	length;		/* Length, in bytes, of the following data */

/*06*/	u_char	exsap;		/* EXOS Service Access Point (= EXSAP_DLL) */
/*07*/	u_char	hsap;		/* Host Service Access Point (= HSAP_DLL) */

    /* Standard EXOS DLL mode header */

/*08*/	long	mid;		/* Host user specific message identifier */
/*12*/	u_char	request;	/* Request code (= NET_START) */
/*13*/	u_char	reply;		/* Reply code */

    /* Message specific data */

/*14*/	u_long	start;		/* Segmented starting address in EXOS */
/*18*/
    };

/* NET_START unique reply codes (net_load.reply) */

#define NETST_BADADDR	0xa2	/* Invalid starting address, not started */

/************************************************************************
 * EXOS Message								*
 *									*
 *	This structure is the union of all messages that are used in	*
 *	communications with the EXOS 201.
 *	Note that all messages should be changed with caution; it is	*
 *	specified by the message definition of the EXOS board; byte	*
 *	alignment is critical.						*
 *									*
 ************************************************************************/


/* EXOS<->Host message format */

union exEXOSmessage
    {
/* Generic messsage */

    struct exMessage	exMessage;	/* Lowest level comm header */

/* Data Link Level Mode message */

    struct exDLLhdr	exDLLhdr;	/* Comm header plus DLL header */

    struct net_load	net_load;	/* NET_DLOAD request/reply */
    struct net_start	net_start;	/* NET_START request/reply */

    struct net_mode	net_mode;	/* LLNET_MODE request/reply */
    struct net_addrs	net_addrs;	/* LLNET_ADDRS request/reply */
    struct net_recv	net_recv;	/* LLNET_RECV request/reply */
    struct net_ststcs	net_ststcs;	/* LLNET_STSTCS request/reply */
    struct enet_xmit	enet_xmit;	/* LL[R]TRANSMIT request/reply */
    struct enet_recv	enet_recv;	/* LLRECEIVE request/reply */

/* TCI/EXCELAN DECnet FEP messages */

#if NXL > 0
    struct decnet_exos	exDECnetHdr;	/* Comm header plus DECnet header */
#endif
    };


/* Maximum length of the message mode data block (exMessage.length) */

#define	MBDATALEN (sizeof(union exEXOSmessage)-sizeof(struct exMessage)+2)
