/* rcsid[] = "$Header: omni.h,v 820.1 86/12/04 19:56:06 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1985				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
/*
 *	Omninet constants
 *  
 *	(c) Copyright 1983, Corvus Systems Inc., San Jose California  
 *	    Rights to this software are subject to your license  
 *	    agreement with Corvus Systems and ATT  
 */

/* Omninet transporter commands */

#define OMNIIDENT 	0x01	/* get my transporter address */
#define OMNIECHO 	0x02	/* do a transporter echo */
#define OMNIMEM 	0x08	/* peek/poke the transporter guts */
#define OMNIEND 	0x10	/* disable skt for recieve */
#define OMNIINIT 	0x20	/* initialize transporter internals */
#define OMNISND 	0x40	/* send packet to destination */
#define OMNIRCV 	0xf0	/* set up recieve on skt */

/* Omninet transporter return codes */

#define SUCCESS 	0	/* command success completion */
#define NOACK 		0x80	/* no ack after max retries */
#define TOOLONG		0x81	/* packet too long for reciever buffer */
#define UNINIT		0x82	/* sent to initialized skt */
#define CNTLNEQ		0x83	/* control len != on both ends */
#define INVSKT		0x84	/* invalid skt */
#define SKINUSE		0x85	/* recieve skt in use */
#define BADADDR		0x86	/* bad transporter address */
#define ECHOACK		0xC0	/* echo ack recieved */
#define RSETUP		0xFE	/* recieve skt successfully set up */

/*
 * Omninet Broadcast Address
 */
#define OMNIBROADADDR	0xFF


/*
 * Max Omninet Transmission Unit
 */
#define OMNIMTU		2048


/*
 * Maximum size of a transmit buffer
 */
#define XMITMAXSIZ	OMNIMTU

/*
 * Maximum size of a receive buffer
 */
#define RCVMAXSIZ	OMNIMTU

/*
 * Generic Omninet command control block format
 */
struct omniccb
{
	unsigned char cmd;
	unsigned char rslt;
	short fill;
	union
	{
		struct
		{
			unsigned char skt;
			unsigned char data;	
			short fill;
			short len;
			unsigned char ctl;
			unsigned char host;
		} snd;
		struct
		{
			unsigned char skt;
			unsigned char data;
			short fill;
			short len;
			unsigned char ctl;
		} rcv;
		struct
		{
			unsigned char skt;
		} end; 
		struct
		{
			unsigned char host;
		} echo;
		struct
		{
			short maddr;
			unsigned char mtype;
			unsigned char mval;
		} mem;
	} c_un;
};

/*
 * Generic Omninet result record format
 */
struct omnirslt
{
	unsigned char rcode;
	unsigned char host;
	short len;
	unsigned char ucb[12];
};

/*
 * Omni header format.  The Omni header is the format used by VALID
 * to send packets out over the Omninet.  The paradigm is the header
 * used in Ethernet packets.  We need to leave enough space for
 * future enhancements (internetworking, etc.)
 */
struct omniheader {
	u_char	omnimagic;	/* Magic number = 0x01 */
#define OMNIMAGIC	0x01
	u_char	omnitype;	/* Analogous to Ethertype */
#ifdef INET
#define OMNITYPE_IP	0x1
#define OMNITYPE_ARP	0x2
#endif INET
#ifdef VALIDnet
#define OMNITYPE_BCAST	0x10
#define OMNITYPE_RPC	0x11
#define OMNITYPE_CONN	0x12
#define OMNITYPE_BULK	0x13
#endif VALIDnet
	u_char	omnidst;	/* Destination address */
	u_char  omnisrc;	/* Source adddress */
	u_short	omnilen;	/* Length of Omninet packet */
	int	omnisum;	/* Check sum of rest of packet */
	u_char 	omnifill[6];	/* 6 bytes of fill */
};

/*
 * per-controller statistics structure
 */
struct omnistats {
	int	xmitbcast;	/* Transmit broadcast packet */
	int	xmitsingle;	/* Transmit point-to-point packet */
	int	xmitqfull;	/* Transmit queue was full */
	int	xmitqueued;	/* Number of transmit packets queued */
	int	xmitloop;	/* Number of loop-back packets */
	int	rcvstrobed;	/* Number of receive packets strobed */
	int	rcvnostrobe;	/* Number of failures in receive strobe */
	int	rcvnointr;	/* No receive interrupt */
	int	badsetrcv;	/* Number of bad setups */
	int	xmitEmpty;	/* Xmit queue was empty */
	int	xmitOut;	/* Xmit was strobed */
	int	xmitFail;	/* Xmit strobe failed */
	int	xmit80;		/* Xmit gives error 80 */
	int	xmit81;		/* Xmit gives error 81 */
	int	xmit82;		/* Xmit gives error 82 */
	int	xmit83;		/* Xmit gives error 83 */
	int	xmit84;		/* Xmit gives error 84 */
	int	xmit86;		/* Xmit gives error 86 */
	int	xmitGood;	/* Xmit gives no error */
	int	xmitBad;	/* Xmit gives unknown error */
	int	rcvBadMagic;	/* A receive pkt had a bad magic # */
	int	rcvBadVhdr;	/* Bad Valid DLL Header */
	int	rcvOK;		/* Successful receive */
	int	rcvQFull;	/* Receive queue was full */
	int	rcvBadValid;	/* No known Omnitype */
	int	rcvNoChange;	/* No change in the setup result code */
	int	rcvoutintr;	/* There was a receive and outi intr */
	int	rcvintrset;	/* Interrupt set */
	int	sndrcvintr;	/* Send/receive intr */
	int	spin2;		/* Spin count < 2 */
	int	spin5;		/* Spin count < 5 */
	int	spin10;		/* Spin count < 10 */
	int	spin20;		/* Spin count < 20 */
	int	spin100;	/* Spin count < 100 */
	int	spinout;	/* Spin count >= 100 */
	int	intrlost;	/* Interrupts lost */
	int	nointrlost;	/* No interrupts lost */
	int	reset;
	int	userreset;	/* User reset */
	int	outNoBufs;	/* output had no mbufs */
	int	outBadAddr;	/* output had bad address */
	int	strobe400;
	int	strobe800;
	int	strobe1000;
	int	strobe2000;
	int	strobe3000;
	int	strobe4000;
	int	strobe8000;
	int	retry20;
	int	retry40;
	int	retry60;
	int	retry80;
	int	retry100;
	int	retry128;
};
