/* rcsid[]="$Header: screg.h,v 820.1 86/12/04 19:56:27 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Signetics 2661 UART
 */

#define NLINE	2
#define CONSOLE	0				/* console is line 0. */
#define	CADDR	((struct scdevice *)0x01c800)	/* console address */
#define	HADDR	((struct scdevice *)0x01c000)	/* "host" address */
#define SCADDR(l)	((l) == CONSOLE ? CADDR : HADDR)

struct scdevice {
	u_char sc0;
	u_char scdr;			/* data register */
	u_char sc1;
	u_char scsr;			/* status register */
	u_char sc2;
	u_char scmr;			/* mode register */
	u_char sc3;
	u_char sccr;			/* command register */
};

	/* sccr bits */
#define SCCR_MODE	0xc0
#define SCCR_MODE0	0x00		/* normal mode */
#define SCCR_RTS	0x20
#define SCCR_CLR	0x10		/* clear error */
#define SCCR_BRK	0x08		/* force break, async mode */
#define SCCR_RXEN	0x04		/* receive enable */
#define SCCR_DTR	0x02
#define SCCR_TXEN	0x01		/* transmit enable */
#define SCCR_NORMAL	SCCR_MODE0

	/* scsr bits */
#define SCSR_DSR	0x80
#define SCSR_DCD	0x40
#define SCSR_FE		0x20		/* framing error, async mode */
#define SCSR_OE		0x10		/* overrun error */
#define SCSR_PE		0x08		/* parity error, async mode */
#define SCSR_TXEMT	0x04
#define SCSR_RXRDY	0x02		/* receive ready */
#define SCSR_TXRDY	0x01		/* transmit ready */

	/* scmr 1 */
#define SCMR1_STOP	0xc0		/* stop bits, async mode */
#define SCMR1_STOP1	0x40		/* 1 stop bit */
#define SCMR1_STOP1_5	0x80		/* 1.5 stop bits */
#define SCMR1_STOP2	0xc0		/* 2 stop bits */
#define SCMR1_PEVEN	0x20
#define SCMR1_PEN	0x10		/* parity enable */
#define SCMR1_LEN	0x0c		/* character length */
#define SCMR1_LEN5	0x00
#define SCMR1_LEN6	0x04
#define SCMR1_LEN7	0x08
#define SCMR1_LEN8	0x0c
#define SCMR1_MD	0x03		/* mode */
#define SCMR1_MDSYNC	0x00
#define SCMR1_MDAS1	0x01		/* async, baud 1x if external */
#define SCMR1_MDAS16	0x02		/* async, baud 16x if external */
#define SCMR1_MDAS64	0x03		/* async, baud 64x if external */
#define SCMR1_NORMAL	SCMR1_MDAS1	/* any async mode is ok */

	/* scmr 2, see specs */
#define SCMR2_BRKDET	0x80		/* pin 25 brkdet, if RXC */
#define SCMR2_1X	0x40		/* pin 9 16x, if TXC */
#define SCMR2_TXC	0x20		/* internal transmit clock */
#define SCMR2_RXC	0x10		/* internal receive clock */
#define SCMR2_NORMAL	(SCMR2_BRKDET|SCMR2_TXC|SCMR2_RXC)
#define SCMR2_BAUD	0x0f
