#define	MAXDPC		8		/* Maximum number of disks per
					 * controller, currently 8 for the
					 * Rimfire controller series
					 */
typedef struct s32_badtrks {
	u_short		sb_cyl;		/* Cylinder number */
	u_short		sb_head;	/* Track number */
}s32_badtrks_t;

typedef struct s32_disk {
	char		*sd_ctlr;	/* Controller name, i.e. "rd" */
	int		sd_cnum;	/* Controller number */
	char		*sd_type[MAXDPC];
					/* Disk Type, index into dk_models
					   structure in dk_types.h */
	s32_badtrks_t	*sd_bad[MAXDPC];
					/* Bad trak list for each disk */
	struct s32_disk	*sd_next;	/* Next controller in list */
}s32_disk_t;

typedef struct s32_config {
	char		*sc_sitename;
	s32_disk_t	*sc_disks;	/* List of controllers and disks
					 * on the system.  Disk 0 on the
					 * first controller in the list
					 * is assumed to be the root disk
					 */
}s32_config_t;

