static char rcsid[] = "$Header: ufs_inode.c,v 86.1 86/07/21 14:57:37 bog Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Ufs_inode.c
 *
 * Code related to inodes in a UNIX FIle System (that's redundant, isn't it?)
 * Ripped off from Valid 4.2BSD UNIX sources 0786 by Bill O. Gallmeister.
 */

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/mount.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/conf.h"
#include "../h/buf.h"
#include "../h/kernel.h"

#include	"saio.h"	/* Nifty standalone stuff. */

#ifdef BSDBUGFIX
#define	INOHSZ	64
#else BSDBUGFIX
#define	INOHSZ	63
#endif BSDBUGFIX

#if	((INOHSZ&(INOHSZ-1)) == 0)
#define	INOHASH(dev,ino)	(((dev)+(ino))&(INOHSZ-1))
#else
#define	INOHASH(dev,ino)	(((unsigned)((dev)+(ino)))%INOHSZ)
#endif

extern int sysdebug;	/* System-level debugging enabled. */

/*
 * Check accessed and update flags on
 * an inode structure.
 * If any is on, update the inode
 * with the current time.
 *
 * Then write the inode's static stuff (i_c) out to disk.
 *
 * Returns 0 normally, and -1 upon messing up.
 */
iupdat(io, ta, tm)
	register struct iob *io;
	struct timeval *ta, *tm;
{
	struct dinode *dp;
	register struct fs *fp = io->i_fs;
	register struct inode *ip = io->i_ino;
	register j;

	/* NOT_WORKING_YET */
if( sysdebug>2 )
{
	printf( "In iupdat - io is 0x%x, ta is 0x%x, tm is 0x%x\n", io, ta, tm );
	printf( "In iupdat - io->i_fs is 0x%x, fp is 0x%x, fp->fs_ronly is %d\n", io->i_fs, fp, fp->fs_ronly );
}
	if ((ip->i_flag & (IUPD|IACC|ICHG)) != 0) {
		if (fp->fs_ronly)
		{
			/*
			 * Never will happen in standalone mode.
			 * "You can run, but you cannot hide."
			 *	-R. "Roy Rogers" R.
			 */
			if (sysdebug)
				printf("iupdat: brane deth: fs_ronly!\n");
			return (-1);
		}
		if (ip->i_flag&IACC)
			ip->i_atime = ta->tv_sec;
		if (ip->i_flag&IUPD)
			ip->i_mtime = tm->tv_sec;
		if (ip->i_flag&ICHG)
			ip->i_ctime = time.tv_sec; /* Why time vs. tm? */
		ip->i_flag &= ~(IUPD|IACC|ICHG);

		io->i_bn = fsbtodb(fp, itod(fp, ip->i_number)) + io->i_boff;
		io->i_cc = fp->fs_bsize;
		io->i_ma = io->i_buf;
		if (devread(io) < 0)
		{
			if (sysdebug)
				printf("iupdat: devread barf.\n");
			errno = io->i_error;
			return(-1);
		}
		dp = (struct dinode *)io->i_buf;
		dp[itoo(fp, ip->i_number)].di_ic = io->i_ino->i_ic;
		if (devwrite(io) < 0)
		{
			if (sysdebug)
				printf("iupdat: devwrite barf.\n");
			errno = io->i_error;
			return(-1);
		}
		writefs (io);
	}
	return (0);
}


#define	SINGLE	0	/* index of single indirect block */
#define	DOUBLE	1	/* index of double indirect block */
#define	TRIPLE	2	/* index of triple indirect block */
/*
 * Truncate the inode ip to at most
 * length size.  Free affected disk
 * blocks -- the blocks of the file
 * are removed in reverse order.
 *
 * NB: triple indirect blocks are untested.
 */
itrunc(io, length)
	register struct iob *io;
	u_long length;
{
	struct inode *oip = io->i_ino;
	register i;
	register daddr_t lastblock;
	daddr_t bn, lastiblock[NIADDR];
	register struct fs *fs;
	register struct inode *ip;
	struct inode tip;
	long blocksreleased = 0, nblocks;
	long indirtrunc();
	int level;

	if (oip->i_size <= length) {
		oip->i_flag |= ICHG|IUPD;
		iupdat(io, &time, &time);
		return;
	}
	/*
	 * Calculate index into inode's block list of
	 * last direct and indirect blocks (if any)
	 * which we want to keep.  Lastblock is -1 when
	 * the file is truncated to 0.
	 */
	fs = oip->i_fs;
	lastblock = lblkno(fs, length + fs->fs_bsize - 1) - 1;
	lastiblock[SINGLE] = lastblock - NDADDR;
	lastiblock[DOUBLE] = lastiblock[SINGLE] - NINDIR(fs);
	lastiblock[TRIPLE] = lastiblock[DOUBLE] - NINDIR(fs) * NINDIR(fs);
	nblocks = btodb(fs->fs_bsize);
	/*
	 * Update size of file and block pointers
	 * on disk before we start freeing blocks.
	 * If we crash before free'ing blocks below,
	 * the blocks will be returned to the free list.
	 * lastiblock values are also normalized to -1
	 * for calls to indirtrunc below.
	 * (? fsck doesn't check validity of pointers in indirect blocks)
	 */
	tip = *oip;
	for (level = TRIPLE; level >= SINGLE; level--)
		if (lastiblock[level] < 0) {
			oip->i_ib[level] = 0;
			lastiblock[level] = -1;
		}
	for (i = NDADDR - 1; i > lastblock; i--)
		oip->i_db[i] = 0;
	oip->i_size = length;
	oip->i_flag |= ICHG|IUPD;
	iupdat(io, &time, &time);
	ip = &tip;

	/*
	 * Indirect blocks first.
	 */
	for (level = TRIPLE; level >= SINGLE; level--) {
		bn = ip->i_ib[level];
		if (bn != 0) {
			blocksreleased +=
			    indirtrunc(io, bn, lastiblock[level], level);
			if (lastiblock[level] < 0) {
				ip->i_ib[level] = 0;
				sa_free(io, bn, (off_t)fs->fs_bsize);
				blocksreleased += nblocks;
			}
		}
		if (lastiblock[level] >= 0)
			goto done;
	}

	/*
	 * All whole direct blocks or frags.
	 */
	for (i = NDADDR - 1; i > lastblock; i--) {
		register int size;

		bn = ip->i_db[i];
		if (bn == 0)
			continue;
		ip->i_db[i] = 0;
		size = (off_t)blksize(fs, ip, i);
		sa_free(io, bn, size);
		blocksreleased += btodb(size);
	}
	if (lastblock < 0)
		goto done;

	/*
	 * Finally, look for a change in size of the
	 * last direct block; release any frags.
	 */
	bn = ip->i_db[lastblock];
	if (bn != 0) {
		int oldspace, newspace;

		/*
		 * Calculate amount of space we're giving
		 * back as old block size minus new block size.
		 */
		oldspace = blksize(fs, ip, lastblock);
		ip->i_size = length;
		newspace = blksize(fs, ip, lastblock);
		if (newspace == 0)
			_stop("itrunc: newspace");
		if (oldspace - newspace > 0) {
			/*
			 * Block number of space to be free'd is
			 * the old block # plus the number of frags
			 * required for the storage we're keeping.
			 */
			bn += numfrags(fs, newspace);
			sa_free(io, bn, oldspace - newspace);
			blocksreleased += btodb(oldspace - newspace);
		}
	}
done:
/* BEGIN PARANOIA */
	for (level = SINGLE; level <= TRIPLE; level++)
		if (ip->i_ib[level] != oip->i_ib[level])
			_stop("itrunc1");
	for (i = 0; i < NDADDR; i++)
		if (ip->i_db[i] != oip->i_db[i])
			_stop("itrunc2");
/* END PARANOIA */
	oip->i_blocks -= blocksreleased;
	if (oip->i_blocks < 0)			/* sanity */
		oip->i_blocks = 0;
	oip->i_flag |= ICHG;
}

/*
 * Release blocks associated with the inode ip and
 * stored in the indirect block bn.  Blocks are free'd
 * in LIFO order up to (but not including) lastbn.  If
 * level is greater than SINGLE, the block is an indirect
 * block and recursive calls to indirtrunc must be used to
 * cleanse other indirect blocks.
 *
 * NB: triple indirect blocks are untested.
 */
long
indirtrunc(io, bn, lastbn, level)
	register struct iob *io;
	daddr_t bn, lastbn;
	int level;
{
	register struct inode *ip = io->i_ino;
	register int i;
	register daddr_t *bap;
	register struct fs *fs = ip->i_fs;
	daddr_t nb, last;
	long factor;
	int blocksreleased = 0, nblocks;
	struct iob copy;

	/*
	 * Calculate index in current block of last
	 * block to be kept.  -1 indicates the entire
	 * block so we need not calculate the index.
	 */
	factor = 1;
	for (i = SINGLE; i < level; i++)
		factor *= NINDIR(fs);
	last = lastbn;
	if (lastbn > 0)
		last /= factor;
	nblocks = btodb(fs->fs_bsize);
	/*
	 * Get buffer of block pointers, zero those 
	 * entries corresponding to blocks to be free'd,
	 * and update on disk copy first.
	 */
	bclear (&copy, sizeof copy);
	io->i_bn = fsbtodb(fs, bn) + io->i_boff; 
	io->i_cc = fs->fs_bsize;
	io->i_ma = io->i_buf;
	if (devread (io) < 0) {
		if (sysdebug)
			printf ("indirtrunc: devread error\n");
		return (0);
	}
	bap = (daddr_t *) io->i_buf;
	bcopy((caddr_t)bap, (caddr_t)copy.i_buf, (u_int)fs->fs_bsize);
	bclear((caddr_t)&bap[last + 1],
	  (u_int)(NINDIR(fs) - (last + 1)) * sizeof (daddr_t));
	
	if (devwrite (io) < 0) {
		if (sysdebug)
			printf ("indirtrunc: devwrite error\n");
		return (0);
	}
	bap = (daddr_t *) copy.i_buf;

	/*
	 * Recursively free totally unused blocks.
	 */
	for (i = NINDIR(fs) - 1; i > last; i--) {
		nb = bap[i];
		if (nb == 0)
			continue;
		if (level > SINGLE)
			blocksreleased +=
			    indirtrunc(io, nb, (daddr_t)-1, level - 1);
		sa_free(io, nb, (int)fs->fs_bsize);
		blocksreleased += nblocks;
	}

	/*
	 * Recursively free last partial block.
	 */
	if (level > SINGLE && lastbn >= 0) {
		last = lastbn % factor;
		nb = bap[i];
		if (nb != 0)
			blocksreleased += indirtrunc(io, nb, last, level - 1);
	}
	return (blocksreleased);
}
#ifndef STANDALONE

/*
 * remove any inodes in the inode cache belonging to dev
 *
 * There should not be any active ones, return error if any are found
 * (nb: this is a user error, not a system err)
 *
 * Also, count the references to dev by block devices - this really
 * has nothing to do with the object of the procedure, but as we have
 * to scan the inode table here anyway, we might as well get the
 * extra benefit.
 *
 * this is called from sumount()/sys3.c when dev is being unmounted
 */
iflush(dev)
	dev_t dev;
{
	register struct inode *ip;
	register open = 0;

	for (ip = inode; ip < inodeNINODE; ip++) {
		if (ip->i_dev == dev)
			if (ip->i_count)
				return(-1);
			else {
				remque(ip);
				ip->i_forw = ip;
				ip->i_back = ip;
				/*
				 * as i_count == 0, the inode was on the free
				 * list already, just leave it there, it will
				 * fall off the bottom eventually. We could
				 * perhaps move it to the head of the free
				 * list, but as umounts are done so
				 * infrequently, we would gain very little,
				 * while making the code bigger.
				 */
			}
		else if (ip->i_count && (ip->i_mode&IFMT)==IFBLK &&
		    ip->i_rdev == dev)
			open++;
	}
	return (open);
}

/*
 * Lock an inode. If its already locked, set the WANT bit and sleep.
 */
ilock(ip)
	register struct inode *ip;
{
	ILOCK(ip);
}

/*
 * Unlock an inode.  If WANT bit is on, wakeup.
 */
iunlock(ip)
	register struct inode *ip;
{
	IUNLOCK(ip);
}
#endif  STANDALONE
