/* rcsid[]="$Header: vnet.h,v 800.1 85/08/08 16:29:03 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Definitions useful for the Valid Logic Systems network.
 *
 * jam 840509-10
 *
 * smj 841116	Add Valid Data Link header definition.
 *
 * smj 850103	Add VALIDnet types for forwarding, sink, and network disk.
 *		VALIDnet_FWD and VALIDnet_SINK are used for
 *		Data Link performance measurements.
 *		VALIDnet_DISK is used for network virtual disk support.
 *		Remove all references to RPC_COMPAT (obsolete).
 *
 * jht 850117	Moved definition of net_t and host_t to ../h/param.h
 *		The object-oriented inode stuff is pretty global and needs it.
 *
 * bog 850628	Since net_t and host_t are not defined anymore, added the code
 *		relating to HAVE_INCLUDED_SYSPARAM, which makes the file smart 
 *		enough to include sys/param.h if it needs to.
 */

#ifndef	VNET_ALREADY_DEFINED
#define	VNET_ALREADY_DEFINED

/*
 * Do we know what net_t and host_t are?
 */
#ifndef HAVE_INCLUDED_SYSPARAM
#ifndef KERNEL
#include	<sys/param.h>
#define 	HAVE_INCLUDED_SYSPARAM
#endif  not KERNEL
#endif  not HAVE_INCLUDED_SYSPARAM

typedef struct node {
	net_t		net;                /* network of the host      */
	host_t		host;               /* host id of the node      */
} node_t;

#define nodecmp(n1,n2)	(hostcmp((n1).host,(n2).host) && (n1).net == (n2).net)

struct sockaddr_vnet
{
	short	sa_family;	/* Address family */
	node_t	sa_node;	/* Node address */
};

/* Data Link Header for VALID network packets */

struct validDLLheader
{
	short	pktType;	/* Valid network packet type */
	short	reserved;	/* n/u, must be 0 */
};

#define VALIDnet_CONN	1	/* Connection Management packet */
#define VALIDnet_RPC	2	/* Remote Procedure Call packet */
#define VALIDnet_BCAST	3	/* Broadcast packet */
#define VALIDnet_FWD	4	/* Poor man's packet router */
#define VALIDnet_SINK	5	/* Packet sink (bit bucket) */
#define VALIDnet_DISK	6	/* Network virtual disk */
#define VALIDnet_BULK	7	/* Bulk data transfer packet */


/* The following definitions are CONN specific */

#ifdef KERNEL
node_t		myNode;		/* Address of my node */
u_long		myGeneration;	/* Current generation for this machine */
#endif KERNEL

#define HAVE_INCLUDED_VNET /* this file has been included */

#endif	VNET_ALREADY_DEFINED
