/* rcsid[]="$Header: via.h,v 800.0 85/08/06 14:18:15 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Synertek SY6522
 * See data sheet for details
 */

#define VIAADDR	((struct via_device *)(IOBASE+0x30f60))

#ifdef HZ60
#define CLKCOUNT	17045		/* 60 HZ */
#else HZ60
#define CLKCOUNT	0x27f3		/* 100 HZ */
#endif HZ60

struct via_device {
	unsigned char v_0, v_rb;
	unsigned char v_1, v_ra;
	unsigned char v_2, v_ddrb;
	unsigned char v_3, v_ddra;
	unsigned char v_4, v_t1cl;
	unsigned char v_5, v_t1ch;
	unsigned char v_6, v_t1ll;
	unsigned char v_7, v_t1lh;
	unsigned char v_8, v_t2cl;
	unsigned char v_9, v_t2ch;
	unsigned char v_a, v_sr;
	unsigned char v_b, v_acr;
	unsigned char v_c, v_pcr;
	unsigned char v_d, v_ifr;
	unsigned char v_e, v_ier;
	unsigned char v_f, v_rax;	/* v_ra without hand shake */
};

	/* v_acr bits */
#define ACR_LPA		0x01
#define ACR_LPB		0x02
#define ACR_SR		0x1c
#define ACR_SR0		0x00		/* shift register disabled */
#define ACR_SR4		0x10		/* shift out free running at t2 rate */
#define ACR_T2		0x20		/* timer 1 mode bit */
#define ACR_T2OS	0x00		/* timer 2 one shot mode */
#define ACR_T2PC	0x20		/* timer 2 pulse counter mode */
#define ACR_T1		0x40		/* timer 1 mode bits */
#define ACR_T1OS	0x00		/* timer 1 one shot mode */
#define ACR_T1FR	0x40		/* timer 1 free running mode */
#define ACR_T1PB7	0x80		/* timer 1 PB7 output enable */

	/* v_ifr and v_ier bits */
#define I_CA2		0x01
#define I_CA1		0x02
#define I_SR		0x04
#define I_CB2		0x08
#define I_CB1		0x10
#define I_T2		0x20
#define I_T1		0x40
#define I_IRQ		0x80
#define I_SET		0x80
#define I_CLR		0x00

	/* v_ra bits */
#define A_OMNIRDY	0x01
#define A_CTS0		0x02
#define A_CTS1		0x04
#define A_DSR0		0x08
#define A_DSR1		0x10
#define A_DCD0		0x20
#define A_DCD1		0x40
#define A_XOR		0x80

	/* v_rb bits */
#define B_VOFF		0x01
#define B_VADDR0	0x02
#define B_VADDR1	0x04
#define B_VSW		0x08
#define B_CH0		0x10
#define B_CH1		0x20
#define B_BSW0		0x40
#define B_BSW1		0x80
