	title 'Diskette Handler Module'
;    CP/M-80 Version 3     --  Modular BIOS

;	Disk I/O Module 


    ; Port Address Equates

	maclib ports

    ; CP/M 3 Disk definition macros

	maclib cpm3

    ; Z80 macro library instruction definitions

	maclib Z80

    ; Disk drive dispatching tables for linked BIOS

	public	fddd0,fddd1,firq
	public	trandd,tranrainbow,tranmorrow
	public u$conin$echo, error$table, errm1
	public  motor$counter

    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot		; warm boot vector
	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99.
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
	extrn	ivect
	extrn	?bank


cr	equ 13
lf	equ 10
bell	equ 7

	page
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                  ;
; TYPE field of XDPH are used as follows:                          ;
;                                                                  ;
; Bits 7,6,5 are used to determine the disk			   ;
; format as follows:						   ;
;							           ;
;     BIT 7   BIT 6  BIT 5		DISK TYPE                  ;
;                                                                  ;
;	0	0	0		Visual 1050                ;
;	0	0	1		Kaypro                     ;
;	0	1	0		Amigo                      ;
;	0	1	1		Rainbow                    ;
;	1	0	0		VT180                      ;
;       1       0       1               Morrow                     ;
;       1       1       0               Osborne I                  ;
;                                                                  ;
; Other bits are:                                                  ;
;                                                                  ;
;    BIT 4   -  Unused                                             ;
;    BIT 3   -  Unused                                             ;
;    BIT 2   -  Single (1) or Double (0) Density                   ;
;    BIT 1   -  48 (0) or 96 (1) TPI                               ;
;    BIT 0   -  Unused                                             ;
;                                                                  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


    ; Extended Disk Parameter Headers (XPDHs)

	CSEG

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	0   			; relative drive zero
	db	2			; TYPE field
fddd0:              
fddd0$dpb equ $+12
	dph   trandd,dpbd0


	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	1  			; relative drive one
	db	02			; TYPE field
fddd1:              
fddd1$dpb equ $+12
	dph	trandd,dpbd1        

	CSEG	; DPB must be resident
dpbd0	
        dw     40              ;#128 byte records/track
        db     4,0fh           ;block shift mask (2K)
        db     1               ;extent  mask  
        dw     194             ;maximun  block number
        dw     127             ;max number of dir entry - 1
        db     0C0H,00h        ;alloc vector for directory
        dw     0020h           ;checksum size
        dw     2               ;offset for sys tracks
psh0:
;       db     2,3             ;physical sect shift (512)	(LEL0684)
	db     3,7             ;Dummy value (see FD$INIT)	(LEL0684)


dpbd1	
        dw     40              ;#128 byte records/track
        db     4,0Fh           ;block shift mask (2K)
        db     1               ;extent  mask  
        dw     194             ;maximun  block number
        dw     127             ;max number of dir entry - 1
        db     0C0H,00h        ;alloc vector for directory
        dw     32              ;checksum size
        dw     2               ;offset for sys tracks
psh1:
;       db     2,3             ;physical sect shift (512 )	(LEL0684)
	DB     3,7             ; Dummy value (see FD$init)	(LEL0684)

trandd		skew	10,1,1
tranrainbow	skew	10,2,1
tranmorrow	skew	5,3,1 
	page

    ; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.

	DSEG
fd$init:
;
; In the DPB, note that the physical sector shift is given as 3,7
; denoting 1024 block size.  The true value for the default format
; (our own 1050 format) is 2,3 (512).  However, since GENCPM is
; used to generate the BCBs, we must fake it out for the generation
; process.  Otherwise, it will allocate only 512 block sizes and we
; need 1024 to provide Morrow support.  If it is changed back to 512,
; note that Morrow support will not work.
;

	lxi h,0302h		;Set up 2,3 as true value	(LEL0684)
	shld	psh0		; store for drive 0		(LEL0684)
	shld	psh1		;store for drive 1		(LEL0684)
	mvi a,fdc$reset		;reset
	out p$disk$control	;do it
	ret

	page
fd$login:
;
; When this entry point is called, the last track accessed
; is set to 0FFH to flag a homing of the head before a new
; Read or Write operation.
;

	lxi     h,fd0$access		; TO address		(LEL0184)
	lded    @rdrv			; get current drive	(LEL0184)
	xra	a			; Clear a		(LEL0184)
	mov	d,a			; Use it to clear d	(LEL0184)
	dad  d                  	;			(LEL0184)
	mvi	a,0ffh			; Use FF to force HOME	(LEL0184)
	mov	m,a			; Set to last trk used	(LEL0184)
	ret				;			(LEL0184)



	page

; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
	DSEG
fd$read:
	call	read$setup		; Set up for read
	jr    rw$common

fd$write:
	call	write$setup		; Set up for write

rw$common:				; seek to correct track (if necessary),
					;	and issue 1797 command.
 
	shld operation$name		; save message for errors
	lhld	@dma
	shld	dmaadr
	sta disk$command		; save 1797 command
	page
;
; Will need to know info on last access to disk.  Move info into
; old$track        
;
	lxi h,fd0$access		; FROM address
	lded @rdrv			; Get relative drive
	xra	a			; Clear a
	mov	d,a			; Use it to clear d
	dad d				; add      
	lxi d,old$track			; TO address
fd$20	ldi				; move in track

	call	set$up$8255		; Set up 8255 command
	page

more$retries:
	mvi c,04			; allow 04 retries
retry$operation:
	push b				; save retry counter
;
; Check to see whether the motor is being turned on cold, or
; whether it is still on from a previous access.
;
	call	start$motor$timer	; Start timing
	in	p$disk$bits		; Get previous status
	push	psw			; save it

	lda	select$mask		; Get new status
	out	p$disk$bits		; Send out (turns on motor)
	pop	psw			; Get prev status
	ani	0100$0000b		; Was motor on
	jrz	check$track		; bit 6=0 means it was on
;
; Motor was off. Wait 800 ms for it to come up to speed.
;

	lxi	h,892
wait$0 
	xra	a
wait$1
	dcr	a
	jnz	wait$1			; Delay 896 uS

	dcx	h			;
	mov	a,l			;
	ora	h			;
	jrnz	wait$0			;

;
; Check current track against desired one.
;


check$track

;
; Access track
;

	lda trk ! lxi h,old$track ! cmp m
	jrz same$track			; if same track, dont seek
;
; New track (different from last one accessed)
;

new$track:				; 

	lda	old$track		; Get last track	(LEL0184)
	CPI	0FFH			; First access?		(LEL0184)
	jrnz	New$trk$5		; Jump if not		(LEL0184)

	CALL	HOME			; Else, home disk 	(LEL0184)
	XRA	A			; Current trk is now 0  (LEL0184)
new$trk$5:
	OUT	P$DISK$TRACK		; out to current track	(LEL0184)


	lda trk				; point to desired track
	call seeker    			; and seek 


	lda	trk			; get track
	sta	old$track		; store as last track accessed
	jr	get$sect		; Now, access sector.         

;
; At same track as last access
;

same$track:
	out p$disk$track		; give 1797 track


;
; Now, Get sector.
;

get$sect:
	lda @sect 
	out p$disk$sector		;and sector

 
;
; Save track info for drive
;

	lxi     h,fd0$access		; TO address
	lded    @rdrv			; get current drive
	xra	a			; Clear a
	mov	d,a			; Use it to clear d
	dad  d                  	;
	lxi d,old$track			; FROM address
	xchg				;
        ldi				; move in track
	JMP	SEL$DMA

	CSEG

;
; Select DMA bank for transfer
;

SEL$DMA:

	IF	BANKED   
	lda	@dbnk			; Get DMA bank
	call	?bank			; Go to it
	ENDIF

;
; Now, set up for NMI to do command.  NMI will use alternate regs
; so set them up with the apprpriate values.
;

	exaf				; exchange af and af
	exx				; and other prime regs
	push h				; save h (really h')
	push b				; save b (really b')
	push psw			; save a (really a')

	mvi c,p$disk$data		; load c with port address
	lhld dmaadr			; get buffer address
	exaf				; put into prime regs
	exx				;


	lda disk$command		; get 1797 command
	call exec$command		; Start. Wait for IREQ & read status
	sta disk$status			; save status for error messages

	exx				; save regs for a second
	exaf				;
	pop psw				; restore a (really a')
	pop b				; restore b (really b')
	pop h				; restore h (really h')
	exx				; put back into prime regs
	exaf				; put af back too

;
; Operation completed.  Status is in location disk$status.
;

	IF	BANKED   
	xra	a   			; Reselect bank 0
	call	?bank       		; 
	ENDIF
	
	pop b				; recover retry counter
	lda disk$status			; get status
	ora a     			; check status. 
	jz fd$exit			; If no error, exit          
	JMP CHK$ERROR

	DSEG

;
; Check error type.  If write protect violation or time out,
; or not ready, don't bother retrying.
;

CHK$ERROR:
	ani 1100$0000b			; Not ready or write protect?
	jrnz fd$error			; jump if yes

	lda disk$status			; get status again
	ani 0001$0000b			; see if record not found error
	cnz seeker    			; if rec not found, may need to force seek

	dcr c				; decrement retry count
	jrz fd$error			; If failed 4 times, exit

	mov a,c				;  
	cpi 02				; If <2 retries
	jp retry$operation		; then retry

;
; If >2 retries have already been done, force a head restore.  This
; is done by seeking track 5, then restore to assure head travel.
; This should cure persistent lint on the heads as well as seek
; errors.
;

	mvi a,5				; track 5
	call seeker    			; seek it
	call home			; home
	lda trk				; Get track back
	Call seeker    			; seek it
	jmp retry$operation		; then retry
	page
;
; Error Handling...
;

FD$ERROR:

;
; suppress error message if BDOS is returning errors to application...
;


 	lda @ermde 
	inr	a		; Is it FF?
	jrz hard$error

;
; Had permanent error, print message like:
;
;	 BIOS Err on d: T-nn, S-mm, <operation> <type>, Retry ?
;


	call	?pderr			; print message header

	lhld operation$name ! call ?pmsg	; last function

		; then, messages for all indicated error bits

	lda disk$status			; get status byte from last error
	cpi 0ffh			; time out error?
	jrz err$timeout			; special message
	lxi h,error$table		; point at table of message addresses
	call	errm1			; Print out messages

errm2	lxi h,error$msg ! call ?pmsg	; print "<BEL>, Retry (Y/N) ? "
	call u$conin$echo		; get operator response
	cpi 'Y'				; Is it YES?
	mvi	a,0ffh			; (set flag in anticipation)  (LEL0784)
	sta	old$track		; of a YES answer	      (LEL0784)
	jz more$retries			; Yes, then retry 4 more times

;
; Error noted.
;
hard$error:
	lda	disk$status		; Get status byte
	cpi	0100$0000b		; Write protect error?
	mvi 	a,0ffh 			; return hard error to BDOS
	jnz	fd$exit			; Not write protect error
	mvi	a,2			; Write protect error
	jmp	fd$exit
err$timeout
	lxi h,time$out			; point to timeout message
	call ?pmsg			; Display message
	jr errm2			; Ask for user response
;
; Print out message for each bit that is on
;
errm1:
	mov e,m ! inx h ! mov d,m ! inx h ; get next message address
	add a ! push psw		; shift left and push residual bits with status
	xchg ! cc ?pmsg ! xchg		; print message, saving table pointer
	pop psw	! jrnz errm1		; if any more bits left, continue
	ret

	page

	DSEG

;
; Subroutine to seek to home track      
;
home:

	mvi a,08h				; home, hld, no verify
	jr  seek$20			;    

;
; Seeker
; This routine seeks a track in A 
;

seeker:
	push	psw			; Save destination track

	lda	tpi			; Get TPI
	ora	a			; Is it 48?
	jrnz	seek$15			; Jump if not

	
;
; Must double track info for 48tpi disks
;

	in	p$disk$track		; Read in current track
	ora	a			; Clear carry
	ral				; *2
	out	p$disk$track		; Set track reg

	pop	psw			; Get desired track
	ora	a			; clear carry
	ral				; *2
	jr	seek$16			; Seek it

seek$15:	
	pop	psw			; Restore track
seek$16:
	out p$disk$data			; send out track
	mvi a,018h			; seek, hld, verify

;
; Routines for seek and home
;

seek$20
	out p$disk$control		; send command from A
;
; Delay at least 24 uSec after command
;

	mvi a,09			;
seek$delay
	dcr a				;.
	jnz seek$delay			;

;
; Wait for completion
;

seek$30
	in p$disk$control		; get status byte
	rrc				; Ready?
	jc seek$30			; loop until ready

;
; Return with A= status byte
;

	in p$disk$control		; read in status         

;
; Delay 18mS to allow for settling time
;

	lxi d,01400h			;
seek$delay2
	dcr	e			;
	jnz seek$delay2			; 896 uS
	dcr d				;
	jnz seek$delay2			; 20*896=18 mS

	push	psw			; save status
	lda	trk			; Get trk
	out	p$disk$track		; Save in track reg
	pop	psw			; Restore status
	ret

	page

	CSEG

;
; This routine actually executes the read or write command.  An initial
; read (or write) is sent out to the controller.  Since we are not 
; doing multiple sectors, an interrupt will be generated at the end of    
; the command.  This invokes the NMI set up at the beginning of the
; routine.  Either an INI or OUTI will be performed, depending on whether
; a read or write is invoked.  This lets us read in an entire sector 
; more efficiently.  
;

exec$command:				

	out p$disk$control		; send 1797 command

;
; Wait at least 24 usec after command before doing anything.
;

	mvi a,08
exec$delay
	dcr a
	jrnz exec$delay			; (delays 32 usec)

;
; Now, wait for completion, but TIME OUT after 1.2 seconds.
;

	lxi d,60000+1
exec$0
	in p$disk$control		; get status
	rrc				; check not ready flag
	jnc exec$success		; if 0, successful completion

	inx d				; (waste time)
	dcx d				;
	inx d				;
	dcx d				;

	dcx d				; decrement count
	mov a,d				;
	ora e				;
	adi 0ffh			;
	jc exec$0			; 20 us*60000=1.2 seconds

;
; Time out.  Set A=0FFH and exit.
;

	mvi a,0d0h			; Reset FDC
	out p$disk$control		; send it out

	mvi a,0ffh			; Set time out flag
	jr exec$exit

;
; Successful completion.  Return w/status byte in A.


exec$success
	in p$disk$control		; Get status byte
exec$exit
	push	psw			; Save status
	call	start$motor$timer	; Start timer   
	pop	psw			;

	ret
	page
;
; Start up motor timer
;

Start$motor$timer:
	di				; DI while changing counter
	mvi	a,120			; Start counter
	sta	motor$counter		;
	ei				; EI

	RET
;
; Exit from routine.
; Must set up interrupts appropriately.
;
fd$exit:
	push psw			; save status
	
	in p$disk$track			; read track
	out p$disk$data			; write out data

;
; Restore nmi locations
;

	IF	BANKED
	lda	@dbnk			; Point to bank
	call	?bank			; Switch to it
	ENDIF

	lxi d,nmi			; Point at nmi
	lxi h,nmibuf			; and at save buffer
	lxi b,8				; load count
	ldir				; move saved data back

	IF	BANKED		
	xra	a    			; Point back to code bank
	call	?bank			; Switch back
	ENDIF

	in	p$disk$bits		; Get disk bits
	ori	0000$1111b		; Deselect drive
	out	p$disk$bits		; Send out

	mvi a,0d0h			;
	out p$disk$control		; Reset disk controller    

	pop	psw
	ora	a			; set flags
	ret				; and exit!!

	CSEG


read$setup:
	IF	BANKED    
	lda	@dbnk
	call	?bank
	ENDIF
	call nmi$setup			; set up nmi (invarient part)
	lxi h,0a2edh			; "INI"
	shld nmi+2			; store read portion
	IF	BANKED   
	xra	a    
	call	?bank
	ENDIF
	lxi h,read$msg			; point at " Read "
	mvi a,82h             		; 1797 read 
	ret

write$setup:
	IF	BANKED   
	lda	@dbnk
	call	?bank			; Switch banks
	ENDIF
	call nmi$setup			; set up nmi (invarient part)
	lxi h,0a3edh			; "OUTI"
	shld nmi+2			; store write portion
	IF	BANKED    
	xra	a    			; Get CBANK back
	call	?bank			; restore it
	ENDIF
	lxi h,write$msg			; point at " Write "
	mvi a,0A2h            		; 1797 write 
	ret



;
; Set up NMI
; NMI (non-maskable interrupt) occurs at fixed location 0066h.
; During normal run time NMI does not occur, so these locations
; are normal RAM.  During diskette data transfers, NMI is
; triggered by the diskette Data Request signal, so the NMI
; locations are temporarily overlayed by intructions to process 
; the interrupt.
;
nmi	equ	0066h

nmi$setup:
	mvi	a,fdc$reset		; Reset FDC
	out	p$disk$control		;

	dcx	d			; Point to TYPE field of XDPH
	ldax	d			; Get value
	push	psw			; Save it    		(LEL0684)
	ani	0000$0010b		; Mask TPI field
	rar				; Rotate into bit 0
	sta	TPI			; store

	pop	psw			; get type		(LEL0684)
	ani	0000$0100b		; Single/double density	(LEL0684)
	sta	Density			; store			(LEL0684)

	lxi d,nmibuf			; point to storage area
	lxi h,nmi			; original values
	lxi b,8				; set up length
	ldir				; save them away

	lxi h,0d908h			; "EX AF,AF'"
	shld nmi			; beginning of nmi
	shld nmi+4			; also, end of nmi
	lxi h,045edh			; "RETN"
	shld nmi+6			; 

	mvi	a,3			; Enable FDC interrupt
	out	p$8255$control		;

	ret

	CSEG

;
; Floppy completion interrupt.
;
firq:	push psw			; save A
	in p$disk$control		; relieve interrupt
	IF	REAL$1050
	mvi	a,int$initial
	out	int$port 		; Init int port
	ENDIF
	pop	psw
	ei
	ret 
	page

	DSEG

u$conin$echo:				; get console input, echo it
					; and shift to upper case
	call ?const ! ora a ! jrz u$c1	; see if any char already struck
	call ?conin ! jr  u$conin$echo	; yes, eat it and try again
u$c1:
	call ?conin ! push psw
	mov c,a ! call ?cono
	pop psw ! cpi 'a' ! rc
	sui 'a'-'A'			; make upper case
	push	psw			; Save character
	lxi	h,cr$lf			; Send out CR LF
	call	?pmsg			;
	pop	psw			; restore character	
	ret


;
; Set up misc 8255 command
;
; Bit 7=0; Bit 6=0 means turn motor on.
; Set up drive select in bits 0-3.

set$up$8255:
	lda	@rdrv			; get relative drive
	inr	a			; increment
	cpi	03			;
	jm	fd$40			;
	ani	06			;
	add	a			; Double it
fd$40	xri	0Fh			; bit=0 => on

	mov	b,a			; save in b
 
;
; Set up Bit 4 (side select) = 0.
;
 
	lda	@trk			; Get track
	sta	trk			; store it

;
; Set up bit 5 for write precompensation.  (Write precomp is
; necessary for outer tracks, so check against constant specified
; by disk manufacturer.)
;

fsel$1	lda	trk			; get track
	cpi	precomp$limit		; Compare with precomp	(LEL0384)
	jrc	fsel$2			; jump if yes
	setb	5,b			; Else, set bit
;
; Set Bit 7=1 if single density
;
fsel$2:
	lda	density			; Get density		(LEL0684)
	ora	a			; Is it 0?		(LEL0684)
	jrz	fsel$5			; jump if yes		(LEL0684)
	setb	7,b			; else, set bit 7	(LEL0684)
;
; All 8 bits of 8255 command have been set up.  Save them.            
;

fsel$5:
      	mov	a,b			; get b reg values
	sta	select$mask		; save 8255 bits
	ret
	page

	CSEG

ivect2		equ	0fff8h	;
nmibuf		ds	8	; buffer to hold prev contents of nmi
disk$command	ds	1	; current wd1797 command
select$mask	ds	1	; current drive select code
dmaadr		ds	2
trk		ds	1	; track for current operation
disk$status	ds	1	; last error status code for messages

precomp$limit	equ	43  

tpi		db	0	; tracks per inch
density	  	db	0	; single/double density		(LEL0684)
motor$counter	db	0

		DSEG

old$track	db	0ffh	; last track seeked to

fd0$access
fd0$trk		db	0ffh	; last track accessed on A
fd1$trk		db	0ffh	; last track accessed on B


	; error message components

cr$lf		db	13,10,0

read$msg	db	', Read',0
write$msg	db	', Write',0

operation$name	dw	read$msg

	; table of pointers to error message strings
	;	first entry is for bit 7 of 1797 status byte

error$table	dw	b7$msg
		dw	b6$msg
		dw	b5$msg
		dw	b4$msg
		dw	b3$msg
		dw	b2$msg
		dw	b1$msg
		dw	b0$msg

b7$msg		db	' Not ready,',0
b6$msg		db	' Protect,',0
b5$msg		db	' Fault,',0
b4$msg		db	' Record not found,',0
b3$msg		db	' CRC,',0
b2$msg		db	' Lost data,',0
b1$msg		db	' DREQ,',0
b0$msg		db	' Busy,',0

time$out	db	' Time out,',0

error$msg	db	' Retry (Y/N) ? ',0

	END