	title 'Diskette Handler Module'
;    CP/M-80 Version 3     --  Modular BIOS

;	Disk I/O Module 


    ; Port Address Equates

	maclib ports

    ; CP/M 3 Disk definition macros

	maclib cpm3

    ; Z80 macro library instruction definitions

	maclib Z80

    ; Disk drive dispatching tables for linked BIOS

	public	fddd0,fddd1
	public u$conin$echo, error$table

    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect
	extrn	@dbnk,@cbnk

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot		; warm boot vector
	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99.
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
	extrn	ivect
	extrn	?bank


cr	equ 13
lf	equ 10
bell	equ 7

	page
    ; Extended Disk Parameter Headers (XPDHs)

	cseg

	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	0   			; relative drive zero
	db	2			; TYPE field
fddd0:              
	dw	trandd			; Translate table address
	db	0,0,0,0,0,0,0,0,0	; Bdos scratch area
	db	0			; Media flag
	dw	dpbd0			; Disk parameter block
	dw	0fffeh			; Checksum vector
	dw	0fffeh			; Allocation vector
	dw	dirbcb			;
	dw	datbcb			;
	dw	0fffeh			; Hash      
	db	0			; Hash bank


	dw	fd$write
	dw	fd$read
	dw	fd$login
	dw	fd$init
	db	1  			; relative drive one
	db	02			; TYPE field
fddd1:              
	dw	trandd			; Translate table address
	db	0,0,0,0,0,0,0,0,0	; Bdos scratch area
	db	0			; Media flag
	dw	dpbd1			; Disk parameter block
	dw	0fffeh			; Checksum vector
	dw	0fffeh			; Allocation vector
	dw	dirbcb
	dw	datbcb
	dw	0fffeh			; Hash      
	db	0			; Hash bank



	cseg	; DPB must be resident
dpbd0	
	dw	0028h		; #128 byte records/track
	db	04,0fh		; block shift and mask
	db	1		; extent mask
	dw	194  		; maximum block number
	dw	127		; maximum dir entry #
	db	0C0h,00h	; alloc vector for directory
	dw	32   		; checksum size
	dw	2		; offset for sys tracks
	db	2,3		; physical sector size shift

dpbd1	
	dw	0028h		; #128 byte records/track
	db	04,0fh		; block shift and mask
	db	1		; extent mask
	dw	194  		; maximum block number
	dw	127		; maximum dir entry #
	db	0C0h,00h	; alloc vector for directory
	dw	32   		; checksum size
	dw	2		; offset for sys tracks
	db	2,3		; physical sector size shift

	
	dseg

;
; Directory buffer control block
;

dirhead	dw	dirbcb

dirbcb:	db	0ffh		; DRV - Drive with record in buf
	db	0,0,0		; Rec #
	db	0		; wflg
	db	0		; Scratch byte
	dw	0		; Track
	dw	0		; Sector
	dw	dirbf		; Buffer address
	db	0		; Bank
	dw	0		; Link
	

dirbf:	ds	512
	
	cseg
;
; Data buffer control block
;

dathead	dw	datbcb

datbcb:	db	0ffh		; Drive
	db	0,0,0		; Record #
	db	0		; Wflg
	db	0		; Scratch byte
	dw	00		; Track
	dw	0		; Sector
	dw	datbf		; Buffer address
	db	0		; Bank
	dw	0		; Link

datbf:	ds	512


trandd	skew	10,1,1

	page

    ; Disk I/O routines for standardized BIOS interface

; Initialization entry point.

;		called for first time initialization.


fd$init:
	mvi a,fdc$reset		;reset
	out p$disk$control	;do it
	ret
	page

fd$login:
		; This entry is called when a logical drive is about to
		; be logged into for the purpose determining what type    
		; of disk is in use.

		; It may adjust the parameters contained in the disk
		; parameter header pointed at by <DE>
		
		; The value of XDPH-1 (TYPE field) is adjusted to reflect
		; the type of disk.  This is determined by reading the
		; disk label.

	push	d		; Save address of XDPH
	lda	@ermde		; Get error mode
	sta	save$mode	; save it
	mvi	a,0ffh		; Force to not display msgs
	sta	@ermde		; store

	lxi h,datbf             ; point to dma area
	shld	dmaadr		; store
	lxi h,fd0$access	; assume A drive
	lded @rdrv		; Get drive
	xra	a		; a=0
	mov	d,a		; Clear D
	dad d			; Point to correct flag
	pop	d		; Restore address of XDPH
login$10:
	mvi a,0ffh		; flag=ff
	mov m,a			; reset last track
	lda @rdrv		; Get relative drive
	inr	a		; increment
	xri 0fh			; bit=0 => on
	sta select$mask		; save command
	mvi	a,0ffh		; Clear "last" flags
	sta old$track		;
	xra	a		; a=0
	sta trk			; Going to Track 0
	inr	a		; a=1
	sta	sect		; Sector 1
;
; Set up for reading the label
;
	push	d		; Save addr of XDPH
	call nmi$setup		; set up nmi (invarient part)
	lxi h,0a2edh		; "INI"
	shld nmi+2		; store read portion
	lxi h,read$msg		; Point to "Read"
	shld operation$name	; store for error msg
	mvi	a,82h		; Store read 
	sta	disk$command	; as command to execute
	call	more$retries	; do it
	jrnz	bad$exit	; Jump if problem

;
; Check that disk has our "signature"
;

	lxi	b,0003		; count =3
	lxi	h,datbf		; Point to signature on disk
	lxi	d,signature	; and our recognized one
back	ldax	d		; get signature char
	cci			; compare
	inx	d		; increment de
	jrnz	notok  		; jump if no match
	jpe	back		; if bc<>0, keep going
	
	mov	a,m		; Get next character
	cpi	'0'		; Is it '0'?
	jrz	login$30	; If yes, it's ok
	cpi	'1'		; Is it '1'?
	jrnz	notok		; If not, it's bad

;
; Set up fields in TYPE field as follows:        
;  
; Bit 0 : 1=2 sides
;         0=1 side
; Bit 1 : 1=96 TPI
;         0=48 TPI
; Bit 2 : unused
; Bit 3 : unused
; Bit 4 : unused 
; Bit 5 : unused
; Bits 6-7: step rate
;

login$30:
	pop	d			; Restore address of XDPH
	dcx	d			; Point to type field

	lxi	h,datbf+no$of$heads	;
	mov	a,m			; Get # sides
	dcr	a			; Decrement
	mov	b,a			; Save in B

	lxi	h,datbf+tpi$offset	; Get tpi from label
	mov	a,m			;

	ora	a			; clear carry
	ral				; Move to bit 1
	ora	b			; OR with # sides
	mov	b,a			; Save in B

	lxi	h,datbf+step$offset	; Get step rate
	mov	a,m			;
	db      0fh			; Into bits 6&7
	db      0fh			;
	ora	b			; OR with others
	stax	d			; store in TYPE field

;
; Move label info into appropriate DPH
;

	lxi	b,15		; # bytes to move
	lxi	h,datbf+32	; FROM address
	lxi	d,dpbd0		; Assume drive 0
	lda @rdrv		; check it
	ora	a		;
	jz	login$67	; Jump if drive 0
	lxi	d,dpbd1		; Set to drive 1
login$67:
	ldir			; move
	inx	h		; skip skew
	ldi			; Then move in 2 more
	ldi			;
	jr	login$exit	; exit 

notok:
	pop	b		; Restore stack
	lxi	h,nomatch	; Error, print message
	call ?pmsg
	jr	login$exit

bad$exit:
	pop	b
login$exit:
	lda	save$mode	; Get saved value of @ermde
	sta	@ermde		; restore it
	xra	a		; Clear A
	ret

save$mode	ds	1
no$of$heads	equ	53	;Offset into label
step$offset	equ	56	;
tpi$offset	equ	11	;

signature	db	'FMT' 
nomatch	db	'***WARNING - Disk format not recognized***',13,10,0

	page

	cseg

; disk READ and WRITE entry points.

		; these entries are called with the following arguments:

			; relative drive number in @rdrv (8 bits)
			; absolute drive number in @adrv (8 bits)
			; disk transfer address in @dma (16 bits)
			; disk transfer bank	in @dbnk (8 bits)
			; disk track address	in @trk (16 bits)
			; disk sector address	in @sect (16 bits)
			; pointer to XDPH in <DE>

		; they transfer the appropriate data, perform retries
		; if necessary, then return an error code in <A>
fd$read:
	call nmi$setup			; set up nmi (invarient part)
	lxi h,0a2edh			; "INI"
	shld nmi+2			; store read portion
	lxi h,read$msg			; point at " Read "
	mvi a,82h             		; 1797 read 
	jr  rw$common

fd$write:
	call nmi$setup			; set up nmi (invarient part)
	lxi h,0a3edh			; "OUTI"
	shld nmi+2			; store write portion
	lxi h,write$msg			; point at " Write "
	mvi a,0A2h            		; 1797 write 


rw$common:				; seek to correct track (if necessary),
					;	and issue 1797 command.
 

	shld operation$name		; save message for errors
	mov b,a				; put read or write into B
	lda	@sect			; Get sector
	sta	sect			; save it
	lhld	@dma
	shld	dmaadr

	lda	no$of$sides		; Get # sides
	ora	a 			; Check it
	jrz 	rw$26			; Jump if single-sided
	lda @trk			; get track
	ani 01h				; low bit = side
	add	a			;
	add	a			;
	add	a			; *8
rw$26	ora b				; OR in w/read or write
	sta disk$command		; save 1797 command
	page
;
; Will need to know info on last access to disk.  Move info into
; old$track        
;
	lxi h,fd0$access		; FROM address
	lded @rdrv			; Get relative drive
	xra	a			; Clear a
	mov	d,a			; Use it to clear d
	dad d				; add      
	lxi d,old$track			; TO address
fd$20	ldi				; move in track
  
;
; Set up misc 8255 command
;
; Bit 7=0; Bit 6=0 means turn motor on.
; Set up drive select in bits 0-3.

	lda	@rdrv			; get relative drive
	inr	a			; increment
	cpi	03			;
	jm	fd$40			;
	ani	06			;
	add	a			; Double it
fd$40	xri	0Fh			; bit=0 => on

	mov	b,a			; save in b
 
;
; Set up Bit 4 (side select).
; If double sided, consecutive tracks use alternate sides 
; of the disk
;
 
	lda	@trk			; Get track
	sta	trk			; store it

	lda	no$of$sides		; Get # sides
	ora	a			; Is it double sided?
	jrz	fsel$1			; Jump if not

 	lda	@trk			; get track
	push	psw			; save it
	rar				; rotate into place
	sta	trk			; store
	pop	psw			; restore track
	ani	1			; mask off other bits
	jrz	fsel$1			; If side 0, ok
	mvi	a,010h			; Else, set side 1 bit
	ora	b			; or w/b-reg
	mov	b,a			; save in b again

;
; Set up bit 5 for write precompensation.  (Write precomp is
; necessary for outer tracks, so check against constant specified
; by disk manufacturer.)
;

fsel$1	lda	trk			; get track
	lxi	h,precomp$limit		; and precomp limit
	cmp	m			; is it <?   
	jrc	fsel$2			; jump if yes
	mvi	a,020h			; set write pre-comp
	ora	b			; or with other bits
	mov	b,a			; store back in b

;
; All 8 bits of 8255 command have been set up.  Save them.            
;

fsel$2	mov	a,b			; get b reg values
	sta	select$mask		; save 8255 bits
	page

more$retries:
	mvi c,10			; allow 10 retries
retry$operation:
	push b				; save retry counter
;
; Check to see whether the motor is being turned on cold, or
; whether it is still on from a previous access.
;
	call	start$motor$timer	; Start timing
	in	p$disk$bits		; Get previous status
	push	psw			; save it

	lda	select$mask		; Get new status
	out	p$disk$bits		; Send out (turns on motor)
	pop	psw			; Get prev status
	ani	0100$0000b		; Was motor on
	jrz	check$track		; bit 6=0 means it was on
;
; Motor was off. Wait 800 ms for it to come up to speed.
;
	lxi	h,892
wait$0 
	xra	a
wait$1
	dcr	a
	jnz	wait$1			; Delay 896 uS

	dcx	h			;
	mov	a,l			;
	ora	h			;
	jrnz	wait$0			;

;
; Check current track against desired one.
;


check$track

;
; Access track
;

	lda trk ! lxi h,old$track ! cmp m
	jrz same$track			; if same track, dont seek
;
; New track (different from last one accessed)
;

new$track:				; 
	lda old$track			; get last track accessed
	out p$disk$track		; send it out
	cpi	0ffh			; first access? 
	cz home				; if yes, home
	lda trk				; point to desired track
	call seeker    			; and seek 

	lda	trk			; get track
	sta	old$track		; store as last track accessed
	jr	get$sect		; Now, access sector.         

;
; At same track as last access
;

same$track:
	out p$disk$track		; give 1797 track


;
; Now, Get sector.
;

get$sect:
	lda sect 
	out p$disk$sector		;and sector
 
;
; Save track info for drive
;

	lxi     h,fd0$access		; TO address
	lded    @rdrv			; get current drive
	xra	a			; Clear a
	mov	d,a			; Use it to clear d
	dad  d                  	;
	lxi d,old$track			; FROM address
	xchg				;
        ldi				; move in track


;
; Now, set up for NMI to do command.  NMI will use alternate regs
; so set them up with the apprpriate values.
;

	exaf				; exchange af and af
	exx				; and other prime regs
	push h				; save h (really h')
	push b				; save b (really b')
	push psw			; save a (really a')

	mvi c,p$disk$data		; load c with port address
	lhld dmaadr			; get buffer address
	exaf				; put into prime regs
	exx				;


	lda disk$command		; get 1797 command
	call exec$command		; Start. Wait for IREQ & read status
	sta disk$status			; save status for error messages

	exx				; save regs for a second
	exaf				;
	pop psw				; restore a (really a')
	pop b				; restore b (really b')
	pop h				; restore h (really h')
	exx				; put back into prime regs
	exaf				; put af back too

;
; Operation completed.  Status is in location disk$status.
;

	pop b				; recover retry counter
	lda disk$status			; get status
	ora a     			; check status. 
	jz fd$exit			; If no error, exit          

;
; Check error type.  If write protect violation or time out,
; or not ready, don't bother retrying.
;

	ani 1100$0000b			; Not ready or write protect?
	jrnz fd$error			; jump if yes

	lda disk$status			; get status again
	ani 0001$0000b			; see if record not found error
	cnz seeker    			; if rec not found, may need to force seek

	dcr c				; decrement retry count
	jrz fd$error			; If failed 10 times, exit

	mov a,c				;  
	cpi 06				; If <4 retries
	jp retry$operation		; then retry

;
; If >4 retries have already been done, force a head restore.  This
; is done by seeking track 5, then restore to assure head travel.
; This should cure persistent lint on the heads as well as seek
; errors.
;

	mvi a,5				; track 5
	call seeker    			; seek it
	call home			; home
	lda trk				; Get track back
	Call seeker    			; seek it
	jmp retry$operation		; then retry
	page
;
; Error Handling...
;

FD$ERROR:

;
; suppress error message if BDOS is returning errors to application...
;


 	lda @ermde 
	cpi 0FFh 
	jrz hard$error

;
; Had permanent error, print message like:
;
;	 BIOS Err on d: T-nn, S-mm, <operation> <type>, Retry ?
;


	call	?pderr			; print message header

	lhld operation$name ! call ?pmsg	; last function

		; then, messages for all indicated error bits

	lda disk$status			; get status byte from last error
	cpi 0ffh			; time out error?
	jz err$timeout			; special message
	lxi h,error$table		; point at table of message addresses
errm1:
	mov e,m ! inx h ! mov d,m ! inx h ; get next message address
	add a ! push psw		; shift left and push residual bits with status
	xchg ! cc ?pmsg ! xchg		; print message, saving table pointer
	pop psw	! jnz errm1		; if any more bits left, continue

errm2	lxi h,error$msg ! call ?pmsg	; print "<BEL>, Retry (Y/N) ? "
	call u$conin$echo		; get operator response
	cpi 'Y' ! jz more$retries	; Yes, then retry 10 more times
hard$error:				; otherwise,
	lda	disk$status		; Get status byte
	cpi	0100$0000b		; Write protect error?
	mvi a,1 			; 	return hard error to BDOS
	jnz	fd$exit			; Not write protect error
	inr	a			; Write protect error
	jmp	fd$exit
err$timeout
	lxi h,time$out			; point to timeout message
	call ?pmsg			; Display message
	jr errm2			; Ask for user response

	page
;
; Subroutine to seek to home track      
;
home:
	lda	step$rate		; Get step rate   
home$0
	ori 08h				; home, hld, no verify
	jmp seek$20			;    

;
; Seeker
; This routine seeks a track in A at the given step rate
;

seeker:
	push	psw			; Save destination track

	lda	tpi			; Get TPI
	ora	a			; Is it 48?
	jrnz	seek$15			; Jump if not

	
;
; Must double track info for 48tpi disks
;

	in	p$disk$track		; Read in current track
	ora	a			; Clear carry
	ral				; *2
	out	p$disk$track		; Set track reg

	pop	psw			; Get desired track
	ora	a			; clear carry
	ral				; *2
	jr	seek$16			; Seek it

seek$15:	
	pop	psw			; Restore track
seek$16:
	out p$disk$data			; send out track
	lda	step$rate		; Get step rate
	ori	018h			; seek, hld, verify

;
; Routines for seek and home
;

seek$20
	out p$disk$control		; send command from A
;
; Delay at least 24 uSec after command
;

	mvi a,09			;
seek$delay
	dcr a				;.
	jnz seek$delay			;

;
; Wait for completion
;

seek$30
	in p$disk$control		; get status byte
	rrc				; Ready?
	jc seek$30			; loop until ready

;
; Return with A= status byte
;

	in p$disk$control		; read in status         

;
; Delay 18mS to allow for settling time
;

	lxi d,01400h			;
seek$delay2
	dcr	e			;
	jnz seek$delay2			; 896 uS
	dcr d				;
	jnz seek$delay2			; 20*896=18 mS

	push	psw			; save status
	lda	trk			; Get trk
	out	p$disk$track		; Save in track reg
	pop	psw			; Restore status
	ret

	page
;
; This routine actually executes the read or write command.  An initial
; read (or write) is sent out to the controller.  Since we are not 
; doing multiple sectors, an interrupt will be generated at the end of    
; the command.  This invokes the NMI set up at the beginning of the
; routine.  Either an INI or OUTI will be performed, depending on whether
; a read or write is invoked.  This lets us read in an entire sector 
; more efficiently.  
;

exec$command:				

	out p$disk$control		; send 1797 command

;
; Wait at least 24 usec after command before doing anything.
;

	mvi a,09
exec$delay
	dcr a
	jnz exec$delay			; (delays 31 usec)

;
; Now, wait for completion, but TIME OUT after 1.2 seconds.
;

	lxi d,60000+1
exec$0
	in p$disk$control		; get status
	rrc				; check not ready flag
	jnc exec$success		; if 0, successful completion

	inx d				; (waste time)
	dcx d				;
	inx d				;
	dcx d				;

	dcx d				; decrement count
	mov a,d				;
	ora e				;
	adi 0ffh			;
	jc exec$0			; 20 us*60000=1.2 seconds

;
; Time out.  Set A=0FFH and exit.
;

	mvi a,0d0h			; Reset FDC
	out p$disk$control		; send it out

	mvi a,0ffh			; Set time out flag
	jr exec$exit

;
; Successful completion.  Return w/status byte in A.


exec$success
	in p$disk$control		; Get status byte
exec$exit
	push	psw			; Save status
	call	start$motor$timer	; Start timer   
	pop	psw			;

	ret
	page
;
; Start up motor timer
;

Start$motor$timer:

	RET
;
; Exit from routine.
; Must set up interrupts appropriately.
;
fd$exit:
	push psw			; save status
	
	in p$disk$track			; read track
	out p$disk$data			; write out data

;
; Restore nmi locations
;

	lxi d,nmi			; Point at nmi
	lxi h,nmibuf			; and at save buffer
	lxi b,8				; load count
	ldir				; move saved data back


	mvi a,0d0h			;
	out p$disk$control		; Reset disk controller    

	pop	psw
	ora	a			; set flags
	ret				; and exit!!

;
; Set up NMI
; NMI (non-maskable interrupt) occurs at fixed location 0066h.
; During normal run time NMI does not occur, so these locations
; are normal RAM.  During diskette data transfers, NMI is
; triggered by the diskette Data Request signal, so the NMI
; locations are temporarily overlayed by intructions to process 
; the interrupt.
;
nmi	equ	0066h

nmi$setup:
	mvi	a,fdc$reset		; Reset FDC
	out	p$disk$control		;

	dcx	d			; Point to TYPE field of XDPH
	ldax	d			; Get value
	push	psw			; (save)
	ani	1			; Mask # sides
	sta	no$of$sides		; store

	pop	psw			; Get TYPE again
	push	psw			; Save
	db     07h			; Rotate 6&7into 0&1
	db	07h			;
	ani	0000$0011b		; Mask bits
	sta	step$rate		; store step rate

	pop	psw			; Get type
	ani	0000$0010b		; Mask TPI field
	rar				; Rotate into bit 0
	sta	TPI			; store

	lxi d,nmibuf			; point to storage area
	lxi h,nmi			; original values
	lxi b,8				; set up length
	ldir				; save them away

	lxi h,0d908h			; "EX AF,AF'"
	shld nmi			; beginning of nmi
	shld nmi+4			; also, end of nmi
	lxi h,045edh			; "RETN"
	shld nmi+6			; 

	mvi	a,3			; Enable FDC interrupt
	out	p$8255$control		;

	ret


	cseg

u$conin$echo:	; get console input, echo it, and shift to upper case
	call ?const ! ora a ! jrz u$c1	; see if any char already struck
	call ?conin ! jr  u$conin$echo	; yes, eat it and try again
u$c1:
	call ?conin ! push psw
	mov c,a ! call ?cono
	pop psw ! cpi 'a' ! rc
	sui 'a'-'A'		; make upper case
	ret

	cseg
	IF	REAL$1050
ivect2		equ	0fff8h	;
	ELSE
ivect2		equ	0ffe2h	; address of ivect+2
	ENDIF
nmibuf		ds	8	; buffer to hold prev contents of nmi
disk$command	ds	1	; current wd1797 command
select$mask	ds	1	; current drive select code
old$track	db	0ffh	; last track seeked to
dmaadr		ds	2
sect		ds	1
trk		ds	1	; track for current operation
disk$status	ds	1	; last error status code for messages

fd0$access
fd0$trk		db	0ffh	; last track accessed on A
fd1$trk		db	0ffh	; last track accessed on B

	; error message components

read$msg	db	', Read',0
write$msg	db	', Write',0

operation$name	dw	read$msg

	; table of pointers to error message strings
	;	first entry is for bit 7 of 1797 status byte

error$table	dw	b7$msg
		dw	b6$msg
		dw	b5$msg
		dw	b4$msg
		dw	b3$msg
		dw	b2$msg
		dw	b1$msg
		dw	b0$msg

b7$msg		db	' Not ready,',0
b6$msg		db	' Protect,',0
b5$msg		db	' Fault,',0
b4$msg		db	' Record not found,',0
b3$msg		db	' CRC,',0
b2$msg		db	' Lost data,',0
b1$msg		db	' DREQ,',0
b0$msg		db	' Busy,',0

time$out	db	' Time out,',0

error$msg	db	' Retry (Y/N) ? ',0
precomp$limit	db	43  
no$of$sides	db	0			; # sides
step$rate	db	0
tpi		db	0
motor$counter	db	0
	end

