	title	'MOVE - bank select and move module for CP/M Plus'
	maclib	ports
	maclib	z80
	cseg
;
;		subroutines for other modules use
;	
	public	?move,?xmove,?bank
;
;		external areas and subroutines that we may need to use
;
	extrn	@cbnk
	extrn	@bnkbf
	extrn	?bnksl

;		local save areas
;
move$stat:	db  	0		;flag to show next move is interbank
src$des$bank	equ	$		
src$bank:	db  	0		;source bank number
des$bank:	db  	0		;destination bank number

des$add:	ds  	2		;destination address for interbank move
src$add:	ds  	2		;source address for interbank move
mov$cnt:	ds  	2		;byte count for interbank move

old$stk$save:	ds  	2		;place to save users stack

					;place for out local stack

		ds  	24		; Stack size		(LEL0784)
local$stack	equ	$

tc$bank:	db  	0

		;conversion table used to translate
		;CP/M's bank to ours
		;
		;local equates
		;
int$bnk$act	equ	0		;flag for interbank move active

		page
;
;set interbank move flag active for next call to ?move subroutines
;and save both the destination and source numbers
;
;at entry:
;
;b = destination bank
;c = source bank
;

?xmove:
	sbcd	src$des$bank		;save source and destination
	lda	move$stat		;get status byte
	setb	int$bnk$act,a		;set interbank move active
	sta	move$stat		;save status byte
	ret				;return to caller

	page
?move:
	lda	move$stat		;test flag for interbank move
	bit	int$bnk$act,a		;and go to appropriate routine
	jrnz	int$bnk$mov		;*

	xchg				;we are passed source and dest in hl
	ldir				;use z80 block move instruction
	xchg     			;need next address in same registers
	ret				;return to caller

;
;	this routine is improved over the DR example
;
;	interbank moves of > 128 bytes can be made with one exception,
;	a move cannot span a bank boundry

int$bnk$mov:

	res	int$bnk$act,a		;set off interbank move flag
	sta	move$stat		;save status byte

	sspd	old$stk$save		;save callers stack
	lxi	sp,local$stack		;and load it with a local stack

	shld	des$add			;save destination address
	sded	src$add			;save source address
	sbcd	mov$cnt			;save length of move

int$bnk$mov$a:

	lhld	mov$cnt			;restore move length
	mov 	a,l			;check for zero length move
	ora	h			;*
	jrz	int$bnk$mov$ret		;*
;	lxi	b,128			;segment length
;	xra	a			;clear carry flag
;	db	0edh,042h		; SBC HL,BC    
;	jrc	int$bnk$mov$last	;last move this time
;	shld	mov$cnt    		;save remaining length
;	lhld	src$add			;restore source address
;	lxi	d,@bnkbf		;point at intermediate save area
;	lxi	b,128			;segment length
;	lda	src$bank		;get source bank number
;	call	?bank			;find physical bank and swap it
;	ldir				;move a segment
;	shld	src$add    		;save new source address
;	lxi	h,@bnkbf		;point at segment as source
;	lded	des$add			;restore real destination address
;	lxi	b,128			;segment length
;	lda	des$bank		;get segment bank number
;	call	?bank			;find physical bank and swap it
;	ldir				;move a segment
;	sded	des$add			;save new destination address
;	jr	int$bnk$mov$a		;loop until complete

int$bnk$mov$last:

	lhld	src$add			;restore source address
;	lxi	d,buffr 		;point at intermediate save area
	lded	@bnkbf

	lbcd	mov$cnt			;remaining length to move
	lda	src$bank		;get source bank number
	call	?bank			;find physical bank and swap it
	ldir				;move a segment
	shld	src$add    		;save new source address
;	lxi	h,buffr 		;point at segment as source
	lhld	@bnkbf

	lded	des$add			;restore real destination address
	lbcd	mov$cnt			;remaining length to move
	lda	des$bank 		;get destination bank number
	call	?bank			;find physical bank and swap it
	ldir				;move a segment
	sded	des$add    		;restore ending source address

int$bnk$mov$ret:

	lda	@cbnk			;load current bank number
	call	?bnksl			;find physical bank and swap it
	lspd	old$stk$save		;restore callers stack pointer
	ret

	page

?bank:
	ral				; rotate into 1&2
	ori	01h			; set bit 0 on
	out	p$bank$select		; Select bank
	ret

;buffr	ds	128
	end
