; Private BIOS call
;
; This routine is entered by making a BDOS call 50 (Direct BIOS 
; call) to Bios entry point 30.
;
; When called, A is a subfunction identifier.  (0 is illegal)
; Values in other registers depend upon particular subfunction.
;

	public	Priv$call
	maclib	Z80
	extrn	trandd,tranrainbow
	extrn	tranmorrow
	extrn	rspar
	dseg

PRIV$CALL:

	ora	a		; Check value in A
	jrz	bad$exit$2	; Jump if 0 (illegal)

	cpi	01		; Is it 1?
	jrnz	priv$2 		; Jump if not

;
; A=1 is a private call which gives the user access to flags located
; in memory. Register values are as follows:
;
;	C = # of byte to be accessed
;	B =0FFH if setting a byte
;	  =0FEH if setting a word
;	  =000H if a GET operation
;	  (else, ignored)
;	DE =  word value to be set
;   or  D = byte value to be set
;
; Upon exit, A or HL will contain the byte or word on a GET operation.
;

priv$1:
	push	b
	mov	a,c		; Get OFFSET
	CPI	MAX		; > MAX?
	JP	BAD$EXIT	; Yes => error

	lxi	h,bytetbl	; Point to bytetbl
	mvi	b,0		; Clear B
	DAD	B		; Add to get address within tbl
 
	pop	Psw		; Move B into A
	ORA	A		; Check SET
	JRZ	GET$op		; 0 => Get operation

	inr	a		; Increment
	jrz	set$byte	; FF => Set Byte

	inr	a		; Increment
	jrnz	bad$exit2	; If not FE, error

;
; Set word in bytetbl to VALUE
;

Set$word:

	mov	m,e		; Move Move lo byte into table
	inx	h		; Increment
	mov	m,d		; Move hi byte into table
	jr	priv$exit	; Exit

;
; Set byte in Bytetbl to VALUE.
;
Set$byte:

	mov	m,d		; Store it
	jr	priv$exit	;

;
; Get operation.  Move low byte into A and L, move high byte into H.
;

GET$op:
	Mov	a,m		; Get low byte
	inx	h		; increment
	mov	h,m		; Move high byte to H
	mov	l,a		; Move low byte to L
	jr	priv$exit	; exit
	page
;
; A=2 is a private call which returns in HL the address of the
; requested translate table.  
; C=1 if V1050 translate table requested
; C=2 if RAINBOW translate table requested
; C=3 if Morrow translate table requested
;
priv$2:
	cpi	02		; Is it 2?
	jrnz	priv$3 		; See if another type
	lxi	h,0		; HL=0 if neither
	mov	a,c		; Get C reg
	cpi	01		; Is it 1?
	jrz	V1050		; If yes, 1050 table
	cpi	02		; Is it 2?
	jrz	rainbow		; jump if yes
	cpi	03		; Is it Morrow?
	jrnz	priv$exit	; Jump if not
Morrow:
	lxi	h,tranmorrow	; Load Morrow address
	jr	priv$exit	; exit
Rainbow:
	lxi	h,tranrainbow	; load Rainbow address
	jr	priv$exit	; exit
V1050:
	lxi	h,trandd	; Load V1050 address
	jr	priv$exit	; exit
	page
;
; Private call 3 is a call to request the address of RSPAR, the
; current parameter settings for the AUX port 8251.  It can be used
; to set/reset the various bits to provide signals such as DTR, RTS, etc
; or to perform an error reset.
;
priv$3:
	cpi	03		; Is it 3?
	jrnz	priv$80		; If no, see if another type
	lxi	h,rspar		; else, get address of params
	jr	priv$exit	; exit
	page
;
; Other functions can be implemented here:
;
Priv$80:

	jr	priv$exit
;
; Error exit
;
Bad$exit:
	pop	b
bad$exit$2:



;
; Exit point
;

Priv$exit:
;
; Apparently, the A register gets moved on top of the L register
; sometime after leaving this routine.  To make sure HL is the
; desired result, move L to A.
;
	mov	a,l		;
	ret
BYTETBL:
	DB	0
	DB	0
	DB	0
	DB	0   
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0 
MAX	EQU	$-BYTETBL
	end