% File Boot.mc(2048)
Last edit by HGM March 5, 1980  11:32 AM,
	GOTO[.] on Boot,
	ZapDevices when clearing timers,
	Set Traps for strange Wakeups,
	Change Hang to Dally and reBoot, lengthen Dally a bit.
Last edit by Jim Frandeen March 2, 1980  1:53 PM Set everything to Font 0
Last edit by Jim Frandeen February 22, 1980  12:16 PM H4 parity errors for Model 31
Last edit by HGM February 14, 1980  11:35 PM,
	lights and dally into fault handler
Last edit by Jim Frandeen February 14, 1980  8:27 AM
Reorganized by Jim Frandeen January 26, 1980  11:11 AM. Unscramble Processor ID and store in CS location 7777. Handle H4 parity errors caused by the Model 31. General cleanup for SA4000 booting.
Created by Chuck Thacker, 1978
%****************************************************************
Insert[PromDefs];l4268e12
Title[Boot];l4268
Set Task[0];l4268
OnPage[InitialBootPage];l4268
*Definitions that depend on this page address. This will be page 0, but we leave it variable for test purposes.l4268
SET[InitialBootOffset,LSHIFT[InitialBootPage,10]];l4268e12
:IF[NotMidasTesting];	*Don't use locations 0 and 1 if testing with Midas.l11968d2998e12(0,11712)
StartBoot:e12
*We must be careful not to cause an R parity error. This means that we cannot read any Registers until they are loaded. Also, we must avoid a StackOverflow trap by loading Stkp with a known value.l4268
T_StkP_GetRSpec[147],	*Load T with 377 from NCIA.l4268
   GoTo[StartTest],l4268
   AT[0];	*Boot starts at location 0.l4268
l4268
*Control comes to location 1 if a parity error occurs.l4268
:IF[Model31];***Begin Code for Model 31****************************e12
*The following code determines whether the H4 parity error was expected. If so, we continue at the location specified by btParityReturn.l4268
ParityError:
LoadPage[0],l4268
   AT[1];l4268
ResetErrors;l4268
btParityTemp_10C;	*Address for notifyl4268
APCTask&APC_btParityTemp;l4268
ResetMemErrs,l4268
   RETURN;	*Continue belowl4268
LU_btParityReturn,	*Test for H4 parity error expectedl4268e12
   AT[10];l4268
GoTo[ResumeAfterParity,ALU#0];l4268
Boot, GOTO[.];	*Rebootl4268
ResumeAfterParity:e12
*Come here if the H4 parity error was expected. Continue at the location specified by btParityReturn.l4268
APCTask&APC_btParityReturn;l4268
btParityReturn_0C,	*Not expecting H4 parity nowl4268
   RETURN;l4268
:ELSE;**********End Code for Model 31******************************
**********Begin Code For SA4000*************************************e12
ParityError:	* We are in Task 17B now
LoadPage[0],l4268
   AT[1];l4268
T _ MPCodeFaultHappened;l4268
T _ (Parity)+(T);	* 20 thru 35l4268
ResetErrors, GOTO[SetPanelAndDally];	* UnFreeze Result and suchl4268
:ENDIF;*********End Code for SA4000********************************
:ELSE;*****Alternate code if MidasTesting so as not to wipe out 0e12
StartBoot:e12
GoTo[StartTest];l4268e12
IMRESERVE[0,0,2];l4268
:ENDIF;  * Of MidasTestinge12
e12
SetPanelAndDally:l10698d2998e12
Call[SetPanel];l4268
* Dally a short while so somebody can read the lightse12
Dally:
btTemp1 _ 400C;
btTemp _ 60000C;
btTemp _ (btTemp)-1, GOTO[.,R>=0];
btTemp1 _ (btTemp1)-1, GOTO[.-2,R>=0];
Boot, GOTO[.];	* Reboot to reload ControlStorel4268
*This routine puts the number in T in the Maintenance Panel.l10698d2998e24
* It does not TASK when it returns.
l10698d2998
SetPanel:l10698d2998
ClearMPanel;l4268
IncrementPanel:l10698d2998e12
btTemp_T;	*btTemp=number to put in panell11968d4268
SetPanelLoop:l10698d2998
btTemp1_4C;	*Delay countl11968d4268
btTemp1_(btTemp1)-1,l11968d4268
   GoTo[., ALU>=0];	*Delayl11968d4268
btTemp_(btTemp)-1;l11968d4268
UseCTask,l11968d4268
   GoTo[SetPanelReturn,ALU<0];	*If finishedl11968d4268
IncMPanel,l11968d4268
   GoTo[SetPanelLoop];l11968d4268
SetPanelReturn:l10698d2998
RETURN;l11968d4268
e12
*This section of code performs rudimentary tests to assure that the basic functions of the CPU are working. If an error is detected, put a number in the Maintenance Panel and hang.e12
StartTest:e12
*We must be careful not to cause an R parity error. This means that we cannot read a register until we load R3.l4268
LoadPage[TestPage1],l4268
   btTemp_T,AT[2];l4268
LU_T,l4268
   ClearMPanel,l4268
   GoToP[tsStartTest],AT[3];l4268
l4268
OnPage[TestPage1];l4268
tsStartTest:
LU_0C;l4268
ResetMemErrs,l4268
   GoTo[tsTestNonZero,ALU=0];l4268
tsFail1:
GoTo[NastyError];l4268
tsTestNonZero:
LU_377C;l4268
GoTo[tsLoadR0,ALU#0];l4268
tsFail2:
GoTo[NastyError];l4268
tsLoadR0:
btTemp_T_0C;l4268
LU_T;	*Allow load to happen (Don't test bypass yet).l11968d4268
IncMPanel;	*Increment to 1 to indicate that we have gotten started.l11968d4268
LU_(btTemp) XOR (0C);l11968d4268
GoTo[tsLoadT0,ALU=0];l11968d4268
tsFail4:l10698d2998
T_4C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadT0:l10698d2998
LU_(btTemp) XOR (T);l11968d4268
T_btTemp_125C,l11968d4268
   GoTo[tsLoadR125,ALU=0];l11968d4268
tsFail5:l10698d2998
T_5C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadR125:l10698d2998
LU_(btTemp) XOR (125C);l11968d4268
GoTo[tsLoadT125,ALU=0];l11968d4268
tsFail6:l10698d2998
T_6C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadT125:l10698d2998
LU_(btTemp) XOR T;l11968d4268
T_btTemp_252C,l11968d4268
   GoTo[tsLoadR252,ALU=0];l11968d4268
tsFail7:l10698d2998
T_7C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadR252:l10698d2998
LU_(btTemp) XOR (252C);l11968d4268
GoTo[tsLoadT252,ALU=0];l11968d4268
tsFail8:l10698d2998
T_10C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadT252:l10698d2998
LU_(btTemp) XOR T;l11968d4268
T_btTemp_125000C,l11968d4268
   GoTo[tsLoadR125000,ALU=0];l11968d4268
tsFail9:l10698d2998
T_11C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadR125000:l10698d2998
LU_(btTemp) XOR (125000C);l11968d4268
GoTo[tsLoadT125000,ALU=0];l11968d4268
tsFail10:l10698d2998
T_12C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadT125000:l10698d2998
LU_(btTemp) XOR T;l11968d4268
T_btTemp_52400C,l11968d4268
   GoTo[tsLoadR52400,ALU=0];l11968d4268
tsFail11:l10698d2998
T_13C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadR52400:l10698d2998
LU_(btTemp) XOR (52400C);l11968d4268
GoTo[tsLoadT52400,ALU=0];l11968d4268
tsFail12:l10698d2998
T_14C,GoTo[SetPanelAndDally1];l11968d4268
tsLoadT52400:l10698d2998
LU_(btTemp) XOR T;l11968d4268
btTemp_177400C,l11968d4268
   GoTo[tsRByPass,ALU=0];l11968d4268
tsFail13:l10698d2998
T_15C,GoTo[SetPanelAndDally1];l11968d4268
tsRByPass:l10698d2998
LU_(btTemp) XOR (177400C);l11968d4268
GoTo[tsTByPass,ALU=0];l11968d4268
tsFail14:l10698d2998
T_16C,GoTo[SetPanelAndDally1];l11968d4268
tsTByPass:l10698d2998
T_177400C;l11968d4268
LU_(btTemp) XOR T;l11968d4268
GoTo[tsAluOR,ALU=0];l11968d4268
tsFail15:l10698d2998
T_17C,GoTo[SetPanelAndDally1];l11968d4268
SET[TestRegLoc,LSHIFT[TestPage2,10]];	l15552d2998e12
MC[TestRegNotify,TestRegLoc];	l15552d2998
tsAluOR:l10698d2998e12
btTemp_TestRegNotify;	*Notify to insure task 0l11968d4268
APC&APCTask_btTemp,l11968d4268
   GoTo[tsReturn];	*Continue at tsRegTestl11968d4268
*This completes the tests of the basic CPU functions.l10698d2998e12
NastyError:l10698d2998e12
LoadPage[SetPanelPage];l11968d4268
GOTOP[Dally];l11968d4268
SetPanelAndDally1:l10698d2998e12
LoadPage[SetPanelPage];l11968d4268
GOTOP[SetPanelAndDally];l11968d4268
tsReturn:l10698d2998e12
RETURN;l11968d4268
l11968d4268
*Come here via Notify from tsAluOR when the basic CPU functions have been tested. Now test the register functions. If all goes well, clear the registers except for the registers 0-17, which are not so easy to access with EPROM code.l4512d4268
OnPage[TestPage2];l11968d4268e12
tsTestReg:l10698d2998
T_btTemp_20C,	*Start past Mesa stack to avoid overflow trap.l11968d4268
   AT[TestRegLoc];l11968d4268
tsStkWriteLoop:l10698d2998
StkP_btTemp;l11968d4268
Stack_T;	*Register n _ nl11968d4268
NOP;	*Careful not to cause R parity errorl11968d4268
LU_(Stack) XOR T;	*Did write work?l11968d4268
T_btTemp_(btTemp)+1,	*Increment nl11968d4268
   GoTo[tsStkWriteIncr,ALU=0];l11968d4268
tsFail16:l10698d2998
T_20C,GoTo[SetPanelAndDally2];l11968d4268
tsStkWriteIncr:l10698d2998
LU_(btTemp) XOR (400C);	*Test for last registerl11968d4268
GoTo[tsStkWriteLoop,ALU#0];l11968d4268
T_btTemp_20C;l11968d4268
tsStkReadLoop:l10698d2998
StkP_btTemp;l11968d4268
LU_(Stack) XOR T;l11968d4268
Stack_0C,	*Clear all registersl11968d4268
   GoTo[tsStkReadIncr,ALU=0];l11968d4268
tsFail17:l10698d2998
T_21C,GoTo[SetPanelAndDally2];l11968d4268
tsStkReadIncr:l10698d2998
T_btTemp_(btTemp)+1;	*Next registerl11968d4268
LU_(btTemp) XOR (400C);	*Test for last registerl11968d4268
GoTo[tsStkReadLoop,ALU#0];l11968d4268
l11968d4268e12
%Continue when registers 20-377 have been cleared.l11968d4268e12
The following code sets the Mesa Stack registers (registers 0-17) to zero in order to prevent a parity error. This won't be easy because we can't address all these registers directly (in EPROM code, we can only address registers with 11 in the low order two bits). To make things worse, we can't address them with the stack pointer either; this would cause a trap. So all this code creates an instruction to set R0 to zero and then increments the RSEL field by one until 17.l4268e12
The following definitions are for the three parts of a microinstruction that correspond to:l4268e12
   R0_0C,RETURN;l4268
MEMINST=0, RMOD=0, RSEL=110000 (because RSEL.0 and RSEL.1 must be complemented), ALUF=0, BSEL=0, F1=0, F2=0, LR=1, LT=0, JC=110(return), FA=0, Parity=0
%l4268
MC[ZeroReg00To15,30000];	*Word 0
MC[ZeroReg16To31,101400];	*Word 1
MC[ZeroReg32To35,0];	*Word 2l4268e12
*Definitions that depend on this page address:l11968d4268e12
MC[ClearStackPage,LSHIFT[TestPage2,10]];l16822d4268(2048)
MC[ClearStackOffset,50];	*Arbitrary page offsetl16822d4268
SET[ClearStackLoc,ADD[ClearStackPage!,ClearStackOffset!]];	*Arbitrary locationl16822d4268
SET[ClearStackEvenLoc1,ADD[ClearStackPage!,42]];	*Arbitrary even location for CSopl16822d4268
SET[ClearStackEvenLoc2,ADD[ClearStackPage!,44]];	*Arbitrary even location for CSopl16822d4268
ClearRegs0To17:e12(0,11712)
btCount_0C;	*Start with register 0.l4268e12
btBits32To35_ZeroReg32To35;	*Initialize bits 32 to 35l4268
btBits00To15_ZeroReg00To15;	*Initialize bits 0 to 15l4268
btBits16To31_ZeroReg16To31;	*Initialize bits 16 to 31l4268
btZeroRegAddr_ClearStackPage;	*Initialize ClearStack addressl11968d4268
btZeroRegAddr_(btZeroRegAddr)+(ClearStackOffset);l4268
ZeroNextRegister:e12
*Create a microinstruction to zero the next register and store it in ClearStack.l4268
T_btBits32To35;l4268
LU_btBits00To15;l4268
APC&APCTask_btZeroRegAddr;l4268
WriteCS0&2;	*Write bits 0 to 15, 32 to 35l4268
LU_btBits16To31,l4268
   AT[ClearStackEvenLoc1];	*Must be even location for CSopl4268
APC&APCTask_btZeroRegAddr;l4268
WriteCS1;	*Write bits 16 to 31l4268
*Now execute the instruction to clear a register.l4268e12
Call[ClearStack],AT[ClearStackEvenLoc2];	*Must be even location for CSopl11968d4268
*Test for last instruction.l4268e12
LU_(btCount) XOR (17C);l4268
btCount_(btCount)+1,	*Increment register numberl4268
   GoTo[RegistersInitialized,ALU=0];l4268
*Continue if we have another register to initialize. Increment the RSEL field of the microinstruction. Bits 32-33 of the microinstruction are the low order 2 bits of RSEL. They will come from the low order 2 bits of Count.l4268e12
T_(btCount) AND (3C);l4268
btBits32To35_T;l4268
btBits32To35_LSH[btBits32To35,2];l4268
*Bits 4 and 5 of the microinstruction are bits 2 and 3 of RSEL. These come from the high order 2 bits of Count.l4268e12
T_(btCount) AND (14C);l4268
btTemp_T;l4268
T_btTemp_LSH[btTemp,10];l4268
btBits00To15_(btBits00To15) AND NOT (6000C);l4268
btBits00To15_(btBits00To15) OR T;l4268
*The parity bit is bit 31. This depends on the number of bits in Count. If the number of bits in Count is odd, the parity is odd.l4268e12
T_btCount;l4268
btTemp_T;l4268
btBits16To31_(btBits16To31) AND NOT (1C);	*Turn off parity bit.l11968d4268
NextParityBit:
LU_btTemp, Skip[R Even];l4268
      btBits16To31_(btBits16To31) XOR (1C);l4268
btTemp_RSH[btTemp,1],l4268
   GoTo[NextParityBit, ALU#0];l4268
GoTo[ZeroNextRegister];l4268
ClearStack:e12
UseCTask;l11968d4268
ZeroReg:l10698d2998
btTemp_0C,RETURN,	*This is the instruction that gets modified.l11968d4268
   AT[ClearStackLoc];l11968d4268

RegistersInitialized:
*Now clear control store.l4268
LoadPage[TestPage3];l4268
btCount_20C,	*Set page countl4268
   GoToP[ClearCS];l4268
SetPanelAndDally2:l10698d2998e12
LoadPage[SetPanelPage];l11968d4268
GOTOP[SetPanelAndDally];l11968d4268

OnPage[TestPage3];l4268
SET[ClearCSEvenLoc3,ADD[LSHIFT[TestPage3,10],46]];	*Arbitrary even location for CSopl16822d4268(2048)
SET[ClearCSEvenLoc4,ADD[LSHIFT[TestPage3,10],52]];	*Arbitrary even location for CSopl16822d4268
ClearCS:(0,11712)
btCSAddr_100C;	*Don't clear EPROM areal4268
:IF[NotMidasTesting];	*Don't clear Control Store if testing with Midas.l11968d4268e12
ClearNextWord:
T_0C;l4268
APC&APCTask_btCSAddr;l4268
WriteCS0&2;l4268
LU_1C,	*Put in 1 for good parityl4268
   AT[ClearCSEvenLoc3];	*Must be even location for CSopl4268
APC&APCTask_btCSAddr;l4268
WriteCS1;l4268
btCSAddr_(btCSAddr)+1,l4268
   AT[ClearCSEvenLoc4];l4268
T_LDF[btCSAddr,10,10];	*Test for page boundaryl4268
GoTo[ClearNextWord,ALU#0];	*if not at end of page boundaryl4268
btCount_(btCount)-1;	*Decrement page count.l4268
GoTo[CSCleared,ALU=0];	*If donel4268
btCSAddr_(btCSAddr)+(100C),	*Step to next pagel4268
   GoTo[ClearNextWord];l4268
:ENDIF;	*End of clearing ControlStorel4268
CSCleared:e12
*Continue here when Control Store has been cleared. l4512d4268
l4512d4268e12
*This routine unscrambles the Processor ID and stores in in CS location 7777.l4512d4268e12
SET[ProcessorIDPage,TestPage3];l15552d2998e12(2048)
SET[ProcessorIDdisp,ADD[LSHIFT[ProcessorIDPage,10],20]];	*Arbitrary even location for dispatchl15552d2998
SET[ProcessorIDEvenLoc1,ADD[LSHIFT[ProcessorIDPage,10],30]];	*Arbitrary even location for CSopl15552d2998
SET[ProcessorIDEvenLoc2,ADD[LSHIFT[ProcessorIDPage,10],32]];	*Arbitrary even location for CSopl15552d2998
SET[ProcessorIDEvenLoc3,ADD[LSHIFT[ProcessorIDPage,10],34]];	*Arbitrary even location for CSopl15552d2998
btCSAddr_(AND[377, ScrambledProcessorIDAddress]C);	*Set CSAddr to point to the CS location where the Processor ID was loaded from the Prom.l11968d4268e12(0,11712)
btCSAddr_(btCSAddr) OR (AND[177400, ScrambledProcessorIDAddress]C);l11968d4268
T_btPIDstate_0C;	*Start with word 0l11968d4268
ProcessorIDLoop:l10698d2998e12
APC&APCTask_btCSAddr;l11968d4268
ReadCS;	*Read word 0 or word 1 from CSl11968d4268
Dispatch[btPIDstate,16,2],	*Dispatch on state.l11968d4268
   AT[ProcessorIDEvenLoc1];	*Must be even location for CS OPl11968d4268
T_RHMask[CSData],	*T contains next byte.l11968d4268
   Disp[ProcessorIDByte0];l11968d4268
ProcessorIDByte0:l10698d2998e12
btTemp_T,	*first bytel11968d4268
   AT[ProcessorIDdisp,0];l11968d4268
ProcessorIDNextState:l10698d2998e12
btPIDstate_(btPIDstate)+1;	*Next statel11968d4268
T_(btPIDstate) AND (1C),	*Get word 0 on even states and word 1 on odd states.l11968d4268
   GoTo[ProcessorIDLoop];l11968d4268
ProcessorIDByte1:l10698d2998e12
btTemp_(LSH[btTemp,10]) OR T,	*Merge second bytel11968d4268
   AT[ProcessorIDdisp,1];l11968d4268
btCSAddr_(btCSAddr)+1,	*only 2 bytes per wordl11968d4268
   GoTo[ProcessorIDNextState];l11968d4268
ProcessorIDByte2:l10698d2998e12
btTemp1_T,	*Third bytel11968d4268
   GoTo[ProcessorIDNextState],l11968d4268
   AT[ProcessorIDdisp,2];l11968d4268
ProcessorIDByte3:l10698d2998e12
btTemp1_(LSH[btTemp1,10]) OR (T),	*Fourth (last) bytel11968d4268
   AT[ProcessorIDdisp,3];l11968d4268
*This is the state of affairs:
*  btTemp   left byte = CS location 7475  bits 8-15
*  btTemp   right byte = CS location 7475  bits 24-31
*  btTemp1   left byte = CS location 7476  bits 8-15
*  btTemp1   right byte = CS location 7476  bits 24-31
*Now write the Processor ID in the last CS location.l4256e12
btCSAddr_(AND[377, ProcessorIDAddress]C);	*Set CSAddr to point to the CS location where the Processor ID will be saved.l11968d4268e12
btCSAddr_(btCSAddr) OR (AND[177400, ProcessorIDAddress]C);l11968d4268
T_0C;	*Data for bits 32-35 is zero.l11968d4268
LU_btTemp;	*Data to be written in word 0l11968d4268
APC&APCTask_btCSAddr;	*Address to write Processor IDl11968d4268
WriteCS0&2,	*Write word 0l11968d4268
   LU_btTemp1;	*Load CSIn with next wordl11968d4268
APC&APCTask_btCSAddr,	*Address to write Processor IDl11968d4268
   AT[ProcessorIDEvenLoc2];	*Must be even locationl11968d4268
WriteCS1;	*Write word 1l11968d4268
IncMPanel,	*Increment panel to 2 to indicate that all tests are done.l11968d4268
   AT[ProcessorIDEvenLoc3];	*Must be even locationl11968d4268
%
Look to see why we were booted: Midas or Panel are the expected cases.

Note that we will go the wrong way if we get (re)Booted because of a CS or R mem error after a Midas Boot.  (Reloading the BootReason register forgets the Midas boot flag.)  But that's ok because Midas will notice that we are not talking to it and yank on it's wire again.
%l3008d2998e24
:IF[NotMidasTesting];	*If Midas Testing, we will always go DiskBoot.l11968d4268e12
LU_GetRSpec[157] AND (40C);	*Test for tester boot (it is complemented)l4512d4268e12
GoTo[GoMidas,ALU=0];	*Midas bootl11968d4268
:ENDIF;  l11968d4268
GoDiskBoot:l10698d2998e12
LoadPage[ZapPage];l11968d4268
GoToP[ZapDevices];l11968d4268
GoMidas:l10698d2998e12
LoadPage[MidasBootPage];l11968d4268
GoToP[MidasBoot];l11968d4268

ONPAGE[ZapPage];l4512d4268
%
Clear all the devices just in case.  This shouldn't do anything because they were just reset by the Boot sequence that got us this far, but it can't hurt.  We have not done any TASKing RETURNs yet, so random wakeup requests have not had a chance to do anything horrible.

Note that this doesn't do anything to old Ethernet boards.  (Tough.)
%l3242d2998
ZapDevices:l3242d2998e12
T _ btTemp1 _ 177400C;l4512d4268
btTemp _ 0c;l4512d4268
ZapLoop:l3242d2998
OUTPUT@[btTemp];	*send 0 to register 0l4512d4268
T _ btTemp1 _ (btTemp1) + (20c);l4512d4268
goto[ZapLoop,ALU<0];l4512d4268
*Clear all the timers; otherwise a timer will go off and kill us.l3242d2998e12
btTemp_100000C;l11968d4268
ClearTimers:l10698d2998
LoadTimer[btTemp];l11968d4268
ResetMemerrs;l11968d4268
btTemp_(btTemp)+1;l11968d4268
LU_(btTemp) AND (17C);l11968d4268
GoTo[ClearTimers,ALU#0];l11968d4268
LU_Timer;	* Gobble up any timer that was readyl11968d4268
* Capture all TPCs in case we get a strange wakeup from broken hardware.l10698d2998e12
SET[TrapSetupLoc,ADD[LSHIFT[TrapPage,10],40]];l15552d2998(2048)
SET[SetNextTrapLoc,ADD[LSHIFT[ZapPage,10],42]];l15552d2998
SetTraps:l10698d2998e12(0,11712)
btTemp _ 60C;	* Random scratch registerl11968d4268
Stkp _ btTemp;	*  that won't cause StackOvfll11968d4268
Stack _ AND[377,SetNextTrapLoc]C;l11968d4268
Stack _ (Stack) OR (AND[177400,SetNextTrapLoc]C);l11968d4268
btTemp _ AND[377,TrapSetupLoc]C;l11968d4268
btTemp _ (btTemp) OR (AND[177400,OR[TrapSetupLoc,LSHIFT[17, 14]]]C);l11968d4268
Smash:l10698d2998
APC&APCTask _ btTemp;	* Notify to TrapSetupl11968d4268
RETURN;l11968d4268
SetNextTrap:l10698d2998
LU _ LDF[btTemp,0,3], AT[SetNextTrapLoc];l11968d4268
btTemp _ (btTemp) - (10000C), GOTO [Smash, ALU#0];l11968d4268
LoadPage[DiskBootPage];l11968d4268
GoToP[DiskBoot];l11968d4268
* These 6 instructions should not get overlayed by initial.l10698d2998e24
TrapSetup:l10698d2998
CALL [TrapSetupExit], AT[TrapSetupLoc];	*Leave TPC herel11968d4268
StrangeTaskRan:l10698d2998
T _ CTask;l11968d4268
btTemp _ T, LOADPAGE[SetPanelPage];l11968d4268
T _ (btTemp)+(MPCodeUnexpectedWakeup), GOTOP[SetPanelAndDally];l11968d4268
l11968d4268
TrapSetupExit:l10698d2998
APC&APCTask_Stack;	* Notify back to SetNextTrapl11968d4268
RETURN;l11968d4268
l11968d4268e12
OnPage[MidasBootPage];l11968d4268
*Definitions that depend on this page address:l10698d2998e12
SET[MidasBootEvenLoc1,ADD[LSHIFT[MidasBootPage,10],2]];	*Arbitrary even locationl15552d2998e12
SET[MidasBootEvenLoc2,ADD[LSHIFT[MidasBootPage,10],4]];	*Arbitrary even locationl15552d2998
MidasBoot:l10698d2998e12
*This is the Midas loader. We come here if the boot reason is Midas Boot. We load the Kernel from the Alto Via the Printer interface and jump to it.l4512d4268
btTemp_(400C);	*Set bus for receivel11968d4268
Printer_btTemp;l4512d4268
*Now receive address/data pairs from the Alto. The Address comes first (2 bytes) followed by data (5 bytes). If the address has bit 0 set, jump to that address. l4512d4268e12
MidasLoad:l3242d2998e12
btByte_0C,	*Get 2 bytes of addressl4512d4268
   Call[MidasReceive],l4512d4268
   AT[MidasBootEvenLoc1];	*Must be even locationl4512d4268
btCSAddr_T,l4512d4268
   GoTo[MidasJump,ALU<0];	*If address<0, jump to codel4512d4268
NOP;	*Placement constraintl4512d4268
btByte_0C,l4512d4268
   Call[MidasReceive];	*Get data word 0l4512d4268
btWord0_T;l4512d4268
btByte_0C,	*Get data word 1l4512d4268
   Call[MidasReceive];l4512d4268
btWord1_T;l4512d4268
btData_0C;	*Last byte, clear upper bitsl4512d4268
btByte_1C,l4512d4268
   Call[MidasReceive];	*Get data word 1 (1 byte only)l4512d4268
LU_btWord0;	*LoadCSIn, T has word 2l4512d4268
APCTask&APC_btCSAddr;	*Addressl4512d4268
WriteCS0&2;	l4512d4268
LU_btWord1,	*Load CSinl4512d4268
   AT[MidasBootEvenLoc2];	*Must be even locationl4512d4268
APCTask&APC_btCSAddr;	*Addressl4512d4268
GoTo[MidasLoad],l4512d4268
   WriteCS1;	l4512d4268
*Come here when the address has bit 0 set.l4512d4268e12
MidasJump:l3242d2998e12
btCSAddr_(btCSAddr) AND NOT (170000C);	*Clear upper bitsl4512d4268
T_APCTask&APC_btCSAddr;	*Get address to jump tol4512d4268
RETURN;	*Jump to addressl4512d4268
MidasReceive:l10698d2998e12
T_Printer,l11968d4268
   GoTo[MidasReceive,R>=0];	*Look for send strobel11968d4268
LU_(Printer)-T;	*Tell-me-thrice here to increase noise immunityl11968d4268
Skip[ALU=0];l11968d4268
GoTo[MidasReceive];l13238d5538
LU_(Printer)-T;	*Tell-me-thrice here to increase noise immunityl11968d4268
Skip[ALU=0];l11968d4268
GoTo[MidasReceive];l13238d5538
btTemp_T;	*Printer data and controll11968d4268e12
T_RHMask[btTemp];	*Mask off data bitsl11968d4268
T_btData_(LSH[btData,10]) OR T;	*Shift and mergel11968d4268
btTemp_2400C;	l11968d4268
Printer_btTemp;l11968d4268
WaitForACK:l10698d2998e12
LU_Printer,l11968d4268
   GoTo[WaitForACK,R<0];	*Look for bit 0=0l11968d4268
btTemp_400C;	*Got it, turn ACK offl11968d4268
Printer_btTemp;l11968d4268
LU_btByte,l11968d4268
   UseCTask,l11968d4268
   Skip[R Odd];	*one or two bytes (least significant byte if 1)l11968d4268
btByte_1C,l13238d5538
   GoTo[MidasReceive];	*Can't go direct to MidasReceivel13238d5538
LU_T,l11968d4268
   RETURN;	*Set condition codes with data, no Task returnl11968d4268
l11968d4268
l11968d4268
:END[Boot];l11968d4268
l10698d2998
