:TITLE[Disk];	*Alto rigid disk controller

%27 May 1983 by Fiala: bum 1 mi at WDFx+6, 1 mi at ReadFinalSingle+6;
  save 1 cycle at SendSecondHeader; put rdcLongPointer1 setup into
  Initialize.Mc saving 2 mi; bum 1 mi at LabelIn+4.
21 January 1983 by Ed Fiala; fix Output-Output-PStore4 problems at StepIn+4,
  rdcWaitD+2, WDFx+3, and SendSecondHeader+2.
%

Set[rdcDRun0,LShift[rdcTask,4]];	*Not task 3 mod 4 because of rdcDCB
				*and rdc520

Set[rdcStatus,1];
Set[rdcBufferInput,17]; *Input[x,rdcBufferInput] gets buffer word into x
Set[rdcBufferStore,Add[rdcDRun0,17]];
	*IOStoren[memBase,rdcBufferStore] stores n words from buffer into mem 

Set[rdcGenReset,0];
Set[rdcDr/HdReg,1];
Set[rdcErrRst,2];
Set[rdcDevOpReg,3];
Set[rdcBufferOutput,4]; *Output[x,rdcBufferOutput] stores x into buffer
Set[rdcMemBufAddr,6];
Set[rdcPrimeIData,7];
Set[rdcBufferFetch,Add[rdcDRun0,4]];
	*IOFetchn[memBase,rdcBufferFetch] gets n words from mem into buffer 


SetTask[rdcTask];

Set[rdcRBase,And[60,rdcDRun0]]; *first of the 16 RM locations used by the disk

*Keep following four registers together and quadaligned
*DoIntR requires Temp and Temp1 at 0 and 1
RV4[rdcTemp,rdcTemp1,rdcLongPointer,rdcLongPointer1,Add[0,rdcRBase]];

RV[rdcCount,Add[4,rdcRBase]];
*Bit 0 default partition, 10b in 1:4, 626b in 6:16b, and zeroes in 5&17b.
RV[rdcPartition,Add[5,rdcRBase]];
RV[rdcAltoCommand,Add[6,rdcRBase]];
RV[rdcIntWord,Add[7,rdcRBase]];

*Next four registers also quadaligned (for reading KBLK)
*dummy name, for quadword KBLK fetch.
RV2[rdcAltoStatus,rdcAltoDA,Add[10,rdcRBase]];
*rdcAltoDA used during setup for transfer, rdcDiskCommand during transfer
RM[rdcDiskCommand,IP[rdcAltoDA]];

RV[rdcDiskStatus,Add[12,rdcRBase]];	*read from controller at start of every sector

*Bits 0:4 current sector, head settle flag in bit 5, bits 8:15 track.
RV[rdcPosition,Add[13,rdcRBase]];

*Don't move these base regs without fixing initialization in Initialize.Mc
RV2[rdc520,rdc520hi,14];
RV2[rdcDCB,rdcDCBhi,Add[16,rdcRBase]];

*The following two regs are for testing and may be removed.
RV[HeaderFlakeCnt,Add[70,rdcRBase]];
RV[ServiceLateCnt,Add[71,rdcRBase]];

SetTask[0];

*Common subroutine for Mesa/Alto Partition instruction.
*newP in RTemp, result in T.

OnPage[XMiscPage];

MXPar:	RTemp1 _ IP[rdcPartition]C;
	T _ (SStkP&NStkP) xor (377C);
	StkP _ RTemp1, RTemp1 _ T, NoRegILockOK;
	RTemp _ (RTemp) - 1;	*internally, partitions are 0..1, not 1..2.
*Return current default without change if newP is 0
	LU _ (RTemp) and not (1C), Skip[ALU>=0];
	  T _ (RSh[Stack,17]) + 1, GoTo[RestSP];	*RestSP in Timer.Mc
	T _ (RSh[Stack,17]) + 1, Skip[ALU=0];
	  T _ 0C, GoTo[RestSP];	*Return 0 on illegal newP
	LU _ RTemp, Skip[R Odd];
	  Stack _ (Stack) and not (100000C), GoTo[RestSP];	*new value = 0
	Stack _ (Stack) or (100000C), GoTo[RestSP];	*new value = 1

*Throwaway initialization code
SetTask[rdcTask];

rdcInit:
	T _ rdc520 _ 400C, At[rdcInitLoc];
	rdc520 _ (rdc520) or (120C);
*	rdcDCBhi _ 0C;			*In Initialize.Mc
*	rdc520hi _ 0C;			*In Initialize.Mc
	Output[rdc520hi,rdcGenReset];	*Reset 
	Output[rdc520hi,rdcDr/HdReg];	*SET rdcDISK=0 HEAD=0
*Initialize put BootType in MNBR--start at partition 1 or 2 based upon bit 8.
	T _ MNBR;
	T _ rdcIntWord _ Zero, Skip[H2Bit8];
	  rdcPartition _ 41400C, Skip;	*Par 1
	rdcPartition _ 141400C;		*Par 2
	rdcPosition _ T, LoadPage[rdcInitPage2];
	rdcPartition _ (rdcPartition) or (54C);
*ON ETHERBOOT, DISK INIT WON'T FINISH FOR A LONG TIME, SO CAN'T OVERWRITE
*THIS WITH FINAL OVERLAY.
OnPage[rdcInitPage2];
	rdcCount _ 34C, Call[rdcSetCmd];	*Head settle delay

*Look for DevSelOk and SeekComplete.  When we have them, look for
*Track0.  If not, issue an outward step pulse on alternate sectors.
*When the disk is at track 0, go to IndexError to acquire index.
	Input[rdcDiskStatus,rdcStatus];
	LU _ (LdF[rdcDiskStatus,12,2]) xor T;	*SeekComplete, DevSelOK
	LU _ LdF[rdcDiskStatus,11,1], Skip[ALU=0]; *field is Trk0
	  IOStrobe, GoTo[rdcIniRet];
	rdcDiskCommand _ 6000C, GoTo[AtTrk0,ALU#0];
*IOStrobe cancels the sector wakeup.
	rdcPosition _ (rdcPosition) + 1, IOStrobe, Skip[R Odd];
rdcIniRet:
	  T _ 3C, Return;			*wrong sector for step pulse
	Output[rdcDiskCommand,rdcDevOpReg];	*WakeAllow, Step, Out
rdcSetCmd:
	rdcDiskCommand _ 4000C;
	Output[rdcDiskCommand,rdcDevOpReg];	*WakeAllow, NoStep, Out
	rdcDiskCommand _ rdcDiskCommand, Return;

*recalibrate and synchronize: get to track zero, sector 0
AtTrk0:	LoadPage[rdcPage];
	rdcPosition _ 2000C, GoToP[IndexError];	*Track0, heads settling

%Here are codes, locations, and reasons for all errors posted by this microcode:

CODE	LOCATION		REASON

10	SectorWakeupx+13	No transfer last sector (normal)
203	HaveCommand+13		Seal comparison with 110b failed
3	HaveCommand+15		Command specified sector .gr. 15b
10	Recal+10		No transfer last sector (normal during recal)
100	NoRecalx+3		Seek in progress
100	ArmStillMoving		Seek in progress
100	SeekUnnecessary+6	Seek in progress
10	SeekOnlyCmd		Seek only command is done
--	HeaderFlake+1		RDC raised IOAtten when we expected it to
				have read the header data into the buffer.
				Controller retries the command automatically.
200	HeaderCheckFlake+1	RDC raised IOAtten when header was read by a
				Check command.  We should determine whether
				the disk is at the correct TRACK position,
				and declare a check error if it is, but
				instead, we say SeekFailed.
1	LabelIn+2		RDC raised IOAtten at second label wakeup
2	HLReturn+1		Header or Label check failed.
1	FirstSectorError	RDC raised IOAtten at start of the 2nd sector.
21	rdcWriteDone+3		RDC raised IOAtten during or after writing
				data field.
1	ReadDataField+10	RDC raised IOAtten before reading data field.
1	rdcReadDone+3		RDC raised IOAtten after read, but
				Status.RdErr was off.
5	rdcReadDone+3		RDC raised IOAtten after read, Status.RdErr
				was on
%

OnPage[rdcPage];

rdcIOSRet:	IOStrobe;
*interlock Outputs at NoHeaderFlake, LabelFlake+1, & ReadDataField+4
rdcReturn:
	rdcAltoCommand _ rdcAltoCommand, Return;

UpdateChain:
	PStore1[rdc520,rdcTemp1,1], GoTo[rdcNTTEr];

*Get here on an error:
FlushCmd:	
	Input[rdcDiskStatus,rdcStatus];
	rdcTemp1 _ 0C, Call[UpdateChain];	*zap the controller
	rdcAltoStatus _ (rdcAltoStatus) or (7400C); *Status _ Done
*store final status into the DCB. UNLIKE ALTO, Sector_0.  Then resynchronize
	PStore1[rdcDCB,rdcAltoStatus,1], Call[rdcNTTEr];
*Fetch error interrupt word; interrupt starts next proper sector.
	PFetch1[rdcDCB,rdcIntWord,7], GoTo[IndexReset];


*Get here when a seek-only (status = 10b), write (status = 0), or read
*(status = 100000) is done.  Chain to next command.  Note: must not task
*to emu between DCB chain update and storing status in DCB.
Chain:	PFetch1[rdcDCB,rdcTemp1,0], Call[UpdateChain];	*Chain to next DCB
	PFetch1[rdcDCB,rdcIntWord,6];	*IntWord for next sector interrupt.
	rdcPosition _ (rdcPosition) and not (1000C); *clear 'Ignore Recal' bit
*skip if read
	rdcAltoStatus _ (rdcAltoStatus) and not (100000C), Skip[R<0];
	  IOStrobe;
	rdcAltoStatus _ (rdcAltoStatus) or (7400C); *Status _ Done
*Store final status into the DCB. UNLIKE ALTO, Sector_0.
	PStore1[rdcDCB,rdcAltoStatus,1], Call[rdcReturn];
SectorWakeup1:
	PFetch1[rdc520,rdcDCB,1], GoTo[SectorWakeupx];

IndexReset:	*Keep looking for index pulse
	Output[rdcAltoCommand,rdcErrRst];
IndexError:
	IOStrobe, Call[rdcReturn];
*Here one sector later--acquire index.
	Input[rdcDiskStatus,rdcStatus];
	LU _ (rdcDiskStatus) and (200C);
*note: 'Ignore Recal' is cleared.
	rdcPosition _ (rdcPosition) and not (175000C), GoTo[IndexReset,ALU=0];
*Fall through to here when index found
*Jump here if there is a command, but the disk is not on sector yet.
ContinueCmd:
	IOStrobe, Call[rdcReturn];

*Start of next sector
SectorWakeup:
	PFetch1[rdc520,rdcDCB,1];
SectorWakeupx:
	T _ (rdcPosition) and (170000C);	*Last sector's number, Alto style.
	rdcAltoStatus _ (LdF[rdcAltoStatus,4,14]) or T;	*Last sector's status
	Input[rdcDiskStatus,rdcStatus];
	T _ rdcIntWord;				*Interrupts from last sector
	rdcIntWord _ 0C;
	PFetch1[rdc520,rdcTemp,4];		*Fetch sector int mask
	LU _ (rdcDiskStatus) and (200C);	*Check for index mark 
	LU _ rdcDCB, GoTo[rdcIndex,ALU#0];	*Clear or inc sector based on index
	rdcPosition _ (rdcPosition) + (4000C), GoTo[HaveCommand,ALU#0];
NoCommand:
	PStore1[rdc520,rdcAltoStatus,2];
	LoadPage[DoIntPage];
	rdcTemp _ (rdcTemp) or T, IOStrobe, CallP[DoIntR];

	rdcAltoStatus _ 10C, GoTo[SectorWakeup];	*no-transfer status

rdcIndex:
	rdcPosition _ (rdcPosition) xor (154000C);	*Sector _ 0 (?)
	LU _ (rdcPosition) and (174000C);
	LU _ rdcDCB, GoTo[IndexError,ALU#0];
	GoTo[NoCommand,ALU=0];
*Get here if there is a command.
HaveCommand:
	PFetch1[rdcDCB,rdcAltoDA,11];	*fetch disk address of command
*Sector interrupt mask in reg 0 (rdcTemp); store last sector's status and
*this command's AltoDA in core for the emulator.
	rdcTemp _ (rdcTemp) or T, LoadPage[DoIntPage];
	PStore2[rdc520,rdcAltoStatus,2], CallP[DoIntR];

	PFetch1[rdcDCB,rdcAltoCommand,2];	*fetch command

*Shugart sector number _ 2*AltoSector + AltoHead
	T _ (rdcAltoDA) and (170000C);
	LU _ (rdcAltoDA) and (4C); 	*Test 'head' bit
	rdcTemp _ T, Skip[ALU=0];	*rdcTemp holds Shugart sector
	  rdcTemp _ (rdcTemp) + (4000C);

*Check command Seal and 'complement  disk' bit
	rdcAltoCommand _ (rdcAltoCommand) xor (44000C), Skip[R Even];
	  rdcAltoDA _ (rdcAltoDA) xor (2C);	*complement the disk bit in AltoDA
	LU _ (rdcAltoCommand) and (176000C);	*check for good seal (bits 6,7 hold partition no.)
	LU _ (rdcAltoDA) + (20000C), Skip[ALU=0];	*check for legal Alto sector (0..15b)

*Bad seal; Status _ seek failed, illegal sector
	  rdcAltoStatus _ 203C, GoTo[FlushCmd];

*Shugart Track _ (406c*AldoDisk + AltoTrack)/8 +1
	T _ (rdcAltoDA) and (2C), Skip[Carry'];	*Test disk bit (T_0 if off)
	  rdcAltoStatus _ 3C, GoTo[FlushCmd];	*Status _ illegal sector

*Test partition bits in the command
	LU _ LdF[rdcAltoCommand,6,2], Skip[ALU=0];
	  T _ LdF[rdcPartition,6,11], DblGoTo[DefPar,NDefPar,ALU=0]; *add 406d to address
	T _ 0C, DblGoTo[DefPar,NDefPar,ALU=0];

DefPar:	T _ (LdF[rdcPartition,1,4]) + T, DblGoTo[ParOne,ParZero,R<0]; *T _ 10, check partition
NDefPar:
	LU _ LdF[rdcAltoCommand,6,1];
	T _ (LdF[rdcPartition,1,4]) + T, DblGoTo[ParOne,ParZero,ALU#0];

ParOne:	T _ (LdF[rdcPartition,6,12]) + T;	*add 812d to address
ParZero:
	rdcAltoDA _ (LdF[rdcAltoDA,4,11]) + T, GoTo[NoRecal,R Even];
*rdcAltoDA now has (8*Shugart track) + head

Recal:	LU _ (rdcPosition) and (1000C);	*check 'ignore recal'
*set up as if ignoring recal
	T _ LdF[rdcPosition,7,10], GoTo[NoRecalx,ALU#0];
	LU _ (rdcDiskStatus) and (40C);	*Check seek complete
	LU _ (rdcDiskStatus) and (100C), Skip[ALU#0];	*check TRACK0
	  rdcIntWord _ 0C, GoTo[ArmStillMoving];
	rdcPosition _ (rdcPosition) and (177000C), GoTo[StepOutx,ALU=0]; *rdcPosition.Track_0
*Get here when recal is complete.  Set head settling flag and 'ignore recal'
*bits in rdcPosition and settling count in rdcCount.
*The next command will incur head settling delay.
	rdcPosition _ (rdcPosition) or (3000C), Task;
	rdcCount _ 34C;
*Status _ no transfer last sector
	rdcAltoStatus _ 10C, GoTo[ContinueCmd];

*Get here if the command is not a recal, and is OK so far.  rdcTemp contains
*the desired Shugart sector in bits 0-4, rdcAltoDA holds the Shugart
*track,,head number.  Check for seek required.
NoRecal:
	T _ LdF[rdcPosition,7,10];	*Current Shugart track
NoRecalx:
	LU _ (LdF[rdcAltoDA,5,10]) - T;
	FreezeResult, GoTo[SeekUnnecessary,ALU=0];
*issue step pulses every other sector
	rdcPosition _ (rdcPosition) + 1, FreezeResult, Skip[R Odd];
	  rdcAltoStatus _ 100C, GoTo[ContinueCmd];
	rdcCount _ 34C, DblGoTo[StepOut,StepIn,ALU<0]; *desired-current (negative => OUT)

*We incremented rdcPosition by 1 twice at NoRecalx+2, so subtract 4.
StepOut:
	rdcPosition _ (rdcPosition) - (4C);
StepOutx:
	rdcAltoCommand _ 6000C, Skip;
StepIn:	rdcAltoCommand _ 7000C;	*We incremented rdcPosition at NoRecalx+2
	Output[rdcAltoCommand,rdcDevOpReg];	*step, wake allow, direction
	rdcPosition _ (rdcPosition) or (2000C); *set head settling flag
*clear seek command bit, interlock
	rdcAltoCommand _ (rdcAltoCommand) and not (2000C);
*no step, wake allow, direction unchanged
	Output[rdcAltoCommand,rdcDevOpReg];
ArmStillMoving:
	rdcAltoStatus _ 100C, GoTo[ContinueCmd]; *status _ SeekInProgress

*Get here if the arm is at the correct position.
SeekUnnecessary:
	T _ LdF[rdcTemp,0,6];
	LU _ (LdF[rdcPosition,0,6]) xor T; *Compare sector addresses
	LU _ (rdcDiskStatus) and (40C), GoTo[DoTransfer,ALU=0];	*Test seek complete

*Get here if arm is at the right place, but sector comparison failed, either
*because angular position wrong or because heads not yet settled after seek.
*If SeekComplete, decrement head settle count in rdcCount.  If rdcCount
*negative, clear head settling flag.
	rdcIntWord _ 0C, GoTo[ArmStillMoving,ALU=0];	*ALU=0 means seek incomplete
	rdcCount _ (rdcCount) - 1, Skip[R>=0];	*test settling count
	  rdcPosition _ (rdcPosition) and not (2000C); *clear settling flag
	rdcAltoStatus _ 100C, GoTo[ContinueCmd]; *status _ SeekInProgress

rdcIncLPNT:
	UseCTask, GoTo[rdcRTx];

*Max of ~53 cycles from last task to here.
DoTransfer:
	LU _ (rdcAltoCommand) and (2C);		*check SeekOnly flag
*clear all but head number.
	rdcAltoDA _ (rdcAltoDA) and (7C), Skip[ALU=0];
	  rdcAltoStatus _ 10C, GoTo[Chain];	*Seek-only cmd--chain
*Here when ready to do a transfer.
	LU _ LdF[rdcAltoCommand,12,1];
	Output[rdcAltoDA,rdcDr/HdReg], Skip[ALU#0];	*load head register
	  rdcTemp1 _ 0C, GoTo[DoHeader];
*Load Label buffer
	PFetch1[rdcDCB,rdcLongPointer,4], Task;
	rdcTemp1 _ 4C;
	T _ LdF[rdcLongPointer,16,2];
	rdcTemp1 _ (rdcTemp1) - T;
	Output[rdcTemp1,rdcMemBufAddr];
	rdcTemp1 _ RSh[rdcTemp1,2], Call[rdcReturn]; *interlock, task
	rdcTemp1 _ 0C, Skip[R Odd];	*If quadaligned label, do 2 IOFetch4's
	  IOFetch4[rdcLongPointer,rdcBufferFetch,0], Call[rdcIncLPNT];
	IOFetch4[rdcLongPointer,rdcBufferFetch,0], Call[rdcIncLPNT];
	IOFetch4[rdcLongPointer,rdcBufferFetch,0], Call[rdcReturn];

DoHeader:
	PFetch1[rdcDCB,rdcLongPointer,3], Call[rdcReturn]; *fetch header pointer into base register
	LU _ LdF[rdcAltoCommand,10,2];	*test for header read (0)
	LU _ LdF[rdcAltoCommand,10,1], GoTo[HeaderWriteOrCheck,ALU#0];
HdrRead:
	rdcDiskCommand _ 4400C;		*inhibit header abort allowing read to finish
	LU _ LdF[rdcAltoCommand,12,1];	*set header verify bit, test label operation
	rdcDiskCommand _ (rdcDiskCommand) or (100C), DblGoTo[rdcLabelWrite,rdcLabelRdChk,ALU#0];


HeaderWriteOrCheck:
	rdcDiskCommand _ 4000C, Skip[ALU#0];
	  rdcDiskCommand _ (rdcDiskCommand) or (100C), GoTo[LoadHeaderBuffer]; *check => verify
	rdcDiskCommand _ (rdcDiskCommand) or (200C);	*Header write
*When writing headers, clear the OtherDisk bit in rdcAltoCommand so that the
*test in LoadHeaderBuffer will skip (causing the header to be written as
*specified in the header record (allows writing DP0 style headers on DP1).
	rdcAltoCommand _ (rdcAltoCommand) and not (1C);

LoadHeaderBuffer:	*clear buffer pointer in RDC (rdcTemp1 contains 0)
	Output[rdcTemp1,rdcMemBufAddr];
	PFetch1[rdcLongPointer,rdcTemp,1], Call[rdcNTTE]; *fetch SECOND header word

*Here is an error in M31 emulation--we force 1st word of header to be 0.
	Output[rdcTemp1,rdcBufferOutput];	*send first header word.
	LU _ LdF[rdcAltoCommand,12,1], Skip[R Even]; *test label write, OtherDisk bit
	  rdcTemp _ (rdcTemp) xor T, FreezeResult; *T = 2 from rdcNTTE
*send second header word, test label operation.
	Output[rdcTemp,rdcBufferOutput], Skip[ALU=0];
rdcLabelWrite:
	  rdcDiskCommand _ (rdcDiskCommand) or (40C), Skip;	*Label write
rdcLabelRdChk:
	  rdcDiskCommand _ (rdcDiskCommand) or (20C);		*label read
	Output[rdcDiskCommand,rdcDevOpReg];	*send command to controller
	rdcDiskCommand _ rdcDiskCommand;	*interlock

******************************************************************************
*         header and/or label have been sent if writes were requested        *
*         wakeups are generated as follows:                                  *
*           1 wakeup when header read is completed                           *
*           1 wakup when first six label words are read                      *
*           1 wakup when entire label has been read                          *
*           1 wakup at end of data NOP                                       *
******************************************************************************
rdcWaitD:
	rdcTemp1 _ 20C;
	LU _ (LdF[rdcAltoCommand,10,1]) - 1;	*if header write then no wakeup
*MemBufAddr _ 20 to avoid ServiceLate 
	Output[rdcTemp1,rdcMemBufAddr], GoTo[FirstLabel,ALU=0];
*Wait for header read complete wakeup
	rdcTemp1 _ 2C, Call[rdcIOSRet];

*Get here when RDC has read the header data from the disk into buffer[2..3].
*Check it (if Alto command was check) or transfer it to memory (if Alto
*command was read).
HeaderIn:
	Output[rdcTemp1,rdcMemBufAddr];		*load buffer address
	LU _ LdF[rdcAltoCommand,10,2], GoTo[NoHeaderFlake,IOAtten']; *check for happy RDC

*If Alto command was Read, set Inhibit Header Abort, and only get here on
*data late.  We can therefore retry the command.  If the command was check,
*we must abandon the command now.
HeaderFlake: 
	Input[rdcDiskStatus,rdcStatus], Skip[ALU#0]; *skip if command was check.
*retry the command without notifying software.
	  HeaderFlakeCnt _ (HeaderFlakeCnt) + 1, GoTo[IndexReset];
HeaderCheckFlake:
	LU _ (rdcDiskStatus) and (2000C);	*check service late
*command was check.  Declare SeekFailed.
	rdcAltoStatus _ 200C, GoTo[FlushCmd,ALU=0];
*service late--retry command
	ServiceLateCnt _ (ServiceLateCnt) + 1, GoTo[IndexReset];

NoHeaderFlake:
	Output[rdcAltoCommand,rdcPrimeIData], Call[rdcReturn];	*interlock the PrimeIdata
	LU _ (LdF[rdcAltoCommand,11,1]) - 1, Call[rdcHLRC];
	LU _ (LdF[rdcAltoCommand,11,1]) - 1, Call[rdcHLRC];
FirstLabel:
	LU _ (LdF[rdcAltoCommand,12,1]) - 1;	*Even placement
	rdcTemp1 _ 6C, GoTo[NoLabelWait,ALU=0];
	IOStrobe, Call[rdcReturn];	*wait for 1st label wakeup
*Fetch Label pointer and wait for 2nd label wakeup
	PFetch1[rdcDCB,rdcLongPointer,4], Call[rdcIOSRet];

*Get here when the RDC has read the entire label into buffer[6-13d].
*Check it (if Alto command was check) or transfer it to memory (if Alto command was read).
LabelIn:
	Output[rdcTemp1,rdcMemBufAddr];		*load buffer address
	rdcCount _ 7C, Skip[IOAtten'];		*call rdcHLRC eight times
	  rdcAltoStatus _ 1C, GoTo[FlushCmd];	*Whoops; label flake
*Interlock the PrimeIdata.
	Output[rdcAltoCommand,rdcPrimeIData], Call[rdcReturn];
	rdcCount _ (rdcCount) - 1, Skip[R<0];
	  LU _ (LdF[rdcAltoCommand,13,1]) - 1, GoTo[rdcHLRC];
	GoTo[NoLabelWait];

*SUBROUTINE rdcHLRC reads one word of header or label, and does a read or
*check.  On entry, rdcLongPointer contains the memory address, and ALU=0
*for check, ALU#0 for read; updates rdcLongPointer.
rdcHLRC:
	Input[rdcTemp1,rdcBufferInput], Skip[ALU=0];	*get word from disk
	  PStore1[rdcLongPointer,rdcTemp1,0], GoTo[HLReturn]; *store the data.
	PFetch1[rdcLongPointer,rdcTemp,0];	*get the data from memory.
	T _ rdcTemp;		*SIGH!, long abort
	LU _ (rdcTemp1) xor T, Skip[ALU#0];
	  PStore1[rdcLongPointer,rdcTemp1,0], GoTo[HLReturn]; *memory zero - store disk data, no check
	Skip[ALU#0];		*check for data equal
HLReturn:	rdcLongPointer _ (rdcLongPointer) + 1, Return;	*data were equal, no store, check OK.
	rdcAltoStatus _ 2C, GoTo[FlushCmd]; *Status _ Check error

*Get here when the header and label have been processed.  IOStrobe has not been issued.

*Get the header for the second sector.
NoLabelWait:
	PFetch1[rdcDCB,rdcTemp,3];	*Header pointer; even placement
*Fetch data block pointer for 2nd sector.
	PFetch1[rdcDCB,rdcLongPointer,5];
*Now fetch 2nd header word (the disk address) and turn off 1st sector wakeup.
	rdcTemp _ (rdcTemp) - (400C);
	T _ (rdcTemp) - (117C);
	PFetch1[rdc520,rdcCount], IOStrobe, Call[rdcReturn];

*Second sector wakes up here
	rdcAltoStatus _ 0C;
	Output[rdcAltoStatus,rdcMemBufAddr];	*clear buffer pointer in RDC
	rdcDiskCommand _ 104000C;		*CommandSentFlag + Wake Allow
	Output[rdcDiskCommand,rdcDevOpReg];	*zap the command in case of error
	LU _ (rdcPosition) + (24000C);	*carries if sector =33b
*Send first header word (zero) to the buffer, test for sector overflow
	Output[rdcAltoStatus,rdcBufferOutput], Skip[Carry'];
	  rdcPosition _ (rdcPosition) and not (174000C), Skip; *clear sector
	  rdcPosition _ (rdcPosition) + (4000C); *increment sector
*Inc Alto header: if head=0 then [head_1] else [ head_0; sector_sector+1]
	LU _ (rdcCount) and (4C);
	rdcCount _ (rdcCount) xor (4C), GoTo[rdcSetupDone,ALU=0]; *complement head
	LU _ (rdcCount) + (30000C);	*produces carry if sector now 15b.
	Skip[Carry];
	  rdcCount _ (rdcCount) + (10000C), Skip;	*inc header sector no.
	rdcCount _ (rdcCount) and not (170000C);	*clear header sector no.
rdcSetupDone:
	LU _ (rdcAltoCommand) and (200C), Skip[IOAtten']; *check for header write
FirstSectorError:
	  rdcAltoStatus _ 1C, GoTo[FlushCmd]; *Status _ Hardware Error (type unknown)
	LU _ (rdcAltoCommand) and (10C), GoTo[VerifyHeader,ALU=0]; *test WriteData

*swallow 1 wakeup after data
WriteHeader:
	rdcDiskCommand _ (rdcDiskCommand) or (204C);	*write,nop,write
	rdcAltoStatus _ (rdcAltoStatus) - (1C), GoTo[WDFx];

*swallow 2 wakeups after data
VerifyHeader:
	rdcAltoStatus _ (rdcAltoStatus) - (2C), GoTo[ReadDataField,ALU=0];

*~39 to 49 cycles to here from wakeup.
WriteDataField:
	rdcDiskCommand _ (rdcDiskCommand) or (104C);	*verify,nop,write
WDFx:	T _ LdF[rdcLongPointer,16,2];
	rdcTemp1 _ 4C, GoTo[SendSecondHeader,ALU=0];
	rdcTemp1 _ (rdcTemp1) - T;
	Output[rdcTemp1,rdcMemBufAddr], Call[rdcNTTE];	*send buffer pointer
	IOFetch4[rdcLongPointer,rdcBufferFetch,0];	*one IOF4 to quadalign
	rdcTemp1 _ (rdcTemp1) + (4C), Call[rdcIncLPNT];	*update data buffer ptr
SendSecondHeader:
	rdcTemp _ 1C;
	Output[rdcTemp,rdcMemBufAddr];	*send buffer pointer (1)
	rdcTemp _ 17C;
	Output[rdcCount,rdcBufferOutput];	*send second header word
	rdcCount _ T _ 2C, Call[rdcNTTE];
*Reset pointer for data field and setup loop; prime the buffer with 16d words
*before issuing the command.
	Output[rdcTemp1,rdcMemBufAddr], Call[.+1];
*Send 16d blocks of 4 quadwords via 4 IOStore4's/task
	IOFetch4[rdcLongPointer,rdcBufferFetch,0];
	rdcCount _ (rdcCount) - 1, UseCTask, Skip[R<0];	*Non-tasking
rdcWTx:	  rdcLongPointer _ (rdcLongPointer) + (4C), Return;
rdcWTy:	rdcTemp _ (rdcTemp) - 1, GoTo[rdcWriteDone,R<0];
	rdcDiskCommand _ (rdcDiskCommand) and not (100000C), Skip[R>=0];
*Send the command (once) and interlock
	  Output[rdcDiskCommand,rdcDevOpReg], GoTo[rdcWTy];
	rdcCount _ T, IOStrobe, GoTo[rdcWTx]; *rdcCount_ 2

rdcWriteDone:
	Call[.+1];		*1 or 2 more wakeups
	rdcAltoStatus _ (rdcAltoStatus) + 1, GoTo[rdcIOSRet,R<0];
	rdcAltoStatus _ 0C, GoTo[Chain,IOAtten'];	*Status _ good
*WriteDataFlake (status _ SectorLate for now)
	rdcAltoStatus _ 21C, GoTo[FlushCmd];

ReadDataField:
	Output[rdcCount,rdcBufferOutput];	*send second header word
	rdcDiskCommand _ (rdcDiskCommand) or (102C); *verify, nop, read
	Output[rdcDiskCommand,rdcDevOpReg];
	rdcAltoCommand _ 20C;
*want this to be 20 when Header Sync is found to avoid abort; cancel sector wakeup
	Output[rdcAltoCommand,rdcMemBufAddr], Call[rdcIOSRet];

*data starts here since the label is a nop; cancel the header wakeup. 
	rdcTemp1 _ 5C, Call[rdcIOSRet];

	Output[rdcTemp1,rdcMemBufAddr]; *First data wakeup here.  16 words are ready.
	rdcTemp _ 16C, Skip[IOAtten']; *go through the outer loop below 16d times.
*PreReadFlake
	  rdcAltoStatus _ 1C, GoTo[FlushCmd];
*use rdcCount so later write will interlock it
	Output[rdcCount,rdcPrimeIData];
*Dispatch to get starting singles; T _ number of final singles - 1.
	T _ (Dispatch[rdcLongPointer,16,2]) - 1;
	rdcIntWord _ T, Disp[.+1];	*Save final singles count - 1.
	rdcCount _ 2C, GoTo[rdcQuadReadLoopStart], DispTable[4,17,0];
	rdcCount _ 1C, Call[rdcHLRC];	*3 starting singles
	rdcCount _ 1C, Call[rdcHLRC];	*2 starting singles
	rdcCount _ 1C, Call[rdcHLRC];	*1 starting single
rdcQuadReadLoopStart:
	T _ 2C, Call[.+1];
*Loop here 4 times/tasking return (3 times if initial singles)
	IOStore4[rdcLongPointer,rdcBufferStore,0];
	rdcCount _ (rdcCount) - 1, UseCTask, Skip[R<0];	*Non-tasking
rdcRTX:	  rdcLongPointer _ (rdcLongPointer) + (4C), Return;
	rdcTemp _ (rdcTemp) - 1, Skip[R<0];
	  rdcCount _ T, IOStrobe, GoTo[rdcRTX];	*Tasking
*0 to 3 words remain; read final singles as efficiently as possible.
*Don't task to emulator
ReadFinalSingle:
	LU _ (rdcIntWord) - 1, GoTo[rdcReadDone,R<0];
	Input[rdcTemp,rdcBufferInput], Skip[ALU>=0];	*Skip for 2 words
	  PStore1[rdcLongPointer,rdcTemp,4], GoTo[rdcReadDone];
	Input[rdcTemp1,rdcBufferInput];
	rdcIntWord _ (rdcIntWord) - (2C);
	PStore2[rdcLongPointer,rdcTemp,4];
	rdcLongPointer _ (rdcLongPointer) + (2C), GoTo[ReadFinalSingle];

*We have read all data.
*The syndrome will not be checked until the next sector wakeup, so we must
*set up for it.  Note that we never actually read the syndrome, since doing
*so will cause an H4PE.  Instead, we use ReadError to differentiate between
*random hardware problems (status = 1) and checksum errors (status = 4).

rdcReadDone:
	IOStrobe, Call[rdcReturn];

	Input[rdcAltoStatus,rdcStatus];		*Sector wakeup comes here
*Reason for IOAtten:  1 = random hardware problem; 5 = read error
*Construct error code from read-error bit in status.
	LU _ rdcAltoStatus, Skip[IOAtten'];
	  rdcAltoStatus _ (Form4[rdcAltoStatus]) + 1, GoTo[FlushCmd];
	rdcAltoStatus _ 100000C, GoTo[Chain];	*Read was good

*SUBROUTINE rdcNTTE does a Return, but not to emulator. Also, T _ 2.
rdcNTTE:
	LU _ APCTask;
	rdcTemp1 _ rdcTemp1, Skip[ALU#0];	*Interlock for call at WDFx
rdcNTTEr:	UseCTask;
	T _ 2C, Return;

:END[Disk];
