:TITLE[MesaDefs];	*Definitions for Mesa code modules INSERTed by
			*GlobalDefs.Mc
			*Ed Fiala 3 June 1982

*ASSEMBLY SWITCHES

Set[AltoMode,1];	*Default Mesa assemblies to Alto mode.
			*(Pilot mode = 0, but no longer supported)
Set[CacheLocals,1];	*Indicate cache for Mesa locals 0 to 3
			*(performance improvement affecting MesaLS and MesaX;
			*presently, this MUST be 1 for AltoMode=1)
Set[WithFloatingPoint,1];	*1 assembles MesaFP.Mc in MicOverlay


*PAGE ASSIGNMENTS
*Set[opPage0,4];	*These cannot move since hardware forces the first mi
*Set[opPage1,5];	*of each bytecode to start at 2001 + (4 * opcode)
*Set[opPage2,6];
*Set[opPage3,7];
*  Loca[KFCRLoc,opPage3,76];
*  Loca[P7TailLoc,opPage3,27];	**Don't move--used by LRJ


Set[xfPage1,10];
  Loca[xfPage1p,xfPage1,0];
  Loca[xfType,xfPage1,140];
  Loca[MiscDisp0,xfPage1,160];
  Loca[MiscDisp1,xfPage1,200];
  Loca[LoadGCLoc,xfPage1,220];

Set[RRPage,10];		*07b mi in MesaX (not pages 4 to 7)
Set[RS232Page,6];	*07b mi in MesaX
Set[prPage,11];
Set[CSPage,10];		*25b mi for CSum Misc opcode (not on pages 4 to 7)
Set[MStartPage,7];	*14b mi for MStart
Set[BLTPage,4];		*50b mi for various BLT opcodes in MesaX
Set[CBLPage,5];		*02b mi for subr used by WCBL and ICBL opcodes

IFE[And[CSPage,14],4,ER[CSPage.illegal.page.4.to.7]];

%Register definitions for Alto and Mesa emulators

For Mesa, RM 21, 44-53, 56-57, 66-73 are temps; RM 17, 25, and 64 are somewhat
temps (see comment later); RM 0 and 20 are unused; all other RM locations
have uses that must survive across opcodes.
**Maybe free RM 21 (CurrentTime) in MesaP.
%
*Mesa Stack cannot move because of hardware overflow/underflow checking.
RV[Stack0,1]; RV2[Stack1,Stack2,2]; RV4[Stack3,Stack4,Stack5,Stack6,4];
RV4[Stack7,Stack8,Stack9,Stack10,10]; RV2[Stack11,Stack12,14]; RV[Stack13,16];

RV2[CODE,CODEhi,22];
*RV[NWW,24];		*Both Alto and Mesa
RV2[LOCAL,LOCALhi,26];
*RV2[PCB,PCBhi,30];	*Alto and Mesa
*RV2[MDS,MDShi,32];	*Alto and Mesa
*RM[RMZero,IP[MDS]];	*Contains 0 for both Mesa and Alto
*RM[RZero,IP[MDS]];	*Contains 0 for both Mesa and Alto
*RV4[IBuf,IBuf1,IBuf2,IBuf3,34];
*RV4[wBuf,wBuf1,wBuf2,wBuf3,40];
*RV4[xBuf,xBuf1,xBuf2,xBuf3,44];
*RV4[yBuf,yBuf1,yBuf2,yBuf3,50];

:IF[CacheLocals];	*Cache Local0 to Local3 for Mesa
RV4[LocalCache0,LocalCache1,LocalCache2,LocalCache3,IP[wBuf]];
:ENDIF;

RV4[GLOBAL,GLOBALhi,xfMY,xfMX,54];	*For Mesa

*Constants
*RV[R400,60];
*RV[AllOnes,61];

*RV[MemStat,62];	*Directs page fault handling by Fault.Mc

RV[xfWDC,63];		*Wakeup disable counter

*RV2[LP,LPhi,66];	*Long pointer base pair. (used by LRJ--cannot move)
			*(Used for Alto XMLDA & XMSTA)

*RV4[zBuf,zBuf1,zBuf2,zBuf3,70];	*Quadword used by MesaFP
			*(Don't move unless xfTemp def changed--see below)

*RV[RTemp,IP[yBuf2]];
*RV[RTemp1,IP[yBuf3]];

%These 1st 3 registers may be read by a MISC opcode.  They are used to pass
values through xfer to trap procedures, so the sequence is load-the-register,
do-an-xfer, disable-interrupts, and then simple code sequence to read the
register and save its value.  For this reason, these registers are reused in
the process code (because interrupts are off) and in BitBlt and the floating
point opcodes (because BitBlt is not in the trap sequence), but they may not
be used in opcodes which might appear in the trap procedure.
%
RV[xfXTPreg,25];	*Xfer trap parameter
RV[xfATPreg,64];	*Alloc trap parameter
RV[xfOTPreg,17];	*Other trap parameter

*These hold permanent state
RV[xfGFIWord,65];	*Holds word 0 of global frame
RV[xfBrkByte,74];	*Permanent--holds break byte
*75 used as 'Sticky' by MesaFP.Mc
RV[TickCount,76];	*For process timeout (Valid for Mesa only)
RV[xfXTSreg,77];

RV[RLink,IP[zBuf1]];	*Used in MesaP and ?
*RV2[xfTemp,xfTemp1,IP[zBuf2]];	*(used by LRJ--cannot move)

RV2[LPdest,LPdesthi,IP[xfMY]];	*Long BLT

*Process registers (also use RLink, RTemp, RTemp1, xfTemp, WW, and ?)
*Is zBuf available here?
RV2[PBase,PBasehi,IP[MDS]];	*PSB base reg = MDS, NOT initialized anywhere
			*(must change in the Post IME world)
RV[CurrentTime,21];
RV2[Queue1,Queue1hi,IP[xBuf]];
RV2[Queue2,Queue2hi,IP[xBuf2]];
RV[PRTime,IP[zBuf2]];
RV[Process,IP[zBuf3]];
RV[MQ,IP[LP]];
RV2[QTemp,QTemphi,IP[yBuf]];
RV[Prev,IP[xfXTPreg]];
RV[PRFlags,IP[xfATPreg]];
RV[EMLink,16];		*Only used by ExitMon
RV[IntType,IP[LPhi]];
RV[IntLevel,IP[xfMX]];
RV[ITemp,IP[yBuf]];
RV[ITemp1,IP[yBuf1]];
*RV[WW,56];

*Temporaries for xfer (also xfTemp, xfTemp1, xfMY, xfMX, and ?)
*Are xBuf, xBuf1, xBuf2, xBuf3, yBuf, and yBuf1 available here?
RV[xfTemp2,IP[LP]];
RV[xfCount,IP[LP]];
RV[xfFSI,IP[LPhi]];
RV[xfRlink,IP[RLink]];
RV[xfFrame,IP[zBuf]];

MC[xfAV,1000];
MC[xfSDOffset,100];
MC[xfGFT,1400];

MC[Normal,0];		*Things in MemStat
MC[FreeFrame,10];
MC[EarlyXfer,4];
MC[BltFixup,3];
MC[BltLFixup,2];
MC[XferFixup,1];

*Frame formats
MC[xfPcOffset,1];	*in L (unused)
MC[xfRetLinkOffset,2];	*in L (unused)
MC[LocalZeroOffset,4];	*in L (unused)
MC[xfGfiOffset,0];	*in G
MC[GlobalZeroOffset,3];	*in G (unused)

*StateVector format
MC[StkPOffset,10];
MC[DestOffset,11];
MC[SourceOffset,12];	*unused

*SD indicies
MC[sStackError,2];
MC[sWakeupError,3];
MC[sXferTrap,4];
MC[sUnimplemented,5];
MC[sAllocListEmpty,6];
MC[sControlFault,7];
MC[sCsegSwappedOut,10];
MC[sPageFault,11];
MC[sWriteProtect,12];
MC[sUnbound,13];
MC[sZeroDivisor,14];
MC[sDivideCheck,15];
MC[sHardwareError,16];	*unused
MC[sProcessTrap,17];
MC[sBoundsFault,20];
MC[sPointerFault,21];
MC[sFloatingPoint,137];
MC[sWCBL,151];
MC[sICBL,152];
MC[sCedarTrap,156];

MC[FirstProcess,75];
MC[LastProcess,76];	*unused
MC[FirstStateVector,77];

MC[CurrentPSB,21];
MC[ReadyQ,22];
MC[CurrentState,23];
MC[ReadyQhi,1];		*unused

*Nova entry point constants
MC[IntStopPC,25];	*unused
MC[StopStopPC,26];
MC[MEStopPC,27];	*unused
MC[MXDStopPC,30];	*unused
MC[MREStopPC,31];	*unused
MC[MXWStopPC,32];	*unused
MC[NOTIFYStopPC,33];	*unused
MC[BCASTStopPC,34];	*unused
MC[REQUEUEStopPC,35];	*unused
(1792)\3539f1 34f0
