%Provide for "standard" configurations through the AssemblyMode switch.
The following values of AssemblyMode are defined:
	0	Vanilla Pilot as SDD wants it;
	1	Tor Pilot;
	2	Cedar Pilot;
	3	ESS Pilot;
	4	PathFinder Pilot;
	5	Tor Pilot for ENX manufacturing test;
	6	any other configuration.
%
Set[AssemblyMode,0];
IDF[AssemblyMode,,Set[AssemblyMode,0]];


Set[ESSMode,0];	Set[TorMode,0];	Set[SDDMode,0];	Set[CedarMode,0];
Set[PathFinderMode,0];	Set[TorTestMode,0]
Select[AssemblyMode,Set[SDDMode,1],Set[TorMode,1],Set[CedarMode,1],
  Set[ESSMode,1],Set[PathFinderMode,1],Set[TorTestMode,1],];

:IF[TorMode]; ************************************
  TITLE[GlobalDefs.TOR.Configuration];
:ELSEIF[CedarMode]; ******************************
  TITLE[GlobalDefs.Cedar.Configuration];
:ELSEIF[SDDMode]; ********************************
  TITLE[GlobalDefs.SDD.Configuration];
:ELSEIF[ESSMode]; ********************************
  TITLE[GlobalDefs.ESS.Configuration];
:ELSEIF[PathFinderMode]; *************************
  TITLE[GlobalDefs.PathFinder.Configuration];
:ELSEIF[TorTestMode]; ****************************
  TITLE[GlobalDefs.Tor.Test.Configuration];
:ELSE; *******************************************
  TITLE[GlobalDefs.Non-standard.Configuration];
:ENDIF; ******************************************
%
Ed Fiala 13 June 1983: Add CULError (MP 138d).
Ed Fiala 3 June 1983: Remove 3MB ethernet from TorMode, floating point from
  TorTestMode.
Ed Fiala 11 May 1983: Add MonExitError (MP 137d); renumber TextBlt regs;
  eliminate prQueue.
Tom Henning 9 May 1983:  Add page defs for EOM Star graphics extensions,
  delete floating point microcode from Tor Mode.
Ed Fiala 29 April 1983: Eliminate prCleanupLink, prConditionTail, prTimeout,
  prPsbPriority, prQueueHead, prQueueTail, prQTemp, prQTemphi, prStackPointer,
  prFrame; add prWaitCount, prIntPsbIndex, prLocal, prStkP; fix process
  register comments; make prTime, prTicks, RSImage, NWW a 4-register group
  for MesaP.
Ed Fiala 21 December 1982: Eliminated WithJS conditional (JS opcode no longer
  implemented); added WithNILCK conditional for Cedar.
Ed Fiala 29 November 1982: Put in Tor Test mode per message from Henning.
Ed Fiala 3 November 1982: Add TimerInts register; made non-CDC9730 register
  numbers for timer task same as with CDC9730.
Tom Rich 12 October 1982: relocate Timer registers RTimer and vCrystal from
  342-343b to 322-323b when WithCDC9730.
Tom Henning 16 September 1982: For TOR mode, change RefreshPeriod from
  5000b to 1200b, or 256 usec to 64 usec.
Ed Fiala 13 September 1982: Change cdcTask from 7 to 6.
Tom Rich 8 September 1982: Replace WithTor by WithUIB and WithEOM.  Add
  PathFinderMode.
Ed Fiala 21 May 1982: Move prCurrentPsb and prPsbIndexMask from 26-27 to
  22-23 and make the LocalCache be 24-27; debug CacheLocals=1.
Ed Fiala 20 May 1982: Shuffle task numbers for 3mb and 10mb ethernets to
  avoid problem with multiple controllers--conditional task assignment
  for 10mb ethernet controller with TOR and ESS configurations; eliminate
  WithBlkZ switch and prPsbLink.next register; set LPChecking to 0; add
  csPage; change prMonitor and prSaveStkP from 53 to 10, prQueue and prReady
  from 22 to 50; renumbered the TextBlt registers 20-23, 64, and 66-67
  to be 64-67, 20, and 24-25 so that they overlap the permanent Cedar
  registers.
Ed Fiala 11 May 1982: Change register allocation comments for 300-377 area;
  eliminate mpPage, ReadTimeLoc, vdInitialPage; add prIntSaveStkP and
  prIntPdaTimeout; interchange fpPage3 and fpPage6; change vdLoaderPage and
  vdLoaderPage2 for Tom Rich.
Ed Fiala 26 April 1982: Shuflle Tor-mode switches; absorb page assignments
  from MesaIO and MesaFP; move EOM on page 1 to page 3, XWTask on page 14b to
  17b, MesaFP on 17b to 13b, and MesaFP on 3 to 17b; cdc off JRAM location
  changed; add Rich's ESSMode stuff for Xenia/Verdi; add WithRDC, WithUTVFC
  switches.
Ed Fiala 23 March 1982: Eliminate PNIPBase, PageCount, XWInInitLoc2,
  EOMinitPage, eomLoBase, eomHiBase, all old 10 mb Ethernet stuff;
  add TimerGoLoc, WithBitBlt, WithBlTLR, WithDShift, WithBlkZ, WithBytBlT,
  WithBLEL, WithDLogic, WithJS, WithLInt, WithTMS1000, WithRotate, new 10 mb
  Ethernet stuff, TorMode, CedarMode, PilotMode, AssemblyMode;
  move 10 mb code from page 3 to 1; move DeviceInitPage from 2 to 6 and
  InitPage from 16b to 4; insert some error checks; shuffle task numbers.
Ed Fiala 22 February 1982: Absorb Initial's MP codes; add InitialPage1,
  xPageCount, xStorageFaults, xHardBadPages, xSoftBadPages for MemInit.Mc;
  eliminate RCnt; add ExchStkPLoc and SetStkPLoc for new LoadRAM,
  xfFaultGoLoc, StartDeviceInit, MC12, MCNoneCrash; absorb location defs from
  Fault.Mc; move RSImage and NWW.
Ed Fiala 17 December 1981: Changes for new Pilot instruction set:
  Eliminate MiscDisp0, MiscDisp1, xfSDOffset, xfAV, xfGFT, BrkBPage,
  LoadgcPage, moWRTab, moRRTab, MulDivPage, GlobalZeroOffset, LocalZeroOffset,
  StopStopPC, REQUEUEStopPC, sAllocListEmpty, xfRlink, xfTemp2, RLink,
  xfTemp-1, prRtnLink2, prPsbTimeout, cdcOffLoc;
  Add LSPage, mpPage, ppPage, piPage, dsPage1, dvPage1, bltPage1, EscTop,
  EscD0-3, EscD7, EscD10, SDOffset, AVOffset, EscTrapOffset, GFTOffset,
  xfGarb0, LPChecking, prPdaTimeout, prPsbMds; rename and renumber SD indices;
  move xfBryByte from 40 to 17, GLOBAL/GLOBALhi from 56/57 to 54/55 etc.
  thereby causing temporaries at 56/57 to be renumbered as 54/55 and
  temporaries at 17 renumbered as 40; move prSaveStkP from 51 to 53 and
  prPsbIndex from 23 to 51 freeing RM 23; interchange xfFrame and TrapParm;
  move prTimeout from 54 to 70.


Standard for all five configurations are WithRDC=1, LPChecking=0,
WithBitBlt=1, WithDLogic=1, WithBlEL=1, WithLInt=1, WithBlTLR=1,
WithRotate=1.

Tor also sets: With10MB=1, WithUIB=1, WithEOM=1, WithTMS1000=1, all other
switches 0.

ESS also sets: WithMidas=1, WithUIB=1, WithEOM=1, WithCDC9730=1, WithEIM=1,
WithTMS1000=1, With3MB=1, all other switches 0.

PathFinder also sets: WithMidas=1, WithUTVFC=1, WithEOM=1, WithCDC9730=1,
WithEIM=1, WithTMS1000=1, With3MB=1, all other switches 0.

SDD also sets: WithMidas=1, WithUTVFC=1, With10MB=1, WithMIOC=1, WithCDC=1,
WithFloatingPoint=1, With3MB=1, all other switches 0.

Cedar also sets: WithUTVFC=1, With10MB=1, WithCDC=1, WithCCABoard=1,
WithCedar=1, WithFloatingPoint=1, WithNILCK=1, With3MB=1, all other switches 0.

NOTES:
1) Jasmine microcode has not been checked since its starting addresses
were changed and other changes made for AMesa release version about 53.
2) AUIB microcode not upgraded from Rubicon yet and not included here.
%

:IF[TorMode]; ***********************************************
*WithBltLR, WithDShift, WithRotate are optional here
Set[WithMidas,0];	Set[WithFloatingPoint,0];
Set[WithCedar,0];	Set[WithCCABoard,0];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,0];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBltLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBLEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,1];
Set[WithUIB,1];	Set[WithEOM,1];	Set[WithMIOC,0];
Set[With10MB,1];	Set[With3MB,0];
Set[WithCDC,0];		Set[LPChecking,0];
Set[WithCDC9730,0];	Set[WithEIM,0];
Set[WithRDC,1];		Set[WithUTVFC,0];
:ELSEIF[CedarMode]; *****************************************
Set[WithMidas,0];	Set[WithFloatingPoint,1];
Set[WithCedar,1];	Set[WithCCABoard,1];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,1];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBlTLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBlEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,0];
Set[WithUIB,0];	Set[WithEOM,0];	Set[WithMIOC,0];
Set[With10MB,1];	Set[With3MB,1];
Set[WithCDC,1];		Set[LPChecking,0];
Set[WithCDC9730,0];	Set[WithEIM,0];
Set[WithRDC,1];		Set[WithUTVFC,1];
:ELSEIF[SDDMode]; *******************************************
Set[WithMidas,1];	Set[WithFloatingPoint,1];
Set[WithCedar,0];	Set[WithCCABoard,0];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,0];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBlTLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBlEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,0];
Set[WithUIB,0];	Set[WithEOM,0];	Set[WithMIOC,1];
Set[With10MB,1];	Set[With3MB,1];
Set[WithCDC,1];		Set[LPChecking,0];
Set[WithCDC9730,0];	Set[WithEIM,0];
Set[WithRDC,1];		Set[WithUTVFC,1];
:ELSEIF[ESSMode]; *******************************************
Set[WithMidas,1];	Set[WithFloatingPoint,0];
Set[WithCedar,0];	Set[WithCCABoard,0];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,0];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBlTLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBlEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,1];
Set[WithUIB,1];	Set[WithEOM,1];	Set[WithMIOC,0];
Set[With10MB,0];	Set[With3MB,1];
Set[WithCDC,0];		Set[LPChecking,0];
Set[WithCDC9730,1];	Set[WithEIM,1];
Set[WithRDC,1];		Set[WithUTVFC,0];
:ELSEIF[PathFinderMode]; ************************************
Set[WithMidas,1];	Set[WithFloatingPoint,0];
Set[WithCedar,0];	Set[WithCCABoard,0];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,0];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBlTLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBlEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,1];
Set[WithUIB,0];	Set[WithEOM,1];	Set[WithMIOC,0];
Set[With10MB,0];	Set[With3MB,1];
Set[WithCDC,0];		Set[LPChecking,0];
Set[WithCDC9730,1];	Set[WithEIM,1];
Set[WithRDC,1];		Set[WithUTVFC,1];
:ELSEIF[TorTestMode]; ***************************************
*WithBltLR, WithDShift, WithRotate are optional here
Set[WithMidas,0];	Set[WithFloatingPoint,0];
Set[WithCedar,0];	Set[WithCCABoard,0];
Set[WithFPBoard,0];	Set[WithDESBoard,0];
Set[WithBitBlT,1];	Set[WithTextBlT,0];
Set[WithLInt,1];	Set[WithNILCK,0];
Set[WithDShift,0];	Set[WithRotate,1];
Set[WithBltLR,1];	Set[CacheLocals,0];
Set[WithBytBlT,0];	Set[WithBLEL,1];
Set[WithDLogic,1];	Set[WithTMS1000,1];
Set[WithUIB,1];	Set[WithEOM,1];	Set[WithMIOC,0];
Set[With10MB,1];	Set[With3MB,1];
Set[WithCDC,0];		Set[LPChecking,0];
Set[WithCDC9730,0];	Set[WithEIM,0];
Set[WithRDC,1];		Set[WithUTVFC,0];
:ELSE; ******************************************************

Set[WithMidas,1];	*1 reserves space for Midas Kernel and
			*communication microcode; must be 0 for Audio.Mc,
			*Jasmine.Mc, or other Printer interface devices.
			*Mi consumed as follows: 33b mi on pg 17b in Fault,
			*10b mi on pg 0 in Fault, 4b mi on pg 14b in Timer,
			*and 117b mi on pg 17 IMReserved for Midas Kernel.
Set[WithFloatingPoint,0];	*1 for microcoded floating point else 0; affects
			*MesaESC.Mc and MesaFP.Mc; consumes 20b mi on
			*moPage, 517b mi elsewhere.
Set[WithCedar,0];	*1 for Cedar-specific changes else 0
			*(affects opcodes 76-77 and code in CedarGC.Mc).
			*Adds 164b mi on page 3, 7b mi on opPage0,
			*371b mi on page 2, and 20b mi on moPage.
Set[WithCCABoard,0];	*1 for CCA board microcode; adds 126b mi on ccPage,
			*3b mi on moPage.
Set[WithFPBoard,0];	*1 for Floating point board microcode; adds 23b mi
			*on fpbPage0, 3b mi on moPage.
Set[WithDESBoard,0];	**Not implemented yet
Set[WithBitBlt,1];	*1 for microcoded BitBlt (adds 1 mi on moPage,
			*344b mi on bbP1).
Set[WithTextBlt,0];	*1 for microcoded TextBlt else 0; affects
			*MesaESC.Mc and TextBlt.Mc (adds 1 mi on
			*moPage, 230b mi on TxP1).
Set[WithLInt,1];	*1 for microcoded LINT (adds 2 mi on moPage.
Set[WithNILCK,0];		*1 for microcoded NILCK (adds 1 mi on moPage, 1 mi
			*on opPage0).
Set[WithDShift,0];	*1 for microcoded DSHIFT (adds 1 mi on moPage,
			*34b mi on opPage3, 2 mi on dsPage1).
			*DSHIFT not produced by the compiler.
			***WithDShift=1 IS UNTESTED***
Set[WithRotate,1];	*1 for microcoded ROTATE (adds 2 mi on moPage,
			*1 mi on opPage1).
			*ROTATE not produced by the compiler.
Set[WithBlTLR,1];	*1 for microcoded BLTLR (adds 1 mi on moPage,
			*13b mi on opPage3).
			*BLTLR not produced by the compiler.
Set[WithBytBlT,0];	*1 for microcoded BYTBLT and BYTBLTR opcodes
			*(No code available yet).
Set[WithBlEL,1];	*1 for microcoded BLEL and BLECL opcodes (adds
			*2b mi on moPage, 25b mi on opPage3, and  5b mi on
			*opPage0).
Set[WithDLogic,1];	*1 for microcoded DAND, DIOR, and DXOR opcodes
			*(adds 2b mi on ppPage and 6b mi on moPage).
			*None of these opcodes produced by the compiler.
Set[WithTMS1000,1];	*1 for microcoded SETTIME opcode (adds 10b mi on
			*moPage).

%NOTE: These switches control assembly of DTab entries in Initialize.Mc and
of some IMReserves in Mesa1Occupied.Mc and Mesa2Occupied.Mc.
XWSIO2.Mc and Timer.Mc are affected by With10MB and With3MB switches.
Microcode io drivers must be included in the MicroD loadup if the switch here
is 1; otherwise device initialization will carry out a wild branch on machines
which include a device for which there is no microcode.
%
Set[WithUIB,1];		*1 for Tor/Xenia/Verdi UIB device.
Set[WithEOM,0];		*1 for Tor/Xenia/Verdi/PathFinder EOM device.
Set[WithMIOC,0];	*1 to assemble MIOC microcode else 0.
Set[With10MB,1];	*1 to assemble 10 mb Ethernet microcode
Set[With3MB,0];		*1 to assemble 3 mb Ethernet microcode
Set[WithCDC9730,0];	*1 for Control Data 9730 disk for Xenia/Verdi/PathFinder.
Set[WithEIM,0];		*1 for Xenia/Verdi/PathFinder EIM device.
Set[WithCDC,0];		*1 to assemble color display (cdcTask) microcode
Set[WithRDC,1];		*1 to assemble RDC (SA4000 disk) microcode
Set[WithUTVFC,0];	*1 to assemble UTVFC (Display and keyboard) microcode

Set[LPChecking,0];	*1 to ensure map faults for long pointers .ge.
			*2^22 else 0 (checking costs 2 cycles per long
			*pointer setup which slows the emulator about
			*1.8 percent; it also costs 4 mi on opPage1, 3 mi
			*on opPage3, and 6 mi on xfPage1, but it saves
			*4 mi on moPage).  When LPChecking .eq. 0,
			*long pointers are truncated mod 2^24.  Some
			*places (e.g., BitBlt, Cedar) do not use this
			*switch.
Set[CacheLocals,0];	*0 for no cache, 1 to cache locals 0 - 3.
			*The local cache adds 24b mi on opPage0, 10b mi on
			*opPage1, and 1 mi on xfPage1.  It improves
			*performance about 1.2 percent.  HOWEVER, it has
			*a bug at LPDoubleWrite in MesaOP1.  Avoid using
			*this feature until better checked out; also it
			*would be worth more if there was no need to
			*reload the local cache after long pointer writes.
:ENDIF; *****************************************************

*NOTE: AltoMode=0 is mandatory.
Set[AltoMode,0];	*0 selects Pilot mode (1 for Alto Mesa mode)

*RefreshPeriod is the number of processor cycles in the refresh timer period.
:IF[TorMode]; ************************************
Set[RefreshPeriod,1200];	*1200b=640d cycles = 64 microseconds if processor
			*clock is 40 mHz.
:ELSEIF[TorTestMode]; ****************************
Set[RefreshPeriod,1200];	*1200b=640d cycles = 64 microseconds if processor
			*clock is 40 mHz.
:ELSE; *******************************************
Set[RefreshPeriod,5000];	*5000b=2560d cycles = 256 microseconds if processor
			*clock is 40 mHz.
:ENDIF; ******************************************

IFE[And[RefreshPeriod,77],0,,ER[RefreshPeriod.must.be.multiple.of.100b,2]];
IFE[RefreshPeriod,5000,,IFE[RefreshPeriod,2400,,IFE[RefreshPeriod,1200,,
	ER[Illegal.value.for.RefreshPeriod,2]]]];

IFE[WithCedar,1,
	IFE[WithTextBlt,1,ER[Cedar.TextBlt.register.conflict,2]]
	IFE[WithCDC9730,1,ER[CDC9730.with.Cedar.is.a.no.no,2]]
	IFE[WithEIM,1,ER[EIM.with.Cedar.is.a.no.no,2]]
	IFE[WithEOM,1,ER[EOM.with.Cedar.is.a.no.no,2]]
	IFE[WithMIOC,1,ER[Cedar.and.MIOC.both.use.page.2,2]]
	IFE[CacheLocals,1,ER[Cedar.Local.Cache.Register.conflict,2]]];
IFE[WithEOM,1,
	IFE[WithTextBlt,1,ER[EOMHiTask.TextBlt.page.conflict,2]]
	IFE[WithMIOC,1,ER[EOMHiTask.and.MIOC.both.use.page.2,2]]];
IFE[WithTextBlt,1,
	IFE[CacheLocals,ER[TextBlt.not.fixed.to.restore.Local.cache,2]]];

%TASK ASSIGNMENTS

Beware of expecting too many things to work.  Duplicates in the following
assignments and/or device table in Initialize are mostly a convience allowing
one microcode version to run on many configurations rather than a way to
support the most complicated configuration you might build.

Current software and the XWSIO2.Mc (StartIO) combine to restrict both the
3mb and 10mb ethernets so that the first 3mb or 10mb board (i.e., the board
nearer the processor) MUST be assigned to the primary task(s) below, and the
primary task(s) must be larger than the secondary tasks.  If the first board
is assigned to the 2nd or 3rd task, then software will malfunction.  Also, it
is possible to have a 3mb controller assigned to its primary input task but
its secondary output task, or vice versa, and that malfunctions also.

The MIOC wants the first board assigned to the lower numbered task.

Ideally, we should have the following:
(1) Both 3mb input tasks higher than both 3mb output tasks higher than all
10mb tasks.
(2) StartIO eliminated and JRAM used instead.
(3) Ability to overlap the tasks better so that tasks 10/11 can be used for
the 1st two 10mb controllers if there are no 3mb controllers.
%
Set[BootTask,1];
  IFG[BootTask,3,ER[Initialize.requires.BootTask.be.0.to.3,2]];

*MakeTask check for a task number in the range 4 to 16.
Macro[MakeTask,Set[#1,#2]
	IFG[#2,3,IFG[#2,16,ER[#1.task.too.big,2]],
		ER[#1.task.number.too.small,2]]];

MakeTask[xoTask,10];	*1st 3mb Ethernet Output
MakeTask[xiTask,11];	*1st 3mb Ethernet Input
MakeTask[xoTask2,4];	*2nd 3mb Ethernet Output
MakeTask[xiTask2,5];	*2nd 3mb Ethernet Input

:IF[TorTestMode]; *******************************************
*Max of 1 ENX and 1 XW board with TorTest configuration.
*(WithEOM=1 is assumed).
MakeTask[enxTask,15];	*1st 10 mb Ethernet in/out
:ELSEIF[WithEOM]; *******************************************
*Only one ethernet controller with Tor, ESS, and PathFinder configurations.
MakeTask[enxTask,11];	*1st 10 mb Ethernet in/out
:ELSE; ******************************************************
MakeTask[enxTask,7];	*1st 10 mb Ethernet in/out
:ENDIF; *****************************************************
MakeTask[enxTask2,6];	*2nd 10 mb Ethernet in/out
MakeTask[enxTask3,5];	*3rd 10 mb Ethernet in/out

MakeTask[cdcTask,6];	*Color display (1 wakeup/63 us; 27 percent)

*RDC uses registers for two tasks, so its task number should be even and
*the next task should not be used.
MakeTask[rdcTask,12];
*The display uses several registers for the next task (see Pilot1.Regs)
MakeTask[DisplayTask,14];	*(3 wakeups/28.8 us; 25 percent) 
MakeTask[TTask,16];	*Can't change; uses some task 15 registers.

MakeTask[ioTask1,4];	*1st MIOC task
MakeTask[ioTask2,6];	*2nd MIOC task
*MakeTask[fdtask,5];	*IFDC task (no longer supported)

*TOR TASK ASSIGNMENTS--EOM uses registers for tasks 4, 5, and 7
MakeTask[eomLoTask,4];	*eomLo
MakeTask[eomHiTask,5];	*eomHi
MakeTask[uibTask,14];	*UIB

*ESS (XENIA/VERDI) TASK ASSIGNMENTS
MakeTask[eimTask,6];
MakeTask[vdTask,15];	*CDC9730 task

IFE[enxTask3,xiTask2,,
  ER[Since.enxTask3.ne.xiTask2.fix.xoNotify2.enxNotify3.register.conflict,2]];

IFE[enxTask,xoTask,ER[enxTask.xoTask.conflict.affects.timers,2]];
IFE[enxTask2,xoTask,ER[enxTask2.xoTask.conflict.affects.timers,2]];
IFE[enxTask3,xoTask,ER[enxTask3.xoTask.conflict.affects.timers,2]];
IFE[enxTask,xoTask2,ER[enxTask.xoTask2.conflict.affects.timers,2]];
IFE[enxTask2,xoTask2,ER[enxTask2.xoTask2.conflict.affects.timers,2]];
IFE[enxTask3,xoTask2,ER[enxTask3.xoTask2.conflict.affects.timers,2]];
IFE[enxTask,enxTask2,ER[enxTask.enxTask2.conflict.affects.timers,2]];
IFE[enxTask2,enxTask3,ER[enxTask2.enxTask3.conflict.affects.timers,2]];
IFE[enxTask,enxTask3,ER[enxTask.enxTask3.conflict.affects.timers,2]];

IFG[DisplayTask,rdcTask,,ER[DisplayTask.should.be.>.rdcTask,2]];
IFG[rdcTask,cdcTask,,ER[rdcTask.should.be.>.cdcTask,2]];
*IFG[rdcTask,xoTask,,ER[rdcTask.should.be.>.xoTask,2]];
IFG[xiTask,xoTask,,ER[xiTask.should.be.>.xoTask,2]];
IFG[xiTask2,xoTask2,,ER[xiTask2.should.be.>.xoTask2,2]];
IFG[enxTask,enxTask2,,ER[enxTask2.>=.enxTask,2]];
IFG[enxTask2,enxTask3,,ER[enxTask3.>=.enxTask2,2]];
IFG[xoTask,xoTask2,,ER[xoTask2.>=.xoTask,2]];

IFE[And[rdcTask,1],0,,ER[rdcTask.must.be.even.because.>.20b.regs,2]];
IFE[TTask,16,,ER[TTask.must.remain.16,2]];

*PILOT1 INITIALIZATION PAGE ASSIGNMENTS
*NOTE: It is desirable to put throwaway initialization code on pages 4 to 7
*which we KNOW will be overwritten by Pilot2, leaving the rest of the
*microstore for dynamic assignment between Pilot1 and Pilot2.
Set[DeviceInitPage,6];	*Device initialization
	Loca[DBootDoneLoc,DeviceInitPage,375];	*Where is this used?
	Loca[TimerInitLoc,DeviceInitPage,376]; 
Set[enxInitPage,DeviceInitPage];
	Loca[enxInitLoc,enxInitPage,240]; 
	Loca[enxInitLoc2,enxInitPage,242];
	Loca[enxInitLoc3,enxInitPage,244]; 
Set[xwInitPage,DeviceInitPage];
	Loca[xwInInitLoc,xwInitPage,230]; 
	Loca[xwOutInitLoc,xwInitPage,234];
	Loca[xwOutInitLoc2,xwInitPage,236]; 
Set[rdcInitPage,DeviceInitPage]; 
	Loca[rdcInitBase,rdcInitPage,340]; 
	Loca[rdcInitLoc,rdcInitPage,340]; 

Set[UIBInitPage,DeviceInitPage];	*TOR UIB (46b mi)
	Loca[UIBInitLoc,UIBInitPage,220];
	Loca[eomHiTaskInitLoc,DeviceInitPage,221];	*TOR EOM (7 mi)
	Loca[eomLoTaskInitLoc,DeviceInitPage,222];	*TOR EOM

Set[eimInitPage,DeviceInitPage];	*ESS EIM (6 mi)
	Loca[eimInitLoc,eimInitPage,223];
Set[vdInitPage,DeviceInitPage];		*ESS CDC 9730 (35b mi)
	Loca[vdInitLoc,vdInitPage,224];

Set[DeviceInitPage2,5];	*More device initialization
Set[DisplayInitPage,DeviceInitPage2]; 
	Loca[DisplayInitLoc,DisplayInitPage,207]; 
	Loca[Task0NotifyLocA,DisplayInitPage,210];
	Set[Task0NotifyLocB,Add[Task0NotifyLocA,1]]; *2611 in .Mlf files
	Set[vOverlayLoadedLoc,Add[Task0NotifyLocB,1]]; *2612 in .Mlf files
	Loca[Task0NotifyLocC,DisplayInitPage,215];
	Loca[vContinueInitLoc,DisplayInitPage,206];
	Loca[vSLCountLoc,DisplayInitPage,214];
Set[IOInitPage,DeviceInitPage2];	*MIOC initialization
	Loca[IOInitLoc,IOInitPage,220];

Set[InitPage,4];		*Initialize module
	Loca[BootStartLoc,4,372];	*Not presently used (?)
	Loca[SoftStartLoc,4,373];	*2373 in .Mlf files
	Loca[InitBase,InitPage,0];
	Set[QretLoc,Add[InitBase,7]];
	Set[Task0StartLoc,Add[InitBase,10]];

*PILOT1 RESIDENT PAGE ASSIGNMENTS--WILL REMAIN AFTER PILOT2 OVERWRITE
	Loca[PFExitLoc,0,7];
	Set[Qloc,5];	*On page 0 so Qloc+1 won't be overwritten, but
			*Pilot2 can go ahead and overwrite Qloc
Set[FaultPage,0];	*In Fault.Mc
	Loca[StartMemTrapLoc,FaultPage,16];
	Loca[InitEndLoc,0,20];		*In MesaOP3.Mc
	Loca[FixDisp,FaultPage,100];
	Loca[CrashLoc,FaultPage,134];
	Loca[StackErrorLoc,FaultPage,136];
	Loca[MC12,FaultPage,140];
	Loca[EmuNotifyLoc,0,200];	*Must be page 0
	Loca[NonEmuNotifyLoc,0,202];	*Must be page 0
	Loca[ContNonEmuLoc,FaultPage,204];
	Loca[NonEmuPFLoc,0,206];	*205b to 210b are used (must be page 0)
Set[DoIntPage,0];
Set[NotifyInterruptPage,0];
	Loca[NotifyInterruptLoc,0,360];	*For NotifyInterrupt
Set[LRJPage,0];				*42b mi inherited from Initial
	Loca[LRJStart,LRJPage,300];
	Set[LRJContinue,Add[LRJStart,1]];	*For old LoadRAM; also works
					*with new LoadRAM.
	*Set[LRJGo,LRJPage,302];		*Start and continue address
					*for new LoadRAM
	*Set[ExchStkPLoc,Add[LRJGo,30]];	*Entry in new LoadRAM only
	*Set[SetStkPLoc,Add[LRJGo,31]];	*Entry in new LoadRAM only
	Set[nePage,1];	*Alto emulator page, def still needed by LoadRAM
	Loca[JmpFinLoc,nePage,3];	*Reentry location for Alto LRJ
Set[PNIPPage,0];		*12b mi
	Loca[PNIPStart,PNIPPage,176];	*Must be even location

Set[enxPage,1];		*10 mb Ethernet microcode
	Loca[enxStartLoc,enxPage,110];	*Input notify location
	Loca[enxOTimerDoneLoc,enxPage,114];	*Output notify location
	Loca[enxDispTableLoc,enxPage,120];	*TimerDone notify loc

Set[IOPage,2];		*MIOC code (376b mi)
	Loca[IOStartLoc,IOPage,374];

Set[eomHiTaskPage,2];
Set[eomLoTaskPage,3];
Set[eomHiTaskPage2,17];
Set[eomLoTaskPage2,17];
Set[eomLoTaskPage3,1];

Set[UIBpage,12];	*TOR UIB microcode
Set[DisplayPage,12];	*Display and keyboard microcode
	Loca[vEndOfFieldLoc,DisplayPage,0];
	Loca[BootSV,DisplayPage,1];

Set[rdcPage,14];	*SA4000 task
Set[StartIOPage,1];	*Ethernet StartIO
	Loca[StartIOLoc,StartIOPage,140];

Set[TimerPage,14];
	Loca[TimerGoLoc,TimerPage,335];
	Loca[TimerTable,TimerPage,340];	*0-17 used
	Loca[MidasHaltLoc,TimerPage,213];	*Must be odd; 212-214 are used
Loca[cdcInitLoc,3,222];	*JRAM 71622 turns on color display controller
			*Output with 0 argument to device cdcTask,,0
			*turns it off.

Set[eimPage,1];		*ESS EIM (241b mi)
Set[vdPage,13];		*CDC9730 disk (371b mi)
Set[vdPage1,1];		*Overflow cdc9730 naked write (11b mi)
Set[vdPage2,1];		*Overflow cdc9730 naked read (12b mi)
Set[vdPage3,1];		*Overflow cdc9730 diagnostic cmnds (14b mi)
Set[vdPage4,1];		*Overflow cdc9730 control cmnds (42b mi)

Set[xwPage,17];		*3 mb Ethernet microcode
	Loca[xoStartLoc,xwPage,152];	*Output notify location
	Loca[xoTimerDoneLoc,xwPage,154];	*TimerDone notify loc
	Loca[xiStartLoc,xwPage,161];	*Input notify location; must be
					*odd; next 2 locations used.

Set[FDpage,17];		*IFDC code	
	Set[FDoffset,240];	*IFDC dispatch table offset (must be mod 20)
	Loca[FDinit,FDpage,Add[FDoffset,2]];	*initial starting address
Set[MidasPage,17];
	Set[MidasFaultLoc,112];	*In Midas Kernel (used with GoToExternal)
	Set[MidasBreakLoc,110];	*In Midas Kernel (used with GoToExternal)

*PILOT2 PAGE ASSIGNMENTS
Loca[MesaRefillLoc,0,2];
Set[opPage0,4]; 
	Loca[prFaultLoc,opPage0,300];
Set[opPage1,5]; 
Set[opPage2,6];
Set[opPage3,7];
	Loca[P7TailLoc,opPage3,27];	*Known to LoadRAM--can't easily move
	Loca[KFCRLoc,opPage3,76];

Set[TxP1,2];		*TextBlt page 
	Loca[BBFAType0Disp,TxP1,140];
	Loca[TxInitFuncDisp,TxP1,160];
	Loca[TxCharFuncDisp,TxP1,200];
	Loca[TxLoopFuncDisp,TxP1,220];

*Floating point (in MesaFP.Mc) adds 541b mi--20b mi on moPage for the Esc
*dispatch + the following:
Set[fpPage0,13];		*336b mi (not pages 4 to 7, includes refill)
	Loca[UnnormDisp,fpPage0,40];
	Loca[UnpackRet,fpPage0,60];
	Loca[RoundDisp,fpPage0,100];
	Loca[FixRndDisp,fpPage0,120];
Set[fpPage1,13];			* 36b mi
Set[fpPage2,IFE[WithMidas,1,3,17]];	* 40b mi
Set[fpPage3,IFE[WithMidas,1,3,17]];	*  5b mi
Set[fpPage4,IFE[WithMidas,1,3,17]];	* 12b mi
Set[fpPage5,IFE[WithMidas,1,3,17]];	* 22b mi
Set[fpPage6,13];			*  2b mi
Set[fpPage7,IFE[WithMidas,1,3,17]];	* 22b mi

Set[ccPage,3];		*126b mi anywhere if WithCCABoard=1

Set[fpbPage0,10];	*23b mi if WithFPBoard=1--must be page with
			*buffer refill at 377b

Set[moPage,10];		*Miscellaneous opcode page
	Loca[EscTop,moPage,0];
	Loca[EscD0,moPage,20];
	Loca[EscD1,moPage,40];
	Loca[EscD2,moPage,60];
	Loca[EscD3,moPage,100];
	Loca[EscD6,moPage,120];
	Loca[EscD7,moPage,140];
	Loca[EscD10,moPage,160];

Set[bbP1,11];		*BitBlt page

Set[xfPage1,15];
	Loca[xfFaultGoLoc,xfPage1,1];
	Loca[xfMSTab,xfPage1,120];
	Loca[xftype,xfPage1,140];
	Loca[LoadGCLoc,xfPage1,300];

Set[prPage,16];

Set[wrMDSPage,5];	* 3b mi in MesaESC (anywhere)
Set[ncPage,5];		* 1b mi in MesaESC (anywhere)
Set[ppPage,5];		* 2b mi in MesaESC (anywhere)
Set[piPage,5];		* 1b mi in MesaESC (anywhere)
Set[dsPage1,5];		* 2b mi in MesaESC if WithDShift=1 (anywhere)
Set[dvPage1,5];		* 1b mi in MesaESC (anywhere)
Set[bltPage1,7];	* 3b mi in MesaOP3 (anywhere)
Set[LSPage,7];		*25b mi in MesaESC (any page with refill)
Set[csPage,11];		*27b mi in MesaESC (not 4 to 7)

*CEDAR PAGE ASSIGNMENTS
*Audio.Mc uses timer slot 2b; Jasmine.Mc, slots 13b through 16b.
Set[audPage,17];
	Loca[audGoLoc,audPage,200];		*JRam start = 160000b+audGoLoc
Set[JasPage,17];				*164b mi (not on 4 to 7)
	Loca[JasmineOn,JasPage,201];	*JRam start = 160000b+JasmineOn
	Loca[JasmineOff,JasPage,202];
	Loca[JasminePulse,JasPage,203];
Set[HalftonePage,17];			*124b mi (not on 4 to 7)
	Loca[PrintLine,HalftonePage,204];

*REGISTER DEFINITIONS FOR TIMER TASK, MIDAS KERNEL, ETC.
SetTask[TTask];

*320-377 are accessible as variables, but registers that are targets of
*PFetch/PStore can only use 340-357 for the timer task.
*RM 352-353 are smashed by PNIP on a crash, so they are ok as temporaries
*but inconvenient for permanent registers.

*CDC 9730 disk runs at task 15b using registers 320-321b, 324-337b, 342-343b.
RV[RTimer,22];		*Refresh timer
RV[vCrystal,23];	*Contains 2*processor clock speed in mHz.

RV[TimerInts,40];	*Holds Notify bits for the UserTimer Esc opcode
		**Must be register 340b because of NotifyInterrupt;
		**341b will also be smashed when the timer expires.

RV2[ClockLo,ClockHi,52];	*Pilot 64d-cycle Timer

RV[xoNotify,50];	*Notify value for 1st 3 mb Ethernet output task
RV[xoNotify2,40];	*Notify value for 2nd 3 mb Ethernet output task
RV[enxNotify,51];	*Notify value for 10 mb Ethernet
RV[enxNotify2,41];	*Notify value for 10 mb Ethernet
RV[enxNotify3,40];	*Notify value for 10 mb Ethernet

**RM 334-346 Audio.Mc temporaries must be moved to overlap CDC9730 regs.
**RM 334-351 Jasmine.Mc temporaries must be moved to overlap CDC9730 regs.

*Where Initial's memory test results are left for the emulator.
RV4[xPageCount,xStorageFaults,xHardBadPages,xSoftBadPages,44];

*These permanent registers are accessed through StkP and can move anywhere.
*Image of RS232 hardware register; new wakeups waiting; tick size (3);
*current tick count.  The code in MesaOP0 at NopInt and in MesaP at Interrupt
*references these four registers in sequence.
RV4[RSImage,NWW,prTime,prTicks,54];


*REGISTER DEFINITIONS FOR KERNEL, INITIAL, AND FAULT.
SetTask[17];

RV4[PipeReg,PipeReg1,PipeReg2,PipeReg3,60]; *Pipe Ram Entry
RV2[PipeReg4,PipeReg5,64];
RV[FFault,66];		*Flags tell what to do with fault
RV[FaultParm,67];	*-1 => MOB fault
			*positive => page fault, page in low 14 bits
			*negative => write protect, page in low 14 bits
RV[RTMP,71];		*temporary
RV[RXStk,72];		*SStkP&NStkP
RV[RXPPB,73];		*Page&Par&Boot
RV[RXCTask,74];		*CTask.NCIA
RV[RXAPC,75];		*APCTask&APC
RV[RXALU,76];		*ALUResult&NSALUF
RV[Refr,77];		*Refresh address (task 17's register); used by
			*both Midas Kernel and Pilot TTask, so convenient
			*not to move this.

*RM DEFS ALLOWING SYMBOLIC MIDAS DISPLAY FOR RM 100-107 AFTER MEMORY ERRORS
SetTask[4];
RV4[MapEntry,TaskNumber,RefType,CrashCode,0];
RV4[CardNumber,MapFlags,QuadAddr,Syndrome,4];

*REGISTER DEFINITIONS FOR MESA EMULATOR

SetTask[0];

**Should move MemStat to avoid overlap with prLocal.
RV[MemStat,0];	*Permanent variable controlling page fault handling

*Mesa Stack locations cannot move because of hardware overflow checking.
MC[MaxStack,16];	*Largest referenceable stack address
RV[Stack0,1]; RV2[Stack1,Stack2,2]; RV4[Stack3,Stack4,Stack5,Stack6,4];
RV4[Stack7,Stack8,Stack9,Stack10,10]; RV2[Stack11,Stack12,14]; RV[Stack13,16];

RV[xfBrkByte,17];

*20-21 are permanent registers for Cedar or TextBlt temporaries.
RV[prCurrentPsb,22];	*Points to front of ready queue.
RV[prPsbIndexMask,23];	*Contains a mask for the PsbIndex

:IF[CacheLocals]; ************************************
*Quadword for cacheing Locals 0 to 3
RV4[LocalCache0,LocalCache1,LocalCache2,LocalCache3,24];	
:ENDIF; **********************************************
*24-25 are permanent registers for Cedar or TextBlt temporaries.
*26-27 are unused except by the LocalCache
RV2[PCB,PCBhi,30];		*PC base register pair
***Free one register by defining RZero equal to MDS.
RV2[RZero,R400,32];		*Constant 0, Constant 400
RV2[prPda,prPdaHi,32];	*Base register pair points to Process Data Area.
			*Must be same as RZero and R400 
RV2[LOCAL,LOCALhi,34];
RV2[MDS,MDShi,36];
*xfGarb0 not necessarily in quadword; xfGFIWord, CODE, and
*CODEhi must be 2nd to 4th words of quadword for MesaOP3 Loadgc.
RV4[xfGarb0,xfGFIWord,CODE,CODEhi,40];
*44-55 are temporaries.
*These four registers must be arranged this way for MesaOP3 type 1 Xfer.
RV4[xfRSAV,xfMY,GLOBAL,GLOBALhi,54];	*xfRSAV and xfMY are temps
RV4[IBuf,IBuf1,IBuf2,IBuf3,60];	*instruction buffer

*64-73 are temporaries.

*AllOnes is used by Initialize.Mc, so it may not conflict with
*registers defined there (it may not be in the range 40b to 57b,
*and some other values are illegal also).
RV[AllOnes,74];
*75 is a permanent register (fpSticky) for MesaFP
RV[xfWDC,76];
RV[xfXTSreg,77];

*General temporaries
RV4[xBuf,xBuf1,xBuf2,xBuf3,44];	*Quadword temporary buffer 
RV4[yBuf,yBuf1,yBuf2,yBuf3,50];	*For new LoadRAM
RV[RTemp,52];
RV[RTemp1,53];
RV[WW,54];
RV2[LPdest,LPdesthi,54];	*Long BLT
RV2[LP,LPhi,66];		*long pointer base pair

*XFER temporaries used in MesaOP3 and MesaESC
RV[TrapParm,50];
RV[xfFrame,51];
RV[xfCount,66];
*xfFSI and xfMX must be even/odd pair for @RET in MesaOP3;
*xfTemp and xfTemp1 must be an even/odd pair for LoadRAM and other places
*and may not be moved from 72/73 because of LoadRAM.
RV4[xfFSI,xfMX,xfTemp,xfTemp1,70];
RV4[zBuf,zBuf1,zBuf2,zBuf3,70];

*BitBlt temporaries (Stack2 - Stack13 available because BitBlt args
*are always passed in Stack0 - Stack1); RTemp is also used here.
*15, 51, and 64-65 are available temporaries here.
RV[bbArgPtr,1];			*pointer to BitBltArg table
RM[bbGrayWordIndex,IP[bbArgPtr]];	*Low order 4 bits
RV2[bbDestQLo,bbDestQHi,2];	*Dest Quad word address
RV2[bbSourceQLo,bbSourceQHi,4];	*Source Quadword address
RV[bbSourceBitOffset,6];
RV[bbItemsRemaining,7];
RV[bbDestBitOffset,10];
RV[bbDestBpl,11];
RV[bbItemWidth,12]; 
RV[bbSubitemDestBitOffset,13];
RV[bbFlags,14];
RV[bbGrayWord,16];		*Gray word
RV[bbNegItemWidth,40]; 
RV[bbDest,44];			*Quadword buffer
RV[bbSDNonOverlap,44];
RV[bbNegSDNonOverlap,50];
RV[bbDestWordOffset,53];
RV[bbSourceBpl,54];		*source bits per line
RV[bbSourceWordOffset,55]; 
RV[bbTouchPages,66];
RV[bbSubitemSourceBitOffset,67];
RV[bbSource,70];		*Quadword buffer
RV2[bbArgLo,bbArgHi,70];	*Points to BitBltArg table

*End of bitblt registers

%TextBlt registers--all temporaries are used here; in addition the permanent
Cedar register RM 24 is overwritten--TextBlt uses five more temporaries than
any other opcode.
%
*The following registers are in the stack on entry and reentry
RV[txrIndex,1];		*Stack 0
RV[txrBitPos,2];	*Stack 1
RV[txrMicaPos,3];	*Stack 2
RV[txrCount,4];		*Stack 3
RV[txrArgSPtr,5];	*Stack 4

*The following register is the same as txrArgSPtr above. On exit we
*return our result in the same stack register by which we recieved
*our argument pointer.
RV[txrResult,5];	*Stack 4

RV[txrDestBpl,6];
RV[txrMargin,7];

RV4[txrFontBodyLo,txrFontBodyHi,txrFlagLo,txrFlagHi,10];
RV[txrSrcBitOffset,12];
RV[txrDestBitOffset,13];

RV2[txrArgLo,txrArgHi,14];

RV[txrSrcImageWO,16];
RV[txrNegItemWidth,16];
RV[txrMicaWidth,40];

RV4[txrFunction,txrLast,txrTextLo,txrTextHi,64];

RV[txrDestBuf,44];	*Quadword block

RV[txrFlag,50];

RV[txrHeight,51];

RV2[txrDestLo,txrDestHi,52];
RV2[txrCoordLo,txrCoordHi,52];

RV2[txrFontLo,txrFontHi,54];

RV[txrBitWidth,26];

RV[txrSrcQWO,24];
RV[txrDestQWO,27];

RV[txrSrcBuf,70];	*Quadword block
RV[txrCharacter,70];
RV[txrSpace,71];

%Temporary Process Registers

(1) Process registers are used only in MesaP and need not survive opcodes.
(2) Register assignments are based upon analysis of the scope of register use.
When MesaOP3 subroutines (only SavPCinFrame) are called by process code, the
MesaOP3 registers used must be included in the scoping.
(3) All process opcodes are minimal stack.  Unfortunately, because much of the
code is also used during interrupts and fault notification we cannot, in
general, take advantage of minimal stack to use stack registers for process
temporaries. Since prMonitorQ(hi), prMonitor, and prSaveStkP are only used in
paths originating with opcodes, they can overlap the stack. 
%

RV2[prMonitorQ,prMonitorQhi,6];	
RV[prMonitor,10];	*Contains MonitorQ^
RV[prSaveStkP,10];	*Used by @MW to remember StkP while accessing
			*prTime and prTicks outside RM 0-77.
RV[prWaitCount,5];	*Used by MW (The original stack position of the
			*argument, so can't move it).

RV[prReturnLink,71];	*Used by all major subroutines
RV[prFlags,40];		*Used by all
RV4[prPsbLink,prPsbFlags,prPsbContext,prPsbMds,44];	*Used by all

*MW: prCondition & prConditionQ/Qhi survive Requeue.
*Faults: prData (RM 54) & prConditionQ/Qhi survive Requeue.
*Interrupts: WW (RM 54), prIntSaveStkP, & prConditionQ/Qhi survive Requeue.
*CheckForTimeouts: WW (RM 54), prIntSaveStkP, prIntPdaTimeout, prIntPsbIndex,
*& IBuf-IBuf3 survive Requeue.
*WW, prCondition, and prIntSaveStkP must be different registers.
**NOTE: RM 52-53 are smashed by PNIP, so prConditionQ/hi are invalid then.
RV2[prConditionQ,prConditionQhi,52];
RV2[prData,prData1,54];		*For fault parameters
RM[prCondition,IP[prData1]];	*Contains ConditionQ^
RM[prIntPdaTimeout,IP[prConditionQ]];
RM[prIntPsbIndex,IP[prConditionQhi]];
RV[prIntSaveStkP,67];

*RM 64-66 are available in RequeueSub.
RV[prReady,50];		*Used by Requeue and Reschedule
RV[prPsbIndex,51];	*Argument to Requeue (not modified)
RV[prPrevPsbLink,70];	*Used by Requeue, CleanUpQueue
RV[prNextPsbLink,72];	*Used by Requeue, CleanUpQueue
RV[prPrevPsbIndex,73];	*Used by Requeue

*prData, prData1 are used.
RV[prCurrentSAT,52];	*Used by Reschedule
RV[prPtrToSV,53];	*Used by Reschedule
RV2[prState,prStateHi,66];	*Used by Reschedule
*prStkP and prLocal are used in PFetch4/PStore4 from/to the state vector
*by Reschedule.  The hardware uses RM 15b, 16b, 17b, and 0 for this.
RV[prStkP,17];		*Used by Reschedule--**DON'T MOVE**
RV[prLocal,0];		*Used by Reschedule--**DON'T MOVE**
*xfTemp1 (RM 73) is used by SavPCinFrame called by Reschedule

RV[prPdaTimeout,70];	*Used by @MW and WakeHead

*End of process registers


*Following two definitions emphasize in the MicroD .Regs file that RM 352-353
*are clobbered by PNIP when executed on a fault; these registers aren't
*directly mentioned in Initialize.Mc because PNIP is defined for task 0.
RM[FaultPNIPX0,Add[300,IP[RTemp]]];
RM[FaultPNIPX1,Add[300,IP[RTemp1]]];

*CONSTANTS

MC[AVOffset,400];
MC[SDOffset,1000];
MC[EscTrapOffset,1400];	*Displacement of Esc/EscL trap table in MDS.
MC[GFTOffset,2000];

MC[StkPOffset,MaxStack];	*StateVector format
MC[DestOffset,MaxStack,1];
MC[SourceOffset,MaxStack,2];

MC[GFlagsOffset,3];	*G frame (negative displacements)
*MC[GCodeBaseOffset,2];

*MC[LPCOffset,1];		*L frame (negative displacements)
*MC[LGlobalLinkOffset,2];
*MC[LRetLinkOffset,3];
*MC[LFSIOffset,4];

MC[IntPendingBit,10];

MC[sBreakTrap,0];		*SD indices
MC[sStackError,1];
*MC[sBoot,2];
MC[sRescheduleError,3];
MC[sXferTrap,4];
MC[sOpcodeTrap,5];
MC[sControlTrap,6];
MC[sCodeTrap,7];
*MC[sHardwareError,10];
MC[sUnboundTrap,11];
MC[sDivZeroTrap,12];
MC[sDivCheckTrap,13];
MC[sInterruptError,14];
MC[sProcessTrap,15];
MC[sBoundsTrap,16];
MC[sPointerTrap,17];

*PDA (Process Data Area) format.
*The first Psb has a PsbIndex of 210. This permits us to use the
*same register to access the Pda and all of the Psbs.
MC[pdaReady,0];		*Word 0: points to tail of ready queue.
MC[pdaCount,1];		*Word 1: number of Psbs in the block.
MC[pdaTimeout,2];	*Word 2: Pointer to TimeoutVector.
MC[pdaReserved,3];	*Word 3..7: Currently not used, = zero.
MC[pdaState,10];	*Word 10: Array[0..7] of Pointer To
			*StateVector List. Indexed by priority.
MC[pdaInterrupt,20];	*Word 20: Array[0..WordSize) of
			*InterruptVector : [Condition, Unspecified].
MC[pdaLastInterrupt,56];	*Word 56: last [Condition, Unspecified].
Set[qFaultOS,60];	*Word 60: Array[0..7] of
			*FaultVector : [Queue, Condition].
MC[pdaFault,qFaultOS];	*MC form.
MC[pdaBlock,100];	*Word 100: Array[0..count) of Psb.
*Fault Offsets. Offsets from pda to Fault[fault]
MC[qFrameFaultOs,qFaultOS];
MC[qFrameFaultCOs,ADD[qFaultOS,1]];	*Fault[frame].condition
MC[qPageFaultOs,ADD[qFaultOS,2]];
MC[qWriteProtectOs,ADD[qFaultOS,4]];	

*MemStat constants
* low three bits are dispatch code for page fault
* other bits are flags to Xfer
MC[Normal,0];		*Only normal PC fixup required on page fault
MC[BltLFixup,2];	*Fixup for BLTL
MC[BltFixup,3];		*Fixup for BLT
MC[EarlyXfer,4];	*Fixup for early Xfer
MC[XferFixup,5];	*Fixup for late Xfer
MC[BitBltFixup,6];	*Fixup for BitBlt
MC[Trap,40];		*Current Xfer is a Trap
MC[PushSD,100];		*Put source/dest above stack
MC[FreeFrame,200];	*Free old frame if Xfer is successful

MC[StartDeviceInit,150];	*104d indicates that Pilot microcode initialization
			*has started.

*Crash codes for Maintenance Panel.  NOTE: maintenance panels have been known
*to pick up occasional extra pulses, so codes 1 larger than those here
*sometimes are seen.

MC[RMCSCrash,170];	*120d to 135d RM or CS parity error possibly in
			*combination with other errors.  MP code is 120d plus:
			* 1 if MC1 or MC2 error
			* 2 if RM parity error
			* 4 if CS parity error
			* 8 if Stack overflow or underflow

%The following codes imply no RM or CS parity error or stack error.  Many
codes show a mod 20d number + the task responsible for the error; mod 20d
allows the task number to be easily computed from the maintenance panel.
NOTE: code definitions with the pipe task added to them are offset by 15d to
compensate for the microcode's algorithm, but comments are correct.
%
MC[MOBCrash,214];	*140d + current task.  Map Out of Bounds during
			*microcode init (traps to Mesa after init).
MC[H4PECrash,240];	*160d + current task.  H4PE.
MC[LPCrash,264];	*180d + current task.  Some fault when preceding mi
			*was LoadPage (Indicates microcode bug--report it).
MC[MC2Crash,327];	*200d + pipe task.  MC2 error (Uncorrectable
			*storage failure, correctable failure with LogSE
			*true (illegal), or violation of
			*Output-Output-PStore4 gotcha).
MC[MC1Crash,353];	*220d + pipe task.  MC1 fault (i.e., page or write
			*protect fault) by any task during microcode init
			*or during LoadRAM.  After init, only io task
			*references experiencing MC1 faults crash;
			*emulator MC1 faults are passed to MesaP.Mc
			*at the label "prFault".

MC[BrkPCrash,360];	*240d + current task.  SetFault (i.e., breakpont) by
			*task, interpreted as follows:
			* 0 emulator (no special uses)
			* 1 unused (bad wakeup)
			* 2 unused (bad wakeup)
			* 3 unused (bad wakeup)
			* 4 1st MIOC task, 2nd Ethernet 3mb or 10mb output
			*	task, or EOM low task.
			* 5 3mb or 10mb 2nd Ethernet input task, IFDC task,
			*	color display task, or EOM high task.
			* 6 2nd MIOC task or 1st 10mb Ethernet output task.
			* 7 1st 10mb Ethernet input task.
			* 8 RDC task.
			* 9 unused (bad wakeup)
			* 10 1st 3mb Ethernet output task.
			* 11 1st 3mb Ethernet input task.
			* 12 Display task or UIB task.
			* 13 unused (bad wakeup).
			* 14 timer task.
			* 15 fault task.

MC[NoStateVectorError,164];	*116d--MesaP crash.
MC[MC22Crash,165];	*117d 2 MC2 errors
*MC[NextInstMPCode,166];	*118d--Hardware problem on some machines causing
			*ResetErrors executed at the onset of a fault to be
			*interpreted as a NextInst.  The consequence is
			*that SStkP _ StkP and PCX advance occurs;
			*NO LONGER IMPLEMENTED. 

MC[StkCrash,167];	*119d--Stack over/underflow
MC[MCNoneCrash,210];	*136d--MC12 error with no error indication in
			*pipe--possibly PFetch4 experienced error
			*correction, next reference faulted, and third
			*reference slipped in erroneously.
MC[MonExitError,211];	*137d--MX or MW with monitor already unlocked.
MC[CULError,212];		*138d--MW with cleanup link non-zero.

%These MP codes are used by Initial, the boot loader that runs prior to
loading either AMesa or Pilot; fault and crash MP codes are identical to
those for Pilot, except that they are offset by InitialMPOffset.  However,
InitialMPOffset .eq. 0, so they are the same now.  In addition, Initial has
the "normal boot sequence" codes enumerated below and a few error MP codes of
its own.  These codes are used in Initial.Mc, MemInit.Mc, and SA4000Loader.Mc.
%
Set[MinGoodPages,400];		*Minimum no. good pages (= 64k words)

Set[InitialMPOffset,0];		*Offset for fault crash MP codes
MC[MPOffset,1000];		*Offset for sequencing MP codes
				*(displayed by ShowNumber).
MC[StartMapInit,274];		*700d
MC[NotEnoughMemory,275];	*701d (64k 16-bit words required)
MC[BadMap,276];			*702d (map must be perfect)
MC[StartDiskBoot,320];		*720d
MC[NoRDC,321];			*721d
MC[RDCReadError,322];		*722d
MC[StartDiskBootPilot,325];	*725d
MC[StartEtherBoot,344];		*740d  Offset for set of boot numbers. 
MC[NoUTVFC,345];		*741d

%If any storage board failures are found by Initial's diagnostic, irrespective
of whether the pages are used or discarded, then 3 numbers will be shown on
the MP for 1.6 seconds each.  The first number, indicating storage board(s)
affected by failures, has a range of 400d to 655d; it is interpreted
according to the table below.  The second number is a count of hard bad pages
detected (ones with uncorrectable failures).  The third number is a count of
soft bad pages (ones with correctable failures).
%
Set[TestingStorage,620];	*400d + n bit-encoded as follows:
				* +   1 1st storage board has failure(s)
				* +   2 2nd storage board has failure(s)
				* +   4 3rd storage board has failure(s)
				* +   8 4th storage board has failure(s)
				* +  16 5th storage board has failure(s)
				* +  32 6th storage board has failure(s)
				* +  64 7th storage board has failure(s)
				* + 128 8th storage board has failure(s)

MC[MPOffset256,400];		*Used by SA4000Loader
MC[MPCodeNoSoftBootCode,51];	*809d
MC[MPCodeNoGerm,52];		*810d
MC[MPCodeNoPilotBootVolume,53];	*811d
MC[MPCodeRDCLabelCheck,54];	*812d

:END[GlobalDefs];(2048)
