*Only one of these release switches may be 1; the others must be 0.
Set[Rubicon,0];
Set[Trinity,0];
Set[Klamath,1];
:IF[Rubicon]; ************************************
  TITLE[InitialDefs.Cedar.microcode];
:ELSEIF[Trinity]; ********************************
  TITLE[InitialDefs.10.0.microcode];
:ELSEIF[Klamath]; ********************************
  TITLE[InitialDefs.11.0.microcode];
:ELSE; *******************************************
  ER[BUG..SYSTEM.RELEASE.NOT.SPECIFIED.IN.INITIALDEFS];
:ENDIF; ******************************************

%Ed Fiala 12 March 1984: Renumber OldWordOffset for conflict reported
  by Blackman.
Ed Fiala 6 February 1984: Change some defs for Klamath.
Ed Fiala 16 January 1984: Create this file from declarations in
  GlobalDefs.mc, Initial.mc, and other files.
%

*Page and location assignments

*For Initial.mc
Set[InitialPage,10];
	Loca[InitBase,InitialPage,100];
	Set[Qloc,Add[InitBase,30]];
	Set[QretLoc,Add[InitBase,32]];
	Set[BootTaskLoc,Add[InitBase,34]];
	Set[Task17Start,Add[InitBase,20]];
	Set[DeviceDispatch,Add[InitBase,40]];
*Place Task 16 code on a page that will not be smashed by Pilot1
*because Initial's timer task must still be running to handle Midas
*breakpoints after Pilot1 is loaded and before Pilot1's timer task starts.
Set[InitialPage1,11];
	Loca[Task16Start,InitialPage1,0];	*two locations
	Loca[MidasStopLoc,InitialPage1,3];	*two locations
	Loca[MC2ErrRet0,InitialPage1,17];
	Loca[MC2ErrRet1,InitialPage1,16];
	Loca[imBST,InitialPage1,20];
	Loca[imFST,InitialPage1,40];

*For SA4000Load.mc
Set[SalLoaderPage,12];	*271b mi (could be bummed more)

*For E3Load.mc
Set[E3Page,4];		*171b mi
	Loca[E3OutStartLoc,E3Page,130];
	Loca[E3InStartLoc,E3Page,110];

Set[EtherBootLoc,1400];	*The starting address for a 3 mb etherboot
			*in the Boot microcode blown in the EPROMs;
			*This is known to PromDefs.  SA4000Load jumps
			*to EtherBootLoc if it fails.

*For E10Load.mc
Set[E10Page,5];
	Loca[E10StartLoc,E10Page,101];

*Tasks
Set[E3OutTask,2];	*3 mb Ethernet output task
Set[E3InTask,3];	*3 mb Ethernet input task
Set[E10Task,2];	*10 mb Ethernet task
Set[RdcBootTask,4];
*RdcTask (in GlobalDefs.mc) is also used.


*The following are for the ESS Initial microcode
Set[vdLoaderPage,15];	*302b mi
Set[vdLoaderPage2,16];	*163b mi

***NOTE: All the 10mb Ethernet parameters need to be defined.

Set[E3BFNOffset,3000];	*3 mb boot servers add E3BFNOffset to BFI
			*to get BFN.
Set[E3AUCodeBFI,Sub[3411,E3BFNOffset]];	*AltoD0.eb BFI
Set[E3AltAUCodeBFI,Sub[3431,E3BFNOffset]];	*Alternate AltoD0.eb BFI

Set[E10AUCodeBFN,3411];	*AltoD0.eb BFI
Set[E10AltAUCodeBFN,3431];	*Alternate AltoD0.eb BFI

*GermAddress is the location into which loading of the germ from 3 mb or
*10 mb Ethernet or the disk takes place.  For Trinity and later system
*releases, the location into which the germ is loaded is also its running
*location, but for Rubicon, the germ is moved to high virtual memory
*by exchanging map entries prior to running.
Set[GermAddress,400];	*MDS-relative address where germ starts
			*Bank 0 is required by the code which computes
			*page numbers for Rubicon XMaps.
MC[CSBAddress,100000];	*Memory address of CSB for SA4000Load
  MC[IOCBOffset,100];	*Offset of IOCB from the CSB
MC[RootPageAddress,100400];	*Memory address of Physical Volume Root Page
MC[MicrocodeAddress,101000];	*This address must be large enough that
			*the germ won't overwrite it, small enough that
			*the largest emulator won't wrap around and
			*smash the germ.

*The following software constants vary with Rubicon, Trinity, and Klamath
*system releases.  Changing them requires the microcode to be reassembled.
:IF[Rubicon]; ********************************************
MC[GermMDSPage,37000];
MC[GermStartOffset,2];
Set[RealGermAddress,1000];	*MDS-relative address where germ starts
  Set[RealGermAddressHi,76];	*64k bank number for germ
Set[sFirstFree,142];	*Index of sFirstFree (from SDDefs.mesa)
Set[GermSwitchesOffset,Add[1100,sFirstFree]];	*Offset of Germ
			*switches within its MDS:
			*LOOPHOLE [@SDDefs.SD[SDDDefs.sFirstFree]]

Set[GermRequestOffset,1360];	*Offset of Germ Request within its MDS
***I don't know how big the Germ Request area is; 6 is large enough to zero
***the Device ordinal at 2, the 3 mb net number at 4, and the 3 mb host
***number at 5.  The RequestSize is used to control the number of words
***zeroed.
  Set[RequestSize,6];
  *Within the request:
  Set[ReqActionOffset,0];	*Offset of Action
	MC[bootPhysicalVolume,2];	*For disk boot
	MC[inLoad,0];	*For 3 mb or 10 mb etherboot
  Set[ReqDevTypeOffset,1];	*Offset of Device Type
	MC[PilotDiskDeviceType,3];	*=SA4000DeviceType from Device.mesa
	MC[E3DevType,5];
	MC[E10DevType,6];	***Not meaningful
  *Set[ReqDevOrdinal,2];	*Offset of device ordinal (left 0)

  Set[E3ReqBFN,3];	*Offset of boot file number
  *Set[E3ReqNetNum,4];	*Offset of 3mb network number (left 0)
  *Set[E3ReqHostNum,5];	*Offset of 3mb host number (left 0)

Set[E3PUCodeBFI,Sub[3425,E3BFNOffset]];	*CedarD0.eb
Set[E3GermBFI,Sub[45002,E3BFNOffset]];	*Cedar5D0.eg
Set[E3OthelloBFN,45003];			*BasicCedarD0.pb
*These are the same for now except CedarOthello replaces BasicCedar.
Set[E3AMPUCodeBFI,Sub[3425,E3BFNOffset]];	*Exp. CedarD0.eb
Set[E3AMGermBFI,Sub[45002,E3BFNOffset]];	*Exp. Cedar5D0.eg
Set[E3AMOthelloBFN,5001];			*CedarOthelloD0.pb

:ELSEIF[Trinity]; ****************************************
Set[GermRequestOffset,1320];	*Offset of Germ Request within its MDS
  Set[RequestSize,60];	*Size of Germ Request area
  *Within the request:
  Set[ReqVersionOffset,0];	*Offset of Version
	Set[RequestVersion,3456];
  Set[ReqActionOffset,1];	*Offset of Action
	MC[bootPhysicalVolume,2];
	MC[inLoad,0];
  Set[ReqDevTypeOffset,2];	*Offset of Device Type
	MC[PilotDiskDeviceType,100];	***EAT said SA4000 was 129
	MC[E3DevType,7];
	MC[E10DevType,6];
  Set[ReqExtVersionOffset,15];	*requestExtionsionVersion
	Set[ReqExtVersion,7123];	*For 10.0 germ
  Set[ReqSwitches,16];	*Offset of Switches (0)

*For 3 mb Ethernet:
  Set[E3ReqBFN,4];	*Offset of boot file number
  Set[E3ReqNetNum,5];	*Offset of 3mb network number (0)
  Set[E3ReqHostNum,6];	*Offset of 3mb host number (0)

*For 10 mb ethernet:
  Set[E10ReqBFN,4];	*Offset of boot file number (3 words)
  Set[E10ReqNetNum,7];	*Offset of net number (2 words)
  Set[E10ReqHostNum,11];	*Offset of host number (3 words)
  Set[E10ReqSocketNum,14];	*Offset of socket number

Set[E3PUCodeBFI,Sub[3421,E3BFNOffset]];	*Trinity PilotD0.eb
Set[E3GermBFI,Sub[4010,E3BFNOffset]];	*Trinity D0.eg
Set[E3OthelloBFN,4011];			*Trinity OthelloD0.pb
***Note that for a UIB terminal, BFI = AMPUCodeBFI+2 which won't work.
Set[E3AMPUCodeBFI,Sub[43001,E3BFNOffset]];	*Exp. Trinity PilotD0.eb
Set[E3AMGermBFI,Sub[43002,E3BFNOffset]];	*Exp. Trinity D0.eg
Set[E3AMOthelloBFN,43003];			*Exp. Trinity OthelloD0.pb

%The high-order and middle-order parts of all 10 mb BFN's for the Dolphin
are the same for all files of interest here.
No Alto emulator BFN has been assigned for 10 mb booting (Alto emulator
doesn't include any 10 mb Ethernet driver.).
%
Set[E10BFNHi,0];
Set[E10BFNMid,125002];
*The low-order part of the BFN for Initial itself is 0.
Set[E10PUCodeBFN,1];	*PilotD0.eb
Set[E10GermBFN,2];	*D0.germ
Set[E10OthelloBFN,3];	*OthelloD0.boot
*Set[E10AUCodeBFN,??];
*The low-order part of the BFN for experimental Initial is 10b.
Set[E10AMPUCodeBFN,11];	*PilotD0Alt.eb
Set[E10AMGermBFN,12];	*D0Alt.germ
Set[E10AMOthelloBFN,13];	*OthelloD0Alt.boot
*Set[E10AltAUCodeBFN,??];

:ELSEIF[Klamath]; ****************************************
Set[GermRequestOffset,1640];	*Offset of Germ Request within its MDS
  Set[RequestSize,60];	*Size of Germ Request area
  *Within the request:
  Set[ReqVersionOffset,0];	*Offset of Version
	Set[RequestVersion,3456];
  Set[ReqActionOffset,1];	*Offset of Action
	MC[bootPhysicalVolume,2];
	MC[inLoad,0];
  Set[ReqDevTypeOffset,2];	*Offset of Device Type
	MC[PilotDiskDeviceType,100];	***EAT said SA4000 was 129
	MC[E3DevType,7];
	MC[E10DevType,6];
  Set[ReqExtVersionOffset,15];	*requestExtionsionVersion
	Set[ReqExtVersion,7123];	*For 11.0 germ
  Set[ReqSwitches,16];	*Offset of Switches (0)

*For 3 mb Ethernet:
  Set[E3ReqBFN,4];	*Offset of boot file number
  Set[E3ReqNetNum,5];	*Offset of 3mb network number (0)
  Set[E3ReqHostNum,6];	*Offset of 3mb host number (0)

*For 10 mb ethernet:
  Set[E10ReqBFN,4];	*Offset of boot file number (3 words)
  Set[E10ReqNetNum,7];	*Offset of net number (2 words)
  Set[E10ReqHostNum,11];	*Offset of host number (3 words)
  Set[E10ReqSocketNum,14];	*Offset of socket number

Set[E3PUCodeBFI,Sub[3421,E3BFNOffset]];	*Klamath PilotD0.eb
Set[E3GermBFI,Sub[4010,E3BFNOffset]];	*Klamath D0.eg
Set[E3OthelloBFN,4011];			*Klamath OthelloD0.pb

***Note that for a UIB terminal, BFI = AMPUCodeBFI+2 which won't work.
Set[E3AMPUCodeBFI,Sub[43001,E3BFNOffset]];	*Exp. Klamath PilotD0.eb
Set[E3AMGermBFI,Sub[43002,E3BFNOffset]];	*Exp. Klamath D0.eg
Set[E3AMOthelloBFN,43003];			*Exp. Klamath OthelloD0.pb

%The high-order and middle-order parts of all 10 mb BFN's for the Dolphin
are the same for all files of interest here.
No Alto emulator BFN has been assigned for 10 mb booting (Alto emulator
doesn't include any 10 mb Ethernet driver.).
%
Set[E10BFNHi,0];
Set[E10BFNMid,125002];
*The low-order part of the BFN for Initial itself is 0.
Set[E10PUCodeBFN,1];	*PilotD0.eb
Set[E10GermBFN,2];	*D0.germ
Set[E10OthelloBFN,3];	*OthelloD0.boot
*Set[E10AUCodeBFN,??];
*The low-order part of the BFN for experimental Initial is 10b.
Set[E10AMPUCodeBFN,11];	*PilotD0Alt.eb
Set[E10AMGermBFN,12];	*D0Alt.germ
Set[E10AMOthelloBFN,13];	*OthelloD0Alt.boot
*Set[E10AltAUCodeBFN,??];

:ENDIF; **************************************************

SetTask[0];

*Registers used in more than one file or which must survive major calls
*to other files:
RV[BootType,20];	*Must survive call to MemInit.mc

*These registers must survive calls to the boot file reading subroutines.
RM[BFIMicrocode,IP[BootType]];
RV[BFIGerm,21];
RV[BFNBootFile,22];
RV[PageCount,37];	*Count of 'good' pages; ***Location known to
			*old versions of Alto emulator.  PageCount is
			*initialized by MemInit.mc and used by Rubicon
			*Initial.mc and SA4000Load.mc
RV[IReturn,50];
RV2[IniBaseLo,IniBasehi,72];
*Also RTemp, RTemp1, xfTemp, xfTemp1, LP, and LPhi

*The following are needed only for Rubicon when doing XMap's to relocate
*the germ.
RV4[IniMap0,IniMap1,IniMap2,IniMap3,14];
RV[IniExchPage,4];
RV[IniFrom,7];
RV[IniTo,13];
RV[IniPageCount,2];

*Initial.mc registers
RV[RCnt,51];

*MemInit.mc registers
*All RM registers except BootType appear to be available to MemInit.mc,
*except that RTemp and RTemp1 (RM 52-53) are smashed by PNIP.
RV[StorageFaults,21];	*Number of quadwords with correctable
			*failures detected by the diagnostic in pages
			*which had no uncorrectable failures.
RV2[XMAdLo,XMAdHi,22];	*Base register
RV4[XMBuf0,XMBuf1,XMBuf2,XMBuf3,24];	*Buffer for XMap
RV4[RBuf0,RBuf1,RBuf2,RBuf3,24];	*Buffer for PFetch4
RV4[WBuf0,WBuf1,WBuf2,WBuf3,30];	*Buffer for PStore4
RV[RLink0,34];		*Subroutine return link
RV[MapAddr,35];		*Current map location
RV[RealPage,36];	*Current real storage page
RV[Transient,40];	*Holds soft error count during storage test.
RV[ZPage,41];		*Virtual page being tested during sweep
RV[ZWord,42];		*Word within page being tested during sweep
RV[RLink1,43];		*MC2 fault return link
RV[RLink2,44];		*Another subroutine return link
RV[SoftQThreshold,45];
RV[SoftBadPages,46];
RV[HardBadPages,47];

*E3Load and E10Load registers; E10Task=2, E3OutTask=2, and E3InTask=3.
*Since these registers are referenced by both task 0 and task 2 or 3,
*they are restricted to be in the range 20 to 77b.
RV[Count,3];
RV[BootFileNumber,43];
RV[BytesLeft,62];
RV[Packet,66];
RV[Checksum,67];
RV[Word,70];
*IReturn and IniBaseLo/Hi shared with Initial.mc
RV[WordOffset,74];

SetTask[E3OutTask];
RV[OutTemp,41];
RV[OutMask,42];

SetTask[E3InTask];
RV[InTemp,61];
RV[Junk,63];
RV[Source,64];
RV[SourceTemp,65];
RV[Host,77];

SetTask[E10Task];
RV[E10HostID1,41];
RV[E10Source0,42];
RV[E10Source1,44];
RV[E10Source2,45];
RV2[E10HostID2,E10HostID3,46];
RV4[E10Temp0,E10Temp1,E10Temp2,E10Temp3,54];
RV[OldWordOffset,60];(635)\f2
