#
/*
*************************************************************************
*									*
*	This program finds solutions to the following game:		*
*									*
*	A triangular board has 15 holes, as shown in the diagram.	*
*	Some holes have pegs in them, and some are empty.  A move	*
*	consists of jumping with one peg over a second peg to an 	*
*	empty hole.  The peg jumped over is removed.  Moves are		*
*	permitted in any direction parallel to a side of the triangle.  *
*	A solution results when exactly one pin remains.		*
*									*
*	DIAGRAM								*
*				  1					*
*				2   3 					*
*		              4   5   6					*
*			    7   8   9  10				*
*			 11  12  13  14  15				*
*									*
*	INPUT is a list of hole numbers that are to be empty.		*
*									*
*		Program Written By:       Gil Berglass			*
*					  The MITRE Corporation		*
*					  McLean, Virginia 22102	*
*					  (703) 827-6087		*
*									*
*************************************************************************
*/


/*
	the "connect" table shows the connectivity of nodes 1-15.
	the order is ne,e,se,sw,w,nw.
*/

int connect[16][6] = {	{0,0,0,0,0,0},
		        {0,0,3,2,0,0},
			{1,3,5,4,0,0},
			{0,0,6,5,2,1},
			{2,5,8,7,0,0},
			{3,6,9,8,4,2},
			{0,0,10,9,5,3},
			{4,8,12,11,0,0},
			{5,9,13,12,7,4},
			{6,10,14,13,8,5},
			{0,0,15,14,9,6},
			{7,12,0,0,0,0},
			{8,13,0,0,11,7},
			{9,14,0,0,12,8},
			{10,15,0,0,13,9},
			{0,0,0,0,14,10}
		    };

/*
	an MNODE describes a move.  the "mto" field is the position moved
	to; the "mover" field is the position jumped over.
*/

typedef struct mnode {
			int mto;
			int mover;
			struct mnode *mnext;
		     } MNODE;

/*
	for each position (1-15), the list in the "move" table describes
	all legal moves.
*/

MNODE *move[16];

/*
	MNODEs are allocated from "mnspace".  "mnavail" is the index of
	the next free mnode cell 
*/

# define MNSIZE 300
MNODE mnspace[MNSIZE];
int mnavail;

/*
	the "state" vector describes the current state of the game.  a
	1 in a position indicates the presence of a peg; a zero indicates
	the absence of a peg.  "count" is the number of 1's.
*/

int state[16];
int count;

/*
	the "history" table indicates positions already seen.  the state
	is treated as a 15 bit number; the "history" table is treated as
	a 32768 entry bit vector (4096 8-bit characters).
*/

char history[4096];

/*
	the "path" vector describes the current path as a sequence of
	positions.  "ppath" is the index of the current position.
*/

struct {
	int jfrom;
	int jto;
	int jover;
       } path[16];
int ppath;

char lastchar;		/* the last character read */

char
posprt(p)
  int p;
  {
  /*
	return "*" is position p (1-15) contains a peg; "-" otherwise.
  */

	return( state[p] ? '*' : '-' );
  }

printit()
  {
  /*
	prints the current position at the terminal (centered on an 80
	character line).  a pin is indicated by an "*"; an empty position
	is indicated by a "-"
  */

	printf("                       %c\n",posprt(1));
	printf("                      %c %c\n",posprt(2),posprt(3));
	printf("                     %c %c %c\n",posprt(4),posprt(5),posprt(6));
	printf("                    %c %c %c %c\n",posprt(7),posprt(8),posprt(9),
					  posprt(10));
	printf("                   %c %c %c %c %c\n\n",posprt(11),posprt(12),posprt(13),
					      posprt(14),posprt(15));
  }

MNODE *
newmnode(pto,pover,pnext)
  int pto, pover;
  MNODE *pnext;
  {
	/* create a new MNODE, and initialize it */

	register MNODE *p;

	if( mnavail < 0 )  {
	  printf("ran out of free space -- abort\n");
	  return;  }
	p = &mnspace[mnavail];
	mnavail--;

	p->mto = pto;
	p->mover = pover;
	p->mnext = pnext;

	return( p );
  }

int
getnbr()
  {
  /*
	find, and then convert the next digit string;  return the value,
	or zero on newline.
  */

	register char c;
	register int  v;

	v = 0;
	if( lastchar == '\n' )  return( 0 );
	c = getchar();
	while( (c < '0') || (c > '9') )  {
	  if( c == '\n' )  return( 0 );
	  c = getchar();  }
	while( (c >= '0') && (c <= '9') )  {
	  v = 10*v + (c - '0');
	  c = getchar();  }
	lastchar = c;

	return( v );
  }

instate()
  {
  /*
	ask the user to list those positions containing pegs.
	return a state descriptor bit mask
  */

	register int bit;

	printf("\nenter initial configuration as list of positions without pegs:\n");
	for( bit = 1; bit <= 15; bit++ )  state[bit] = 1;
	count = 15;
	while( bit = getnbr() )  if( bit <= 15 )  {
				    count--;
				    state[bit] = 0;  }

	return;
  }

init()
  {
  /*
	processes the "connect" array to build the "move" table.
	initializes everything needing initializing.
  */

	register int i, m, p, q;

	mnavail = MNSIZE - 1;
	for( m = 1; m < 16; ++m )  {
	  move[m] = 0;
	  for( i = 0; i < 6; ++i )  {
	    if( p = connect[m][i] )  {
	      if( q = connect[p][i] )  move[m] = newmnode(q,p,move[m]); } } }

	lastchar = 'X';
	instate();

	ppath = 0;
	for( i = 0; i < 4096; ++i )  history[i] = 0;
  }

listpath()
  {
  /*
	list the jumps as a->b involved in the solution
  */

	register int i;

	for( i = 1; i <= ppath; ++i )  {
	    if( i == 10 )  putchar('\n');
	    printf("%d->%d  ",path[i].jfrom,path[i].jto);  }
	putchar('\n');
  }

int
dejavu()
  {
  /*
	examine the current state.  if we've seen it before, return 1.
	otherwise, return 0--but remember this state for another time.
  */

	register int box, bit;
	register int i;

	box = 0;
	for( i = 15; i > 0; i-- )  box = 2*box + (state[i]?1:0);
	bit = 1 << (box % 8);
	box /= 8;
/*	for( i = 15; i > 0; i-- )  box = box+box + (state[i]?1:0);
	bit = 1 << (box & 7);
	box >>= 3;
*/
	if( history[box] & bit )  return( 1 );
	history[box] |= bit;
	return( 0 );
  }

win()
  {
  /*
	if only one peg remains, we have "won" (i.e. found a solution),
	and we return a 1.  Otherwise we attempt a move from the current
	position.  If we find a move we make it and adjust the state.
	If not, we undo the most recent move and try an alternative.
	If no alternatives remain, we return 0 (failure).
*/

	register MNODE * c;
	register int peg;

next_step:
	for( peg = 1; peg <= 15; peg++ ) { 
	  if( state[peg] == 0 )  continue;
	  for( c = move[peg]; c; c = c->mnext )  {
	    if( (state[c->mover] != 0) && (state[c->mto] == 0) )  {
	      state[c->mover] = state[peg] = 0;
	      state[c->mto] = 1;
	      if( dejavu() )  {
		state[c->mover] = state[peg] = 1;
		state[c->mto] = 0;
		continue; }
	      count--;
	      ppath++;
	      path[ppath].jover = c->mover;
	      path[ppath].jto   = c->mto;
	      path[ppath].jfrom = peg;
	      if( count == 1 )  return( 1 );
	      goto next_step; } } }

	if( ppath == 0 )  return( 0 );

	state[path[ppath].jover] = state[path[ppath].jfrom] = 1;
	state[path[ppath].jto] = 0;
	ppath--;
	count++;
	goto next_step;
  }

main()
  {

again:
	init();
	if( count == 15 )  return;
	printit();
	while( win() )  {
	  printit();
	  listpath();  }
	printf("\n --- ALL SOLUTIONS HAVE BEEN PRINTED ---\n");
	goto again;
  }

);
	while( win() )  {
	  printit();
	  listpath();  }
	printf("\n --- ALL SOLUTIONS HAVE BEEN PRINTED ---\n");
	goto again;
  }


  }


ain;
  }

BEEN PRINTED ---\n");
	goto again;
  }

again;
  }

TIONS HAVE BEEN PRINTED ---\n");
	goto again;
  }



ALL 