/* basic i-o routines for C on ZOOMSYS */
/* putchar, getchar, open, creat, close, read, write, lseek, printf, scanf */
/* (also have length) */


putchar(c)
  {
	hexcode{31C300087F45}  /* {R3:=@RR12[8]; SC 045} */
  }

/*****************************************************************/

static	char	_BUF[144];  /*BUFLEN=144*/
static	int	_BUFIDX;
static	int	_RDCNT=0;

getchar()
  {
	/* assumes 1st reg. var (buf)->RR6, 2nd (rdcnt)->R8 */
	register char *buf;
	register int rdcnt;
	buf=_BUF;
	if ((rdcnt=_RDCNT)==0) {
	  hexcode{BD309464210100907F42A138}  /* get line of input */
		/* {R3:=0; LDL RR4,buf; R1:=144; SC 042; rdcnt:=R3} */
	  if (rdcnt<=0) {_RDCNT=0; return(-1);}
	  _RDCNT=rdcnt; _BUFIDX=0;
	}
	_RDCNT-=1;
	return(buf[_BUFIDX++]);
  }

/*****************************************************************/

errno=0;

/* open-write below assume 1st reg. var (errno_)->R6, 2nd (retval)->R7 */

open(name)
  char *name;
  {
	/* assumes 1st reg. var (errno_)->R6, 2nd (retval)->R7 */
	register int errno_,retval;
	hexcode{35C20008BD507F40A0DEC600A137}
	  /* LDL RR2,RR12[8]; R5:=0; SC 040; RL6:=RL5; RH6:=0; R7:=R3 */
	errno=errno_;
	return(retval);
  }

creat(name)
  char *name;
  {
	register int errno_,retval;
	hexcode{35C20008BD507F40A0DEC600A137}
	  /* LDL RR2,RR12[8]; R5:=0; SC 040; RL6:=RL5; RH6:=0; R7:=R3 */
	errno=errno_;
	return(retval);
  }

close(fd)
  {
	register int errno_,retval;
	hexcode{31C300087F41A0DEC600A137}
	  /* R3:=@RR12[8]; SC 041; RL6:=RL5; RH6:=0; R7:=R3 */
	errno=errno_;
	return(retval);
  }

read(fd,addr,len)
  char *addr;
  {
	/* assumes 1st reg. var (errno_)->R6, 2nd (retval)->R7 */
	register int errno_,retval;
	hexcode{31C3000835C4000A31C1000E7F42A0DEC600A137}
	  /* R3:=@RR12[8]; LDL RR4,RR12[10]; R1:=@RR12[14]; SC 042
	     RL6:=RL5; RH6:=0; R7:=R3 */
	errno=errno_;
	return(retval);
  }

write(fd,addr,len)
  char *addr;
  {
	register int errno_,retval;
	hexcode{31C3000835C4000A31C1000E7F43A0DEC600A137}
	  /* R3:=@RR12[8]; LDL RR4,RR12[10]; R1:=@RR12[14]; SC 043
	     RL6:=RL5; RH6:=0; R7:=R3 */
	errno=errno_;
	return(retval);
  }

lseek(fd,offset,type)
  long offset;
  {
	/* assumes 1st reg. var (errno_)->R6, 2nd (retval)->RR8 */
	register int errno_;
	register long retval;
	hexcode{30CB000935C4000A31C1000E7F05A0DEC6009428}
	  /* RL3:=@RR12[9]; LDL RR4,RR12[10]; R1:=@RR12[14]; SC 5
	     RL6:=RL5; RH6:=0; LDL RR8,RR2 */
	errno=errno_;
	return(retval);
  }

/**********************************************************************/


		/* printf.c - C implementation of Unix 	*/
		/* formatted I/O routine		*/

printf(frmt, i)
register char	*frmt;
int		i;
{
	register char	*argv; /*so can increment normally*/ /* **argv; */
	register int	c;
	register int	len, cnt;
	int		fwidth, precision, base;
	long		value;
	char		*cp, buf[25];

	argv = (char *) &i;

	len = length(frmt);

	while (len--)
	{
		if ((c = *frmt++) != '%')
		{
			putchar(c);
			continue;
		}

		/* format specification */
		/* pick up type */
		if (len == 0)
			break;	/* end of string */

		len--;
		c = *frmt++;
		fwidth = precision = 0;


		/* check for possible width specifier */
		if (c < 'A')
		{
			cnt = atoi(--frmt, ++len, &fwidth);
			frmt += cnt;
			len -= cnt;

			/* check for precision specifier */
			if (len == 0)
				break;
			if (*frmt == '.')
			{
				frmt++;
				len--;
				if (len == 0) break;

				cnt = atoi(frmt, len, &precision);

				len -= cnt;
				frmt += cnt;
			}

			/* pick up true format char */
			if (len == 0)
				break;
			len--;
			c = *frmt++;
		}

		base = 10;

		switch (c)
		{

		  case 'o':
			base = 8;
			goto unsigncase;

		  case 'x':
			base = 16;
			/* goto unsigncase; */

		  case 'u':
		unsigncase:
			value = *((unsigned *) argv);
			argv += sizeof(unsigned);
			/* *((int *) &value) = 0; */
			goto numeric;

		  case 'X':
			base = 16;

		  case 'D':
			value = *((long *) argv);
			argv += sizeof(long);
			goto numeric;

		  case 'd':
			value = *((int *) argv);
			argv += sizeof(int);

		numeric:
			cp = buf;
			cnt = cnvt(cp, base, value);
			break;

		  case 'f':
			cp = buf;
			getfltsr(*((double *) argv), cp);
			argv += sizeof(double);
			cnt = length(cp);
			break;

		  case 's':
			cp = *((char **)argv);
			argv += sizeof(char *);
			cnt = length(cp);
			break;

		  case 'c':
			cnt = 1;
			cp = (char *) argv;
			argv += sizeof(int);
/*#			ifdef Z8000	*/
			cp++;	/* byte passed in odd address on Z8000 */
/*#			endif	*/
			break;

		  default:
			putchar(c);
			continue;
		}

		/* output 'cp' according to fwidth & precision */
		/* limit field width */
		if (precision && cnt > precision)
			cnt = precision;

		while (cnt < fwidth)
		{
			fwidth--;
			putchar(' ');
		}

		while (cnt--)
			putchar(*cp++);
	}
}

/************************************************************************/

static
getfltsr(fval, buf)
	/* turn floating pt. value into ascii string (makes ZOOMSYS call) */
    double fval;
    char *buf;
    {
	/* assumes 1st reg. var. (fval2) ->RR6, 2nd (buf2) ->RR8 */
	register double fval2;
	register char *buf2;
	fval2=fval; buf2=buf;  /* RR6=fval, RR8=buf */
	hexcode {946294847F51}  /* LDL RR2,RR6; LDL RR4,RR8; SC 051 */
    }

/************************************************************************/

static
cnvt(buf, base, value)
char		*buf;
int		base;
long		value;
{
	register char	*ncp, *cp;
	unsigned long	val;
	char		locbuf[14];

	cp = buf;
	val = value;
	if (base==10 && value < 0)
	{
		*cp++ = '-';
		val = -value;
	}

	ncp = locbuf;
	do
	{
		*ncp = (val % base) + '0';
		if (base == 16 && *ncp > '9')
			*ncp += 'A' - ':';
		ncp++;

	} while ((val /= base) != 0);

	/* copy back */
	do
	{
		*cp++ = *--ncp;
	} while (ncp != locbuf);

	return (cp - buf);
}

/************************************************************************/

length(cp)
register char	*cp;
{
	register int	len;

	for (len = 0; *cp++ != '\0'; )
		if (++len > 256)
			break;

	return (len);
}

/************************************************************************/

	/*  atoi.c   ascii to integer conversion routine	*/

static
atoi(cp, len, ip)
register char	*cp;
int		len;
int		*ip;
{
	register int	l, i;
	int		sign;
	char		c;

	/* check for negative */
	sign = 0;
	if ((l = len) && *cp == '-')
	{
		len--;
		cp++;
		sign = 1;
	}

	for (i = 0; l; l--)
	{
		if ((c = *cp++) < '0' || c > '9')
			break;

		i = i * 10 + (c - '0');
	}

	*ip = sign ? -i : i;

	return (len - l);
}

/************************************************************************/

		/* scanf.c - C implementation of Unix 	*/
		/* formatted I/O routine		*/

/************************************************************************/

static double
ascflt(buf)
	/* enter with ascii string representing floating pt. number in buf */
	/* calc. & ret. floating pt. value (makes ZOOMSYS call) */
  char *buf;
  {
	register char *buf2;
	buf2=buf;  /* RR6=fval */
	hexcode {94627F50}  /* LDL RR2,RR6; SC 050 */
	/* ret. RR2 */
  }

/************************************************************************/

scanf(frmt, i)
  char *frmt;
  char *i;
  {
	register char	**argv;
	register int	in_c, count;
	register char	*varp;
	int		len,base,maxcnt;
	long		value;
	char		buf[25];  /* bufsiz=25 */

	argv = &i;

	len = length(frmt);
	count = 0; in_c = 0;

	while (len--)
	{
		if (*frmt++ != '%') continue;

		/* format specification */
		/* pick up type */
		if (len == 0)
			break;	/* end of string */

		--len;

		base = 10; varp = *argv; maxcnt=1000;

		switch (*frmt++)
		{

		  case 'X':
			base = 16;
		  case 'D':
			if ((in_c=inputnum(base,&value)) == -1) break;
			*(long *)varp = value;
			break;

		  case 'x':
			base = 16;
		  case 'h':	/**** must change if short<>int ****/
		  case 'd':
			if ((in_c=inputnum(base,&value)) == -1) break;
			*(int *)varp=(int)value;
			break;

		  case 'f':
			if ((in_c=inputsr(buf,24)) == -1)  /* 24=bufsiz-1 */
				break;
			*(double *)varp=ascflt(buf);
			break;

		  case 'c':
			maxcnt=1;
		  case 's':
			in_c=inputsr(varp,maxcnt);
			break;

		  default:
			continue;
		}

		if (in_c == -1) return(-1);
		++argv; ++count;
		if (in_c == '\n') return(count);
	}
	while (in_c != '\n') {
	  if (in_c == -1) return(-1);
	  in_c=getchar();
	}
	return(count);
  }

static
inputsr(strp,maxcnt)  /* input string to @strp, dest. has space maxcnt+1 */
		/* special case: if maxcnt=1, don't add \0 */
		/* ret. last char. input */
  register char *strp;
  register maxcnt;
  {
	register in_c,maxcnt0;
	maxcnt0=maxcnt;
	do in_c=getchar(); while (in_c == ' ' || in_c == '\t');
	while (in_c != ' ' && in_c != '\t' && in_c != '\n' && in_c != -1) {
	  if (maxcnt != 0) { --maxcnt; *strp++ = in_c; }
	  in_c=getchar();
	}
	if (maxcnt0>1) *strp='\0';
	return(in_c);
  }

static
inputnum(base,valp)  /* input number of base base to @valp */
		/* ret. last char. input */
  long *valp;
  {
	register in_c,sign;
	register long value;
	value=0; sign=0;
	do in_c=getchar(); while (in_c == ' ' || in_c == '\t');
	while (in_c != ' ' && in_c != '\t' && in_c != '\n' && in_c != -1) {
	  if (in_c == '-') sign=1;
	  else {
	    if (in_c>='a') in_c &= 0xDF;
	    if (in_c != 'X') {
	      if ((in_c -= '0') > 10) in_c -= 7;
	      value=value*base+in_c;
	    }
	  }
	  in_c=getchar();
	}
	if (sign != 0) value = -value;
	*valp=value;
	return(in_c);
  }

/*********************************************************************/

/END SECTION  /* get rid of static symbols */


	hexcode{31C300087F45}  /* {R3:=@RR12[8]; SC 045} */
  }

/***********************************