...program to configure EE screen editor (Z8000) for different terminals

FNFERR:	EQU 0C7  ...error code for file not found
HDRSZ:	EQU 018  ...header size
IMGSZ:	EQU 2  ...offset into header of image size
SEGTBSZ: EQU 0A  ...offset into header of segment table size
SCRVCP:	EQU 8  ...offset in EE of ptr. to SCRVEC
KEYVCP:	EQU 0A  ...offset in EE of ptr. to KEYVEC
LSCRVEC: EQU 6
LKEYVEC: EQU 9

BEG:
SAVSP:	LONG 0

SCRVECP: WORD 0  ...points to screen vector
KEYVECP: WORD 0  ...points to key vector
EESIZ:	WORD 0  ...size of EE incl. header

FLAG:	BYTE 0

POSOFF:	BYTE 0
LEADIN:	BYTE 0
CLRSCR:	BYTE 0
CLRLIN:	BYTE 0
POSCRS:	BYTE 0
INSLIN:	BYTE 0

CRSLT:	BYTE 0
CRSRT:	BYTE 0
CRSUP:	BYTE 0
CRSDN:	BYTE 0
CRSHM:	BYTE 0
CRSBTL:	BYTE 0
CRSTAB:	BYTE 0
CRSBTB:	BYTE 0
RUBOUT:	BYTE 0

LCONBUF: EQU 16
CONBUF:	BYTE 0[LCONBUF]

/SEG
START:	LDRL SAVSP,RR14; LDAR RR14,MYSP
	R3:=flag; RES R3,15; R3:->flag
/NONSEG
	EECONFIG()
	R3:=flag; SET R3,15; R3:->flag
/SEG
	LDRL RR14,SAVSP; RET

/NONSEG
LOAD:	PROC  ...load in filename @R3 ("EE")
	R9:=R3
	if R8:=open(R3,0,->RL5)=-1 then begin
	  if RL5=0C7 then printf("%s NOT FOUND\n",R9)
	  else ?"OPEN (of EE) ERROR ",RL5:
	  RESFLG Z; RET
	end
	if read(R8,^BUFF,02000,->RL5)=-1 then begin
	  ?"READ (of EE) ERROR ",RL5:
	  close(R8)
	  RESFLG Z; RET
	end
	close(R8)
	R0==R0; RET

SAVE:	PROC  ...save image to filename @R3 (EEE)
	if R8:=open(R3,1,->RL5)=-1 then begin
	  ?"CREATE (of EEE) ERROR ",RL5:
	  RESFLG Z; RET
	end
	if write(R8,^BUFF,EESIZ,->RL5)<<EESIZ then begin
	  ?"WRITE (of EEE) ERROR ",RL5:
	  close(R8)
	  RESFLG Z; RET
	end
	close(R8)
	R0==R0; RET

GETVECAD: PROC ...get addr of SCRVEC->SCRVECP; addr of KEYVEC->KEYVECP;
	... size of EE file->EESIZ (includes header)
	R8:=^BUFF; R6:=HDRSZ+@R8[SEGTBSZ]; R7:=R6+@R8[IMGSZ+2]->EESIZ
	R8:+R6
	R8+@R8[SCRVCP]->SCRVECP; R8+@R8[KEYVCP]->KEYVECP
	RET

Getnum:	PROC
	printf("    ")
	putchar(B.'>'); read(2,^CONBUF,10); R7:=^CONBUF
	while @R7=' ' do R7:+1
	if Hexd() not then begin ?"    Enter number in hex"; JR Getnum end
	R7:-1; HNum()->RL3
	RET

Getnum2: PROC
	if B.Getnum()&07F>=060 then RESB RL3,5
	RET

EECONFIG: PROC
	LOAD("EE"); RET NZ  ...load in EE
	GETVECAD()  ...get addr of SCRVEC,KEYVEC; also EE size
	FLAG:=0
	...
    ?"Program to configure EE editor for different terminals."
    ?"Both screen function codes and keys for cursor movement (+delete key)"
    ?"may be changed."
    ?
    ?"Do you want to change screen function codes? (enter Y or N)"
    printf("    "); getchar(); putchar(); ?
    if RL3&0DF<>'Y' then JP EC2
	SETB FLAG,0
	?"The following screen functions are used:"
	?"    clear screen"
	?"    clear line (either all or past cursor)"
	?"    insert line (not necessary)"
	?"    position cursor"
	?"Codes for screen functions may be either characters or characters"
	?"preceded by a lead-in character (such as escape)"
	?"(`pos. cursor' will then have 2 more chars. for the X & Y positions)"
	?
	?"Below, enter all values in hex followed by a <RETURN>:"
	?"(in each case, an example value valid for an Infoton 200 terminal is"
	?"shown in square brackets)"
	?
	?"If any function requires a lead-in, enter lead-in character, else 0:"
	?"    Example: if lead-in character=escape, enter 1B"
	?"    [00]"
	B.Getnum()->LEADIN
	?"In the following, give code for the function plus set high bit (bit 7)"
	?"if it needs a lead-in character:"
	?"    clear screen:  [0C]"
	B.Getnum()->CLRSCR
	?"    clear line:  [0B]"
	B.Getnum()->CLRLIN
	?"    insert line (enter 0 if don't have):  [00]"
	B.Getnum()->INSLIN
	?"    position cursor:  [17]"
	B.Getnum()->POSCRS
	?"    enter offset for X & Y positioning characters plus set high bit"
	?"    if order is to be XY (column first, then row) rather than YX"
	?"    (row first, then column):"
	?"    Example: 'A0' means if the 2 chars. sent are '20' then '21', the"
	?"	       column will be set to 0 & the row will be set to 1"
	?"    [A0]"
	B.Getnum()->POSOFF
EC2:
    ?
    ?"Do you want to change any key functions? (enter Y or N)"
    printf("    "); getchar(); putchar(); ?
    if RL3&0DF<>'Y' then JP EC3
	SETB FLAG,1
	KEYVECP->R3; R7:=^CRSLT; R1:=LKEYVEC; LDIRB @R7,@R3,R1
	?"The following cursor movement keys (as well as the DELete key used"
	?"in INSERT or REPLACE modes) may be changed:"
	?"    '4' (cursor left)"
	?"    '6' (cursor right)"
	?"    '8' (cursor up)"
	?"    '2' (cursor down)"
	?"    '7' (cursor to top left corner)"
	?"    '1' (cursor to bottom left corner)"
	?"    tab (cursor tab)"
	?"    '_' (cursor back-tab)"
	?
	?"In the following, enter the ascii value in hex of the key you want"
	?"to change to or 0 if no change is desired; end with <RETURN>:"
	?"(the standard value for each case is shown in square brackets)"
	?
	?"(Avoid changing to keys that have other functions; also note that"
	?"with cursor movement keys, small letters (or any ascii values>=060)"
	?"are equivalent to capital)"
	?"    '4' (cursor left)  [34] ->"
	if B.Getnum2()<>0 then RL3->CRSLT
	?"    '6' (cursor right)  [36] ->"
	if B.Getnum2()<>0 then RL3->CRSRT
	?"    '8' (cursor up)  [38] ->"
	if B.Getnum2()<>0 then RL3->CRSUP
	?"    '2' (cursor down)  [32] ->"
	if B.Getnum2()<>0 then RL3->CRSDN
	?"    '7' (cursor to top left corner)  [37] ->"
	if B.Getnum2()<>0 then RL3->CRSHM
	?"    '1' (cursor to bottom left corner)  [31] ->"
	if B.Getnum2()<>0 then RL3->CRSBTL
	?"    tab (cursor tab)  [09] ->"
	if B.Getnum2()<>0 then RL3->CRSTAB
	?"    '_' (cursor back-tab)  [5F] ->"
	if B.Getnum2()<>0 then RL3->CRSBTB
	?"    DEL (delete in INSERT/REPLACE mode)  [7F] ->"
	if B.Getnum()&07F<>0 then RL3->RUBOUT
EC3:
    if FLAG=0 then JP EC4
	?"Do you want to write out new EE with changes? (enter Y or N)"
	?" (for now, writes out to EEE (rename to EE))"
        printf("    "); getchar(); putchar(); ?
	if RL3&0DF='Y' then begin
	  if BITB FLAG,0 not zero then begin
	    R7:=SCRVECP; R3:=^POSOFF; R1:=LSCRVEC; LDIRB @R7,@R3,R1
	  end
	  if BITB FLAG,1 not zero then begin
	    R7:=KEYVECP; R3:=^CRSLT; R1:=LKEYVEC; LDIRB @R7,@R3,R1
	  end
	  SAVE("EEE")
	end
EC4:
    RET

END:

BUFF:	DEFS 02000
	DEFS 0100
MYSP:

/MAP UNDEF
/WRITE "Type in:"
/WRITE "/IMAGE EECONFIG ",BEG," ",END," E=",START


 configure EE screen editor (Z8000) for different terminals

FNFERR:	EQU 0C7  ...error code for file not found
HDRS