...system dependent part of E

LU0:	EQU 0  ...logical units
LU1:	EQU 1
RECLN:	EQU 080	 ...record length for command file

NEW_NAME: DEFS 15  ...name given with input line
SAVCHBF: DEFS 3  ...used by PUTEOFSQ,RESEOFCH


PUT1:	PROC  ...put out 1 char. to console
	...save all regs. incl. flag
	PUSH AF
	PutC(R.A)
	if R.A=CR then PutC(LF)
	POP AF
	RET

GET1IF:	PROC  ...get 1 char. from console->R.A if ready
	...save other regs.
	B.GetC() ...->B.LASTCHAR;
	RET

GETCHR1: PROC
	repeat GETCHR() until R.A<>CPMEOF; RET


EDIT1:	00; LD (INPTR),A  ...so will ask for filename
EDIT0:	PROC
	LD SP,MYSP  ...allocate stack
	if B.EFLG<>0 then JP EDIT2
	LD HL,(CPM+1); LD L,0; R.HL->ENDBUF  ...set ENDBUF
	CRTTYP();
	^INPTR->R.HL
	LD C,(HL); LD B,0  ...len.
	R.HL+1->R.DE
	0D->@(R.HL+R.BC)  ...make sure CR at end of input in sys cmd buff

	SPC(); R.A=CR
	CALL Z,NAMEQ  ...if filename not given, ask for it
	@DE=CR; JP Z,SYSRET  ...if still no name, ret.

	SAVE_NAME()	...SAVE INPUT NAME

	CKPARM();  ...check param. after name
	@^CMDSW=0; CALL NZ,CFINIT  ...if using cmd. file, open it, set ptrs.

	READIT(); R.HL->R.BC;

	EBUF->R.HL
	FNDEOF()  ...get HL=^'FF'/'1A' or after last char of file
	R.HL->ENDDAT
	FIXEOF()  ...make certain 'FF' at EOF; CR before; + put CR before beg.
	  ...if were doing, open & write out .OLD file here
	if TSTASC() not then begin PRT0(^NOTASC); JP CCFRET end
	  ...make sure file ascii
	1->B.EFLG;
EDIT2:	repeat
	    EDIT()  ...go edit
	    CLSCMF()  ...close cmd. file if one
	    POSCRS(00;LD B,LROW-1);ERASL(); ...clear second to last line
	    B.DUNFLG-1; JP NZ,SYSRET  ...if DUNFLG=2, don't write out file
	until WRITIT();
	JP SYSRET  ...write out edited file

CKPARM:	...check if parameters after space after filename: "N"=no .OLD file;
	..."RL=hh" means create new file (hh is record length)
	...if "filename,filename" ?<Param>, 2nd filename is cmd. file
	P.FNDSPC; RET NZ  ...look for sp. or ","
	R.A=','; INC DE; CALL Z,TSTFN2  ...","=>cmd filename should follow
	LD A,0; if zero then INC A
	R.A->B.CMDSW  ...set CMDSW if cmd file name was given
	RET

CLOS10:	PROC
	CloseF(LD B,LU0);
	RET

CLFRET:	  CLOS10();  ...close file
CCFRET:	  CLSCMF();JP SYSRET  ...if cmd file, close it

TSTASC:	...test if file ascii (chk 1st 100 bytes)
	EBUF->R.HL; LD B,100
	repeat
	  @HL=CPMEOF; RET Z
	  R.A=EOF; RET Z
	  BIT 7,A; RET NZ
	  R.HL+1
	until DEC B zero;
	00; RET

SAVE_NAME: PROC
	PUSH DE
	R.DE->R.HL
	FNDSPC()
	if R.E-R.L>=15 then 14
	if not zero then begin
	  R.A->R.C; LD B,0; LD DE,NEW_NAME; LDIR
	end
	00->@DE
	POP DE; RET

PRTNAM:	PROC  ...Prints name
	PRT0(^NEW_NAME); RET
...	^NEW_NAME; LD B,(HL); INC B;
...	while DEC B not and @(R.HL+1)<>0D and R.A<>' ' do PUT1(R.A)
...	RET

READIT:	PROC  ...read in file; ret. HL=len read
	LD HL,NEW_NAME
	if OpenF(LD B,LU0) not then begin
	    if R.A=FNF_ERR then begin W.0;RET end
	    else begin ERROR();JP CCFRET end
	end
	...CDE=file len.
	R.C->R.A
	LD BC,(EBUF)
	if R.A<>0 or ENDBUF-R.BC<R.DE then begin  ...chk if fits in buffer
	  PRT0(^TOOBIG); JP CLFRET
	end
	EX DE,HL  ...HL=len.
	LD D,B; LD E,C ...PUSH BC; POP IX  ...IX=beg. buffer
	ReadF(LD B,LU0) ...; LD C,0FF)
	if not zero then begin
	  ERROR(); JP CLFRET;
	end
	PUSH HL;	...save length read
	CloseF(LD B,LU0)
	POP HL;
	RET

...READIT:	PROC
...	LD HL,NEW_NAME
...	if OpenF(LD B,LU0) not then begin
...	    if R.A=FNF_ERR then begin W.0;RET end
...	    else begin ERROR();JP CCFRET end
...	end
...	...CDE=file len.
...	R.C->R.A
...	LD BC,(EBUF); ENDBUF-R.BC->R.HL  ...HL=len. of buffer
...	if R.A<>0 or R.HL-R.BC<R.DE then begin
...	  PRT0(^TOOBIG); JP CLFRET
...	end
...	EX DE,HL  ...HL=len.
...	PUSH BC; POP IX  ...IX=beg. buffer
...	ReadF(LD B,LU0; LD C,0FF)
...	if not zero then begin
...	  ERROR(); JP CLFRET;
...	end
...	PUSH HL;	...save length read
...	CloseF(LD B,LU0);
...	POP HL;
...	RET

NAMEND:	PROC  ...00 at end of DEFT @HL
	...preserve DE
	PUSH AF; PUSH HL;
	@HL+1->R.A; R.HL+R.A; 00->@HL
	POP HL; POP AF;
	RET

FNDEOF:	...enter with HL=^text, BC=len to look
	...ret. HL=^'FF'/'1A' or after last char
	R.B|R.C; RET Z
	PUSH BC; PUSH HL
	EOF->R.A; CPIR; if zero then R.HL-1
	EX DE,HL
	POP HL; POP BC
	CPMEOF->R.A; CPIR; if zero then R.HL-1
	if R.HL>=R.DE then EX DE,HL
	RET

GETFIL:	...get a file (name at STRBUF+2) & insert above current line
	...enter with DE at beg. of line; ret. Z=1 iff all ok
	PUSH DE;
	  ...deft name actually now @STRBUF
	  NAMEND(^STRBUF);
	  LD HL,STRBUF+1
	  if OpenF(LD B,LU0) not then begin
	      FILERR(R.A); POP DE; RET
	  end
	  if R.C<>0 then LD DE,0FF80  ...fake it if file > 64K
	  LD C,E; LD B,D
	POP DE; PUSH BC
	if begin SHFIFR(); POP BC end not zero then begin
	  CLOS10(); OR 1; RET
	end
	...shift file fwd.
	EX DE,HL  ...DE=beg. pos. for new part
	if begin PUSH DE; B.ReadF(R.BC->R.HL; LD B,LU0); POP DE; PUSH AF end
	not zero then begin
	  FILERR(R.A); W.0->R.HL ...CLOS10(); RET  ...if error
	end
	PUSH HL  ...am't read
...		...below moved to ED22:
...	  LD (BUFPOS),DE; 00->B.CRSCOL  ...for printing (beg. of read-in text)
...	  B.ROWNO->B.CRSROW  ...adjust cursor row
	PUSH DE
	CLOS10();
	POP DE
	POP BC;
	R.DE+R.BC->R.HL; PUSH HL  ...BC=len., HL=1st pos. past new part
	FNDEOF(EX DE,HL); EX DE,HL  ...DE=after last valid data of file
	POP HL; PUSH HL
	R.HL-R.DE->R.BC  ...no. of extra bytes read in
	POP DE
	SHFTBK()  ...shift back file over excess
	FIXEOF()
	POP AF; RET

PUTFIL:	...write to file (deft name at STRBUF) from HL to DE; Z=0 iff fail
	EX DE,HL  ...DE=addr, HL=end
	PUSH HL
	NAMEND(^STRBUF)  ...preserves DE
	POP BC
	WRTFIL(LD HL,STRBUF+1)
	CALL NZ,FILERR
	RET

WRTFIL:	...enter with HL=addr of name, DE=addr to write from, BC=end
	...ret. Z=0, A=code if err
	PUSH BC; PUSH DE
	CreateF(R.HL; LD B,LU0)
	POP DE; POP HL
	RET NZ
	PUSH HL; PUSH DE  ...DE=addr, HL=end
	PUTEOFSQ(R.HL)  ...put eof seq., move HL past
	POP DE  ...addr
	R.HL-R.DE->R.HL  ...len
	WriteF(LD B,LU0; R.HL);
	POP HL  ...orig end
	PUSH AF; RESEOFCH(R.HL); CLOS10(); POP AF;
	RET

PUTEOFSQ: ...enter HL=^place to put eof seq.
	...save orig. chars., put seq., ret. HL past
	PUSH HL
	LD DE,SAVCHBF; LD BC,3; LDIR
	POP HL
	LD (HL),CPMEOF; R.HL+1
	if CKINBUF() <zero then begin
	  LD (HL),CR; R.HL+1
	  LD (HL),EOF; R.HL+1
	end
	RET

CKINBUF: ...test HL==ENDBUF-1
	LD BC,(ENDBUF); DEC BC
	R.HL=R.BC; RET

RESEOFCH: ...restore @HL chars saved in SAVCHBUF
	LD DE,SAVCHBF
	@DE->@HL; INC DE; INC HL
	if CKINBUF() <zero then begin
	  EX DE,HL; LDI; LDI
	end
	RET

WRITIT: PROC
	WRTFIL(^NEW_NAME; LD DE,(EBUF); LD BC,(ENDDAT))
	RET Z
	PUSH AF; ERROR(); PRT0(^ENDERR); GET1(); POP AF;
	RET

ENDERR:	DEFM '  HIT KEY TO REENTER:'; BYTE 00

CFINIT:	...init. for using cmd. file; enter with HL pointing to CMDSW
	PUSH HL;
	  NAMEND(^STRBUF);
	  LD HL,STRBUF+1
	  if OpenF(LD B,LU1) not then begin
	      POP HL; DEC (HL); ERROR(R.A); RET
	  end
	  LD DE,RECLN;
	  W.ENDBUF->W.SVENDB->W.CMFPOS-R.DE->W.ENDBUF
	  ...allocate sp. at top of edit buff. for cmd file buffer
	POP HL;
	RET

TXTQUN:	DEFB ESC ESC; DEFM 'QU N'; DEFB CR

GETCMF:	PROC
	PUSH HL; PUSH DE; PUSH BC  ...get char. from cmd. file->R.A
	LD DE,(SVENDB)
	if W.CMFPOS=R.DE then begin
	    W.ENDBUF->W.CMFPOS  ...if to end of buffer, reset CMFPOS
	    EX DE,HL  ...->DE
	    ^RECLN->R.HL;
	    if ReadF(LD B,LU1) not zero then begin  ...read in 1 record
FINCMF:		ENDBUF->CMFPOS; EX DE,HL; ^TXTQUN; LD BC,7; LDIR
	    end  ...put in "QU N" if error
	    W.CMFPOS->R.HL;
	end
	@HL=CPMEOF; JR Z,FINCMF; BIT 7,A; JR NZ,FINCMF
	RES 7,A; R.HL+1->W.CMFPOS  ...char.->R.A; inc. cmd file pos.
	POP BC; POP DE; POP HL; RET

CLSCMF:	@^CMDSW-1; RET NZ  ...chk if were doing cmd. file
	R.A->@HL; W.SVENDB->W.ENDBUF  ...restore CMDSW, ENDBUF
	CloseF(LD B,LU1);
	RET

ERRD2:	PROC
...	R.C=0D2; CALL Z,CLSFIL  ...close file if error was for invalid attr.
	RET

>@HL; W.SVENDB->W.ENDBUF  ...restore CMDSW