...Z80 system
...changed 11/26: RETFLG stuff, DOCMD0
...last change 10/15/82

NLU:	EQU 16  ...no. of logical units
BASCNTMSK: EQU 07F  ...default for CNTMSK
MAXLUP:	EQU 04000

...system cmds.:
OPN:	EQU 0
CLS:	EQU 1
RD:	EQU 2
WRT:	EQU 3
RDAHD:	EQU 0A

...1st byte of bucket codes: FF=busy, 0=free, else as below:
...for Z80:
QUITCD:	EQU 081
IOCODE:	EQU 082
RDBKCD:	EQU 083
TIMERCD: EQU 084
CONWRCD: EQU 086
Z80CD:	EQU 087
ACKCD:	EQU 0C0
...for Z8000:
STARTCD: EQU 1
RDCODE:	EQU 2
WRCODE:	EQU 3
DUNCD:	EQU 4
RD2CD:	EQU 5
WR2CD:	EQU 6
BRKCD:	EQU 7
CONINCD: EQU 9
WRSCRCD: EQU 0B  ...not used here
PERINTCD: EQU 0C


...*****************
	ORG RAM

LUFLAGS: BYTE 0[NLU]  ...set corres. byte=1 when LU active
REQFLG:	BYTE 0  ...set=1 if Z80 requesting bucket but must empty first
RETFLG:	BYTE 0
BRKFLG:	BYTE 0  ...set when ctrl-C input; break Z8000
CNTMSK:	BYTE BASCNTMSK
NXTIN:	WORD KBUF  ...^ next char. into keybd buffer (initialize)
NXTOUT:	WORD KBUF  ...ditto next char. out
COUNT:	BYTE 0[5]
...above gets init'd^

KBUF:	DEFS 32
KBUFEND:
WRCONBUF: DEFS 0100

LCMDBUF0: EQU 10  ...only has to hold "I X"CR, otherwise make 144
CMDBUF0: DEFS LCMDBUF0

LFNMBUF: EQU 40
FNMBUF:	DEFS LFNMBUF
...read buffers
BUFF1:	EQU BUFBEG
BUFF2:	EQU BUFBEG+RDBLKSZ
...
...BUFF vector offsets:
BUFFVSZ: EQU 8
BUFFLEN: EQU 0
BUFFDST: EQU 2
BUFFFPOS: EQU 5
...
BUFF1VC: DEFS BUFFVSZ
BUFF2VC: DEFS BUFFVSZ

CURBUF:	WORD 0  ...stores addr of last read buffer allocated
XFBUF:	WORD 0  ...if<>0, pts. to buffer to be xferred by XFDTA0
FILPOS:	WORD 0  ...current file pos.
FILPOSH: BYTE 0  ...high byte of above
ENDFPOS: WORD 0  ...stores end fpos for read req.
ENDFPOSH: BYTE 0  ...high byte of above

LU0:	BYTE 0
CMD0:	BYTE 0
XFADR0:	WORD 0
XFADR0H: BYTE 0
XFLEN0: WORD 0
FNM_POS: WORD 0
POS_H: BYTE 0
FNM_H:	BYTE 0
BUFHDR: WORD 0
OPNTYP: BYTE 0
CC0:	BYTE 0
STATUS: BYTE 0

RAM:	DEFL $

...*****************
	ORG ROM

MAIN:	PROC
	INIT(); RET NZ  ...init. ram & start up Z8000 (NZ=>Z8000 not ready)
	repeat
	  CKSTUF()
	  if STATUS<>0 then begin
	      case CMD0&7 of
		RD: READ()  ...also RDAHD
		WRT: RITE()
		OPN: OPEN()
		CLS: CLOSE()
	      end
	  end
	until RETFLG<>0;
	CLSFILS()  ...not really needed
	RETFLG->R.A=0FF; JP Z,DOCMD0  ...go do Z80 cmd
	if R.A=2 then CACHEOFF()
	RET  ...ret. to Z80 system

CKSTUF:	...may be called from system specific routines
	CONIN(); CKCHAR()
	if TSTBUK() then begin
	  GETCMD()  ...if cmd for Z80, get it
	  UPCOUNT()
	end else INCCOUNT()
	CKPERINT()
	RET

UPCOUNT: ...round up COUNT to next mult. of 0100
	00->@^COUNT; R.HL+1
	repeat INC (HL); INC HL until not zero;
	RET

INCCOUNT: ...COUNT:+1
	^COUNT->R.HL
	repeat INC (HL); INC HL until not zero;
	RET

CKINPRM: ...put 0 in bucket & release; chk if Z8000 rets. 3 which means in prom
	...leave bucket released with 0 in
	GETBUK(); RELBUK0()
	W.1000->R.HL
	repeat B.GETBUK()->R.B; RELBUK0(); R.B=3; RET Z until R.HL-1=0;
	OR 1; RET

WAITACK: ...wait for ACKCD from Z8000; ret Z=0 if timeout
	LD HL,MAXLUP
	repeat TSTBUK(); JR Z,WTA2 until R.HL-1=0;
	0FF->R.A
WTA2:	R.A->R.B
	RELBUK0()
	R.B=ACKCD; RET

NOTRDY:	DEFM 'Z8000 SYS NOT READY'; BYTE 0D 0A 0

INIT:	...init. necessary stuff in ram & elapsed timer
	...chk if Z8000 rdy: if in prom, print msg & ret NZ
	...start up Z8000; if no ack, print msg & ret NZ
	00->R.A->STATUS  ...mark file i-o variables free
	R.A->REQFLG->RETFLG->BRKFLG ...->TIMESW->RQTIMFLG->WRCONFLG
	^LUFLAGS->R.HL; LD B,NLU
	repeat R.A->@HL; INC HL until DEC B zero;  ...mark all LU's inactive
	^KBUF->NXTIN->NXTOUT
	BASCNTMSK->CNTMSK
	^COUNT->R.HL; 00->R.A; LD B,5
	repeat R.A->@HL; INC HL until DEC B zero;
	RELBUK()
	CKINPRM(); JR Z,PRMSG  ...chk if Z8000 in prom
	GETBUK(); PUT1B(STARTCD); SNDBUK()  ...start up Z8000
	WAITACK(); JR NZ,PRMSG  ...wait for ack
	CP A; RET
PRMSG:	PUTSTR0(^NOTRDY)
	OR 1; RET

GETCMD0: ...enter with bucket, 1st byte in R.A
	...get cmd, saving all regs. and keeping bucket
	PUSH AF; PUSH BC; PUSH DE; PUSH HL; PUSH IY; PUSH IX
	^REQFLG; LD (HL),1
	GETCMD(); GETBUK()
	00->REQFLG
	POP IX; POP IY; POP HL; POP DE; POP BC; POP AF; RET

GETCMD:	...routine to get cmds. from Z8000; enter with bucket, R.A=1st byte
	R.A->R.C
	if REQFLG=0 then PUTZ()
	else IN A,(DATA)  ...leave in Z80 cmd so Z8000 won't take
	R.C->R.A
	if R.A=CONWRCD then begin PUTCONI(); RET end
	if R.A<>IOCODE then begin
	  if R.A=Z80CD then Z80CMD()
	  else if R.A=QUITCD then begin
	    IN A,(DATA)
	    if R.A<>0 then 1 else 2  ...A=0 =>turn off cache (if ZOOM)
	    R.A->RETFLG  ...ret. to Z80 system
	  end else if R.A=TIMERCD then begin IN A,(DATA); TIMER() end
	  JR GETCMDX
	end
	...disk cmd. follows:
	...passed in bucket:
	... iocode,LU,cmd,xfadr[4,otyp=2nd],xflen[2],fnam/fpos[4],bufhdr_id
	REQVAR()  ...get use of disk i-o variables
	LD C,DATA
	IN A,(DATA); R.A->LU0
	IN A,(DATA); R.A->CMD0
	IN A,(DATA); R.A->XFADR0H
	IN A,(DATA); R.A->OPNTYP
	IN H,(C); IN L,(C); R.HL->XFADR0
	IN H,(C); IN L,(C); R.HL->XFLEN0
	IN A,(DATA); R.A->FNM_H  ...seg. with filename (if open)
	IN A,(DATA); R.A->POS_H
	IN H,(C); IN L,(C); R.HL->FNM_POS
	  ...addr of filename if open or file pos. if random access R/W
	IN H,(C); IN L,(C); R.HL->BUFHDR
GETCMDX: RELBUK()  ...may be gotten if called by GETCMD0
	RET

TIMER:	...if R.A=0, restore timer to default interval; if R.A=n=1 to 5, set
	... interval to (base=default)*(2**n-1)
	if R.A=0 then R.A+1
	if R.A>=6 then 5->R.A
	R.A->R.B; BASCNTMSK->R.A
	while DEC B not zero do R.A/2
	R.A->CNTMSK
	RET

PUTSTR0: ...enter with HL=^string to put to console (ends with 0)
	@HL=0; RET Z; PutC(R.A); R.HL+1; JR PUTSTR0

Z80CMD:	...enter with bucket containing chars of cmd string ending with CR
	... for poss. Z80 execution
	...load into CMDBUF0, set RETFLG=0FF
	...release bucket
	LD DE,CMDBUF0; LD B,LCMDBUF0-1
	repeat
	  IN A,(DATA)
	  R.A=0D; JR Z,ZC1; ...R.A=';'; JR Z,ZC1
	  R.A->@DE; INC DE
	until DEC B zero;
ZC1:	RELBUK()
	0D->@DE
	0FF->RETFLG; RET

CANTDO:	DEFM "CAN'T DO CMD"; BYTE 0D 0A 0

DOCMD0:	...enter with cmd string for Z80 in CMDBUF0
	...if cmd="I", do disk init'n
	...else goto DOCMD to do cmd if can & JP MAIN when done
	... (if can't, put CAN'T DO msg)
...	if @^CMDBUF0&0DF='I' and @(R.HL+1)=0D or R.A=' ' then DSKINIT()
...	else begin
	  if DOZ80CMD(^CMDBUF0) not then PUTSTR0(^CANTDO)
...	end
	JP MAIN
	

OPEN:	...open file; enter with LU0=LU
	GETFNM()->R.HL
	LU0->R.B
	if OPNTYP=0 then OpenF_() else CreateF_()
	R.A->CC0
	LD (FNM_POS),DE; R.C->POS_H  ...file len to send to Z8000
	if zero then ACTLU()
	DUN(); RET

GETFNM:	...using FNM_POS & FNM_H, get filename from Z8000->FNMBUF & convert
	... to form name+0; ret. HL=^name
	FNM_POS->R.HL; FNM_H->R.A
	LD DE,FNMBUF; LD BC,LFNMBUF-1
	PUSH DE
	GET()  ...get deft fname from Z8000 to FNMBUF
	POP HL
	LD A,LFNMBUF-2
	if R.A>=@HL then @HL->R.A
	R.A->R.C; LD B,0
	00->@(R.HL+1+R.BC)  ...put 0 after name
	LD HL,FNMBUF+1
	RET

READ:	...read file
	GETFPS()  ...requested fpos (where want to read)->AHL
	PUSH AF; PUSH HL
	LD DE,(XFLEN0); LD C,0
	ADD3(); R.HL->ENDFPOS; R.A->ENDFPOSH
	POP DE; POP AF; R.A->R.C; LU0->R.B; 00->R.A
	Seek_()  ...correct zfpos if necessary (CDE=req. fpos)
	if not zero then begin R.A->CC0; JR READX end
	REQBUFR_I()  ...init for REQBUFR
	W.0->XFBUF
	repeat
	  REQBUFR()  ...rets. BC=len for read, HL=addr
	  PUSH BC
	  EX DE,HL; R.BC->R.HL; LU0->R.B
	  ReadF_()  ...read file, ret. R.A=CC, Z=0=>err
	  R.A->CC0 ...@IY(CC)
	  if not zero then begin POP BC; JR READX end
	  if DELXFFLG=0 then XFDTA(CURBUF)
	  else CURBUF->XFBUF
	  POP BC; PUSH BC
	  ADJUST()  ...adjust xfaddr0,xflen0
	  POP HL; INCFPS()
	until XFLEN0=0;
	if DELXFFLG<>0 then XFDTA0()
READX:	DUN(); RET

XFDTA0:	...transfer buffer XFBUF (if<>0) to Z8000
	...may be called from READFL (when DELXFFLG=1)
	XFBUF->R.HL=0; RET Z
	...
XFDTA:	...xfer data from buffer pointed to by R.HL to Z8000
	...if RDAHD, send partdun msg.; preserve IY,IX
	PUSH IX
	LD IX,BUFF1VC; LD BC,BUFF2
	if R.HL=R.BC then LD IX,BUFF2VC
	LD C,(IX+BUFFLEN); LD B,(IX+BUFFLEN+1)
	LD E,(IX+BUFFDST); LD D,(IX+BUFFDST+1); @IX(BUFFDST+2)->R.A
	PUSH BC
	PUT()
	POP DE; LD C,0  ...bufflen
	@2IX(BUFFFPOS)->R.HL; @IX(BUFFFPOS+2)->R.A
	ADD3()  ...get end fpos for buff
	R.A->R.B
	LD DE,(ENDFPOS); ENDFPOSH->R.C
	R.B->R.A
	if CP3() <zero then PARTDUN()
	POP IX; RET

RITE:	...write file
	GETFPS()  ...file pos. requested->AHL
	EX DE,HL; R.A->R.C; LU0->R.B; 00->R.A
	Seek_()  ...correct zfpos if necessary (CDE=req. fpos)
	if not zero then begin R.A->CC0; JR RITEX end
	repeat
	  REQBUFW()  ...rets BC=xflen, HL=xfadr, sets xflen,xfadr
	  PUSH BC; PUSH HL
	  EX DE,HL; R.BC->R.HL; LU0->R.B
	  WriteF0() ...WRITEFL0()
	  POP DE; POP BC
	  if not zero then begin R.A->CC0; JR RITEX end
	  PUSH DE; PUSH BC
	  XFADR0H->R.A; XFADR0->R.HL
	  GET()
	  POP BC; PUSH BC
	  ADJUST()
	  POP BC; POP HL
	  EX DE,HL; R.BC->R.HL; LU0->R.B
	  WriteF_() ...WRITEFL()
	  R.A->CC0; JR NZ,RITEX
	until XFLEN0=0;
RITEX:	DUN(); RET

CLOSE:	...close file
	CloseF_(LU0->R.B)
	R.A->CC0 ...@IY(CC)
	RELLU()
	DUN(); RET

PUTCONI: ...enter with bucket containing len. (0=256) + chars. to put to cons.
	...put out, rel. bucket, ...set WRCONFLG
	IN A,(DATA); R.A->R.B  ...len.
	PUSH BC
	^WRCONBUF->R.HL->R.DE; LD C,DATA
	BYTE 0ED 0B2  ...INIR
	RELBUK()
	POP BC
	repeat PutC(@DE); INC DE; CONIN() until DEC B zero;
	RET

GETFPS:	...get requested fpos->FILPOS->AHL
	FNM_POS->R.HL; POS_H->R.A
	R.HL->FILPOS; R.A->FILPOSH
	RET

REQBUFW: ...req. buffer for writing
	...ret. HL=addr, BC=len=min(xflen0,buff_size)
	LD BC,BUFEND-BUFBEG
	if XFLEN0<R.BC then R.HL->R.BC
	^BUFBEG->R.HL
	RET

REQBUFR_I: ...init for REQBUFR
	W.0->CURBUF; RET

REQBUFR: ...req. buffer<>CURBUF for reading
	...ret. HL=addr, BC=len=min(xflen0,RDBLKSZ)
	...store CURBUF, BUFFLEN, BUFFDST (from XFADR0), BUFFFPOS (from FILPOS)
	PUSH IX
	LD BC,RDBLKSZ
	if XFLEN0<R.BC then R.HL->R.BC
	LD DE,(CURBUF)
	^BUFF1->R.HL; LD IX,BUFF1VC
	if R.HL=R.DE then begin ^BUFF2->R.HL; LD IX,BUFF2VC end
	R.HL->CURBUF ...->@2IY(XFADR)
	PUSH HL
	LD (IX+BUFFLEN),C; LD (IX+BUFFLEN+1),B
	XFADR0->R.HL; XFADR0H->R.A
	R.HL->@2IX(BUFFDST); R.A->@IX(BUFFDST+2)
	FILPOS->@2IX(BUFFFPOS); FILPOSH->@IX(BUFFFPOS+2)
	POP HL
	POP IX; RET

REQVAR:	...mark file i-o variables in use
	if @^STATUS<>0 then stop
	LD (HL),1; RET

RELVAR:	...mark file i-o variables free
	00->STATUS; RET

DUN:	...enter with IY at vector
	REQBUK()
	DUNCD; OUT (DATA),A  ...sending completion msg.
	LU0; OUT (DATA),A
	CMD0; OUT (DATA),A
	BUFHDR->R.HL; R.H->R.A; OUT (DATA),A; R.L->R.A; OUT (DATA),A
	CC0; OUT (DATA),A
	if CMD0=OPN then begin
	  POS_H; OUT (DATA),A  ...file length
	  FNM_POS->R.HL; R.H->R.A; OUT (DATA),A; R.L->R.A; OUT (DATA),A
	end else if R.A=RDAHD then begin
	  FILPOSH->R.A; OUT (DATA),A  ...file pos.
	  FILPOS->R.HL; R.H->R.A; OUT (DATA),A; R.L->R.A; OUT (DATA),A
	end
	SNDBUK()
	RELVAR()
	RET

PARTDUN: ...RDAHD sends back msg. saying how much done
	...call with AHL=filepos done, IY @VEC
	R.A->R.B
	CMD0=RDAHD; RET NZ
	REQBUK()
	DUNCD; OUT (DATA),A
	LU0; OUT (DATA),A
	CMD0; OUT (DATA),A
	LD C,DATA
	LD DE,(BUFHDR); OUT (C),D; OUT (C),E
	00; OUT (DATA),A  ...0 because not comp.
	OUT (C),B; OUT (C),H; OUT (C),L  ...fposdun
	SNDBUK(); RET

INCFPS:	...enter IX at LUvec, HL=#bytes to inc. fpos: FPOS+HL->FPOS->AHL
	LD DE,(FILPOS); FILPOSH->R.C
	ADD3(R.HL;00)
	R.HL->FILPOS; R.A->FILPOSH
	RET

ADD3:	...AHL+CDE->AHL
	R.HL+R.DE; R.A+carry+R.C; RET

CP3:	...AHL==CDE
	R.A=R.C; RET NZ; R.HL=R.DE; RET

ADJUST:	...XFADR0+BC->XFADR0; XFLEN0-BC->XFLEN0
	XFADR0+R.BC->XFADR0
	XFLEN0-R.BC->XFLEN0
	RET

ACTLU:	...mark LU LU0 active
	LU0->R.C; LD B,0; ^LUFLAGS+R.BC->R.HL; LD (HL),1
	RET

RELLU:	...mark LU LU0 inactive
	LU0->R.C; LD B,0; ^LUFLAGS+R.BC->R.HL; LD (HL),0
	RET

CLSFILS: ...close all open files
	00->R.A
	repeat
	  PUSH AF
	  R.A->R.C; LD B,0
	  ^LUFLAGS+R.BC->R.HL
	  if 00<>@HL then begin R.A->@HL; CloseF_(LD B,C) end
	  POP AF
	until R.A+1>=NLU;
	RET

GET:	...move BC bytes from @AHL on Z8000 to @DE on Z80
	PUSH AF
	if R.B|R.C zero then begin POP AF; RET end
	REQBUK()
	PUT1B(RDCODE)
	POP AF
	PUTADL()  ...put Z8000 addr & len into bucket
	SNDBUK()
	R.BC->R.HL
	while begin LD BC,BUCKL-1; R.HL-R.BC end >zero do begin
	  repeat TSTBUK() until zero; PUT1B(RD2CD)
	  RDBUK(); SNDBUK()
	  CONIN()
	end
	R.HL+R.BC->R.BC
	repeat TSTBUK() until zero; PUTZ()
	RDBUK(); RELBUK()
	RET

RDBUK:	...read BC bytes from bucket to @DE+; save HL, inc DE
	EX DE,HL; if begin R.C=0; R.B end<>zero then R.A+1; LD B,C; LD C,DATA
	repeat BYTE 0ED 0B2 until DEC A zero;  ...EDB2=INIR
	EX DE,HL; RET

PUTADL:	OUT (DATA),A; R.H; OUT (DATA),A; R.L; OUT (DATA),A
	R.B; OUT (DATA),A; R.C; OUT (DATA),A; RET

PUT:	...move BC bytes from @HL on Z80 to @ADE on Z8000
	PUSH AF
	if R.B|R.C zero then begin POP AF; RET end
	REQBUK()
	PUT1B(WRCODE)
	POP AF; EX DE,HL
	PUTADL()  ...put Z8000 addr & len into bucket
	R.BC->R.HL; LD BC,BUCKL-6
	if begin R.HL-R.BC; PUSH AF end <zero then R.HL+R.BC->R.BC
	WRTBUK0()
	POP AF; RET C; RET Z
	CONIN()
	while begin LD BC,BUCKL-1; R.HL-R.BC end >zero do begin
	  WRTBUK(); CONIN()
	end
	R.HL+R.BC->R.BC
	...
WRTBUK:	REQBUK(); PUT1B(WR2CD)
	...
WRTBUK0: ...write BC bytes from @DE+ to bucket & send it; save HL, inc DE
	EX DE,HL; if begin R.C=0; R.B end<>zero then R.A+1; LD B,C; LD C,DATA
	repeat OTIR until DEC A zero;
	EX DE,HL; SNDBUK(); RET

INCKPTR: ...inc. HL=^ into circular keybd buffer; preserve R.A,BC,DE
	PUSH BC; LD BC,KBUFEND
	R.HL+1=R.BC; POP BC; RET C; ^KBUF; RET

CONIN:	...get char. from console to keybd buffer if one rdy (reset bit 7)
	...preserve BC,DE,HL
	GetC_(); RET Z
	PUSH HL
	R.A->@W.NXTIN
	W.INCKPTR()->NXTIN
	POP HL; RET

CKCHAR:	...send chars. in keybd buffer->Z8000; chk for cntl-C
	LD DE,(NXTIN)
	W.NXTOUT=R.DE; RET Z
	repeat
	  if begin @HL->R.B=3; CONINCD->R.A end then BRKCD->R.A
	  INTZ8T()
	until W.INCKPTR()=R.DE
	R.HL->NXTOUT; RET

CKPERINT: ...if COUNT up to count interval, int. Z8000
	B.COUNT&@^CNTMSK; RET NZ
	INTZ8T(PERINTCD)
	RET

INTZ8T:	...if conin or timer int., tell Z8000 (code in R.A, poss. char in R.B)
	...don't do if RETFLG<>0
	...preserve HL,DE
	R.A->R.C
	RETFLG=0; RET NZ
	REQBUK(); R.C->R.A
	PUT1B(); PUT1B(R.B)
	SNDBUK(); RET

REQBUK:	...request free bucket
	B.GETBUK()=0; RET Z
	if BIT 7,A zero then begin RELBUK(); JR REQBUK end
	  ...^if cmd for Z8000 in bucket, wait till emptied
	GETCMD0()  ...if cmd for Z80, get it into vector & keep bucket
	RET

TSTBUK:	...test if something for Z80 in bucket; if so, get buck., Z=1, R.A=code
	IN A,(CNTL)
	if R.A<>0FF then begin
	  IN A,(CNTL)
	  if BIT 7,A not zero and R.A<>0FF then begin CP A; RET end
	  RELBUK()
	end
	OR 1; RET

GETBUK:	...get bucket
	repeat IN A,(CNTL) until R.A<>0FF;
	repeat IN A,(CNTL) until R.A<>0FF;
	RET

RELBUK0: PUTZ()
RELBUK:	...release bucket without causing int. on Z8000
	1; OUT (CNTL),A; RET

SNDBUK:	...release bucket & cause int. on Z8000
	00; OUT (CNTL),A; RET

PUTZ:	00
PUT1B:	OUT (DATA),A; RET

ROM:	DEFL $


...release bucket & cause int. on 