...program to split big file into smaller ones (<=BUFLEN)
...	(splits at CR or double CR if can)
...	Usage: SPLIT FILENAME
...	Result: FILENAME.1, FILENAME.2, FILENAME.3, etc
...	(if FILENAME has .TYP, digit added at end or replaces last character if
...	 type is full 3 chars.)

S0:	PROC
	LD SP,MYSP; SPLIT(); JP SYSRET

	ORG S0+0100
MYSP:

/DO SYS.EQU
NLUS:	EQU 2  ...for ZDOS.S
/DO ZDOS.S

BUFLEN:	EQU 09000
OVFSIZ:	EQU 0400

IN_LU:	EQU 0
OUT_LU:	EQU 1

SAVCH:	BYTE 0
FILNM:	BYTE 0[15]
OFILNM:	BYTE 0[20]
ENDFILNM: WORD 0
BUFP0:	WORD 0
BUFP1:	WORD 0
BUFP2:	WORD 0
SIZE:	WORD 0

SPLIT:	PROC
	GETFILNM(); RET NZ
	if OpenF(LD B,IN_LU; ^FILNM) not then begin PRT0(^OPNERR); RET end
	^BUFF->BUFP1
LOOP:	...repeat
	  if ReadF(LD B,IN_LU; LD DE,BUFF; LD HL,BUFLEN)->SIZE not then begin
	    if R.A<>EOF_ERR then begin PRT0(^RDERR); RET end
	  end
	  LD BC,BUFLEN
	  if SIZE=R.BC then begin
	    LD DE,BUFFEND; LD BC,OVFSIZ
	    repeat DEC DE
	    until @DE=0D and begin DEC DE; @DE=0D; INC DE end
	      or begin DEC BC; R.B|R.C end zero;
	    if R.B|R.C zero then begin
	      LD DE,BUFFEND; LD BC,OVFSIZ
	      repeat DEC DE
	      until @DE=0D or begin DEC BC; R.B|R.C end zero;
	    end
	    if R.B|R.C zero then begin
	      LD DE,(BUFFEND); LD (BUFP0),DE; 0D->@DE; INC DE
	    end else begin
	      INC DE; LD (BUFP0),DE
	    end
	    @DE->SAVCH; CPMEOF->@DE; INC DE; LD (BUFP2),DE
	  end else begin LD BC,(SIZE); ^BUFF+R.BC->BUFP2 end
	  LD BC,(BUFP1)
	  if BUFP2-R.BC not zero then begin
	    LD DE,(ENDFILNM)
	    if @DE='9' then '@'
	    R.A+1->@DE
	    if CreateF(LD B,OUT_LU; ^OFILNM) not then begin
	      PRT0(^CREATERR); RET
	    end
	    LD BC,(BUFP1); BUFP2-R.BC->R.HL
	    if WriteF(LD B,OUT_LU; LD DE,(BUFP1); R.HL) not then begin
	      PRT0(^WRTERR); RET
	    end
	    CloseF(LD B,OUT_LU)
	    LD BC,BUFLEN
	    if SIZE=R.BC then begin
	      LD BC,(BUFP2); DEC BC; SAVCH->@BC
	      LD BC,BUFFEND
	      if BUFP0->R.DE<R.BC then begin
		^BUFFEND-R.DE->R.BC; ^BUFF-R.BC->R.HL->BUFP1
		EX DE,HL; LDIR  ...move part past CR to before BUFF
	      end else ^BUFF->BUFP1
	    end
	  end
...	until SIZE<BUFLEN
	LD BC,BUFLEN; SIZE=R.BC; JP Z,LOOP
	CloseF(LD B,IN_LU)
	RET


PRT0:	PROC
	while @HL<>0 do begin PutC(R.A); INC HL end
	RET

USGMSG:	DEFM 'Usage: SPLIT FILENAME'; BYTE 0D 0A 0
OPNERR:	DEFM 'OPEN ERROR'; BYTE 0D 0A 0
RDERR:	DEFM 'READ ERROR'; BYTE 0D 0A 0
CREATERR: DEFM 'CREATE ERROR'; BYTE 0D 0A 0
WRTERR:	DEFM 'WRITE ERROR'; BYTE 0D 0A 0

GETFILNM: PROC
	^INPTR->R.HL
	LD C,(HL); LD B,0  ...len.
	R.HL+1->R.DE
	0D->@(R.HL+R.BC)  ...make sure CR at end of input in sys cmd buff
	while @DE=' ' do INC DE
	if @DE=0D then begin PRT0(^USGMSG); OR 1; RET end
	SAVE_NAME()	...save input name
	SAVEONAME()	...save output name
	00; RET

SAVE_NAME: PROC
	PUSH DE
	R.DE->R.HL
	repeat INC DE until @DE=' ' or R.A=0D;
	if R.E-R.L>=15 then 14
	if not zero then begin
	  R.A->R.C; LD B,0; LD DE,FILNM; LDIR
	end
	00->@DE
	POP DE; RET

SAVEONAME: PROC
	^FILNM->R.HL; LD DE,OFILNM; LD BC,15; LDIR
	^OFILNM->R.HL->R.DE
	LD B,0; LD C,0FF
	repeat
	  if @DE='.' then LD C,B
	  INC DE; INC B
	until R.A=0;
	DEC DE
	if R.C<>0FF then begin
	  LD B,0; R.HL+R.BC->R.HL
	  if R.E-R.L>=4 then R.HL+2+1->R.DE
	end else begin '.'->@DE; INC DE end
	LD (ENDFILNM),DE
	'0'->@DE; INC DE; 00->@DE
	RET

S_END:

BUFOVF:	DEFS OVFSIZ
BUFF:	DEFS BUFLEN
BUFFEND: DEFS 2

	ORG S_END
/MAP 8
/?"/IMAGE SPLIT.COM ",^S0," ",^S_END

ET

S_END:

BUFOVF:	DEFS OVFSIZ
BUFF:	DEFS B