...11-2-82
...program to download Z8000 system

MAXLUP:	EQU 05000  ...max. times to loop before aborting

...load addrs. of "S"
S__BEG:	WORD S_BEG
S__SEG:	BYTE S_SEG
S__ENT:	WORD S_ENT
...load addrs. of "SCREEN"
SCR_BEG: WORD SCREEN_BEG
SCR_SEG: BYTE SCREEN_SEG

SAVSP:	WORD 0
PROGLEN: WORD 0

BUKGET:	PROC  ...wait for bucket of type R.A
	PUSH BC
	PUSH HL; LD HL,MAXLUP
	R.A->R.C
	repeat
	    1; repeat OUT (CNTL),A; IN A,(CNTL) until R.A<>0FF;
	    R.A->R.B; IN A,(CNTL)
	until R.A=R.C and R.A=R.B or R.HL-1=0;
	R.HL=0; JP Z,ABORT
	POP HL;POP BC
	RET

BUKLD:	PROC  ...to port C send message type H of:
		...DE bytes @IX to address IY in Segment L
	PUSH HL
	BUKGET(3)
	OUT (C),H  ...message type
	OUT (C),L  ...to segment number
	R.IY->R.HL; OUT (C),H; OUT (C),L  ...address
	R.HL+R.DE->R.IY
	OUT (C),D; OUT (C),E  ...byte count
	R.E->R.B=0; R.D
	if not zero then R.A+1;
	R.IX; repeat OTIR until DEC A; R.HL->R.IX
	POP HL; RET

MOD:	PROC
	PUSH DE; LD DE,0FFFF
	repeat INC DE until R.HL-R.BC<zero;
	R.HL+R.BC; LD C,E; LD B,D
	POP DE; RET

GOBUK:	BYTE 0
BOOT:	PROC   ...send BC bytes @HL to address DE in Segment A
	...start execution @IX
	PUSH HL;PUSH AF;
	 W.6+R.BC->R.BC ...add space for jump
	 if R.IX+1=0 then 2 else 1 ...0FFFF means load and don't execute
	 R.A->GOBUK
	POP AF;POP HL;
	PUSH HL; PUSH DE; PUSH BC; R.A|080->R.D
	...create JP to entry @IX
	 R.HL+R.BC; LD BC,6; R.HL-R.BC->R.HL
	 05E->@HL; INC HL; 8->@HL; INC HL; R.D->@HL; INC HL; 0->@HL; INC HL
	 PUSH IX; POP BC; R.B->@HL; INC HL; R.C->@HL; INC HL
	R.D; POP BC; POP DE; POP HL
	R.HL->R.IX; R.DE->R.IY; MOD(R.BC; LD BC,BUCKL-16)->R.HL
	R.A->R.B; INC C
	if R.HL=0 then begin
	    LD HL,BUCKL-16; if DEC C zero then begin POP IX; RET end
	end
	R.HL->R.DE
	R.B->R.L; R.C->R.B; DATA->R.C
	PUSH HL; LD HL,MAXLUP
	 repeat
	    0FD; OUT (C),A; OUT (CNTL),A
	    IN A,(CNTL)
	 until R.A<>0FF or R.HL-1=0;	...get bucket
	 JP Z,ABORT  ...HL=0
	POP HL
	00; OUT (C),A		...put in 0
	2->R.H
	while DEC B not do begin PUSH BC; BUKLD(); LD DE,BUCKL-16; POP BC end
	GOBUK->R.H; BUKLD()
	RELBUK()
	RET

ABTMSG:	DEFM 'SYS: Z8000 NOT READY FOR BOOT'; BYTE 0D 0A 0
ABORT:	PUTMSG(^ABTMSG); LD SP,(SAVSP); RET

PUTMSG:	PROC; repeat PUT1(@HL); INC HL until @HL=0; RET

PUT1:	...put R.A to console
	PutC(); RET

REQBUK:	PROC
	repeat IN A,(CNTL) until R.A<>0FF; IN A,(CNTL)
	R.A=0; RET Z
	RELBUK(); JR REQBUK

RELBUK:	PROC
	1; OUT (CNTL),A; RET

SS:	PROC
	LD (SAVSP),SP  ...in case abort
	GETPARM()
	LOAD(^"S"); RET NZ
	LD BC,(PROGLEN); LD DE,(S__BEG); LD A,(S__SEG); LD IX,0FFFF
	BOOT(^BUFF)
	if SCRFLG<>0 then begin
	  LOAD(^"SCREEN"); RET NZ
	end else begin W.089E->W.BUFF; W.2->PROGLEN end  ...Z8000 "RET"
	LD BC,(PROGLEN); LD DE,(SCR_BEG); LD A,(SCR_SEG); LD IX,(S__ENT)
	BOOT(^BUFF)  ...starts up "S"
	LD HL,(1); LD L,0  ...addr BIOS
	if 'Z'=@HL and R.A=@(R.HL+1) and R.A=@(R.HL+1) then begin
	  ...chk if have ZOOM BIOS
	  DELAY()  ...wait for Z8000 to get bucket & keep until init'd
	  R.HL-2
	  LD BC,ZOOM&0FF; R.HL+R.BC
	  PUSH HL
	  JPaHL(ZOOM_RDY)  ...notify ZIOS Z8000 system is loaded
	  POP HL
	  if SCRFLG<>0 then JPaHL(SCREEN_RDY)  ...notify SCREEN loaded
	end
	RET

JPaHL:	JP (HL)

DELAY:	...give Z8000 time; preserve HL
	PUSH HL; W.01000
	repeat until R.HL-1=0;
	POP HL; RET

GETPARM: ...get arg. (if any) from cmd line and poss. adjust SCRFLG
	^INPTR; LD C,(HL); LD B,0; R.HL+1->R.DE+R.BC; 00->@HL
	while @DE=' ' or R.A=9 do INC DE
	if @DE&0DF='S' then 1->SCRFLG
	else if R.A='N' then 00->SCRFLG
	RET

FILNAM:	DEFS 33

LOAD:	PROC  ...load file with deft name @HL; set length->PROGLEN; Z=0=>err
	LD DE,FILNAM; @HL->R.C; LD B,0; INC HL; LDIR; 00->@DE  ...move name
	if OpenF(^FILNAM; LD B,0) not then begin ERR(); RET end
	R.DE->PROGLEN->R.HL; LD DE,BUFF
	if ReadF(LD B,0) not then begin
	  PUSH AF; CloseF(LD B,0); POP AF; ERR(); RET
	end
	CloseF(LD B,0); RET

SNFMSG:	DEFM "'S' NOT FOUND"; BYTE 0D 0A 0
SCRNFMSG: DEFM "'SCREEN' NOT FOUND"; BYTE 0D 0A 0

ERRMSG:	DEFM 'ERROR '
ERRCD:	BYTE ' ' ' '
	BYTE 0D 0A 0

ERR:	PUSH AF
	if R.A=FNF_ERR then begin
	  LD A,(FILNAM+1)
	  ^SCRNFMSG
	  if R.A=0 then ^SNFMSG
	end else begin
	  PUSH AF; ^ERRCD
	  if R.A/2/2/2/2+'0'>'9' then R.A+7
	  R.A->@HL; INC HL
	  POP AF
	  if R.A&0F+'0'>'9' then R.A+7
	  R.A->@HL
	  ^ERRMSG
	end
	PUTMSG(R.HL)
	POP AF; RET


HL; INC HL
	  POP AF
	  if R.A&0F+'0'>'9' then R.A+7
	  R.A->@HL
	  ^ERRMSG
	end
	PUTMS