COMMENT *
	Applied MicroCircuits Corporation
	PCI diagnostic program Ver.2

	Program Title : AMCCDIAG.ASM
	Copyright AMCC 1994

*

	include pciincl.inc
.386
SSEG    SEGMENT use16    STACK   'STACK'

top_of_stack  db  1000 dup (?)

SSEG    ends

	extrn   MAIN_MENU:BYTE, OPERATION_MENU:BYTE
	extrn   ADD_ON_MENU:BYTE, CONFIGURATION_MENU:BYTE, CLRSCR:BYTE
	extrn   SPACE:BYTE, CLRSPACE:BYTE, LINES:BYTE, CRLF:BYTE
	extrn   MBEF_CLR_ERR:BYTE
	
	public  VAL_SIZE, WORD_VAL, WRITE_DWORD, read_flag
	public  BYTE_VAL, WORD_VAL, DWORD_VAL, BYTE3_VAL, BUS_NUM
	public  DEV_FUNC, INDEX, CCODE, CLSCODE, count, flag
	public  MEMIO, MEM_ALLOC, VEN_ID, DEV_ID, BADR0_REG
	public  OPER_REG, ANY_KEY, FILE_HANDLE
	public  TEST_OMB1, TEST_OMB2, TEST_OMB3, TEST_OMB4, TEST_IMB1
	public  TEST_IMB2, TEST_IMB3, TEST_IMB4, TEST_FIFO, TEST_MWAR
	public  TEST_MWTCR, TEST_MRAR, TEST_MRTCR, TEST_MBEF, TEST_INTCSR
	public  TEST_BMCSR, TEST_BYTE0, TEST_BYTE1, TEST_BYTE2, TEST_OMBREG4
	public  TEST_BYTE3, TEST_OMBREG1, TEST_OMBREG2, TEST_OMBREG3 

DSEG    SEGMENT use16    PUBLIC  'DATA'
MAIN_HDR db 1bh, '[3;15H', '   ',
   db 1bh, '[13;15H', '           APPLIED MICRO CIRCUITS CORP.',
   db 1bh, '[14;15H', '                 6195 Lusk Blvd.',
   db 1bh, '[15;15H', '               San Diego, Ca.  92121',
   db 1bh, '[22;15H', '',
   db '$'


hdr4 db 'Searching for AMCC PCI MatchMaker...', 0ah,0dh,'$'
hdr5 db 'PCI MatchMaker found.', 0ah, 0dh, '$'
err3 db 'AMCC PCI Device was not found!', 0ah,0dh,'$'
err4 db 'Bad Vendor ID!',0ah,0dh,'$'

WRITE_DWORD dd 1 dup(0)
ANY_KEY db 'Press any key...', '$'

;This message is used when VID/DID file is not found
NO_ID_FILE  db 'Using default VID & DID for AMCC PCI MatchMaker...', '$'

;This message is used when AMCC PCI device was not found
TRY_NEXT_ID   db 'Should I try a different VID/DID? (Y/N)', '$'
ENTER_NEW_VID db 'Enter Vendor ID : ', '$'
ENTER_NEW_DID db 'Enter Device ID : ', '$'
READ_BUFFER   db 12 dup(0)
ERROR_ID_FILE_READ db 'Error reading idfile.doc.', '$'
ID_FILE db 'idfile.doc', '$'
FILE_HANDLE dw 1 dup(0)                 ;file handle for when a file is opened
USER_DID    dw 1 dup(0)                 ;device id entered by the user
USER_VID    dw 1 dup(0)                 ;vendor id entered by the user

;This message is used when vendor id is bad
ANOTHER_VID db 'Should I try another VID? (Y/N)', '$'

;FIFO messages
isitfifo db 1 dup(0)                    ;flag that tells if fifo is full (1 = full)
ok2read  db 1 dup(0)                    ;flag that tells if it is ok to read the fifo
ok2write db 1 dup(0)                    ;flag that tells if it is ok to write to the fifo
fifo_written2 db 1 dup(0)               ;flag that tells if the fifo has been written to
FIFO_FULL  db 1bh, '[4;53H', 'FIFO is full', 
	   db 1bh, '[5;53H', 'press any key...', '$'
FIFO_EMPTY db 1bh, '[4;53H', 'Cannot read, FIFO is empty', 
	   db 1bh, '[5;53H', 'press any key...', '$'
FIFO_NOT_FULL  db 1bh, '[4;53H', 'FIFO is not full yet', 
	       db 1bh, '[5;53H', 'press any key...', '$'
CLEAR_FIFO_MSG db 1bh, '[4;53H', '                           ',
	       db 1bh, '[5;53H', '                         ', '$'

cnt     db 21d
cntr    db 1 dup(0)

;Prompts for user input for operation register write.
BYTE_TO_WORD   db 1bh, '[13;10H', 'Which byte? (H/L)', '$'
BYTE_TO_DOUBLE db 1bh, '[13;10H', 'Which byte? (0,1,2,3)', '$'
WORD_TO_DOUBLE db 1bh, '[13;10H', 'Which word? (H/L)', '$'

;String to erase user prompt for operation register write.
clear_line db 1bh, '[13;10H', '                               ', '$'

;Variables
INDEX      dw 1 dup(0)
DEV_FUNC   db 1 dup(0)                  ;device /function number
BUS_NUM    db 1 dup(0)                  ;pci bus number, tells which bus the device is on
BADR0_REG  dd 1 dup(0)                  ;
CCODE      dd 1 dup(0)                  ;holds class code when subclass is changed
CLSCODE    dd 1 dup(0)                  ;holds 24 bit class code
DEV_ID     dw 1 dup(0)                  ;holds 16 bit device id
VEN_ID     dw 1 dup(0)                  ;holds 16 bit vendor id
STS_REG    dw 1 dup(0)                  ;
;LINE_POS1  equ 0
;LINE_POS2  equ 30

OFSET     db 1 dup(0)                   ;temporary storage for register offset
REGISTER  dw 1 dup(0)                   ;temporary storage for register name
BYTE_VAL  db 1 dup(0)                   ;holds a 8 bit value that is to be displayed
WORD_VAL  dw 1 dup(0)                   ;holds a 16 bit value that is to be displayed
BYTE3_VAL dd 1 dup(0)                   ;holds a 24 bit value that is to be displayed
DWORD_VAL dd 1 dup(0)                   ;holds a 32 bit value that is to be displayed
TMP_BYTE   db 1 dup(0)                  ;holds a 8 bit value temporarily
TMP_WORD   dw 1 dup(0)                  ;holds a 16 bit value temporarily
BITES      db 1 dup(0) 

TEST_OMB1   dd 1 dup(0)
TEST_OMB2   dd 1 dup(0)
TEST_OMB3   dd 1 dup(0)
TEST_OMB4   dd 1 dup(0)
TEST_IMB1   dd 1 dup(0)
TEST_IMB2   dd 1 dup(0)
TEST_IMB3   dd 1 dup(0)
TEST_IMB4   dd 1 dup(0)
TEST_FIFO   dd 1 dup(0)
TEST_MWAR   dd 1 dup(0)
TEST_MWTCR  dd 1 dup(0)
TEST_MRAR   dd 1 dup(0)
TEST_MRTCR  dd 1 dup(0)
TEST_MBEF   dd 1 dup(0)
TEST_INTCSR dd 1 dup(0)
TEST_BMCSR  dd 1 dup(0)
TEST_BYTE0  dd 1 dup(0)
TEST_BYTE1  dd 1 dup(0)
TEST_BYTE2  dd 1 dup(0)
TEST_BYTE3  dd 1 dup(0)
TEST_OMBREG1  dd 1 dup(0)
TEST_OMBREG2  dd 1 dup(0)
TEST_OMBREG3  dd 1 dup(0)
TEST_OMBREG4  dd 1 dup(0)
LAST_ADDON_POS dw 1 dup(0)

nib db 1 dup(0)
OPER_REG   dd 1 dup(0)
MEMIO      db 1 dup(0)                  ;flag that shows if IO memory was allocated
MEM_ALLOC  dd 1 dup (0)                 ;contains value showing how much memory was allocated
CHECK_REG   dw 1 dup(0)                 ;
DONE        db 1 dup(0)                 ;
count       db 1 dup(0)                 ;variable used as a counter
flag        db 1 dup(0)                 ;
VAL_SIZE    db 1 dup(0)                 ;holds the number of bytes that were entered
opreg_flag  db 1 dup(0)                 ;
FIFO_AO     db 1 dup(0)                 ;flag that tells if addon fifo is present
ADDON_FLAG  db 1 dup(0)                 ;flag that shows if addon card is present
read_flag   db 1 dup(0)                 ;flag that tells if a read operation should be done

SET_VIDEO_COLOR db 1bh, '[44m', '$'     ;set background color to blue
RESTORE_VIDEO_COLOR db 1bh, '[40m', '$' ;restore background color to black

DSEG    ENDS
;--------------------------------------------------------------------

	extrn   input:near, go_dos:near, string:near, readcur:near
	extrn   setcur:near, place_cur:near, print_byte:near
	extrn   print_word:near, print_3bytes:near, print_dword:near
	extrn   showbyte:near, clear_screen:near, do_c_read_write:near
	extrn   read_all_config_regs:near, run_diagnostic:near

	extrn   test_pci_bios:near, fod:near, get_vid:near

	public  getin_val, read_c_word, read_c_dword, write_c_byte
	public  write_c_word, write_c_dword, clear_fifo, clear_mbef
	public  read_c_byte

CSEG    SEGMENT use16    PUBLIC  'CODE'

MAIN    PROC    FAR
	ASSUME  CS:CSEG,DS:DSEG,ES:DSEG,SS:SSEG
	PUSH    DS
	MOV     AX, DSEG                ;initialize segment registers
	PUSH    AX                      ;
	MOV     AX,DSEG                 ;
	MOV     DS,AX                   ;
	MOV     ES,AX                   ;
	MOV     AX, SSEG                ;initilaize stack
	MOV     SS,AX                   ;
	MOV     AX, offset top_of_stack ;point SP to top of the stack
	MOV     sp, AX                  ;

;       lea     dx, SET_VIDEO_COLOR     ;set background color to blue
;       call    string                  ;
	lea     dx, clrscr              ;clear the screen
	call    string                  ;
	lea     dx, MAIN_HDR            ;display the AMCC header
	call    string                  ;
	lea     dx, crlf                ;add carriage return & line feed
	call    string                  ;
	lea     dx, ANY_KEY             ;prompt the user to press any key
	call    string                  ;  to continue
	call    input                   ;accept the users input
	call    show_menu               ;go show the main menu
getout:
;       lea     dx, RESTORE_VIDEO_COLOR ;set background color to black
;       call    string                  ;
	lea     dx, clrscr              ;clear the screen
	call    string                  ;
	call    GO_DOS                  ;exit the program
MAIN    ENDP
;--------------------------------------------------------------------
;                       SHOW_MAIN_MENU
;
;       Display main menu and process user selections
;--------------------------------------------------------------------
show_menu  proc  near
	call    test_for_pci    ;check for the presence of PCI BIOS and PCI devices
	lea     dx, ANY_KEY     ;prompt user to press any key to continue
	call    string          ;
	call    input           ;get input
reshow:
	lea     dx, CLRSCR      ;clear screen
	call    string          ;
	lea     dx, MAIN_MENU   ;display main menu
	call    string          ;
nxt_input:
	call    input           ;get user selection
	cmp     al, '1'         ;check if it was 2
	jz      configs         ;if yes then access configuration registers
	cmp     al, '2'         ;check if it was 3
	jz      opers           ;if yes then access operation registers
	cmp     al, '3'         ;check if it was 4
	jz      cal_test        ;if yes then run tests
	cmp     al, 'q'         ;check if it was q
	jz      gb2main         ;if yes then quit
	cmp     al, 'Q'         ;check if it was upper case Q
	jz      gb2main         ;if yes then quit
	jmp     nxt_input       ;if none of the above then get next input
configs:
	call    do_config_regs  ;call function to access configuration registers
	jmp     reshow          ;go back to main menu
opers:  call    do_oper_regs    ;call function to access operation registers
	jmp     reshow          ;go back to main menu
cal_test:
	call    run_diagnostic  ;run test function
	jmp     reshow          ;go back to main menu
gb2main:ret
show_menu  endp
;--------------------------------------------------------------------
;                       TEST_FOR_PCI
;
;       Test for PCI BIOS
;       Identify other PCI devices
;       Search for AMCC PCI MatchMaker
;       Initialize the operation registers if AMCC device is found
;
;--------------------------------------------------------------------
test_for_pci  proc  near
	lea     dx, CLRSCR      ;clear the screen
	call    string          ;
	call    test_pci_bios   ;check for the presence of PCI bios
	call    fod             ;identify PCI devices in the system
	call    test_pci_dev    ;look for AMCC's PCI device
	call    init_opregs     ;initialize operation register addresses
	ret
test_for_pci  endp
;--------------------------------------------------------------------
;                       DO_CONFIG_REGS
;
;       Read/Write configuration registers
;--------------------------------------------------------------------
do_config_regs  proc near
c_start:
	lea     dx, clrscr              ;clear the screen
	call    string                  ;
	lea     dx, CONFIGURATION_MENU  ;print out the config. register names
	call    string                  ;
	mov     dh, 03                  ;initialize cursor row
	mov     dl, 01                  ;initialize cursor column
	call    setcur                  ;go move the cursor
	call    read_all_config_regs  ;get the values in all the config registers
c_input:
					;get inputs to toggle thru the list of registers
					;  or read/write to a register
	mov     ah, 0h                  ;initialize BIOS get input function
	int     16h                     ;call BIOS
	cmp     ah, 48h                 ;check if input was up-arrow
	jz      go_up                   ;if yes go move the cursor up   
	cmp     ah, 50h                 ;check if input was down-arrow
	jz      go_down                 ;if yes go move the cursor down
	cmp     ah, 4bh                 ;check if input was left-arrow
	jz      go_left                 ;if yes go move the cursor left
	cmp     ah, 4dh                 ;check if input was right-arrow
	jz      go_right                ;if yes go move the cursor right
	cmp     al, 'r'                 ;check if the input is 'r'
	jz      c_read                  ;if yes go read the register
	cmp     al, 'R'                 ;check if the input is upper case 'R'
	jz      c_read                  ;if yes go read the register
	cmp     al, 'w'                 ;check if the input is 'w'
	jz      c_write                 ;if yes go write to the register
	cmp     al, 'W'                 ;check if the input is upper case 'W'
	jz      c_write                 ;if yes go write to the register
	cmp     al, 1bh                 ;check if input was 'ESC'
	jz      gb_dcr                  ;if yes return to main menu
	cmp     al, 'q'                 ;check if input was 'q'
	jz      getout                  ;if yes then exit program
	cmp     al, 'Q'                 ;check if input was upper case Q
	jz      getout                  ;if yes then exit program
	jmp     c_input                 ;if none of the above ignore the invalid input
					; and go get another input
go_up:
	call    readcur                 ;get the current cursor position
	cmp     dl, 1d                  ;check if cursor is on column1 (first group of regs)
	jnz     notcol1                 ;if not it is on column 29 (second group of regs)
	cmp     dh, 03                  ;check if cursor is at the top
	jz      go_bot                  ;if yes then go move it to the bottom
	jmp     move_up1
notcol1:                                ;check second group of registers
	cmp     dh, 03                  ;check if cursor is at the top
	jnz     move_up1                ;if not then change cursor position up one row
	mov     dh, 12d                 ;if it is at the top then change cursor position to the bottom
	jmp     gomoveit                ;go move the cursor
move_up1:                               ;
	sub     dh, 1                   ;change cursor position up one row
	jmp     gomoveit                ;go move it
go_bot: mov     dh, 13d                 ;move cursor position to the bottom (first group)
	jmp     gomoveit
go_down:                                ;
	call    readcur                 ;get the current cursor position
	cmp     dl, 1d                  ;check if cursor is on column 1 (first group)
	jnz     oncol2                  ;if not then it is on column 29 (second group)
	cmp     dh, 13d                 ;check if cursor is at the bottom
	jz      go_top                  ;if it is go to the top
	jmp     go_down1                ;go move it
oncol2:                                 ;
	cmp     dh, 12d                 ;check if cursor is at the top  (second group)
	jz      go_top                  ;if yes go move cursor to the top
go_down1:
	add     dh, 1                   ;otherwise change position down one row
	jmp     gomoveit                ;go move it
go_top: mov     dh, 03                  ;set cursor position to top
	jmp     gomoveit                ;go move it
go_left:
	call    readcur                 ;get the current cursor position
	mov     dl, 1                   ;move cursor to left column
	jmp     gomoveit                ;go move it
go_right:       
	call    readcur                 ;get the current cursor position
	mov     dl, 29d                 ;move cursor to the right column
	cmp     dh, 13d                 ;check if it is at the bottomof the left column
	jnz     gomoveit                ;if not move it straight across
	mov     dh, 12d                 ;if yes move it to bottom of right column
gomoveit:
	call    setcur                  ;move cursor to new position
	jmp     c_input                 ;go get the next input
c_read: 
	mov     read_flag, 1            ;set read flag to indicate read function
	call    do_c_read_write         ;go read the function
	jmp     c_input                 ;go get the next input
c_write:
	mov     read_flag, 0            ;clear read flag to indicate write function
	call    do_c_read_write         ;go write to the register
	jmp     c_read                  ;go get the next input
get_out:
	lea     dx, clrscr              ;clear the screen
	call    string                  ;
	call    go_dos                  ;exit the program
gb_dcr: ret
do_config_regs  endp
;--------------------------------------------------------------------
;                       GETIN_VAL
;
;       Accept value to write to the register
;--------------------------------------------------------------------
getin_val  proc  near
	mov     bl, VAL_SIZE            ;maximum size entered value can have
	mov     count, 0                ;set input counter to zero, counts numbers  entered
nxt_in: mov     ah, 07h                 ;get input
	int     21h                     ;
	cmp     al, 0dh                 ;check if entry was <RETURN>
	jz      tdone                   ;if yes then return
	cmp     al, '0'                 ;compare input to '0'
	jl      nxt_in                  ;if less than zero then itis invalid, get next input
	cmp     al, '9'                 ;compare input to '9'
	jg      letter                  ;if greater then input was a letter, go check it
	call    save_buffer             ;if valid number (0-9) go put it in a buffer
	inc     count                   ;keep count of inputs
	cmp     count, bl               ;check if count is 8
	jnz     nxt_in                  ;if not more inputs are allowed
	jmp     tdone                   ;if yes buffer is full, return
letter:                                 ;check letters for validity
	cmp     al, 'a'                 ;compare input to 'a'
	jl      check_upper             ;if lower then no good, get next input
	cmp     al, 'f'                 ;compare input to 'f'
	jg      nxt_in                  ;if greater then no good, get next input
good_entry:
	call    save_buffer             ;if letter is valid go put it in a buffer
	inc     count                   ;increment the counter
	cmp     count, bl               ;check if 8 numbers have been entered
	jnz     nxt_in                  ;if not go get the next one
tdone:
	cmp     al, 0dh                 ;check if <RETURN> was entered
	jz      tdone2                  ;if yes then go back
	call    input                   ;get keyboard input
	jmp     tdone                   ;check until it is <RETURN>
check_upper:
	cmp     al, 'A'                 ;compare input to 'a'
	jl      nxt_in                  ;if lower then no good, get next input
	cmp     al, 'F'                 ;compare input to 'f'
	jg      nxt_in                  ;if greater then no good, get next input
	add     al, 20h
	jmp     good_entry
tdone2:
	ret
getin_val  endp
;--------------------------------------------------------------------
;                       SAVE_BUFFER
;
;       Save the value input by the user to write to a register
;--------------------------------------------------------------------
save_buffer  proc  near
	push    ax                      ;save register
	push    bx                      ;save register
	mov     ecx, WRITE_DWORD        ;put buffer into ecx
	mov     dl, al                  ;move input to dl
	push    dx                      ;save it
	call    showbyte                ;print it to the screen
	pop     dx                      ;pop it back
	cmp     dl, '9'                 ;compare input to '9'
	jg      letr                    ;if greater then it is a letter
	sub     dl, 30h                 ;if not greater subtract ASCII bias for digits
	jmp     saveit                  ;go put it in the buffer
letr:   sub     dl, 57h                 ;if letter then subtract ASCII bias
saveit: 
	rol     ecx, 1                  ;move values left 4 bits
	rol     ecx, 1                  ;
	rol     ecx, 1                  ;
	rol     ecx, 1                  ;
	or      cl, dl                  ;put input into first nibble
	mov     WRITE_DWORD, ecx        ;move inputs back into buffer
gb_sb:                                  ;go back to calling function
	pop     bx                      ;
	pop     ax                      ;
	ret
save_buffer  endp
;--------------------------------------------------------------------
;                       CHECK_FOR_ADDON
;
;       Check for the presence of AMCC's addon card
;       to know whether there is access to Addon registers
;--------------------------------------------------------------------
check_for_addon  proc  near
	mov     edx, TEST_OMB1          ;load address for OMB1 register
	mov     eax, OPER_REG           ;move base address to eax
	out     dx, eax                 ;write it out to OMB1
	mov     edx, AIMB1              ;load addon base address
	in      eax, dx                 ;read AOMB1
	cmp     eax, OPER_REG           ;compare it to what was written to OMB1
	jz      yes_addon               ;if equal then addon card is present
no_addon:
	mov     ADDON_FLAG, 0           ;0 = no addon card
	jmp     gb_cfa                  ;go back
yes_addon:
	mov     ADDON_FLAG, 1           ;1 = addon card present
gb_cfa:
	ret
check_for_addon  endp
;--------------------------------------------------------------------
;                       DO_OPER_REGS
;
;       Read/Write operation registers
;--------------------------------------------------------------------
do_oper_regs  proc  near
	mov     edx, TEST_INTCSR        ;load address for interrupt ctrl status reg
	add     dx, 03                  ;point to byte 3 of the register
	mov     al, 3ch                 ;set fifo advance control to advance on byte 3
	out     dx, al                  ;set endian conversion to default : none
	mov     ok2read, 0              ;clear fifo read flag
	mov     ok2write, 0             ;clear fifo write flag
	mov     fifo_written2, 0        ;clear fifo status flag
	call    check_for_addon         ;go check for presence of addon card
	lea     dx, CLRSCR              ;clear screen
	call    string                  ;
	lea     dx, OPERATION_MENU      ;print operation register names
	call    string                  ;
	cmp     ADDON_FLAG, 1           ;is addon card present?
	jnz     init_cursor             ;if no put cursor at top register
	lea     dx, ADD_ON_MENU         ;if yes then display addon registers
	call    string                  ;
init_cursor:
	mov     dx, 0301h               ;set cursor to be on top register
	call    setcur                  ;move the cursor
	call    read_all_opregs         ;
opreg_input:
	mov     ah, 0h                  ;set up BIOS input call
	int     16h                     ;make BIOS call
	cmp     ah, 48h                 ;check if up arrow was pressed
	jz      go_up_opreg             ;if yes go move cursor up
	cmp     ah, 50h                 ;check if down arrow was pressed
	jz      opreg_go_down           ;if yes go move cursor down
	cmp     ah, 4bh                 ;check if left arrow was pressed
	jz      opreg_go_left           ;if yes go move cursor left
	cmp     ah, 4dh                 ;check if right arrow was pressed
	jz      opreg_go_right          ;if yes move cursor right
	cmp     al, 'a'                 ;check if input is 'a'
	jz      opreg_read_all          ;if yes then read all registers
	cmp     al, 'A'                 ;check if input is 'A'
	jz      opreg_read_all          ;if yes then read all registers
	cmp     al, 'r'                 ;check if 'r' was pressed
	jz      opreg_read              ;if yes go read an operation register
	cmp     al, 'R'                 ;check if 'r' was pressed
	jz      opreg_read              ;if yes go read an operation register
	cmp     al, 'w'                 ;check if 'w' was pressed
	jz      opreg_write             ;if yes go write to an operation register
	cmp     al, 'W'                 ;check if 'w' was pressed
	jz      opreg_write             ;if yes go write to an operation register
	cmp     ah, 3bh                 ;check if input is 'F1'
	jz      do_addon                ;if yes go to addon registers
	cmp     al, 1bh                 ;check if 'ESC' was pressed
	jz      gb_dor                  ;if yes return to main menu
	cmp     al, 'q'                 ;check if 'q' was pressed
	jz      git                     ;if yes exit program
	cmp     al, 'Q'                 ;check if 'q' was pressed
	jz      git                     ;go back
	jmp     opreg_input             ;go wait for a valid input
go_up_opreg:                            ;up arrow was pressed
	call    readcur                 ;read cursor position
	cmp     dh, 03                  ;check if ti is already at the top of the list
	jz      go_bot_opreg            ;if it is go to the bottom
	sub     dh, 01                  ;if not move the cursor up one row
	jmp     move_opreg              ;go move the cursor
go_bot_opreg:
	mov     dh, 10d                 ;if it is at the top move the cursor to the bottom
	jmp     move_opreg              ;go get next input
opreg_go_down:                          ;down arrow was pressed
	call    readcur                 ;get current cursor position 
	cmp     dh, 10d                 ;check if it is already at the bottom
	jz      opreg_go_top            ;if it is move the cursor to the top 
	add     dh, 01                  ;if not set cursor position down one row
	jmp     move_opreg              ;go move it
opreg_go_top:
	mov     dh, 03                  ;put cursor at the top
	jmp     move_opreg
opreg_go_left:                          ;left arrow was pressed
	call    readcur                 ;get cursor position
	mov     dl, 1                   ;move it to column 1
	jmp     move_opreg              ;get next input
opreg_go_right:                         ;right arrow was pressed
	call    readcur                 ;get cursor position
	mov     dl, 29d                 ;move it to column 29
move_opreg:
	call    setcur                  ;set new cursor position
	jmp     opreg_input             ;get next input
opreg_read_all:
	call    read_all_opregs         ;
	jmp     opreg_input             ;
opreg_read:
	mov     read_flag, 1            ;
	call    do_op_read_write        ;go read an operation register
	jmp     opreg_input             ;get next input
opreg_write:
	mov     read_flag, 0            ;
	call    do_op_read_write        ;
	cmp     isitfifo, 1             ;
	jz      opreg_input             ;
	jmp     opreg_read              ;input  ;get next input
do_addon:       
	cmp     ADDON_FLAG, 1           ;
	jnz     opreg_input             ;
	call    readcur                 ;
	push    dx                      ;
	add     dh, 13d                 ;
	call    setcur                  ;
	call    do_addon_regs           ;
	pop     dx                      ;
	call    setcur                  ;
	jmp     opreg_input             ;
git:
	lea     dx, clrscr              ;clear the screen
	call    string                  ;
	call    go_dos                  ;exit the program
gb_dor: ret
do_oper_regs  endp
;--------------------------------------------------------------------
;                       DO_OP_READ_WRITE
;       Read operation registers
;--------------------------------------------------------------------
do_op_read_write  proc  near
	mov     isitfifo, 0             ;clear fifo indicator flag
	call    readcur                 ;read the cursor position
	mov     TMP_WORD, dx            ;save it
	cmp     dl, 1                   ;check if it is on the left col of registers
	jnz     rnxt_col                ;if not go check the next column
	mov     dl, 10d                 ;move cursor right ten spaces
	call    setcur                  ;go move it
	lea     dx, CLRSPACE            ;clear the area
	call    string                  ;
	mov     dx, TMP_WORD
	mov     dl, 10d                 ;move it right ten spaces
	call    setcur                  ;
	mov     ax, TMP_WORD            ;save it
	cmp     ah, 3                   ;check if cursor is on line 3
	jz      romb1                   ;if yes go read register OMB1
	cmp     ah, 4                   ;check if cursor is on line 4
	jz      romb2                   ;if yes go read register OMB2
	cmp     ah, 5                   ;check if cursor is on line 5
	jz      romb3                   ;if yes go read register OMB3
	cmp     ah, 6                   ;check if cursor is on line 6
	jz      romb4                   ;if yes go read register OMB4
	cmp     ah, 7                   ;check if cursor is on line 7
	jz      rimb1                   ;if yes go read register IMB1
	cmp     ah, 8                   ;check if cursor is on line 8
	jz      rimb2                   ;if yes go read register IMB2
	cmp     ah, 9                   ;check if cursor is on line 9
	jz      rimb3                   ;if yes go read register IMB3
	cmp     ah, 10d                 ;check if cursor is on line 10
	jz      rimb4                   ;if yes go read register IMB4
rnxt_col:                               ;check right column
	mov     dl, 39d                 ;move cursor to column 39
	call    setcur                  ;
	lea     dx, CLRSPACE            ;clear the area
	call    string                  ;
	mov     dx, TMP_WORD
	mov     dl, 39d                 ;move cursor to column 39
	call    setcur                  ;
	mov     ax, TMP_WORD            ;save it
	cmp     ah, 3d                  ;
	jz      rfifo                   ;
	cmp     ah, 4d                  ;
	jz      rmwar                   ;
	cmp     ah, 5d                  ;
	jz      rmwtc                   ;
	cmp     ah, 6d                  ;
	jz      rmrar                   ;
	cmp     ah, 7d                  ;
	jz      rmrtc                   ;
	cmp     ah, 8d                  ;
	jz      rmbef                   ;
	cmp     ah, 9d                  ;
	jz      rintcs                  ;
	cmp     ah, 10d                 ;
	jz      rmcs                    ;
romb1:  mov     ecx, TEST_OMB1          ;
	jmp     read_write              ;
romb2:  mov     ecx, TEST_OMB2          ;
	jmp     read_write              ;
romb3:  mov     ecx, TEST_OMB3          ;
	jmp     read_write              ;
romb4:  mov     ecx, TEST_OMB4          ;
	jmp     read_write              ;
rimb1:  mov     ecx, TEST_IMB1          ;
	jmp     read_write              ;
rimb2:  mov     ecx, TEST_IMB2          ;
	jmp     read_write              ;
rimb3:  mov     ecx, TEST_IMB3          ;
	jmp     read_write              ;
rimb4:  mov     ecx, TEST_IMB4          ;
	jmp     read_write              ;
rfifo:  mov     FIFO_AO, 0              ;
	call    read_fifo_status        ;
	mov     ecx, TEST_FIFO          ;
	cmp     read_flag, 1            ;
	jz      can_i_read              ;
can_i_write:
	mov     isitfifo, 1             ;
	cmp     ok2write, 1             ;
	jz      read_write              ;
	jmp     gb_mor                  ;read_write
can_i_read:
	cmp     ok2read, 1              ;
	jz      read_write              ;
	jmp     gb_mor                  ;
rmwar:  mov     ecx, TEST_MWAR          ;
	jmp     read_write              ;
rmwtc:  mov     ecx, TEST_MWTCR         ;
	jmp     read_write              ;
rmrar:  mov     ecx, TEST_MRAR          ;
	jmp     read_write              ;
rmrtc:  mov     ecx, TEST_MRTCR         ;
	jmp     read_write              ;
rmbef:  mov     ecx, TEST_MBEF          ;
	jmp     read_write              ;
rintcs: mov     ecx, TEST_INTCSR        ;
	jmp     read_write              ;
rmcs:   mov     ecx, TEST_BMCSR         ;
	jmp     read_write              ;
read_write:                             ;check if it is a read or write operation
	cmp     read_flag, 1            ;check if read flag is set
	jz      read_op                 ;if yes go read the register
	call    write_to_opregs         ;
	jmp     gb_mor                  ;
read_op:                                ;
	mov     edx, ecx                ;
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	mov     read_flag, 0            ;
gb_mor:
	mov     dx, TMP_WORD
	call    setcur                  ;
	sub     eax, eax                ;
	mov     WRITE_DWORD, eax        ;
	ret                             ;
do_op_read_write  endp
;--------------------------------------------------------------------
;                       WRITE_TO_OPREGS
;
;       Handle the write function for operation registers
;--------------------------------------------------------------------
write_to_opregs  proc  near
write_op:                               ;if not then write to the register
	push    ecx                     ;save register address
	mov     VAL_SIZE, 8             ;maximum size is 8 bytes (32 bits)
	call    getin_val               ;get value to write
	cmp     count, 4                ;compare number of inputs to 4
	jg      write_double            ;if more than four inputs then do a 32 bit write
	cmp     count, 2                ;compare number of inputs to 2
	jg      write_a_word            ;if more than 2 inputs but less than four do a word write
write_a_byte:                           ;do a byte write
	lea     dx, BYTE_TO_DOUBLE      ;ask user which byte to write to (0,1,2,3)
	call    string                  ;
which_b:
	call    input                   ;get user's input
	push    ax
	lea     dx, clear_line          ;erase user prompt
	call    string                  ;
	mov     dx, TMP_WORD            ;restore cursor position
	call    setcur                  ;
	pop     ax
	pop     edx
	cmp     al, '0'                 ;check if it was zero
	jz      byte0                   ;if yes go write to byte 0
	cmp     al, '1'                 ;check if it was one
	jz      byte1                   ;if yes go write to byte 1
	cmp     al, '2'                 ;check if it was two
	jz      byte2                   ;if yes go write to byte 2
	cmp     al, '3'                 ;check if it was three
	jz      byte3                   ;if yes go write to byte 3
	jmp     which_b                 ;if none of these get next input
byte0:                                  ;write to byte 0
	jmp     byte_output             ;
byte1:                                  ;write to byte 1
	add     dx, 01                  ;point to byte1
	jmp     byte_output             ;go write to it
byte2:                                  ;write to byte 2
	add     dx, 02                  ;point to byte 2
	jmp     byte_output             ;
byte3:                                  ;write to byte 3
	add     dx, 03                  ;point to the third byte of the 32-bit word
byte_output:
	mov     eax, WRITE_DWORD        ;
	out     dx, al                  ;
	jmp     gb_wto                  ;
write_a_word:
	lea     dx, WORD_TO_DOUBLE      ;
	call    string                  ;
which_w:                
	call    input                   ;
	push    ax
	lea     dx, clear_line          ;
	call    string                  ;
	mov     dx, TMP_WORD            ;
	call    setcur                  ;
	pop     ax                      ;
	pop     edx                     ;
	cmp     al, 'h'                 ;
	jz      hi_word                 ;
	cmp     al, 'H'                 ;
	jz      hi_word 
	cmp     al, 'l'                 ;
	jz      write_out               ;
	cmp     al, 'L'                 ;
	jz      write_out               ;
	jmp     which_w                 ;
hi_word:
	add     dx, 2                   ;
	jmp     write_out               ;
write_out:              
	mov     eax, WRITE_DWORD        ;
	out     dx, ax                  ;
	jmp     gb_wto                  ;
write_double:           
	pop     edx                     ;
	mov     eax, WRITE_DWORD        ;
	out     dx, eax                 ;
	jmp     gb_wto                  ;
gb_wto:
	ret
write_to_opregs  endp
;--------------------------------------------------------------------
;                       READ_ALL_OPREGS
;
;       Read all the operation registers including the addon side
;--------------------------------------------------------------------
read_all_opregs  proc  near
	call    readcur                 ;read the current cursor position
	push    dx                      ;save it
	mov     dx, 0301h               ;move cursor to top of first column
	call    setcur                  ;go move it
	mov     flag, 1                 ;
	mov     cl, 08h                 ;
	push    cx                      ;
regs:   mov     read_flag, 1            ;
	call    do_op_read_write        ;
	inc     dh                      ;
	call    setcur                  ;
	pop     cx                      ;
	dec     cl                      ;
	push    cx                      ;
	cmp     cl, 0                   ;
	jz      noregs                  ;
	jmp     regs                    ;
noregs: cmp     flag, 1                 ;check if col 1 was just read
	jnz     noregs2                 ;if not then col 2 was read, go read addon registers
	pop     cx                      ;else pop counter to read the rest of the registers
	mov     dx, 041eh               ;cursor position row 4, col 29, to read col 2
	call    setcur                  ;go move the cursor
	mov     cx, 07h                 ;set counter to 7
	push    cx                      ;save it
	mov     flag, 2                 ;set flag to show the second column is being read
	jmp     regs                    ;go read the second column
noregs2:
	cmp     ADDON_FLAG, 1           ;
	jnz     ao_noregs2              ;
	pop     cx                      ;
	mov     dx, 0f01h               ;cursor position row 16, col 1
	call    setcur                  ;
	mov     flag, 1                 ;
	mov     cl, 09h         ;
	push    cx                      ;
aoregs: mov     read_flag, 1            ;
	call    addon_read_write        ;
	inc     dh                      ;
	call    setcur                  ;
	pop     cx                      ;
	dec     cl                      ;
	push    cx                      ;
	cmp     cl, 0                   ;
	jz      ao_noregs               ;
	jmp     aoregs                  ;
ao_noregs:              
	cmp     flag, 1                 ;
	jnz     ao_noregs2              ;
	pop     cx                      ;
	mov     dx, 101eh               ;
	call    setcur                  ;
	mov     cx, 08h                 ;
	push    cx                      ;
	mov     flag, 2                 ;
	jmp     aoregs                  ;
ao_noregs2:
	pop     cx                      ;
	pop     dx                      ;
	call    setcur                  ;
	ret
read_all_opregs  endp
;--------------------------------------------------------------------
;                       READ_FIFO_STATUS
;
;       Check if FIFO is empty before a read operation,
;       also checks if FIFO is full before a write operation.
;--------------------------------------------------------------------
read_fifo_status  proc near
	xor     edx, edx                ;clear edx
	mov     isitfifo, 1             ;set flag to note fifo is being read or written to
	cmp     FIFO_AO, 1              ;check if it is the addon fifo 
	jz      ao_side                 ;if yes go check the addon fifo
	mov     edx, TEST_BMCSR         ;get master control/status register address
	in      eax, dx                 ;read master control status register 
	jmp     read_csr                ;go found out what is in the MCSR
ao_side:
	mov     dx, AGCSTS              ;read addon control/status register
	in      eax, dx                 ; 
read_csr:
	mov     DWORD_VAL, eax          ;save it for now
	call    readcur                 ;read the cursor position
	push    dx                      ;save it
	mov     dl, 0ah                 ;set the cursor position to column 10
	call    setcur                  ;go move it
	pop     dx                      ;
	call    setcur                  ;
	cmp     read_flag, 1            ;check if it is a read operation
	jz      check_empty             ;if yes check if fifo is empty
	jmp     check_full              ;if it is a write operation check if it is full
check_full:
	cmp     FIFO_AO, 1              ;
	jne     pci_side                ;
	mov     eax, DWORD_VAL          ;
	and     al, 01h                 ;
	cmp     al, 01h                 ;
	jz      fifo_is_full            ;
	mov     ok2write, 1             ;
	jmp     gb_rfifo                ;
pci_side:
	mov     eax, DWORD_VAL          ;get the original cursor position
	and     al, 01h                 ;check if it is on column 1
	cmp     al, 01h                 ;check if FIFO is completely full
	jz      fifo_is_full            ;
	mov     ok2write, 1             ;
	jmp     gb_rfifo                ;
fifo_is_full:
	mov     ok2write, 0             ;
	mov     ok2read, 1              ;
	call    readcur                 ;
	push    dx                      ;
	lea     dx, FIFO_FULL           ;
	call    string                  ;
clear_fifo_prompt:
	call    input                   ;
	lea     dx, CLEAR_FIFO_MSG      ;
	call    string                  ;
	pop     dx                      ;
	call    setcur                  ;
	jmp     gb_rfifo                ;
check_empty:                            ;to read check if fifo is empty
	cmp     FIFO_AO, 1              ;check if it is the addon fifo
	jnz     pci_fifo                ;if not go check the pci side fifo
	mov     eax, DWORD_VAL          ;get the controls/status register data
	and     ah, 20h                 ;mask bit 5
	cmp     ah, 20h                 ;check if the fifo is empty
	jz      empty                   ;if yes show fifo empty message
	jmp     yes_read                ;if not go read it
pci_fifo:
	mov     eax, DWORD_VAL          ;get the control/status register
	and     al, 20h                 ;mask bit 5
	cmp     al, 20h                 ;check if it is empty
	jz      empty                   ;if yes show fifo empty message
yes_read:
	mov     ok2read, 1              ;if it is ok to read the fifo set the flag
	jmp     gb_rfifo                ;go back
empty:  mov     ok2read, 0              ;if empty it is not ok to read
	call    readcur                 ;get the current cursor position
	push    dx                      ;save it
	lea     dx, FIFO_EMPTY          ;show message that fifo is empty
	call    string                  ;
	call    input                   ;wait for the user to press a key
	lea     dx, CLEAR_FIFO_MSG      ;erase the message
	call    string                  ;
	pop     dx                      ;get the cursor position back
	call    setcur                  ;move it
gb_rfifo:
	ret
read_fifo_status  endp
;--------------------------------------------------------------------
;                       DO_ADD_ON_REGS
;
;       Read/write addon operation registers
;--------------------------------------------------------------------
do_addon_regs  proc  near
initialize_cursor:
	cmp     LAST_ADDON_POS, 0       ;
	jz      addon_input             ;
	mov     dx, LAST_ADDON_POS      ;set cursor to be on row 3 column 1
	call    setcur                  ;move the cursor
addon_input:
	mov     ah, 0h                  ;set up BIOS input call
	int     16h                     ;make BIOS call
	cmp     ah, 48h                 ;check if up arrow was pressed
	jz      go_up_addon             ;if yes go move cursor up
	cmp     ah, 50h                 ;check if down arrow was pressed
	jz      addon_go_down           ;if yes go move cursor down
	cmp     ah, 4bh                 ;check if left arrow was pressed
	jz      addon_go_left           ;if yes go move cursor left
	cmp     ah, 4dh                 ;check if right arrow was pressed
	jz      addon_go_right          ;if yes move cursor right
	cmp     al, 'a'                 ;check if input is 'a'
	jz      read_all                ;if yes read all registers
	cmp     al, 'A'                 ;check if input is 'A'
	jz      read_all                ;if yes read all registers
	cmp     al, 'r'                 ;check if 'r' was pressed
	jz      addon_read              ;if yes go read an operation register
	cmp     al, 'R'                 ;check if 'r' was pressed
	jz      addon_read              ;go read the addo register
	cmp     al, 'w'                 ;check if 'w' was pressed
	jz      addon_write             ;if yes go write to the addon register
	cmp     al, 'W'                 ;check if 'w' was pressed
	jz      addon_write             ;if yes go write to the addon register
	cmp     ah, 3bh                 ;check if input is 'F1'
	jz      gb_addon                ;if yes go back to operation registers
	cmp     al, 1bh                 ;check if 'ESC' was pressed
	jz      gb_aodor                ;if yes return to main menu
	cmp     al, 'q'                 ;check if 'q' was pressed
	jz      aogit                   ;if yes exit program
	cmp     al, 'Q'                 ;check if 'q' was pressed
	jz      aogit                   ;exit program
	jmp     addon_input             ;go wait for another input
go_up_addon:                            ;up arrow was pressed
	call    readcur                 ;read cursor position
	cmp     dh, 15d                 ;check if ti is already at the top of the list
	jz      go_bot_addon            ;if it is go to the bottom
	sub     dh, 01                  ;if not move the cursor up one row
	jmp     move_up_addon           ;go move the cursor
go_bot_addon:
	mov     dh, 23d                 ;if it is at the top move the cursor to the bottom
move_up_addon:
	call    setcur                  ;go set the new cursor position
	jmp     addon_input             ;go get next input
addon_go_down:                          ;down arrow was pressed
	call    readcur                 ;get current cursor position 
	cmp     dh, 23d                 ;check if it is already at the bottom
	jz      addon_go_top            ;if it is move the cursor to the top 
	add     dh, 01                  ;if not set cursor position down one row
	jmp     addon_move_dn           ;go move it
addon_go_top:
	mov     dh, 15d                 ;put cursor at the top
addon_move_dn:
	call    setcur                  ;move cursor to its new position
	jmp     addon_input             ;
addon_go_left:                          ;left arrow was pressed
	call    readcur                 ;get cursor position
	mov     dl, 1                   ;move it to column 1
	call    setcur                  ;set new cursor position
	jmp     addon_input             ;get next input
addon_go_right:                         ;right arrow was pressed
	call    readcur                 ;get cursor position
	mov     dl, 29d                 ;move it to column 29
	call    setcur                  ;set new cursor position
	jmp     addon_input             ;get next input
read_all:
	call    read_all_opregs         ;
	jmp     addon_input             ;
addon_read:
	mov     read_flag, 1
	call    addon_read_write        ;go read an operation register
	jmp     addon_input             ;get next input
addon_write:
	mov     read_flag, 0            ;clear read flag to show write operation
	call    addon_read_write        ;go read the register
	cmp     isitfifo, 1             ;check if it was the fifo register
	jz      addon_input             ;
	jmp     addon_read              ;
aogit:  call    go_dos
gb_aodor:
	pop     dx                      ;
	pop     dx                      ;
gb_addon:
	ret
do_addon_regs  endp
;--------------------------------------------------------------------
;                       ADDON_READ_WRITE
;
;       Read/write to the add on operation registers 
;--------------------------------------------------------------------
addon_read_write  proc  near
	mov     isitfifo, 0             ;clear fifo flag
	mov     FIFO_AO, 0              ;
	call    readcur                 ;get cursor position before going to add on registers
	push    dx                      ;save it
	push    dx                      ;
	cmp     dl, 1                   ;check if it is on column one
	jnz     raddonnxt_col           ;if no go check register on the second column
	push    dx                      ;
	mov     dl, 10d                 ;move cursor down to add-on part of the screen
	call    setcur                  ;go move it
	lea     dx, CLRSPACE            ;erase any thing that may be on those spaces
	call    string                  ;
	pop     dx                      ;get cursor position
	mov     dl, 10d                 ;
	call    setcur                  ;move it
	pop     ax                      ;get the cursor position
	mov     TMP_WORD, ax            ;save location on col 1
	cmp     ah, 15d                 ;check if cursor is on row 15
	jz      raimb1                  ;if yes then read AIMB1
	cmp     ah, 16d                 ;check if cursor is on row 16
	jz      raimb2                  ;if yes then read AIMB2
	cmp     ah, 17d                 ;check if cursor is on row 17
	jz      raimb3                  ;if yes then read AIMB3
	cmp     ah, 18d                 ;check if cursor is on row 18
	jz      raimb4                  ;if yes then read AIMB4
	cmp     ah, 19d                 ;check if cursor is on row 19
	jz      raomb1                  ;if yes then read AOMB1
	cmp     ah, 20d                 ;check if cursor is on row 20
	jz      raomb2                  ;if yes then read AOMB2
	cmp     ah, 21d                 ;check if cursor is on row 21
	jz      raomb3                  ;if yes then read AOMB3
	cmp     ah, 22d                 ;check if cursor is on row 22
	jz      raomb4                  ;if yes then read AOMB4
	cmp     ah, 23d                 ;check if cursor is on row 23
	jz      ramwtc
raddonnxt_col:
	push    dx                      ;
	mov     dl, 39d                 ;
	call    setcur                  ;
	lea     dx, CLRSPACE            ;
	call    string                  ;
	pop     dx                      ;
	mov     dl, 39d                 ;
	call    setcur                  ;
	pop     ax                      ;
	mov     TMP_WORD, ax            ;
	cmp     ah, 15d                 ;check if cursor is on row 15
	jz      rafifo                  ;if yes then read AFIFO
	cmp     ah, 16d                 ;check if cursor is on row 15
	jz      ramwar                  ;if yes then read AMWAR
	cmp     ah, 17d                 ;check if cursor is on row 15
	jz      rapta                   ;if yes then read APTA
	cmp     ah, 18d                 ;check if cursor is on row 15
	jz      raptd                   ;if yes then read APTD
	cmp     ah, 19d                 ;check if cursor is on row 15
	jz      ramrar                  ;if yes then read AMRAR
	cmp     ah, 20d                 ;check if cursor is on row 15
	jz      rambef                  ;if yes then read AMBEF
	cmp     ah, 21d                 ;check if cursor is on row 15
	jz      raint                   ;if yes then read AINT
	cmp     ah, 22d                 ;check if cursor is on row 15
	jz      ragcsts                 ;if yes then read AGCSTS
	cmp     ah, 23d                 ;check if cursor is on row 15
	jz      ramrtc                  ;if yes then read AMRTC
	jmp     gb_aorw                 ;if none of these then go back
rafifo: mov     FIFO_AO, 1              ;set flag to show it is the addon fifo 
	call    read_fifo_status        ;go check if the fifo is empty
	mov     dx, AFIFO               ;get the address of the fifo register
	cmp     read_flag, 1            ;check if can be read
	jz      aocan_i_read            ;
aocan_i_write:
	mov     isitfifo, 1             ;
	cmp     ok2write, 1             ;
	jz      rwaddon                 ;
	jmp     gb_aorw                 ;read_write
aocan_i_read:
	cmp     ok2read, 1              ;
	jz      rwaddon                 ;
	jmp     gb_aorw                 ;
ramwar: mov     dx, AMWAR               ;
	jmp     rwaddon                 ;
rapta:  mov     dx, APTA                ;
	jmp     rwaddon                 ;
raptd:  mov     dx, APTD                ;
	jmp     rwaddon                 ;
ramrar: mov     dx, AMRAR               ;
	jmp     rwaddon                 ;
rambef: mov     dx, AMBEF               ;
	jmp     rwaddon                 ;
raint:  mov     dx, AINT                ;
	jmp     rwaddon                 ;
ragcsts:mov     dx, AGCSTS              ;
	jmp     rwaddon                 ;
ramrtc: mov     dx, AMRTCR
	jmp     rwaddon
raimb1: mov     dx, AIMB1               ;
	jmp     rwaddon                 ;
raimb2: mov     dx, AIMB2               ;
	jmp     rwaddon                 ;
raimb3: mov     dx, AIMB3               ;
	jmp     rwaddon                 ;
raimb4: mov     dx, AIMB4               ;
	jmp     rwaddon                 ;
raomb1: mov     dx, AOMB1               ;
	jmp     rwaddon                 ;
raomb2: mov     dx, AOMB2               ;
	jmp     rwaddon                 ;
raomb3: mov     dx, AOMB3               ;
	jmp     rwaddon                 ;
raomb4: mov     dx, AOMB4               ;
	jmp     rwaddon                 ;
ramwtc: mov     dx, AMWTCR              ;
	jmp     rwaddon
rwaddon:                
	cmp     read_flag, 1            ;
	jz      read_addon              ;
	jmp     write_addon             ;
read_addon:
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	jmp     gb_aorw                 ;
write_addon:
	mov     ecx, edx                ;
	call    write_to_opregs         ;
	sub     eax, eax                ;
	mov     WRITE_DWORD, eax        ;
gb_aorw:
	pop     dx                      ;retrieve cursor position
	mov     LAST_ADDON_POS, dx      ;save it
	call    setcur                  ;go move the cursor
	ret
addon_read_write  endp
;--------------------------------------------------------------------
;                       GET_OPERG2
;
;       Read base address register 0 and get the base address
;       for the operation registers
;--------------------------------------------------------------------
get_opreg2  proc  near
	mov     ax, BADR0_ADDR          ;bring up register offset
	mov     di, ax                  ;load register offset to di
	call    read_c_dword            ;read BADR0
	mov     BADR0_REG, ecx          ;save the value
;       push    ecx
;       pop     cx                      ;pop lower byte
;       pop     dx                      ;pop upper byte
	mov     dl, cl                  ;
	and     dl, 01h                 ;mask off everything except bit 1
	cmp     dl, 1                   ;check if bit 1 is set
	jnz     memsp1                  ;if not set then it is memory space
iospc1: and     cl, 0fch                ;clear first 2 bits
	jmp     gbgop1                  ;return
memsp1: and     cl, 0f8h                ;memory space
gbgop1: mov     OPER_REG, ecx           ;save base address for operation registers
gbrb01: mov     opreg_flag, 1
	ret
get_opreg2  endp
;--------------------------------------------------------------------
;                       TEST_PCI_DEVICE
;
;       This function will test for the existence of a AMCC's PCI device.
;       An error message will be printed if the AMCC PCI MatchMaker
;       is not found.
;--------------------------------------------------------------------
test_pci_dev proc near
	lea     dx, hdr4                ;print test for device message
	call    string                  ;call sting output
	call    get_id_file             ;check if vic/did are in idfile.doc
	cmp     ah, SUCCESS             ;if yes then use those values
	jz      look_for_device         ;and look for AMCC MatchMaker
use_default_val:
	lea     dx, NO_ID_FILE          ;if no then display message
	call    string                  ; that there is no idfile.doc
	lea     dx, crlf                ;skip a line
	call    string                  ;
	call    string                  ;
	mov     DEV_ID, 4750h           ;use default values
	mov     VEN_ID, 10e8h           ;for AMCC MatchMaker
look_for_device:        
	mov     cx, DEV_ID              ;device id must be in CX
	mov     dx, VEN_ID              ;vendor id must be in DX
	mov     ah, PCI_FUNC_ID         ;load pci function id into AH
	mov     al, FIND_PCI_DEV        ;load search for device function into AL
	mov     si, 0                   ;
	int     1ah                     ;call bios
	cmp     ah, SUCCESS             ;check if call was successful
	jz      yes_pci                 ;if yes then pci device was found
	cmp     ah, DEV_NOT_FND         ;else check if device was not found
	jz      no_dev                  ;if not display message
check_vendr:
	cmp     ah, BAD_VNDR_ID         ;check if vendor id was bad
	jz      bad_vid                 ;if yes display message
	jmp     gb_tpd                  ;go back
yes_pci:
	mov     DEV_FUNC, bl            ;pci device found , save device & function number
	mov     BUS_NUM, bh             ;save bus number
	mov     ax, BADR0_ADDR          ;put address of BADR0 register in AX
	mov     di, ax                  ;move it to DI
	call    read_c_dword            ;go read BADR0
	and     ecx, 0fffffffeh         ;mask all but bit 0
	mov     OPER_REG, ecx           ;save the value, this tells type and amout of memory needed
	lea     dx, hdr5                ;print pci device found message
	call    string                  ;call string output
	lea     dx, crlf                ;skip a line
	call    string                  ;
	jmp     gb_tpd                  ;continue
no_dev:         
	lea     dx, err3                ;print no device found message
	call    string                  ;
	lea     dx, crlf                ;go down to the next line
	call    string                  ;
	lea     dx, TRY_NEXT_ID         ;ask the user if another VID/DID should used
	call    string                  ;
no_dev_input:
	call    input                   ;get user input
	cmp     al, 'y'                 ;check if yes
	jz      get_new_id_nums         ;go prompt the user to enter the new values
	cmp     al, 'Y'                 ;
	jz      get_new_id_nums         ;go prompt the user to enter the new values
	cmp     al, 'n'                 ;check if no
	jz      exit_prog               ;if no then exit the program
	cmp     al, 'N'                 ;check if no
	jz      exit_prog               ;exit the program
	jmp     no_dev_input            ;get next input
bad_vid:
	lea     dx, err4                ;print bad vendor id message
	call    string                  ;call string output
	lea     dx, ANY_KEY             ;prompt user to enter any key to continue
	call    string                  ;
bvid_input:
	call    input                   ;get input
	cmp     al, 'y'                 ;check if input is 'y'
	jz      get_new_vid             ;if yes get new vid
	cmp     al, 'Y'                 ;check if input is 'Y'
	jz      get_new_vid             ;if yes get new vid
	cmp     al, 'n'                 ;check if input is 'n'
	jz      exit_prog               ;don't continue, exit the program
	cmp     al, 'N'                 ;check if input is 'N'
	jz      exit_prog               ;don't continue, exit the program
	jmp     bvid_input              ;go get another input
get_new_vid:            
	call    get_vid                 ;go get a new vendor id
	jmp     look_for_device         ;go look for the device again
get_new_id_nums:
	call    get_user_ids            ;get vid/did from the user
	lea     dx, crlf                ;skip a line
	call    string                  ;
	call    string                  ;
	jmp     look_for_device         ;go look for the device again
exit_prog:
	lea     dx, RESTORE_VIDEO_COLOR ;restore background color
	call    string                  ;
	call    go_dos                  ;exit the program
gb_tpd:
	ret
test_pci_dev endp
;--------------------------------------------------------------------
;                       GET_ID_FILE
;
;       Look for the file that contains the vendor id and the device
;       id to use to look for the AMCC PCI device.
;--------------------------------------------------------------------
get_id_file  proc  near
	mov     dx, offset ID_FILE      ;
	mov     al, 11000000b           ;set open mode to read only
	mov     ah, 3dh                 ;open file
	int     21h                     ;
	jc      noid_file               ;file does not exist
	mov     FILE_HANDLE, ax         ;file opened, save file handle
	mov     bx, FILE_HANDLE         ;
	mov     dx, offset READ_BUFFER  ;
	mov     cx, 9h                  ;
	mov     ah, 3fh                 ;
	int     21h                     ;
	jc      error_on_read           ;error reading the id file
	mov     bx, 0000h               ;
	call    parse_buffer            ;
	mov     VEN_ID, cx              ;
	inc     bx                      ;
	inc     bx                      ;
	call    parse_buffer            ;
	mov     DEV_ID, cx              ;
	jmp     gb_get_id               ;
error_on_read:
	lea     dx, crlf                ;
	lea     dx, ERROR_ID_FILE_READ  ;
	call    string                  ;
	lea     dx, crlf                ;
noid_file:                      
	mov     ah, FAILURE             ;
gb_get_id:
	ret
get_id_file  endp
;--------------------------------------------------------------------
;                       GET_USER_IDS
;
;
;--------------------------------------------------------------------
get_user_ids  proc  near
	mov     ecx, 00000000h          ;clear ECX
	mov     WRITE_DWORD, 00000000h  ;clear this memory location
	lea     dx, crlf                ;skip a line
	call    string                  ;
	lea     dx, ENTER_NEW_VID       ;promt the user to enter the VID
	call    string                  ;
	mov     VAL_SIZE, 4             ;maximum number of charachters to accept
	call    getin_val               ;go get the new value
	mov     VEN_ID, cx              ;save it
	lea     dx, crlf                ;skip a line
	call    string                  ;
	lea     dx, ENTER_NEW_DID       ;prompt the user to enter the DID
	call    string                  ;
	call    getin_val               ;go get it
	mov     DEV_ID, cx              ;save it
	ret
get_user_ids  endp
;--------------------------------------------------------------------
;                       PARSE_BUFFER
;
;       Will read two bytes of buffer read from IDFILE.DOC
;       The 16-bit value is returned in CX
;--------------------------------------------------------------------
parse_buffer  proc near
	mov     al, 2                   ;counter for number of 16 bit values to read
	mov     nib, 1                  ;point first to the high nibble
buffer_part:
	mov     dh, offset READ_BUFFER[bx]   ;get upper nibble
	cmp     dh, 39h                 ;check if it is a number
	jg      mask_letter             ;if not, check if it is a valid letter entry
mask_bias:
	cmp     nib, 1                  ; check if it is the high nibble
	jne     low_nibble              ; if not it is the low nibble
	and     dh, 0fh                 ;mask of ascii bias
	rol     dh, 4                   ;rotate to upper nibble
	mov     ch, dh                  ;save it in ch
	inc     bx                      ; point to next nibble
	mov     nib, 0                  ; it will be the lower nibble of the next byte
	jmp     buffer_part
low_nibble:
	and     dh, 0fh                 ;mask off ascii bias
	or      ch, dh                  ;put in lower nibble of ch
	dec     al                      ;decrement counter
	cmp     al, 0                   ;check if both bytes have been read
	jz      show_me                 ;if yes go arrange the bytes in order
	mov     BYTE_VAL, ch            ;if not save the upper nibble
	inc     bx                      ;point to the next nibble
	mov     nib, 1
	jmp     buffer_part             ;go read the next byte
mask_letter:
	cmp     dh, 46h                 ;check if it was an uppercase letter
	jg      lower_case              ;if yes go, process it as a lower case
	sub     dh, 37h                 ;if not 
	jmp     mask_bias               ;
lower_case:             
	sub     dh, 57h                 ;
	jmp     mask_bias               ;
show_me:
	mov     cl, ch                  ;save the lower byte
	mov     ch, BYTE_VAL            ;restore the upper byte
	ret
parse_buffer  endp
;--------------------------------------------------------------------
;                       CLEAR_MBEF
;       Clear mailbox register empty/full status flags.
;--------------------------------------------------------------------
clear_mbef  proc  near
	push    edx                     ;save register
	mov     edx, TEST_BMCSR         ;get master control/status register address
	mov     eax, 08000000h          ;write to bit to clear mailbox flags
	out     dx, eax                 ;write to the register
	mov     edx, TEST_MBEF          ;get mailbox status register address
	in      eax, dx                 ;read it
	cmp     ax, 0                   ;check if all flags have been cleared
	jz      gb_mbef                 ;if yes then return to calling function
	lea     dx, MBEF_CLR_ERR        ;if not then show error message
	call    string                  ;
gb_mbef:                
	pop     edx                     ;restore register
	ret
clear_mbef  endp
;--------------------------------------------------------------------
;                       CLEAR_FIFO
;       Clear FIFO register and turn off loop back mode
;       after diagnostic tests.
;--------------------------------------------------------------------
clear_fifo  proc  near
	push    edx                     ;
	mov     edx, TEST_BMCSR         ;write to master control register
	mov     eax, 06000000h          ;clear FIFO
	out     dx, eax                 ;
	pop     edx                     ;
	ret
clear_fifo  endp
;--------------------------------------------------------------------
;                       INIT_OPREGS
;
;       Initialize all operation register addresses
;--------------------------------------------------------------------
init_opregs  proc  near
	mov     ax, BADR0_ADDR          ;get register offset for base address register 0
	mov     di, ax                  ;load register offset to di
	call    read_c_dword            ;read BADR0
	mov     BADR0_REG, ecx          ;save the value returned in ECX
	mov     ecx, OPER_REG           ;
	mov     edx, ecx                ;
	add     dx, OMB1_ADDR           ;
	mov     TEST_OMB1, edx          ;
	mov     edx, ecx                ;
	add     dx, OMB2_ADDR           ;
	mov     TEST_OMB2, edx          ;
	mov     edx, ecx                ;
	add     dx, OMB3_ADDR           ;
	mov     TEST_OMB3, edx          ;
	mov     edx, ecx                ;
	add     dx, OMB4_ADDR           ;
	mov     TEST_OMB4, edx          ;
	mov     edx, ecx                ;
	add     dx, IMB1_ADDR           ;
	mov     TEST_IMB1, edx          ;
	mov     edx, ecx                ;
	add     dx, IMB2_ADDR           ;
	mov     TEST_IMB2, edx          ;
	mov     edx, ecx                ;
	add     dx, IMB3_ADDR           ;
	mov     TEST_IMB3, edx          ;
	mov     edx, ecx                ;
	add     dx, IMB4_ADDR           ;
	mov     TEST_IMB4, edx          ;
	mov     edx, ecx                ;
	add     dx, FIFO_ADDR           ;
	mov     TEST_FIFO, edx          ;
	mov     edx, ecx                ;
	add     dx, MWAR_ADDR           ;
	mov     TEST_MWAR, edx          ;
	mov     edx, ecx                ;
	add     dx, MWTCR_ADDR          ;
	mov     TEST_MWTCR, edx         ;
	mov     edx, ecx                ;
	add     dx, MRAR_ADDR           ;
	mov     TEST_MRAR, edx          ;
	mov     edx, ecx                ;
	add     dx, MRTCR_ADDR          ;
	mov     TEST_MRTCR, edx         ;
	mov     edx, ecx                ;
	add     dx, MBEF_ADDR           ;
	mov     TEST_MBEF, edx          ;
	mov     edx, ecx                ;
	add     dx, INTCSR_ADDR         ;
	mov     TEST_INTCSR, edx        ;
	mov     edx, ecx                ;
	add     dx, BMCSR_ADDR          ;
	mov     TEST_BMCSR, edx         ;
	ret
init_opregs  endp
;********************************************************************
;       PCI BIOS function calls to read and write to configuration
;       registers. 
;
;********************************************************************
;                       READ_C_BYTE
;
;       Read an 8-bit configuration register
;--------------------------------------------------------------------
read_c_byte proc   near           
	push    bx                      ;save register value
	push    ax                      ;
	mov     bh, BUS_NUM             ;load bus number
	mov     bl, DEV_FUNC            ;load device number and function number
	mov     ah, PCI_FUNC_ID         ;load PCI finction id
	mov     al, READ_CONFIG_BYTE    ;load read byte function
	int     1ah                     ;bios interrupt call
	pop     ax                      ;
	pop     bx                      ;restore register value
	jnc     good                    ;if successful return to calling function
good:   ret                             ;return to calling function
read_c_byte endp
;--------------------------------------------------------------------
;                       READ_C_WORD
;
;       Read a 16-bit configuration register
;--------------------------------------------------------------------
read_c_word proc near    
	push    bx                      ;save registers
	push    ax                      ;
	mov     bh, BUS_NUM             ;
	mov     bl, DEV_FUNC            ;load device number and function number
	mov     ah, PCI_FUNC_ID         ;load PCI function id
	mov     al, READ_CONFIG_WORD    ;load read word function
	int     1ah                     ;bios interrupt call
	pop     ax                      ;restore register values
	pop     bx                      ;
	ret
read_c_word endp
;--------------------------------------------------------------------
;                       READ_C_DWORD
;
;       Read a 32-bit configuration register
;--------------------------------------------------------------------
read_c_dword proc near        
	push    bx                      ;save registers
	push    ax                      ;
	mov     bh, BUS_NUM             ;
	mov     bl, DEV_FUNC            ;load device number and function number
	mov     ah, PCI_FUNC_ID         ;load PCI function id
	mov     al, READ_CONFIG_DWORD   ;load read double word function
	int     1ah                     ;bios interrupt call
	pop     ax                      ;restore register values
	pop     bx                      ;
	ret
read_c_dword endp
;--------------------------------------------------------------------
;                       WRITE_C_BYTE
;
;       Write to an 8-bit configuration register
;       Writes out value in cl
;--------------------------------------------------------------------
write_c_byte proc near
	push    ax                      ;save register values
	push    bx                      ;
	mov     ah, PCI_FUNC_ID         ;load function id
	mov     al, WRITE_CONFIG_BYTE   ;load write function value
	mov     bh, BUS_NUM             ;load bus number
	mov     bl, DEV_FUNC            ;load device and function number
	int     1ah                     ;call bios
	pop     bx                      ;restore register values
	pop     ax                      ;
	ret
write_c_byte endp
;--------------------------------------------------------------------
;                       WRITE_C_WORD
;
;       Write to 16-bit configuration register
;       Writes out value in cx
;--------------------------------------------------------------------
write_c_word proc near
	push    bx                      ;save registers
	push    ax                      ;
	mov     ah, PCI_FUNC_ID         ;load function id
	mov     al, WRITE_CONFIG_WORD   ;load write function value
	mov     bh, BUS_NUM             ;load bus number
	mov     bl, DEV_FUNC            ;load device and function number
	int     1ah                     ;call bios
	pop     ax                      ;
	pop     bx                      ;restore register values
	ret                             ;
write_c_word endp
;--------------------------------------------------------------------
;                       WRITE_C_DWORD
;
;       Write to a 32-bit configuration register
;       Writes value in ecx.
;
;--------------------------------------------------------------------
write_c_dword proc near
	push    ax                      ;save register values
	push    bx                      ;
	mov     ah, PCI_FUNC_ID         ;tell BIOS this is a PCI function
	mov     al, WRITE_CONFIG_DWORD  ;tell BIOS what type of PCI function
	mov     bh, BUS_NUM             ;tell BIOS which PCI bus to write to
	mov     bl, DEV_FUNC            ;load device and function number
	int     1ah                     ;call BIOS
	pop     bx                      ;restore register values
	pop     ax                      ;
	ret
write_c_dword endp
;--------------------------------------------------------------------
CSEG    ends    
	END     main

