PAGE 59,79
TITLE SAMPLE PCI BIOS Routine
;
;
PCI_FUNCTION_ID		EQU	0B1H
PCI_BIOS_PRESENT	EQU	001H
FIND_PCI_DEVICE		EQU	002H
FIND_PCI_CLASS_CODE	EQU	003H
GENERATE_SPECIAL_CYCLE	EQU	006H
READ_CONFIG_BYTE	EQU	008H
READ_CONFIG_WORD	EQU	009H
READ_CONFIG_DWORD	EQU	00AH
WRITE_CONFIG_BYTE	EQU	00BH
WRITE_CONFIG_WORD	EQU	00CH
WRITE_CONFIG_DWORD	EQU	00DH
;
SIZE_2K			EQU	04H
VID			EQU	01234H
DID			EQU	05678H
PCI_MASTER		EQU	080H
RD_FIFO_CLK		EQU	040H
WR_FIFO_CLK		EQU	020H
REV_ID			EQU	000H
BASE_CLASS		EQU	0FFH
SUB_CLASS		EQU	000H
PROG_IF			EQU	000H
LATCY_TIME		EQU	0F8H
SELF_TEST		EQU	000H
IO_SIGNATURE		EQU	010E8FFC1H
MEM_SIGNATURE		EQU	010E8FFC0H
EXP_ROM_2K		EQU	0FFFFF800H
INT_LINE		EQU	0FFH
INT_PIN			EQU	001H
MIN_GRNT		EQU	0FFH
MAX_LAT			EQU	000H
BADR1			EQU	03FFFFFC1H
BADR2			EQU	03FFFFFC1H
BADR3			EQU	0FFFFFFC0H
BADR4			EQU	0FFFFFFC1H
;
AMCC_VID		EQU	010E8H
AMCC_DID		EQU	'GP'
;
CSEG	SEGMENT PARA PUBLIC 'CODE'
	ASSUME	CS:CSEG
ENTPT	PROC	FAR
	DB	055H
	DB	0AAH
	DB	SIZE_2K ;
	JMP	INIT_CODE
	ORG	0018H
	DW	0080H
;
; DO NOT MOVE THE FOLLOWING LINES (order sensitive) 
; S593X  BOOT space (040H through 07FH)
	ORG	0040H
VID_LOC:
	DW	VID	; PCI vendor ID for the S5933 goes here
DID_LOC:
	DW	DID	; PCI device ID for the S5933 goes here
	DB	00H		; OFFSET 44H
	DB	PCI_MASTER+RD_FIFO_CLK+WR_FIFO_CLK	; OFFSET 45H
	DW	0000H		; OFFSET 46H, 47H
	DB	REV_ID		; Offset 48h, PCI Revision ID
	DB	PROG_IF		; Offset 49h, PCI Program Interface
	DB	SUB_CLASS
	DB	BASE_CLASS
	DB	000H
	DB	LATCY_TIME
	DB	000H
	DB	SELF_TEST
;	DD	MEM_SIGNATURE *** Note that this is commented out ***
	DD	IO_SIGNATURE   
	DD	BADR1
	DD	BADR2
	DD	BADR3
	DD	BADR4
	DD	0		; space for base address 5
	DD	0		; reserved
	DD	0		; reserved
	DD	EXP_ROM_2K
	DD	0		; reserved
	DD	0		; reserved
	DB	INT_LINE
	DB	INT_PIN
	DB	MIN_GRNT
	DB	MAX_LAT
;	
	ORG	0080H
; Following is an example of a PCI Data structure:
	DB	'PCIR'		
	DW	AMCC_VID
	DW	AMCC_DID
	DW	000H
	DW	018H		; struture length
	DB	000H
	DB	BASE_CLASS	; Class code 
	DB	SUB_CLASS
	DB	REV_ID
	DW	SIZE_2K
	DW	0		; REV LEVEL
	DB	0		; CODE TYPE
	DB	080H		;LAST IMAGE
	DW	000H		; RESERVED
INIT_CODE:
	PUSH	CS
	POP	DS		; set DS=CS
	ASSUME	DS:CSEG
	LEA	SI,PWR_UP_MSG	; Get offset to Power up text messages
	CALL	DIS_STRING
	MOV	AH,PCI_FUNCTION_ID		; PCI_FUNCTION_ID
	MOV	AL,FIND_PCI_DEVICE	;
	LEA	SI,VID_LOC
	MOV	DX,DS:[SI]	; BOOT IMAGE VENDOR ID
	MOV	CX,DS:[SI]+2	; BOOT IMAGE DEVICE ID
	MOV	SI,0		; INDEX OF ZERO (for now)
	INT	1AH
; At this point, we should now know the Bus Number (in BH) and the
; device and function number (ms 5 bits and ls 3 bits of BL).
; This will be used to access other regions of the configuration space,
; such as the base address registers.
;
	CALL	DIS_BX		; now display the BX register as one
				; 4 digit hex string (Bus and function number)
	lea	si,msg_2	; Display message 2
	call	DIS_STRING
	PUSH	CS
	POP	BX
	CALL	DIS_BX		; Output Code segment in hex to screen
	lea	si,msg_3
	call	DIS_STRING	; Display message 3 (Hit any key)
;
;
	MOV	AH,0		
	INT	16H		; Bios Call, Wait for key to be hit
	RETF
;
; Intersegment Return forced here

; ASCII message data area
;
PWR_UP_MSG:	
	DB	10,13,'        AMCC Matchmaker BIOS Program example, Version 1.00'
	db	10,13,'               Copyright, 1994 AMCC ',10,13,10,13
	db	'        This program message signifies that the S5933 controller',10,13
	db	'        has been recognized by the system and is now able to perform',10,13
	db	'        any initialization processing required through use of the host.',10,13
	db	10,13,'        Information about this installation:',10,13,10,13
	db	'              BUS ADDRESS (PCI bus slot):   $'
MSG_2:
	DB	' hex',10,13,10,13
	db	'              CODE segement currently located at: $'
MSG_3:
	DB	' hex',10,13,10,13
	DB	'Hit any key to continue',10,13,'$'
;
DIS_STRING	PROC	NEAR
	MOV	AH,0EH		; BIOS video teletype command
	MOV	BL,07H		; Forground video attribute
MORE_DIS:
	MOV	AL,CS:0+[SI]	; Get character
	CMP	AL,'$'		; test for end of field
	JE	NO_MORE_DIS		; If $, then jump
	INC	SI		; point to next character
	INT	10H		; Display character
	JMP	MORE_DIS	; Loop until $ reached
NO_MORE_DIS:
	RET
	ENDP
;
DIS_BX	PROC	NEAR
;
; This program takes a 16 bit value passed in the BX register and
; displays it on the video screen in hex-ASCII at the current
; screen cursor position.  The original value is preserved in BX.
; Register AX is not preserved.
;
	MOV	AL,BH		; Get MS Byte
	SHR	AL,1	
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	AND	AL,0FH
	OR	AL,030H		; Extract MS Digit and convert to ASCII
	CMP	AL,39H		
	JLE	NC_1		; Skip next inst if numeric 0-9
	ADD	AL,07H		; Need to convert to letters A-F
NC_1:
	PUSH	BX
	MOV	BX,00007H
	MOV	AH,0EH
	INT	10H		; Video write character
	POP	BX		; Get 16 bit value
	MOV	AL,BH		; Get Upper byte
	AND	AL,0FH		; Get lower nibble
	OR	AL,030H		; Convert to hex-ASCII
	CMP	AL,39H		
	JLE	NC_2		; Skip next inst if numeric 0-9
	ADD	AL,07H		; Need to convert to letters A-F
NC_2:
	PUSH	BX
	MOV	BX,00007H
	MOV	AH,0EH
	INT	10H		; Video write character
	POP	BX		; Get 16 bit value
	MOV	AL,BL		; get lower byte
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	AND	AL,0FH
	OR	AL,030H		; Get upper nibble and convert to hex-ASCII
	CMP	AL,39H
	JLE	NC_3		; skip next inst if 0-9
	ADD	AL,07H		; Need to convert to ASCII letters A-F
NC_3:
	PUSH	BX
	MOV	BX,00007H
	MOV	AH,0EH
	INT	10H		; Video write character
	POP	BX		; Get 16 bit value
	MOV	AL,BL		; Get lower byte
	AND	AL,0FH
	OR	AL,030H		; Convert lower nibble to hex-ASCII
	CMP	AL,39H
	JLE	NC_4		; Skip next inst if 0-9
	ADD	AL,07H		; Need to convert to ASCII letters A-F
NC_4:
	PUSH	BX
	MOV	BX,00007H
	MOV	AH,0EH
	INT	10H		; Video write character
	POP	BX
	
	RET			; Done with 16 bit hex-ASCII video write
	ENDP
;
ENTPT	ENDP
;
	ORG	07FFH
; You'll need calculate and place the checksum here....
; the number will be based on the state of the unused portion
; of the nv memory.  The value of 0FFh below was chosen as it
; usually represents the erased state for many nv devices.
;
	DB	0FFH
CSEG	ENDS
;
	END	ENTPT
