PAGE (55,132)
TITLE PCI DIAGNOSTICS

COMMENT *
	APPLIED MICROCIRCUITS CORPORATION
	PCILIB.ASM
	Library file for PCI diagnostic program AMCCDIAG version 1.0
	This file contains menus and screen functions.
*

.386

	extrn	BYTE_VAL:BYTE, WORD_VAL:WORD, DWORD_VAL:DWORD, BYTE3_VAL:DWORD

	public	MAIN_MENU, OPERATION_MENU,ADD_ON_MENU, CONFIGURATION_MENU
	public	CLRSCR, SPACE, CLRSPACE, LINES, CRLF


DSEG    SEGMENT use16    PUBLIC  'DATA'

HEADER 	DB 1BH, '[1;3H', '  APPLIED MICRO CIRCUITS CORPORATION',
        db 1bh, '[2;3H', '  PCI Diagnostics, AMCC copyright 1994','$'

MAIN_MENU db 1bh, '[3;23H', 'AMCC PCI MatchMaker', 
          db 1bh, '[4;21H', '----------------------',
          db 1bh, '[5;20H', '1. Configuration registers',
          db 1bh, '[6;20H', '2. Operation registers',
          db 1bh, '[7;20H', '3. Run Diagnostics',
          db 1bh, '[8;20H', 'q. exit program',
          db '$'

OPERATION_MENU db 1bh, '[1;10H', '        Operation Registers', 
  db 1bh, '[2;10H', 'R - read,  W - write, ESC - main menu',
  db 1bh, '[4;2H',  'OMB1   : ',  1bh, '[4;30H',  'FIFO    : ', 
  db 1bh, '[5;2H',  'OMB2   : ',  1bh, '[5;30H',  'MWAR    : ', 
  db 1bh, '[6;2H',  'OMB3   : ',  1bh, '[6;30H',  'MWTCR   : ',  
  db 1bh, '[7;2H',  'OMB4   : ',  1bh, '[7;30H',  'MRAR    : ', 
  db 1bh, '[8;2H',  'IMB1   : ',  1bh, '[8;30H',  'MRTCR   : ', 
  db 1bh, '[9;2H',  'IMB2   : ',  1bh, '[9;30H',  'MBEF    : ', 
  db 1bh, '[10;2H', 'IMB3   : ',  1bh, '[10;30H',  'INTCSR  : ', 
  db 1bh, '[11;2H', 'IMB4   : ',  1bh, '[11;30H',  'BMCSR   : ', '$' 


ADD_ON_MENU db 1bh, '[15;10H', '        ADD-ON Operation Registers',
  db 1bh, '[16;2H', 'AIMB1  : ',  1bh, '[16;30H',  'AFIFO   : ', 
  db 1bh, '[17;2H', 'AIMB2  : ',  1bh, '[17;30H',  'AMWAR   : ', 
  db 1bh, '[18;2H', 'AIMB3  : ',  1bh, '[18;30H',  'APTA    : ',  
  db 1bh, '[19;2H', 'AIMB4  : ',  1bh, '[19;30H',  'APTD    : ', 
  db 1bh, '[20;2H', 'AOMB1  : ',  1bh, '[20;30H',  'AMRAR   : ', 
  db 1bh, '[21;2H', 'AOMB2  : ',  1bh, '[21;30H',  'AMBEF   : ', 
  db 1bh, '[22;2H', 'AOMB3  : ',  1bh, '[22;30H',  'AINT    : ', 
  db 1bh, '[23;2H', 'AOMB4  : ',  1bh, '[23;30H',  'AGCSTS  : ', 
  db 1bh, '[24;2H', 'MWTCR  : ',  1bh, '[24;30H',  'MRTCR   : ', '$' 

CONFIGURATION_MENU db 1bh, '[1;10H', '   Configuration Registers', 
  db 1bh, '[2;10H', 'R - read,  W - write, ESC - main menu',
  db 1bh, '[4;2H', 'VID    : ',  1bh, '[4;30H',  'BADR1    : ', 
  db 1bh, '[5;2H', 'DID    : ',  1bh, '[5;30H',  'BADR2    : ', 
  db 1bh, '[6;2H', 'CMD    : ',  1bh, '[6;30H',  'BADR3    : ',  
  db 1bh, '[7;2H', 'STS    : ',  1bh, '[7;30H',  'BADR4    : ', 
  db 1bh, '[8;2H', 'RID    : ',  1bh, '[8;30H',  'BADR5    : ', 
  db 1bh, '[9;2H', 'CLCD   : ',  1bh, '[9;30H',  'EXROM    : ', 
  db 1bh, '[10;2H', 'CALN   : ', 1bh, '[10;30H', 'INTLN    : ', 
  db 1bh, '[11;2H', 'LAT    : ', 1bh, '[11;30H', 'INTPIN   : ', 
  db 1bh, '[12;2H', 'HDR    : ', 1bh, '[12;30H', 'MINGNT   : ', 
  db 1bh, '[13;2H', 'BIST   : ', 1bh, '[13;30H', 'MAXLAT   : ', 
  db 1bh, '[14;2H', 'BADR_0 : ', '$'


;Variables
;Screen process variables

CLRSCR      db 1bh, '[2J', '$'		;escape sequence to clear the screen
SPACE       db '   ','$'		;spaces between text
CLRSPACE    db '          ', '$'	;clears text on the screen
LINES       db 5 dup (0ah), 0dh, '$'	;skips 5 lines down
CRLF        db 0DH,0AH, '$'		;adds carriage return and line feed
DSEG    ENDS
;-----------------------------------------------------------

	public	input, go_dos, string, readcur, setcur, place_cur
	public	print_byte, print_word, print_3bytes, print_dword
	public	showbyte, clear_screen

CSEG    SEGMENT use16    PUBLIC  'CODE'
	ASSUME  CS:CSEG,DS:DSEG,ES:DSEG,SS:DSEG


;--------------------------------------------------------------------
;                       PRINT_BYTE
;
;       Prints one byte of data to the screen.
;	INPUT: BYTE_VAL
;--------------------------------------------------------------------
print_byte proc   near
	mov     cl, 02h         ;number of nibbles to print
	mov     dl, BYTE_VAL    ;move saved register contents to dl
	and     dl, 0f0h        ;mask off lower nibble
	ror     dl, 01          ;rotate to print the upper nibble
	ror     dl, 1           ;
	ror     dl, 1           ;
	ror     dl, 1           ;
pr:	cmp     dl, 09h        	;check if it is a number
	jg      pl              ;if it is a letter go print it
	add     dl, 30h         ;it is a number, add ascii bias
	call    showbyte        ;print it to the screen
	dec     cl              ;one nibble has been printed
	cmp     cl, 0h          ;check if both nibbles have been printed
	jz      gb2             ;if this was second nibble go back 
	jmp     upr_nib         ;if not go print the lower nibble
pl:	add     dl, 37h         ;add ascii bias to letter
	call    showbyte        ;print it
	dec     cl              ;one nibble has been printed
	cmp     cl, 0h          ;check if both nibbles have been printed
	jz      gb2             ;if this was second nibble go back
upr_nib: mov    dl, BYTE_VAL    ;if not move register value to dl to print lower nibble
	and     dl, 0fh         ;mask off upper nibble
	jmp     pr              ;go print the next nibble
gb2:    ret
print_byte endp
;--------------------------------------------------------------------
;                       PRINT_WORD
;
;       Print a 16-bit value to the screen
;--------------------------------------------------------------------
print_word proc near
	push    ax			;save register values
	push	cx			;
	push    dx			;
	mov	cx, WORD_VAL		;
	mov     BYTE_VAL, ch       	;move upper byte to pass to print function
	call    print_byte         	;go print the upper byte
	mov     cx, WORD_VAL       	;restore the register value (saved in calling function)
	mov     BYTE_VAL, cl       	;move lower byte to pass to print function
	call    print_byte         	;go print the lower byte
	pop     dx			;
	pop	cx			;restore register values
	pop     ax			;
	ret
print_word endp
;--------------------------------------------------------------------
;                      PRINT_3BYTES
;
;       Print 24-bit register (class code) to the screen
;--------------------------------------------------------------------
print_3bytes  proc near
	push    bx		;save register values
	push    dx		;
	mov	ecx, DWORD_VAL	;
	push	ecx		;push double word value
	pop	dx		;pop low word
	pop	cx		;high word
	mov	WORD_VAL, cx 	;move high word to print it
	push	dx		;save the low word
	call	print_word	;print the high word
	pop	cx		;bring back low word
	xchg	cl, ch		;only need the upper byte
	mov	BYTE_VAL, cl	;move byte to be printed
	call	print_byte	;go print it
	pop     dx		;restore register values
	pop     bx		;
	ret
print_3bytes  endp
;--------------------------------------------------------------------
;                       PRINT_DWORD
;
;       Print a 32-bit value to the screen
;--------------------------------------------------------------------
print_dword proc near
	push    ax		;save register values
	push    bx		;
	push    dx		;
	mov	ecx, DWORD_VAL	;move value to be printed to ecx
	push	ecx		;push value to be printed
	pop	dx		;pop the low word
	pop	cx		;pop the high word
	mov	WORD_VAL, cx	;move the high word to print it
	push	dx		;save the low word
	call	print_word	;go print the high word
	pop	cx		;pop the low word
	mov	WORD_VAL, cx	;move the low word to print it
	call	print_word	;go print the low word
	pop     dx		;restore register values
	pop     bx		;
	pop     ax		;
	ret
print_dword endp
;--------------------------------------------------------------------
;			PLACE_CUR
;
;	Place cursor at desired column
;--------------------------------------------------------------------
place_cur proc near
	call	readcur		;read cursor position
	mov	dl, bl		;get new column number
	call	setcur		;move the cursor to the new position
	ret
place_cur endp
;--------------------------------------------------------------------
;                       SHOW_BYTE
;
;       Prints one byte of data to the screen
;	INPUT: register DL
;--------------------------------------------------------------------
showbyte proc   near
	push    ax                 ;preserve register contents
	push    dx                 ;
	mov     ah, 02h            ;load DOS print character function
	int     21h                ;call DOS interrupt
	pop     dx                 ;restore register contents
	pop     ax                 ;
	ret                        ;return to calling function
showbyte endp
;--------------------------------------------------------------------
;			CLEAR_SCREEN
;--------------------------------------------------------------------
clear_screen  proc  near
	push	edx		;save the register
	push	eax		;save the register
	lea	dx, clrscr	;load clear screen escape sequence
	call	string		;
	pop	eax		;restore register
	pop	edx		;restore register
	ret
clear_screen  endp
;--------------------------------------------------------------------
;                       INPUT
;
;       Accept a character from the keyboard
;
;--------------------------------------------------------------------
INPUT   PROC    NEAR
	MOV     AH,07H		;load input character function
	INT     21H		;call DOS interrupt
	RET
INPUT   ENDP
;--------------------------------------------------------------------
;                       GO_DOS
;
;       Exit the program and return to DOS
;
;--------------------------------------------------------------------
GO_DOS  PROC    NEAR
       MOV     AH,4CH		;
       MOV     AL,01H		;load exit value into ax
       INT     21H              ;call DOS interrupt
       RET
GO_DOS  ENDP
;--------------------------------------------------------------------
;                       STRING
;
;       Print a string of characters
;
;--------------------------------------------------------------------
STRING  PROC    NEAR
	push    ax		;preserve register values
	push    dx		;
	MOV     AH,09H		;load DOS print string function
	INT     21H		;call DOS interrupt
	pop     dx		;restore register values
	pop     ax		;
	RET
STRING  ENDP
;--------------------------------------------------------------------
;			READCUR
;
;	Read the cursor position
;--------------------------------------------------------------------
readcur proc	near
	mov	ah, 3		;load read position function number
	mov	bh, 0		;load text page number (current)
	int	10h		;call bios
	ret
readcur endp
;--------------------------------------------------------------------
;			SETCUR
;
;	Set the new cursor position
;--------------------------------------------------------------------
setcur	proc	near
	push	ax		;save register values
	push	bx		;
	mov	ah, 2		;load set position function number
	mov	bh, 0		;load text page number (current)
	int	10h		;call bios
	pop	bx		;restore register values
	pop	ax		;
	ret
setcur	endp
;--------------------------------------------------------------------

CSEG    ENDS
	END

