#!/usr/bin/sh

CMD=`echo $0 | sed 's/[^/]*$//g'`"pindexcp.sh"
root='/cdrom/models/'

version='1.0'

action=''
target=''
menu=true

MAXFILES=50

while getopts abf:hp:s:v option
do
	case "$option"
	in
		a)	action="about"
			menu=false;;
		b)	action="browse"
			menu=false;;
		f)	if [ "$OPTARG" -le 0 ]
			then
				echo "Invlid MAXFILES value \"$MAXFILES\" specified. Ignored."
			else
				MAXFILES=$OPTARG	
			fi;;
		h)	echo "Usage: pindex [-b] [-h] [-p path] [-s base_number] [-v]"
			echo "	-h : get usage information for EADS Index (this text)"
			echo " "
			echo "	-b : start EADS Index in browser mode"
			echo "	-p : specify the the path to the root of the EADS CDROM"
			echo "	     (current = $root )"
			echo "	-s : start EADS Index in seach mode and search for \"base_number\""
			echo "	     examples: 40120, 123456, 754123"
			echo "	-v : get the version of this EADS Index"
			echo ""
			echo "Runiing pindex with no parameters invokes the index's interactive mode."
			echo ""
			exit 1;;
		p)	root=$OPTARG
			if [ -d "$OPTARG" ]
			then
				root=`dirname $OPTARG//TEMP`/
			else
				echo "Invalid path \"$root\" specified. Ignored."
			fi;;
		s)	action="search"
			target=$OPTARG
			if [ "$target" = '' ]
			then
				echo "Error: No search string supplied."
				exit 1
			fi
			menu=false;;
		v)	echo "AMP EADS Index Version $version"
			echo "(c)Copyright 1995-1997 AMP Incorporated"
			exit 1;;
	esac

done


while true
do
	if [ "$menu" = true ]
	then
		clear
	fi
	if [ "$menu" = true ]
	then
		echo ""
		echo "EADS Index: Main Menu"
		echo "---- ------ ---- ----"
		echo "Currently Search/Browse Directory:"
		echo "[$root]"
		echo ""
		echo "S)earch for a part by base number"
		echo "B)rowse the Index"
		echo ""
		echo "H)elp for Searching and Browsing"
		echo "A)bout EADS Modeling Services"
		echo ""
		echo "---"
		echo "Q)uit the EADS Index"
		echo ""
		echo ""
	
		echo "Selection: \c"
		read selection

		case "$selection"
		in
			[Aa])	action="about";;
			[Bb])	action="browse";;
			[Hh?])	action="help";;
			[Ss])	action="search"
				echo ""
				echo "Enter base number: \c"
				read target;;
			[Qq])	exit 0;;
			*)	echo "Invalid Selection"
				echo "";;
		esac
	fi

	if [ "$action" = about ]
	then
		echo "EADS Modeling Services about information."

	fi

	if [ "$action" = browse ]
	then
		while true 
		do
			while true 
			do
				echo "$root:"
				counter=1
				files=`ls -1 $root`
				filecount=`ls -1 $root | wc -l`
				if [ "$filecount" -gt "$MAXFILES" ]
				then
					echo "$filecount entries exist in this directory."
					echo "Would you like to return to the main menu, making this your active directory? [y/n]: \c"
					read selection
					case "$selection"
					in
						[Yy])	break 2;;
					esac
				fi
				echo ""
				echo "1) .. [parent directory]"
				for file in $files
				do
					counter=`expr $counter + 1`
					if [ -d "$root$file" ]
					then
						echo "$counter) $file/"
					else
						echo "$counter) $file"
					fi
				done
				echo ""
				echo "0) Quit browse mode"	
				echo ""
				echo "Selection: \c"
				read selection
				if [ "$selection" -gt 0 -a "$selection" -le "$counter" -o "$selection" -eq 0 ]
				then
					break
				else
					echo "Invalid selection"
					echo ""
				fi
			done
			if [ "$selection" -eq 0 ]
			then
				break
			fi
			if [ "$selection" -eq 1 ]
			then
				root=`dirname $root`
				root="$root/"
			else
				counter=1
				for file in $files
				do
					counter=`expr $counter + 1`
					if [ "$counter" -eq "$selection" ]
					then
						if [ -f "$root$file" ]
						then
							"$CMD $root$file"
						else
							root="$root$file/"
							break
						fi
					fi
				done
			fi
		done
	fi

	if [ "$action" = help ]
	then
		echo " "
		echo " "
		echo "Overview"
		echo "--------"
		echo " "
		echo "Browse: This function allows the user to \"walk through\" the directories."
		echo "        It is most useful when the user is aware of the product-type that"
		echo "        they need, but not the exact part number."
		echo " "
		echo "Search: This function allows the user to search from the current directory"
		echo "        down through all sub=directories for a specific part number."
		echo " "
		echo " "
		echo "<Press ENTER to continue> \c"
		read nothing
	fi

	if [ "$action" = search ]
	then
		find "$root" -name "*$target*.gz" -exec $CMD {} \;

	fi

	if [ "$menu" = false ]
	then
		exit 0
	fi
done
