/*==========================================================================
  GPRBLIT.C

  Example code to perform a general pattern blit with rotation.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int srcx, srcy, srcwidth, srcheight;
    int dstx, dsty, dstwidth, dstheight;
    int srcpatx, srcpaty, srcpatwidth, srcpatheight;
    unsigned long rotation;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf("Error in setting display mode.\n");
        return (1);
    }

    // initialize standard engine context
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Setup dimensions of source, source pattern size and destination

    // main source rectangle
    srcx = modeinfo.xres / 64;
    srcy = modeinfo.yres / 48;
    srcwidth = modeinfo.xres / 16;
    srcheight = modeinfo.yres / 12;

    // rotation source rectangle offset and size referenced to the main
    //   rectangle
    srcpatx = modeinfo.xres / 80;
    srcpaty = modeinfo.yres / 60;
    srcpatwidth = modeinfo.xres / 40;
    srcpatheight = modeinfo.yres / 30;

    // destination rectangle to be filled from the source
    dstx = modeinfo.xres / 6;
    dsty = modeinfo.yres / 10;
    dstwidth = modeinfo.xres / 4;
    dstheight = modeinfo.yres / 3;


    /* ---- Draw a source made up from several filled rectangles ---- */

    set_fg_color (get_color_code (WHITE));
    draw_rectangle (srcx, srcy, srcwidth, srcheight);

    set_fg_color (get_color_code (LIGHTBLUE));
    draw_rectangle (srcx + (modeinfo.xres / 160),
                    srcy + (modeinfo.yres / 120),
                    srcwidth - (2 * (modeinfo.xres / 160)),
                    srcheight - (2 * (modeinfo.yres / 120)));

    set_fg_color (get_color_code (LIGHTGREEN));
    draw_rectangle (srcx + (2 * (modeinfo.xres / 160)),
                    srcy + (2 * (modeinfo.yres / 120)),
                    srcwidth - (4 * (modeinfo.xres / 160)),
                    srcheight - (4 * (modeinfo.yres / 120)));

    set_fg_color (get_color_code (LIGHTRED));
    draw_rectangle (srcx + (3 * (modeinfo.xres / 160)),
                    srcy + (3 * (modeinfo.yres / 120)),
                    srcwidth - (6 * (modeinfo.xres / 160)),
                    srcheight - (6 * (modeinfo.yres / 120)));


    /* ---- Draw a general pattern blit with rotation ---- */

    // The general pattern blit allows the source to wrap in the X & Y
    // directions while continuing to draw to the destination. This is
    // similiar to the general pattern blit without rotation except the
    // rectangle defined by SRC_X, SRC_Y, SRC_WIDTH1, and SRC_HEIGHT1
    // is drawn first. After this, the source will follow the rectangle
    // defined by SRC_X_START, SRC_Y_START, SRC_WIDTH2, and SRC_HEIGHT2.

    // adjust for 24 bpp if required
    if (modeinfo.bpp == 24)
    {
        rotation = GET24BPPROTATION (dstx);

        srcx = srcx * 3;
        srcwidth = srcwidth * 3;
        srcpatx = srcpatx * 3;
        srcpatwidth = srcpatwidth * 3;
        dstx = dstx * 3;
        dstwidth = dstwidth * 3;
    }

    // Setup for color blit:
    //
    //    The monochrome path controls which source channel is used to read
    //    the source data. If the monochrome path is "1", the foreground
    //    channel is selected as the source; if the monochrome path is "0",
    //    the background channel is selected. In this case, the monochrome
    //    path will be set to "1".
    //
    wait_for_fifo (15);
    regw (DP_SRC, MONO_SRC_ONE | FRGD_SRC_BLIT);

    // Use general pattern with rotation for source:
    //
    //    This implies that the destination rectangle can be a different
    //    size than the source rectangle - in this example, the destination
    //    rectangle is larger.
    //
    regw (SRC_CNTL, SRC_ROTATION_ENABLE | SRC_PATTERN_ENABLE);

    // set rotated and non-rotated source start coordinates and sizes
    regw (SRC_X, srcx + srcpatx);
    regw (SRC_Y, srcy + srcpaty);
    regw (SRC_HEIGHT1, srcheight - srcpatheight);
    regw (SRC_WIDTH1, srcwidth - srcpatwidth);
    regw (SRC_X_START, srcx);
    regw (SRC_Y_START, srcy);
    regw (SRC_HEIGHT2, srcheight);
    regw (SRC_WIDTH2, srcwidth);

    // set destination draw destination
    if (modeinfo.bpp == 24)
    {
        // set rotation value if CRTC is in 24 bpp - the correct rotation
        // value will insure that the engine will draw the correct colors
        regw (DST_CNTL, DST_24_ROTATION_ENABLE |
                        (rotation << 8) |
                        DST_Y_TOP_TO_BOTTOM | DST_X_LEFT_TO_RIGHT);
    }
    else
    {
        regw (DST_CNTL, DST_Y_TOP_TO_BOTTOM | DST_X_LEFT_TO_RIGHT);
    }

    // set destination start coordinate and rectangle size to fill
    regw (DST_X, dstx);
    regw (DST_Y, dsty);
    regw (DST_HEIGHT, dstheight);
    regw (DST_WIDTH, dstwidth);      // this write initiates the operation

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

