/*==========================================================================
  CURSOR.C

  Example code to show setup, enabling, and disabling of the hardware cursor.
  This is a static sample. The cursor is a comprised of four square region,
  each region showing one of the four cursor attributes. If the DAC type is
  an IBM514, the DAC cursor is used and the cursor bitmap data is uploaded
  directly to the DAC. Otherwise, the cursor data is blitted onto onscreen
  video memory and will appear as a line of data near the bottom of the
  screen.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

/* 8x8 Cursor bitmap - 8 x 1 word/line */
unsigned int cursor8x8[8] =
{
    0x0000,
    0x3FFC,
    0x355C,
    0x369C,
    0x369C,
    0x355C,
    0x3FFC,
    0x0000
};

/* 16x16 Cursor bitmap - 16 x 2 words/line */
unsigned int cursor16x16[32] =
{
    0x0000, 0x0000,
    0x0000, 0x0000,
    0xFFF0, 0x0FFF,
    0xFFF0, 0x0FFF,
    0x55F0, 0x0F55,
    0x55F0, 0x0F55,
    0xA5F0, 0x0F5A,
    0xA5F0, 0x0F5A,
    0xA5F0, 0x0F5A,
    0xA5F0, 0x0F5A,
    0x55F0, 0x0F55,
    0x55F0, 0x0F55,
    0xFFF0, 0x0FFF,
    0xFFF0, 0x0FFF,
    0x0000, 0x0000,
    0x0000, 0x0000
};


/* 32x32 Cursor bitmap - 32 x 4 words/line */
unsigned int cursor32x32[128] =
{
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0xAA55, 0x55AA, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0x5555, 0x5555, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0xFF00, 0xFFFF, 0xFFFF, 0x00FF,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000
};

/* 64x64 Cursor bitmap - 64 x 8 words/line */
unsigned int cursor64x64[512] =
{
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0xAAAA, 0xAAAA, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0x5555, 0x5555, 0x5555, 0x5555, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};


/* Main C program */

int main (int argc, char *argv[])
{
    // Check if the mach64 adapter is installed.
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf("mach64 based adapter was not found.\n");
        return (1);
    }

    // Fill the global query structure by calling the mach64 ROM.
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // Setup the engine context and clear the screen.
    init_engine ();

    // Paint the screen with DARKRED.
    set_fg_color (get_color_code (DARKRED));
    draw_rectangle (0, 0, modeinfo.xres, modeinfo.yres);

    // The hardware cursor definition requires 2 bits per pixel. The cursor
    // size regardless of the visible cursor size is 64 pixels x 64 lines.
    // The total memory required to define the cursor is 16 bytes / line
    // for 64 lines or 1024 bytes of data. The data must be in a contigious
    // format. The 2 bit cursor code values are as follows:
    //
    //   00 - pixel color = CURSOR_COLOR_0
    //   01 - pixel color = CURSOR_COLOR_1
    //   10 - pixel color = transparent (current display pixel)
    //   11 - pixel color = 1's complement of current display pixel


    // ---- Use 16 bpp to draw the cursor data information. ----
    //
    // By programming the starting address ('offset'), all destination draw
    // operations will start at this address. This is useful for setting up
    // data that is resolution and color depth independent.

    // The cursor data area will be first filled with 'transparent code'
    // data. Cursor data that is transparent will not be visible when the
    // hardware cursor is enabled. Secondly, the cursor pattern will be drawn
    // to the appropriate area within the cursor data area. Note that the
    // cursor data is in linearized format. It can be thought of as a
    // rectangle whose lines are joined contigiously together in memory.

    // Setup a 32x32 hardware cursor and set the cursor's hot spot to the
    // center of the cursor. The cursor data will be visible at the bottom
    // of the screen.
    set_hwcursor (modeinfo.yres - 10, 32, 32, 16, 16,
                  get_color_code (LIGHTBLUE), get_color_code (YELLOW),
                  cursor32x32);

    // Set the hardware cursor's hot spot to the center of the screen.
    set_hwcursor_pos ((modeinfo.xres / 2) - (32 / 2),
                      (modeinfo.yres / 2) - (32 / 2));

    // Enable the hardware cursor.
    enable_hwcursor ();

    // Wait for a carriage return.
    getch ();

    // Set the hardware cursor's hot spot to the upper left corner of
    // the screen.
    set_hwcursor_pos (0, 0);

    // Wait for a carriage return.
    getch ();

    // Set the hardware cursor's hot spot to the lower right corner of
    // the screen.
    set_hwcursor_pos (modeinfo.xres - 1, modeinfo.yres - 1);

    // wait for a carriage return
    getch ();

    // Disable the hardware cursor.
    disable_hwcursor ();

    // Wait for a carriage return.
    getch ();

    // Disable the accelerator mode and switch back to VGA text mode.
    close_mode ();

    return (0);
}

