/*==========================================================================
  FIXPAT.C

  Example code to show MACH64 fixed patterns - 8x8 mono, 4x2 color, 8x1 color

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // initialize standard engine context
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    /* ---- 8x8 mono pattern ---- */

    // Draw a rectangle filled with an 8x8 monochrome fixed pattern:
    //
    //    A rectangle of size (width1, height1) is drawn at (x1, y1) and
    //    is filled by a color expanded 8x8 monochrome fixed pattern via
    //    the pattern registers. Wrapping is supported.
    //

    // Pattern orientation is determined by the DP_BYTE_PIXEL_ORDER bit in
    // the DP_PIX_WIDTH register. The default in this example is LSB to MSB.

    // mono source       = mono 8x8 fixed pattern,
    // foreground source = foreground color,
    // background source = background color
    //

    // set mono source to pattern, color source to foreground color
    wait_for_fifo (1);
    regw (DP_SRC, MONO_SRC_PATTERN | FRGD_SRC_FRGD_CLR | BKGD_SRC_BKGD_CLR);

    // set foreground and background mix to source (overpaint)
    set_fg_mix (S_MIX);
    set_bg_mix (S_MIX);

    // enable 8x8 mono fixed pattern
    wait_for_fifo (3);
    regw (PAT_CNTL, PAT_MONO_8x8_ENABLE);

    // this is an 8x8 monochrome pattern of a box with a border
    regw (PAT_REG0, 0x818181FF);
    regw (PAT_REG1, 0xFF818181);

    // setup foreground and background colors:
    //
    //    foreground color is used when pattern bit is "1"
    //    background color is used when pattern bit is "0"
    //
    set_fg_color (get_color_code (WHITE));
    set_bg_color (get_color_code (LIGHTMAGENTA));

    // draw a filled pattern rectangle
    draw_rectangle (0, 0, modeinfo.xres / 40, modeinfo.yres / 30);

    // color patterns are only supported in 8 bpp modes
    if (modeinfo.bpp == 8)
    {
        // Draw a rectangle filled with an 4x2 color fixed pattern:
        //
        //    A rectangle of size (width2, height2) is drawn at (x2, y2) and
        //    is filled by a color 4x2 fixed pattern via the pattern registers.
        //    Note that this fixed pattern is only available in 8bpp modes.
        //    Wrapping is supported.
        //

        // Pattern direction is LSB to MSB for both color pattern modes


        /* ---- 4x2 color pattern - only available in 8 bpp modes ---- */

        // foreground source = color pattern
        wait_for_fifo (4);
        regw (DP_SRC, FRGD_SRC_PATTERN);

        // enable 4x2 color pattern
        regw (PAT_CNTL, PAT_CLR_4x2_ENABLE);

        // setup 4x2 8 bpp color pattern
        // 0x09 - LIGHTBLUE, 0x0F - WHITE in 8bpp mode - strip pattern
        regw (PAT_REG0, 0x0F09090F);
        regw (PAT_REG1, 0x0F09090F);

        // draw a filled pattern rectangle
        draw_rectangle (modeinfo.xres / 20, 0,
                        modeinfo.xres / 20, modeinfo.yres / 30);


        /* ---- 8x1 color pattern - only available in 8 bpp modes ---- */

        // Draw a rectangle filled with an 8x1 color fixed pattern:
        //
        //    A rectangle of size (width3, height3) is drawn at (x3, y3) and
        //    is filled by a color 8x1 fixed pattern via the pattern registers.
        //    Note that this fixed pattern is only available in 8bpp modes.
        //    Wrapping is supported.
        //

        // DP_SRC is set to FRGD_SRC_PATTERN in the 4x2 color pattern setup

        // enable 8x1 color pattern
        wait_for_fifo (3);
        regw (PAT_CNTL, PAT_CLR_8x1_ENABLE);

        // setup 8x1 color pattern
        // 0x0C - LIGHTRED, 0x0E - YELLOW in 8bpp - strip pattern
        regw (PAT_REG0, 0x0C0C0C0E);
        regw (PAT_REG1, 0x0E0C0C0C);

        // draw a filled pattern rectangle
        draw_rectangle (modeinfo.xres / 8, 0,
                        modeinfo.xres / 20, modeinfo.yres / 30);
    }

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    if (modeinfo.bpp != 8)
    {
        printf ("The 4x2 and 8x1 color patterns are only supported in 8 bpp "
                "modes.\n");
    }

    return (0);
}

