/*===========================================================================
  ATIM64.H

  C include file that contains ATI MACH64 register definitions

  Copyright (c) 1993-94 ATI Technologies Inc.  All rights reserved
 ===========================================================================*/

/* NON-GUI IO MAPPED Registers - BYTE offset */

// Base I/O Address:         BYTE offset,  0x02EC, 0x01C8, 0x01CC, High 6 bits

#define ioCRTC_H_TOTAL_DISP     0x0000  // 0x02EC, 0x01C8, 0x01CC, 0x0000
#define ioCRTC_H_SYNC_STRT_WID  0x0400  // 0x06EC, 0x05C8, 0x05CC, 0x0001
#define ioCRTC_V_TOTAL_DISP     0x0800  // 0x0AEC, 0x09C8, 0x09CC, 0x0002
#define ioCRTC_V_SYNC_STRT_WID  0x0C00  // 0x0EEC, 0x0DC8, 0x0DCC, 0x0003
#define ioCRTC_VLINE_CRNT_VLINE 0x1000  // 0x12EC, 0x11C8, 0x11CC, 0x0004
#define ioCRTC_OFF_PITCH        0x1400  // 0x16EC, 0x15C8, 0x15CC, 0x0005
#define ioCRTC_INT_CNTL         0x1800  // 0x1AEC, 0x19C8, 0x19CC, 0x0006
#define ioCRTC_GEN_CNTL         0x1C00  // 0x1EEC, 0x1DC8, 0x1DCC, 0x0007

#define ioOVR_CLR               0x2000  // 0x22EC, 0x21C8, 0x21CC, 0x0008
#define ioOVR_WID_LEFT_RIGHT    0x2400  // 0x26EC, 0x25C8, 0x25CC, 0x0009
#define ioOVR_WID_TOP_BOTTOM    0x2800  // 0x2AEC, 0x29C8, 0x29CC, 0x000A

#define ioCUR_CLR0              0x2C00  // 0x2EEC, 0x2DC8, 0x2DCC, 0x000B
#define ioCUR_CLR1              0x3000  // 0x32EC, 0x31C8, 0x31CC, 0x000C
#define ioCUR_OFFSET            0x3400  // 0x36EC, 0x35C8, 0x35CC, 0x000D
#define ioCUR_HORZ_VERT_POSN    0x3800  // 0x3AEC, 0x39C8, 0x39CC, 0x000E
#define ioCUR_HORZ_VERT_OFF     0x3C00  // 0x3EEC, 0x3DC8, 0x3DCC, 0x000F

#define ioSCRATCH_REG0          0x4000  // 0x42EC, 0x41C8, 0x41CC, 0x0010
#define ioSCRATCH_REG1          0x4400  // 0x46EC, 0x45C8, 0x45CC, 0x0011

#define ioCLOCK_CNTL            0x4800  // 0x4AEC, 0x49C8, 0x49CC, 0x0012
#define ioCLOCK_SEL_CNTL        0x4800  // 0x4AEC, 0x49C8, 0x49CC, 0x0012

#define ioBUS_CNTL              0x4C00  // 0x4EEC, 0x4DC8, 0x4DCC, 0x0013

#define ioMEM_CNTL              0x5000  // 0x52EC, 0x51C8, 0x51CC, 0x0014
#define ioMEM_VGA_WP_SEL        0x5400  // 0x56EC, 0x55C8, 0x55CC, 0x0015
#define ioMEM_VGA_RP_SEL        0x5800  // 0x5AEC, 0x59C8, 0x59CC, 0x0016

#define ioDAC_REGS              0x5C00  // 0x5EEC, 0x5DC8, 0x5DCC, 0x0017
#define ioDAC_CNTL              0x6000  // 0x62EC, 0x61C8, 0x61CC, 0x0018

#define ioGEN_TEST_CNTL         0x6400  // 0x66EC, 0x65C8, 0x65CC, 0x0019

#define ioCONFIG_CNTL           0x6800  // 0x6AEC, 0x69C8, 0x69CC, 0x001A
#define ioCONFIG_CHIP_ID        0x6C00  // 0x6EEC, 0x6DC8, 0x6DCC, 0x001B
#define ioCONFIG_STAT0          0x7000  // 0x72EC, 0x71C8, 0x71CC, 0x001C
#define ioCONFIG_STAT1          0x7400  // 0x76EC, 0x75C8, 0x75CC, 0x001D (GX/CX)
#define ioCRC_SIG               0x7400  // 0x76EC, 0x75C8, 0x75CC, 0x001D (CT/DT)

#define ioCRTC_H_TOTAL_DISP_ALIAS 0x7C00  // 0x7EEC, 0x7DC8, 0x7DCC, 0x001F


/* NON-GUI MEMORY MAPPED Registers - expressed in BYTE offsets */

#define CRTC_H_TOTAL_DISP       0x0000  // Dword offset 00
#define CRTC_H_SYNC_STRT_WID    0x0004  // Dword offset 01
#define CRTC_V_TOTAL_DISP       0x0008  // Dword offset 02
#define CRTC_V_SYNC_STRT_WID    0x000C  // Dword offset 03
#define CRTC_VLINE_CRNT_VLINE   0x0010  // Dword offset 04
#define CRTC_OFF_PITCH          0x0014  // Dword offset 05
#define CRTC_INT_CNTL           0x0018  // Dword offset 06
#define CRTC_GEN_CNTL           0x001C  // Dword offset 07

#define OVR_CLR                 0x0040  // Dword offset 10
#define OVR_WID_LEFT_RIGHT      0x0044  // Dword offset 11
#define OVR_WID_TOP_BOTTOM      0x0048  // Dword offset 12

#define CUR_CLR0                0x0060  // Dword offset 18
#define CUR_CLR1                0x0064  // Dword offset 19
#define CUR_OFFSET              0x0068  // Dword offset 1A
#define CUR_HORZ_VERT_POSN      0x006C  // Dword offset 1B
#define CUR_HORZ_VERT_OFF       0x0070  // Dword offset 1C

#define SCRATCH_REG0            0x0080  // Dword offset 20
#define SCRATCH_REG1            0x0084  // Dword offset 21

#define CLOCK_CNTL              0x0090  // Dword offset 24
#define CLOCK_SEL_CNTL          0x0090  // Dword offset 24

#define BUS_CNTL                0x00A0  // Dword offset 28

#define MEM_CNTL                0x00B0  // Dword offset 2C

#define MEM_VGA_WP_SEL          0x00B4  // Dword offset 2D
#define MEM_VGA_RP_SEL          0x00B8  // Dword offset 2E

#define DAC_REGS                0x00C0  // Dword offset 30
#define DAC_CNTL                0x00C4  // Dword offset 31

#define GEN_TEST_CNTL           0x00D0  // Dword offset 34

#define CONFIG_CNTL             0x00DC  // Dword offset 37 (GX rev F+)
#define CONFIG_CHIP_ID          0x00E0  // Dword offset 38
#define CONFIG_STAT0            0x00E4  // Dword offset 39
#define CONFIG_STAT1            0x00E8  // Dword offset 3A (GX/CX)
#define CRC_SIG                 0x00E8  // Dword offset 3A (CT/DT)


/* GUI MEMORY MAPPED Registers */

#define DST_OFF_PITCH           0x0100  // Dword offset 40
#define DST_X                   0x0104  // Dword offset 41
#define DST_Y                   0x0108  // Dword offset 42
#define DST_Y_X                 0x010C  // Dword offset 43
#define DST_WIDTH               0x0110  // Dword offset 44
#define DST_HEIGHT              0x0114  // Dword offset 45
#define DST_HEIGHT_WIDTH        0x0118  // Dword offset 46
#define DST_X_WIDTH             0x011C  // Dword offset 47
#define DST_BRES_LNTH           0x0120  // Dword offset 48
#define DST_BRES_ERR            0x0124  // Dword offset 49
#define DST_BRES_INC            0x0128  // Dword offset 4A
#define DST_BRES_DEC            0x012C  // Dword offset 4B
#define DST_CNTL                0x0130  // Dword offset 4C

#define SRC_OFF_PITCH           0x0180  // Dword offset 60
#define SRC_X                   0x0184  // Dword offset 61
#define SRC_Y                   0x0188  // Dword offset 62
#define SRC_Y_X                 0x018C  // Dword offset 63
#define SRC_WIDTH1              0x0190  // Dword offset 64
#define SRC_HEIGHT1             0x0194  // Dword offset 65
#define SRC_HEIGHT1_WIDTH1      0x0198  // Dword offset 66
#define SRC_X_START             0x019C  // Dword offset 67
#define SRC_Y_START             0x01A0  // Dword offset 68
#define SRC_Y_X_START           0x01A4  // Dword offset 69
#define SRC_WIDTH2              0x01A8  // Dword offset 6A
#define SRC_HEIGHT2             0x01AC  // Dword offset 6B
#define SRC_HEIGHT2_WIDTH2      0x01B0  // Dword offset 6C
#define SRC_CNTL                0x01B4  // Dword offset 6D

#define HOST_DATA0              0x0200  // Dword offset 80
#define HOST_DATA1              0x0204  // Dword offset 81
#define HOST_DATA2              0x0208  // Dword offset 82
#define HOST_DATA3              0x020C  // Dword offset 83
#define HOST_DATA4              0x0210  // Dword offset 84
#define HOST_DATA5              0x0214  // Dword offset 85
#define HOST_DATA6              0x0218  // Dword offset 86
#define HOST_DATA7              0x021C  // Dword offset 87
#define HOST_DATA8              0x0220  // Dword offset 88
#define HOST_DATA9              0x0224  // Dword offset 89
#define HOST_DATAA              0x0228  // Dword offset 8A
#define HOST_DATAB              0x022C  // Dword offset 8B
#define HOST_DATAC              0x0230  // Dword offset 8C
#define HOST_DATAD              0x0234  // Dword offset 8D
#define HOST_DATAE              0x0238  // Dword offset 8E
#define HOST_DATAF              0x023C  // Dword offset 8F
#define HOST_CNTL               0x0240  // Dword offset 90

#define PAT_REG0                0x0280  // Dword offset A0
#define PAT_REG1                0x0284  // Dword offset A1
#define PAT_CNTL                0x0288  // Dword offset A2

#define SC_LEFT                 0x02A0  // Dword offset A8
#define SC_RIGHT                0x02A4  // Dword offset A9
#define SC_LEFT_RIGHT           0x02A8  // Dword offset AA
#define SC_TOP                  0x02AC  // Dword offset AB
#define SC_BOTTOM               0x02B0  // Dword offset AC
#define SC_TOP_BOTTOM           0x02B4  // Dword offset AD

#define DP_BKGD_CLR             0x02C0  // Dword offset B0
#define DP_FRGD_CLR             0x02C4  // Dword offset B1
#define DP_WRITE_MASK           0x02C8  // Dword offset B2
#define DP_CHAIN_MASK           0x02CC  // Dword offset B3
#define DP_PIX_WIDTH            0x02D0  // Dword offset B4
#define DP_MIX                  0x02D4  // Dword offset B5
#define DP_SRC                  0x02D8  // Dword offset B6

#define CLR_CMP_CLR             0x0300  // Dword offset C0
#define CLR_CMP_MASK            0x0304  // Dword offset C1
#define CLR_CMP_CNTL            0x0308  // Dword offset C2

#define FIFO_STAT               0x0310  // Dword offset C4

#define CONTEXT_MASK            0x0320  // Dword offset C8
#define CONTEXT_LOAD_CNTL       0x032C  // Dword offset CB

#define GUI_TRAJ_CNTL           0x0330  // Dword offset CC
#define GUI_STAT                0x0338  // Dword offset CE

