/*==========================================================================
* CLOSE.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved   *
*                                                                          *
* PGL function to close the PGL (effectively disables the engine and       *
* apertures).                                                              *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_close - close the PGL
  
  This function disables the apertures and engine before exit.
-------------------------------------------------------------------------- */
void PGL_close(void)
{
    // disable apertures
    PGL_closeaperture();

    // Ensure engine is not locked up by clearing any FIFO errors
    iow32(ioBUS_CNTL, (ior32(ioBUS_CNTL) & 0xff0fffff) | 0x00a00000);

    // disable engine
    iow32(ioGEN_TEST_CNTL, ior32(ioGEN_TEST_CNTL) & (~GUI_ENGINE_ENABLE));
}

