/*==========================================================================
* FILLPAT.C - Copyright (c) 1993 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to set the fill pattern.                                   *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"


/* --------------------------------------------------------------------------
  PGL_setfillpattern - set the current fill pattern

  The fill pattern can be upto 32 x 32 bits. The input parameters 'width'
  and 'height' must not exceed 32 or the fill pattern will remain unchanged.
  The given 'fillpattern' is interpreted as a mono bitmap. The pattern is
  drawn from the LSB to MSB (bit 0 of the fillpattern is used for pixel 0
  drawn to the screen). The function PGL_setfilltype() must be called to
  enable user defined pattern fills.
-------------------------------------------------------------------------- */
void PGL_setfillpattern(int width, int height, unsigned long *fillpattern)
{
    int i;
    unsigned long temp1, temp2, temp3, temp4;
    unsigned char data;

    if ((width > 32) || (width < 1)) return;
    if ((height > 32) || (height < 1)) return;

    PGL_attr.fillpatternwidth = width;
    PGL_attr.fillpatternheight = height;

    if (PGL_modecfg.bpp == 24)
    {
        for (i = 0; i < height; i++)
        {
            data = (unsigned char)((*(fillpattern + i)) & 0xff);
            temp1 = pgl_reversedata(pgl_expand8to24bpp(data), 24);
            data = (unsigned char)((*(fillpattern + i) >> 8) & 0xff);
            temp2 = pgl_reversedata(pgl_expand8to24bpp(data), 24);
            data = (unsigned char)((*(fillpattern + i) >> 16) & 0xff);
            temp3 = pgl_reversedata(pgl_expand8to24bpp(data), 24);
            data = (unsigned char)((*(fillpattern + i) >> 24) & 0xff);
            temp4 = pgl_reversedata(pgl_expand8to24bpp(data), 24);

            PGL_attr.fillpattern[(i*3)] = ((temp2 & 0xff) << 24) | temp1;
            PGL_attr.fillpattern[(i*3)+1] = ((temp3 & 0xffff) << 16) | ((temp2 >> 8) & 0xffff);
            PGL_attr.fillpattern[(i*3)+2] = ((temp4 & 0xffffff) << 8) | ((temp3 >> 16) & 0xff);
        }
    }
    else
    {
        for (i = 0; i < height; i++)
        {
            if (PGL_modecfg.bpp == 4)
            {
                PGL_attr.fillpattern[i] = pgl_convertpattern(*(fillpattern + i));
            }
            else
            {
                PGL_attr.fillpattern[i] = *(fillpattern + i);
            }
        }
    }

    // determine how polygon will be filled depending of width - this is only
    // used in the polygon drawing routine
    switch(width)
    {
        case 1:
        case 2:
        case 4:
        case 8:
            PGL_attr.fastpolyflag = 1;
            break;

        default:
            PGL_attr.fastpolyflag = 0;
            break;
    }
}

/* --------------------------------------------------------------------------
  PGL_setfilltype - set the current fill pattern type

  The fill pattern used is either a solid fill or a user defined fill
  pattern of upto 32x32 bits:

  0 - Patterned fill using pattern set by PGL_setfillpattern()
  1 - Solid fill

  The line pattern will remain unchanged if the given parameter is invalid.
-------------------------------------------------------------------------- */
void PGL_setfilltype(int type)
{
    if ((type < 0) || (type > 1)) return;

    switch(type)
    {
        case 0: PGL_attr.fillsolid = 0; break;
        case 1: PGL_attr.fillsolid = 1; break;
    }
}

