/*==========================================================================
* FNT12x20.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL function that returns a pointer to the 12x20 interal PGL font.        *
* ======================================================================== */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

//
// Bitmap data array for 12x20 font
//
//   Width in pixels     : 12
//   Height in pixels    : 20
//   Bytes per character : 30
//   Total size in bytes : 7680
//
unsigned char pgl_fontbitmap12x20[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x01, 0xf8, 0x70, 0xe4, 0x02, 0xc9, 
    0x38, 0x01, 0x90, 0x9c, 0xf3, 0x40, 0x27, 0x0e, 
    0x1f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x01, 0xf8, 0x7f, 0xe7, 0xfe, 0xf6, 0xff, 0xff, 
    0xff, 0xfe, 0xf7, 0x70, 0xe7, 0xfe, 0x1f, 0x80, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x7b, 0xcf, 0xfe, 0xff, 0xef, 0xfe, 0xff, 0xe7, 
    0xfc, 0x3f, 0x81, 0xf0, 0x0e, 0x00, 0x40, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x0e, 0x01, 
    0xf0, 0x3f, 0x87, 0xfc, 0xff, 0xe7, 0xfc, 0x3f, 
    0x81, 0xf0, 0x0e, 0x00, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0e, 0x01, 0xf0, 0x3f, 0x81, 0xf0, 0x0e, 
    0x07, 0xfc, 0xff, 0xef, 0xfe, 0x7f, 0xc0, 0x40, 
    0x0e, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x40, 0x0e, 0x01, 0xf0, 0x3f, 0x87, 0xfc, 
    0xff, 0xef, 0xfe, 0xff, 0xe6, 0x4c, 0x0e, 0x01, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0f, 0x01, 0xf8, 0x3f, 0xc3, 
    0xfc, 0x3f, 0xc1, 0xf8, 0x0f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xf0, 0xfe, 0x07, 0xc0, 0x3c, 0x03, 0xc0, 
    0x3e, 0x07, 0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
    0x01, 0x98, 0x30, 0xc3, 0x0c, 0x30, 0xc1, 0x98, 
    0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xfe, 0x67, 
    0xcf, 0x3c, 0xf3, 0xcf, 0x3e, 0x67, 0xf0, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x01, 0xe0, 0x06, 0x00, 0xa1, 0xf2, 0x21, 0x04, 
    0x08, 0x40, 0x84, 0x08, 0x21, 0x01, 0xe0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x20, 0x84, 
    0x04, 0x40, 0x44, 0x04, 0x20, 0x81, 0xf0, 0x04, 
    0x00, 0x40, 0x1f, 0x00, 0x40, 0x04, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x02, 0x00, 0x30, 0x03, 0x80, 0x2c, 0x02, 
    0x40, 0x24, 0x02, 0x00, 0x20, 0x02, 0x01, 0xe0, 
    0x3e, 0x01, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x60, 0x1a, 0x06, 0x20, 0x86, 0x09, 0xa0, 0xe2, 
    0x08, 0x20, 0x82, 0x08, 0x20, 0x9e, 0x0b, 0xe0, 
    0x9c, 0x78, 0x0f, 0x80, 0x70, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 
    0x84, 0x25, 0xf4, 0x20, 0x84, 0x04, 0xc0, 0x64, 
    0x04, 0x20, 0x85, 0xf4, 0x84, 0x20, 0x40, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0xfc, 0x0f, 
    0xf0, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xfc, 0xff, 
    0x0f, 0xc0, 0xf0, 0x0c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x0f, 0x03, 0xf0, 0xff, 0x3f, 
    0xff, 0xff, 0xff, 0xf3, 0xff, 0x0f, 0xf0, 0x3f, 
    0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x00, 0xf0, 0x1f, 0x80, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x01, 0xf8, 0x0f, 0x00, 
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc7, 0x9e, 
    0x79, 0xe7, 0x9e, 0x79, 0xe3, 0x0c, 0x30, 0xc3, 
    0x0c, 0x30, 0xc0, 0x00, 0x30, 0xc3, 0x0c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1f, 0xc3, 0xc4, 0x3c, 0x43, 
    0xc4, 0x1c, 0x40, 0x44, 0x04, 0x40, 0x44, 0x04, 
    0x40, 0x44, 0x04, 0x40, 0x44, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0f, 0x81, 0x8c, 0x30, 0x03, 0x00, 0x18, 
    0x01, 0xf8, 0x3c, 0xc2, 0xe4, 0x27, 0x43, 0x3c, 
    0x1f, 0x80, 0x18, 0x00, 0xc0, 0x0c, 0x31, 0x81, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7f, 0xe7, 0xfe, 0x7f, 0xe7, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0xf0, 
    0x1f, 0x80, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x1f, 0x80, 0xf0, 0x06, 0x01, 0xf8, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x06, 0x00, 0xf0, 0x1f, 0x83, 
    0x6c, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x36, 0xc1, 0xf8, 
    0x0f, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x80, 0x0c, 0x00, 0x6f, 0xff, 
    0xff, 0xf0, 0x06, 0x00, 0xc0, 0x08, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x10, 0x03, 0x00, 0x60, 0x0f, 0xff, 0xff, 0xf6, 
    0x00, 0x30, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x0e, 0x00, 0xe0, 0x0e, 0x00, 0xff, 
    0xef, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x10, 0x83, 0x0c, 0x60, 
    0x6f, 0xff, 0xff, 0xf6, 0x06, 0x30, 0xc1, 0x08, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x00, 0x60, 0x0f, 0x00, 0xf0, 0x1f, 0x81, 0xf8, 
    0x3f, 0xc3, 0xfc, 0x7f, 0xe7, 0xfe, 0xff, 0xff, 
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 
    0x7f, 0xe7, 0xfe, 0x3f, 0xc3, 0xfc, 0x1f, 0x81, 
    0xf8, 0x0f, 0x00, 0xf0, 0x06, 0x00, 0x60, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x06, 0x00, 0xf0, 0x0f, 0x00, 
    0xf0, 0x0f, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x00, 0x06, 0x00, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x19, 0x81, 0x98, 0x19, 0x80, 0x90, 0x09, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
    0x80, 0x88, 0x08, 0x87, 0xfe, 0x11, 0x01, 0x10, 
    0x11, 0x01, 0x10, 0xff, 0xc2, 0x20, 0x22, 0x02, 
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0xa0, 
    0x1f, 0x02, 0xa8, 0x2a, 0x01, 0xa0, 0x0e, 0x00, 
    0xb0, 0x0a, 0x82, 0xa8, 0x1f, 0x00, 0xa0, 0x0a, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x03, 0x8e, 0x47, 0x64, 
    0x4c, 0x39, 0x80, 0x30, 0x06, 0x00, 0xdc, 0x1a, 
    0x23, 0x22, 0x61, 0xc0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1e, 0x03, 0x30, 0x33, 0x01, 0xe0, 0x0c, 
    0x01, 0xc0, 0x36, 0x66, 0x24, 0x63, 0xc6, 0x18, 
    0x33, 0xa1, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x40, 0x08, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60, 
    0x0c, 0x00, 0xc0, 0x1c, 0x01, 0xc0, 0x1c, 0x01, 
    0xc0, 0x0c, 0x00, 0xc0, 0x06, 0x00, 0x30, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x18, 0x00, 0xc0, 0x06, 0x00, 
    0x60, 0x07, 0x00, 0x70, 0x07, 0x00, 0x70, 0x06, 
    0x00, 0x60, 0x0c, 0x01, 0x80, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x15, 
    0x00, 0xe0, 0x3f, 0x80, 0xe0, 0x15, 0x00, 0x40, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x3f, 0xc0, 0x60, 0x06, 0x00, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x60, 0x0f, 0x00, 0x70, 0x01, 
    0x00, 0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 
    0x0f, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x00, 0xc0, 0x18, 0x03, 0x00, 0x60, 
    0x0c, 0x01, 0x80, 0x30, 0x06, 0x00, 0xc0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x03, 0x0c, 
    0x31, 0xc6, 0x16, 0x62, 0x66, 0x26, 0x64, 0x66, 
    0x46, 0x68, 0x63, 0x8e, 0x30, 0xc0, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x06, 0x00, 0xe0, 0x16, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x01, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1f, 0x83, 0x1c, 0x40, 0xc0, 0x0c, 0x01, 
    0x80, 0x30, 0x06, 0x00, 0xc0, 0x18, 0x03, 0x00, 
    0x60, 0x67, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0x82, 0x0c, 0x00, 0x60, 0x06, 0x00, 0xc0, 0x7c, 
    0x00, 0xc0, 0x06, 0x00, 0x60, 0x06, 0x60, 0xc1, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x38, 
    0x05, 0x80, 0x98, 0x11, 0x82, 0x18, 0x41, 0x87, 
    0xfe, 0x01, 0x80, 0x18, 0x01, 0x80, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x3f, 0xc3, 0x00, 0x60, 0x06, 
    0x00, 0x7f, 0x80, 0x0c, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x60, 0xc1, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0f, 0x81, 0x84, 0x30, 0x06, 0x00, 0x60, 
    0x06, 0xf8, 0x70, 0xc6, 0x06, 0x60, 0x66, 0x06, 
    0x30, 0xc0, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 
    0xe4, 0x06, 0x00, 0xc0, 0x0c, 0x01, 0x80, 0x18, 
    0x03, 0x00, 0x30, 0x06, 0x00, 0x60, 0x0c, 0x00, 
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x01, 0x98, 
    0x30, 0xc3, 0x0c, 0x1c, 0x80, 0xf0, 0x13, 0x83, 
    0x0c, 0x30, 0xc3, 0x0c, 0x18, 0x80, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1f, 0x03, 0x0c, 0x60, 0x66, 
    0x06, 0x60, 0x63, 0x0e, 0x1f, 0x60, 0x06, 0x00, 
    0x60, 0x0c, 0x21, 0x81, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0xf0, 0x06, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 0x00, 0x60, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x06, 0x00, 0xf0, 0x06, 0x00, 0x00, 
    0x00, 0x00, 0x60, 0x0f, 0x00, 0x70, 0x01, 0x00, 
    0x20, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x30, 
    0x06, 0x00, 0xc0, 0x18, 0x03, 0x00, 0x30, 0x01, 
    0x80, 0x0c, 0x00, 0x60, 0x03, 0x00, 0x18, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x3f, 0xc0, 0x00, 0x00, 0x03, 0xfc, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x30, 0x01, 0x80, 0x0c, 0x00, 0x60, 0x03, 
    0x00, 0x18, 0x01, 0x80, 0x30, 0x06, 0x00, 0xc0, 
    0x18, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0x82, 0x1c, 0x60, 0xe0, 0x0e, 0x01, 0xc0, 0x30, 
    0x06, 0x00, 0x40, 0x00, 0x00, 0x40, 0x0e, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 
    0x60, 0x64, 0x02, 0x8f, 0x19, 0x11, 0x91, 0x38, 
    0xfc, 0x40, 0x06, 0x06, 0x1f, 0x80, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x04, 0x00, 0x40, 0x0e, 0x00, 
    0xe0, 0x13, 0x01, 0x30, 0x21, 0x83, 0xf8, 0x21, 
    0x84, 0x0c, 0x40, 0xce, 0x1e, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0x83, 0x0c, 0x30, 0x63, 0x06, 0x30, 
    0xc3, 0xf8, 0x30, 0xc3, 0x06, 0x30, 0x63, 0x06, 
    0x30, 0xc7, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
    0xa3, 0x8e, 0x30, 0x66, 0x02, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x03, 0x02, 0x18, 0xc0, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x03, 0x18, 
    0x30, 0xc3, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 
    0x06, 0x30, 0x63, 0x0c, 0x31, 0xc7, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7f, 0xe3, 0x06, 0x30, 0x23, 
    0x00, 0x30, 0x83, 0xf8, 0x30, 0x83, 0x00, 0x30, 
    0x03, 0x02, 0x30, 0x67, 0xfe, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0xe3, 0x06, 0x30, 0x23, 0x00, 0x30, 
    0x83, 0xf8, 0x30, 0x83, 0x00, 0x30, 0x03, 0x00, 
    0x30, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0xc3, 0x0c, 0x60, 0x46, 0x00, 0x60, 0x06, 0x00, 
    0x61, 0xe6, 0x0c, 0x60, 0xc6, 0x0c, 0x30, 0xc1, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xe3, 0x0c, 
    0x30, 0xc3, 0x0c, 0x30, 0xc3, 0xfc, 0x30, 0xc3, 
    0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc7, 0x9e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1f, 0x80, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x01, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x07, 0xe0, 0x18, 0x01, 0x80, 0x18, 0x01, 
    0x80, 0x18, 0x01, 0x80, 0x18, 0x01, 0x87, 0x18, 
    0x73, 0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 
    0xe3, 0x0c, 0x31, 0x83, 0x30, 0x36, 0x03, 0xc0, 
    0x3c, 0x03, 0x60, 0x33, 0x03, 0x18, 0x30, 0xc7, 
    0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x03, 0x00, 
    0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 
    0x00, 0x30, 0x03, 0x02, 0x30, 0x67, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xc0, 0x76, 0x06, 0x70, 0xe7, 
    0x0e, 0x59, 0x65, 0x96, 0x4e, 0x64, 0xe6, 0x44, 
    0x64, 0x46, 0x40, 0x6e, 0x0f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x60, 0xe3, 0x04, 0x38, 0x43, 0x84, 0x2c, 
    0x42, 0x64, 0x26, 0x42, 0x34, 0x21, 0xc2, 0x1c, 
    0x20, 0xc7, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
    0x01, 0x08, 0x30, 0xc6, 0x06, 0x60, 0x66, 0x06, 
    0x60, 0x66, 0x06, 0x60, 0x63, 0x0c, 0x10, 0x80, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x83, 0x0c, 
    0x30, 0x63, 0x06, 0x30, 0xc3, 0xf8, 0x30, 0x03, 
    0x00, 0x30, 0x03, 0x00, 0x30, 0x07, 0x80, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0f, 0x01, 0x08, 0x30, 0xc6, 
    0x06, 0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 0x60, 
    0x63, 0x0c, 0x10, 0x80, 0xf0, 0x07, 0x00, 0x18, 
    0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0x83, 0x0c, 0x30, 0x63, 0x06, 0x30, 
    0xc3, 0xf8, 0x36, 0x03, 0x30, 0x31, 0x83, 0x0c, 
    0x30, 0x67, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0xa3, 0x0e, 0x60, 0x66, 0x02, 0x70, 0x03, 0xe0, 
    0x07, 0xc0, 0x0e, 0x40, 0x66, 0x06, 0x70, 0xc5, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xe4, 0x62, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x78, 0xe3, 0x04, 0x30, 0x43, 
    0x04, 0x30, 0x43, 0x04, 0x30, 0x43, 0x04, 0x30, 
    0x43, 0x04, 0x18, 0x80, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x78, 0xe3, 0x04, 0x30, 0x43, 0x04, 0x18, 
    0x81, 0x88, 0x18, 0x80, 0xd0, 0x0d, 0x00, 0xd0, 
    0x06, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xef, 
    0x3c, 0x61, 0xc6, 0x1c, 0x61, 0x67, 0x26, 0x72, 
    0x67, 0x23, 0x9c, 0x39, 0xc3, 0x9c, 0x18, 0xc1, 
    0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0xe3, 0x04, 
    0x18, 0x81, 0x88, 0x0f, 0x00, 0xe0, 0x07, 0x00, 
    0xf0, 0x11, 0x81, 0x18, 0x20, 0xc7, 0x1e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x78, 0xe3, 0x04, 0x18, 0x81, 
    0x88, 0x0d, 0x00, 0xf0, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0xe8, 0x06, 0x00, 0xc0, 0x18, 0x03, 
    0x00, 0x60, 0x0c, 0x01, 0x80, 0x30, 0x06, 0x00, 
    0xc0, 0x2f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
    0x00, 0xc0, 0x0c, 0x00, 0xc0, 0x0c, 0x00, 0xc0, 
    0x0c, 0x00, 0xc0, 0x0c, 0x00, 0xc0, 0x0c, 0x00, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 
    0x60, 0x03, 0x00, 0x18, 0x00, 0xc0, 0x06, 0x00, 
    0x30, 0x01, 0x80, 0x0c, 0x00, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0f, 0x00, 0x30, 0x03, 0x00, 
    0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 0x30, 0x03, 
    0x00, 0x30, 0x03, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x06, 0x00, 0xf0, 0x19, 0x83, 0x0c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
    0xf0, 0x21, 0x80, 0x0c, 0x1f, 0xc3, 0x0c, 0x60, 
    0xc6, 0x0c, 0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x30, 0x07, 0x00, 0x30, 0x03, 0x78, 0x38, 
    0xc3, 0x06, 0x30, 0x63, 0x06, 0x30, 0x63, 0x06, 
    0x30, 0x41, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x30, 0x66, 0x02, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x02, 0x38, 0x40, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x1c, 
    0x00, 0xc0, 0xec, 0x31, 0xc6, 0x0c, 0x60, 0xc6, 
    0x0c, 0x60, 0xc6, 0x0c, 0x31, 0xe1, 0xec, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xf8, 0x30, 0xc6, 0x06, 0x60, 0x67, 0xfe, 0x60, 
    0x06, 0x02, 0x30, 0xc1, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0f, 0x81, 0x8c, 0x18, 0x01, 0x80, 0x18, 
    0x03, 0xf0, 0x18, 0x01, 0x80, 0x18, 0x01, 0x80, 
    0x18, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0xf0, 0x23, 0xe6, 0x18, 
    0x61, 0x83, 0x10, 0x1e, 0x03, 0x00, 0x1f, 0xc3, 
    0x06, 0x60, 0x26, 0x04, 0x3f, 0x80, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x07, 0x00, 
    0x30, 0x03, 0x78, 0x38, 0xc3, 0x0c, 0x30, 0xc3, 
    0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc7, 0x9e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 
    0x60, 0x0e, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x18, 0x03, 
    0x80, 0x18, 0x01, 0x80, 0x18, 0x01, 0x80, 0x18, 
    0x01, 0x80, 0x18, 0x31, 0x83, 0x18, 0x1f, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 
    0x07, 0x00, 0x30, 0x03, 0x0c, 0x30, 0x83, 0x10, 
    0x32, 0x03, 0xe0, 0x33, 0x03, 0x18, 0x30, 0xc7, 
    0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0xe0, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 
    0xcc, 0xf5, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 
    0x66, 0x66, 0x66, 0x6f, 0x6f, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x78, 0x78, 
    0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 
    0x30, 0xc7, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf0, 0x30, 0xc6, 0x06, 
    0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 0x30, 0xc0, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x03, 0x78, 0x78, 0xc3, 0x06, 0x30, 0x63, 
    0x06, 0x30, 0x63, 0x06, 0x38, 0xc3, 0x70, 0x30, 
    0x03, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xe4, 0x31, 0xc6, 0x0c, 0x60, 0xc6, 0x0c, 0x60, 
    0xc6, 0x0c, 0x31, 0xc1, 0xec, 0x00, 0xc0, 0x0c, 
    0x01, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x78, 0x78, 
    0xc3, 0x0c, 0x30, 0x03, 0x00, 0x30, 0x03, 0x00, 
    0x30, 0x07, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x01, 0xf2, 0x70, 0xe6, 0x02, 
    0x78, 0x01, 0xf8, 0x01, 0xe4, 0x06, 0x70, 0xe4, 
    0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0xc0, 
    0x0c, 0x03, 0xf8, 0x0c, 0x00, 0xc0, 0x0c, 0x00, 
    0xc0, 0x0c, 0x00, 0xc0, 0x0c, 0x40, 0x78, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
    0x1c, 0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x30, 
    0xc3, 0x0c, 0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x8e, 0x30, 
    0x43, 0x04, 0x18, 0x81, 0x88, 0x0d, 0x00, 0xd0, 
    0x06, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0e, 0xf3, 0xc6, 0x1c, 0x61, 
    0x67, 0x26, 0x72, 0x39, 0xa3, 0x9c, 0x18, 0xc1, 
    0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x07, 0x8e, 0x30, 0x41, 0x88, 0x0d, 0x00, 
    0x60, 0x0b, 0x01, 0x18, 0x20, 0xc7, 0x1e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
    0x8e, 0x30, 0x41, 0x88, 0x18, 0x80, 0xd0, 0x0d, 
    0x00, 0x60, 0x06, 0x00, 0x40, 0x04, 0x06, 0x80, 
    0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfe, 0x40, 
    0xc0, 0x18, 0x03, 0x00, 0x60, 0x0c, 0x01, 0x80, 
    0x30, 0x27, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
    0x80, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x1c, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1c, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x03, 0x80, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x1c, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1c, 0xe7, 0x38, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 0x01, 0x98, 
    0x30, 0xc6, 0x06, 0x60, 0x66, 0x06, 0x60, 0x67, 
    0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xa3, 0x8e, 
    0x30, 0x66, 0x02, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x03, 0x02, 0x18, 0xc0, 0xf8, 0x02, 
    0x00, 0x38, 0x08, 0x80, 0x70, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x30, 0xc3, 0x0c, 0x00, 0x07, 
    0x1c, 0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x30, 
    0xc3, 0x0c, 0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0x03, 0x00, 0x40, 0x00, 0x00, 0xf8, 0x30, 
    0xc6, 0x06, 0x60, 0x67, 0xfe, 0x60, 0x06, 0x02, 
    0x30, 0xc1, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 
    0x01, 0x08, 0x00, 0x01, 0xf0, 0x21, 0x80, 0x0c, 
    0x1f, 0xc3, 0x0c, 0x60, 0xc6, 0x0c, 0x31, 0xe1, 
    0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x81, 0x98, 
    0x00, 0x01, 0xf0, 0x21, 0x80, 0x0c, 0x1f, 0xc3, 
    0x0c, 0x60, 0xc6, 0x0c, 0x31, 0xe1, 0xec, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x06, 0x00, 0x10, 0x00, 0x01, 
    0xf0, 0x21, 0x80, 0x0c, 0x1f, 0xc3, 0x0c, 0x60, 
    0xc6, 0x0c, 0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xe0, 0x11, 0x00, 0xe0, 0x00, 0x01, 0xf0, 0x21, 
    0x80, 0x0c, 0x1f, 0xc3, 0x0c, 0x60, 0xc6, 0x0c, 
    0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xf8, 0x30, 0x66, 0x02, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x02, 0x38, 0x40, 
    0xf8, 0x02, 0x00, 0x38, 0x08, 0x80, 0x70, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 0x01, 0x08, 
    0x00, 0x00, 0xf8, 0x30, 0xc6, 0x06, 0x60, 0x67, 
    0xfe, 0x60, 0x06, 0x02, 0x30, 0xc1, 0xf8, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x19, 0x81, 0x98, 0x00, 0x00, 
    0xf8, 0x30, 0xc6, 0x06, 0x60, 0x67, 0xfe, 0x60, 
    0x06, 0x02, 0x30, 0xc1, 0xf8, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xc0, 0x06, 0x00, 0x10, 0x00, 0x00, 0xf8, 0x30, 
    0xc6, 0x06, 0x60, 0x67, 0xfe, 0x60, 0x06, 0x02, 
    0x30, 0xc1, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 
    0x81, 0x98, 0x00, 0x00, 0x60, 0x0e, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 0x01, 0x08, 
    0x00, 0x00, 0x60, 0x0e, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x06, 0x00, 0x10, 0x00, 0x00, 
    0x60, 0x0e, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x83, 
    0x18, 0x00, 0x00, 0x40, 0x04, 0x00, 0xe0, 0x0e, 
    0x01, 0x30, 0x13, 0x03, 0xf8, 0x21, 0x84, 0x0c, 
    0x40, 0xce, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x0e, 0x01, 0x10, 0x0e, 
    0x00, 0x40, 0x04, 0x00, 0xe0, 0x0e, 0x01, 0x30, 
    0x13, 0x03, 0xf8, 0x21, 0x84, 0x0c, 0x40, 0xce, 
    0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x01, 0x80, 0x30, 0x04, 0x07, 0xfe, 
    0x30, 0x63, 0x02, 0x30, 0x03, 0x08, 0x3f, 0x83, 
    0x08, 0x30, 0x03, 0x02, 0x30, 0x67, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 
    0x8e, 0x4d, 0x10, 0x71, 0x1e, 0x16, 0x7f, 0xc6, 
    0x0c, 0x60, 0xc7, 0x17, 0xce, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x07, 0xf0, 0x71, 0x0b, 0x00, 0xb0, 0x13, 
    0x21, 0x3e, 0x3f, 0x22, 0x30, 0x43, 0x04, 0x30, 
    0x83, 0x1c, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x0f, 
    0x01, 0x08, 0x00, 0x00, 0xf0, 0x30, 0xc6, 0x06, 
    0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 0x30, 0xc0, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x81, 0x98, 
    0x00, 0x00, 0xf0, 0x30, 0xc6, 0x06, 0x60, 0x66, 
    0x06, 0x60, 0x66, 0x06, 0x30, 0xc0, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xc0, 0x06, 0x00, 0x10, 0x00, 0x00, 
    0xf0, 0x30, 0xc6, 0x06, 0x60, 0x66, 0x06, 0x60, 
    0x66, 0x06, 0x30, 0xc0, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x60, 0x0f, 0x01, 0x08, 0x00, 0x07, 0x1c, 0x30, 
    0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 
    0x31, 0xe1, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x06, 
    0x00, 0x10, 0x00, 0x07, 0x1c, 0x30, 0xc3, 0x0c, 
    0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x31, 0xe1, 
    0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x81, 0x98, 
    0x00, 0x07, 0x8e, 0x30, 0x41, 0x88, 0x18, 0x80, 
    0xd0, 0x0d, 0x00, 0x60, 0x06, 0x00, 0x40, 0x04, 
    0x06, 0x80, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x30, 0xc3, 0x0c, 0x00, 0x00, 0xf0, 0x10, 0x83, 
    0x0c, 0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 0x60, 
    0x63, 0x0c, 0x10, 0x80, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0xc3, 
    0x0c, 0x00, 0x07, 0x8e, 0x30, 0x43, 0x04, 0x30, 
    0x43, 0x04, 0x30, 0x43, 0x04, 0x30, 0x43, 0x04, 
    0x18, 0x80, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x80, 0x08, 0x01, 0x00, 0xf8, 0x19, 0x43, 0x10, 
    0x32, 0x01, 0xa4, 0x0f, 0x80, 0x20, 0x04, 0x00, 
    0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x64, 
    0x0c, 0x00, 0xc0, 0x0c, 0x03, 0xf8, 0x0c, 0x00, 
    0xc0, 0x0c, 0x03, 0xc0, 0x4f, 0x23, 0x9c, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x78, 0xe3, 0x04, 0x18, 0x81, 
    0x88, 0x0d, 0x00, 0xf0, 0x3f, 0xc0, 0x60, 0x3f, 
    0xc0, 0x60, 0x06, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0x83, 0x0c, 0x30, 0x63, 0x06, 0x30, 
    0xc3, 0xf8, 0x30, 0x03, 0x18, 0x31, 0x83, 0x3c, 
    0x31, 0x87, 0x98, 0x01, 0xa0, 0x0c, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
    0xc0, 0x32, 0x03, 0x00, 0x30, 0x06, 0x00, 0x60, 
    0x06, 0x03, 0xf8, 0x0c, 0x00, 0xc0, 0x0c, 0x01, 
    0x80, 0x18, 0x09, 0x80, 0x70, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 0x00, 0x80, 
    0x00, 0x01, 0xf0, 0x21, 0x80, 0x0c, 0x1f, 0xc3, 
    0x0c, 0x60, 0xc6, 0x0c, 0x31, 0xe1, 0xec, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x30, 0x06, 0x00, 0x80, 0x00, 0x00, 
    0x60, 0x0e, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x30, 0x06, 0x00, 0x80, 0x00, 0x00, 0xf0, 0x30, 
    0xc6, 0x06, 0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 
    0x30, 0xc0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x06, 
    0x00, 0x80, 0x00, 0x07, 0x1c, 0x30, 0xc3, 0x0c, 
    0x30, 0xc3, 0x0c, 0x30, 0xc3, 0x0c, 0x31, 0xe1, 
    0xec, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xc3, 0x38, 
    0x00, 0x03, 0x78, 0x78, 0xc3, 0x0c, 0x30, 0xc3, 
    0x0c, 0x30, 0xc3, 0x0c, 0x30, 0xc7, 0x9e, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x1c, 0xc3, 0x38, 0x00, 0x06, 0x0e, 0x30, 0x43, 
    0x84, 0x38, 0x42, 0xc4, 0x26, 0x42, 0x34, 0x21, 
    0xc2, 0x1c, 0x20, 0xc7, 0x04, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x0e, 0x81, 0x98, 0x31, 0x83, 0x18, 0x33, 
    0xc1, 0xd8, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 
    0x01, 0x98, 0x30, 0xc3, 0x0c, 0x19, 0x80, 0xf0, 
    0x00, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x70, 
    0x02, 0x00, 0x00, 0x02, 0x00, 0x60, 0x0c, 0x03, 
    0x80, 0x70, 0x07, 0x06, 0x38, 0x41, 0xf8, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x30, 
    0x03, 0x00, 0x30, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x03, 0xfe, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x01, 0x00, 0x30, 0x61, 0x0c, 0x11, 0x83, 0xb0, 
    0x06, 0x00, 0xd8, 0x1a, 0x43, 0x08, 0x61, 0x00, 
    0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 
    0x30, 0x61, 0x0c, 0x11, 0x83, 0xb0, 0x06, 0x00, 
    0xc8, 0x19, 0x83, 0x28, 0x63, 0xc0, 0x08, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 0x00, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0xf0, 0x0f, 
    0x00, 0xf0, 0x0f, 0x00, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0xcc, 0x19, 
    0x83, 0x30, 0x66, 0x03, 0x30, 0x19, 0x80, 0xcc, 
    0x06, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x66, 0x03, 0x30, 0x19, 0x80, 0xcc, 
    0x06, 0x60, 0xcc, 0x19, 0x83, 0x30, 0x66, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0xaa, 0xa5, 0x55, 0xaa, 0xa5, 0x55, 
    0xaa, 0xa5, 0x55, 0xaa, 0xa5, 0x55, 0xaa, 0xa5, 
    0x55, 0xaa, 0xa5, 0x55, 0xaa, 0xa5, 0x55, 0xaa, 
    0xa5, 0x55, 0xaa, 0xa5, 0x55, 0xaa, 0xa5, 0x55, 
    0x77, 0x7d, 0xdd, 0x77, 0x7d, 0xdd, 0x77, 0x7d, 
    0xdd, 0x77, 0x7d, 0xdd, 0x77, 0x7d, 0xdd, 0x77, 
    0x7d, 0xdd, 0x77, 0x7d, 0xdd, 0x77, 0x7d, 0xdd, 
    0x77, 0x7d, 0xdd, 0x77, 0x7d, 0xdd, 0xf7, 0xdb, 
    0xef, 0xf7, 0xdb, 0xef, 0xf7, 0xdb, 0xef, 0xf7, 
    0xdb, 0xef, 0xf7, 0xdb, 0xef, 0xf7, 0xdb, 0xef, 
    0xf7, 0xdb, 0xef, 0xf7, 0xdb, 0xef, 0xf7, 0xdb, 
    0xef, 0xf7, 0xdb, 0xef, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0xfe, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0xfe, 0x00, 0x60, 0xfe, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0xf8, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xff, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 
    0x60, 0xfe, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0xf8, 0xc0, 0x0c, 0xf8, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xff, 0xc0, 0x0c, 0xf8, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0xf8, 0xc0, 
    0x0c, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0xff, 
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0xfe, 0x00, 0x60, 0xfe, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfe, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0xff, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x07, 0xf0, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0xff, 
    0xf0, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x07, 0xf0, 0x60, 0x07, 0xf0, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xf1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xf1, 
    0x80, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x1f, 0xf1, 0x80, 0x18, 
    0xf1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0xf8, 0xf0, 0x00, 0xff, 0xf0, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0xff, 0xf0, 0x00, 0xf8, 0xf1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xf1, 
    0x80, 0x18, 0xf1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0xf8, 0xf0, 0x00, 0xf8, 0xf1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0xff, 0xf0, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0xff, 
    0xf0, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x1f, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x07, 0xf0, 
    0x60, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x60, 0x07, 
    0xf0, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xf1, 0x8c, 
    0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x18, 0xc1, 0x8c, 0xff, 0xf1, 0x8c, 0x18, 0xc1, 
    0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 
    0xc1, 0x8c, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0xff, 0xf0, 
    0x60, 0xff, 0xf0, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0xfe, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf0, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xfc, 0x0f, 0xc0, 0xfc, 0x0f, 0xc0, 0xfc, 0x0f, 
    0xc0, 0xfc, 0x0f, 0xc0, 0xfc, 0x0f, 0xc0, 0xfc, 
    0x0f, 0xc0, 0xfc, 0x0f, 0xc0, 0xfc, 0x0f, 0xc0, 
    0xfc, 0x0f, 0xc0, 0xfc, 0x0f, 0xc0, 0x03, 0xf0, 
    0x3f, 0x03, 0xf0, 0x3f, 0x03, 0xf0, 0x3f, 0x03, 
    0xf0, 0x3f, 0x03, 0xf0, 0x3f, 0x03, 0xf0, 0x3f, 
    0x03, 0xf0, 0x3f, 0x03, 0xf0, 0x3f, 0x03, 0xf0, 
    0x3f, 0x03, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1c, 0x23, 0x66, 0x63, 0xc6, 
    0x18, 0x63, 0xc3, 0x66, 0x1c, 0x20, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1f, 0x03, 0x18, 0x61, 0x86, 
    0x18, 0x63, 0x07, 0xf8, 0x60, 0xe6, 0x06, 0x60, 
    0x66, 0x06, 0x78, 0xe6, 0x78, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x7f, 0xe1, 0x86, 0x18, 0x21, 0x80, 0x18, 
    0x01, 0x80, 0x18, 0x01, 0x80, 0x18, 0x01, 0x80, 
    0x18, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x03, 0x8e, 0x4f, 0x80, 0xd8, 
    0x0d, 0x80, 0xd8, 0x0d, 0x80, 0xd8, 0x0d, 0xa1, 
    0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xe6, 0x06, 
    0x30, 0x21, 0x80, 0x0c, 0x00, 0x60, 0x06, 0x00, 
    0xc0, 0x18, 0x03, 0x02, 0x60, 0x67, 0xfe, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 
    0xfc, 0x33, 0x06, 0x18, 0x61, 0x86, 0x18, 0x61, 
    0x86, 0x18, 0x33, 0x01, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8c, 0x18, 
    0xc1, 0x8c, 0x18, 0xc1, 0x8c, 0x18, 0xc1, 0x8c, 
    0x19, 0xe1, 0xf4, 0x10, 0x03, 0x00, 0x60, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x03, 0xfc, 0x66, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x80, 
    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x60, 
    0x06, 0x01, 0xf8, 0x36, 0xc6, 0x66, 0x66, 0x63, 
    0x6c, 0x1f, 0x80, 0x60, 0x06, 0x01, 0xf8, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x0f, 0x01, 0x08, 0x30, 0xc6, 
    0x06, 0x69, 0x66, 0xf6, 0x6f, 0x66, 0x96, 0x60, 
    0x63, 0x0c, 0x10, 0x80, 0xf0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x1f, 0x83, 0x0c, 0x60, 0x66, 0x06, 0x60, 
    0x66, 0x06, 0x30, 0xc1, 0x98, 0x09, 0x00, 0x90, 
    0x49, 0x27, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0x03, 0x18, 0x30, 0x01, 0x80, 0x0f, 0x81, 0x8c, 
    0x30, 0x66, 0x06, 0x60, 0x66, 0x0c, 0x31, 0x81, 
    0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x39, 0xc6, 0x66, 0x46, 0x24, 
    0x62, 0x46, 0x26, 0x66, 0x39, 0xc0, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x00, 0xc0, 
    0xfc, 0x31, 0xc6, 0x36, 0x63, 0x66, 0x66, 0x6c, 
    0x66, 0xc6, 0x38, 0xc3, 0xf0, 0x30, 0x06, 0x00, 
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xfc, 0x38, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x7f, 0x86, 0x00, 0x60, 0x06, 0x00, 
    0x38, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 
    0x83, 0x0c, 0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 
    0x60, 0x66, 0x06, 0x60, 0x66, 0x06, 0x60, 0x66, 
    0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x07, 
    0xfe, 0x00, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x60, 0x06, 0x03, 0xfc, 0x06, 0x00, 0x60, 0x00, 
    0x03, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0xe0, 0x03, 
    0x80, 0x0e, 0x03, 0x80, 0xe0, 0x38, 0x00, 0x00, 
    0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0xe0, 0x38, 0x0e, 0x03, 0x80, 
    0x0e, 0x00, 0x38, 0x00, 0xe0, 0x00, 0x3f, 0xe0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x03, 0xc0, 0x62, 0x06, 0x20, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 
    0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 0x06, 
    0x00, 0x60, 0x06, 0x04, 0x60, 0x46, 0x03, 0xc0, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 
    0x00, 0x00, 0x3f, 0xc0, 0x00, 0x06, 0x00, 0x60, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xce, 
    0x73, 0x80, 0x00, 0x1c, 0xe7, 0x38, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x03, 0x18, 
    0x31, 0x81, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x60, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 
    0xe0, 0x60, 0x06, 0x00, 0x60, 0x06, 0x00, 0x60, 
    0x06, 0x02, 0x60, 0x76, 0x01, 0xe0, 0x0e, 0x00, 
    0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x05, 0x98, 
    0x19, 0x81, 0x98, 0x19, 0x81, 0x98, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x1e, 0x03, 0x30, 0x06, 0x00, 
    0xc0, 0x18, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xfc, 0x3f, 
    0xc3, 0xfc, 0x3f, 0xc3, 0xfc, 0x3f, 0xc3, 0xfc, 
    0x3f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x04, 0x00, 0x81, 0xf8, 0x31, 0xc6, 0x26, 
    0x64, 0x63, 0x8c, 0x1f, 0x81, 0x00, 0x20, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0xf4, 
    0x10, 0xc3, 0x0c, 0x61, 0xe6, 0x36, 0x66, 0x66, 
    0x66, 0x6c, 0x63, 0x8c, 0x30, 0x82, 0xf0, 0x60, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

//
// Static PGL font structure for 12x20 font
//
PGL_font pgl_fixedfont12x20[] =
{
    12, // character width
    20, // character height
    {   // character index array

        0x0000, 0x001e, 0x003c, 0x005a, 0x0078, 0x0096, 0x00b4, 0x00d2,
        0x00f0, 0x010e, 0x012c, 0x014a, 0x0168, 0x0186, 0x01a4, 0x01c2, 
        0x01e0, 0x01fe, 0x021c, 0x023a, 0x0258, 0x0276, 0x0294, 0x02b2, 
        0x02d0, 0x02ee, 0x030c, 0x032a, 0x0348, 0x0366, 0x0384, 0x03a2, 
        0x0000, 0x03c0, 0x03de, 0x03fc, 0x041a, 0x0438, 0x0456, 0x0474, 
        0x0492, 0x04b0, 0x04ce, 0x04ec, 0x050a, 0x0528, 0x0546, 0x0564, 
        0x0582, 0x05a0, 0x05be, 0x05dc, 0x05fa, 0x0618, 0x0636, 0x0654, 
        0x0672, 0x0690, 0x06ae, 0x06cc, 0x06ea, 0x0708, 0x0726, 0x0744, 
        0x0762, 0x0780, 0x079e, 0x07bc, 0x07da, 0x07f8, 0x0816, 0x0834, 
        0x0852, 0x0870, 0x088e, 0x08ac, 0x08ca, 0x08e8, 0x0906, 0x0924, 
        0x0942, 0x0960, 0x097e, 0x099c, 0x09ba, 0x09d8, 0x09f6, 0x0a14, 
        0x0a32, 0x0a50, 0x0a6e, 0x0a8c, 0x0aaa, 0x0ac8, 0x0ae6, 0x0b04, 
        0x0b22, 0x0b40, 0x0b5e, 0x0b7c, 0x0b9a, 0x0bb8, 0x0bd6, 0x0bf4, 
        0x0c12, 0x0c30, 0x0c4e, 0x0c6c, 0x0c8a, 0x0ca8, 0x0cc6, 0x0ce4, 
        0x0d02, 0x0d20, 0x0d3e, 0x0d5c, 0x0d7a, 0x0d98, 0x0db6, 0x0dd4, 
        0x0df2, 0x0e10, 0x0e2e, 0x0e4c, 0x0e6a, 0x0e88, 0x0ea6, 0x0ec4, 
        0x0ee2, 0x0f00, 0x0f1e, 0x0f3c, 0x0f5a, 0x0f78, 0x0f96, 0x0fb4, 
        0x0fd2, 0x0ff0, 0x100e, 0x102c, 0x104a, 0x1068, 0x1086, 0x10a4, 
        0x10c2, 0x10e0, 0x10fe, 0x111c, 0x113a, 0x1158, 0x1176, 0x1194, 
        0x11b2, 0x11d0, 0x11ee, 0x120c, 0x122a, 0x1248, 0x1266, 0x1284, 
        0x12a2, 0x12c0, 0x12de, 0x12fc, 0x131a, 0x1338, 0x1356, 0x1374, 
        0x1392, 0x13b0, 0x13ce, 0x13ec, 0x140a, 0x1428, 0x1446, 0x1464, 
        0x1482, 0x14a0, 0x14be, 0x14dc, 0x14fa, 0x1518, 0x1536, 0x1554, 
        0x1572, 0x1590, 0x15ae, 0x15cc, 0x15ea, 0x1608, 0x1626, 0x1644, 
        0x1662, 0x1680, 0x169e, 0x16bc, 0x16da, 0x16f8, 0x1716, 0x1734, 
        0x1752, 0x1770, 0x178e, 0x17ac, 0x17ca, 0x17e8, 0x1806, 0x1824, 
        0x1842, 0x1860, 0x187e, 0x189c, 0x18ba, 0x18d8, 0x18f6, 0x1914, 
        0x1932, 0x1950, 0x196e, 0x198c, 0x19aa, 0x19c8, 0x19e6, 0x1a04, 
        0x1a22, 0x1a40, 0x1a5e, 0x1a7c, 0x1a9a, 0x1ab8, 0x1ad6, 0x1af4, 
        0x1b12, 0x1b30, 0x1b4e, 0x1b6c, 0x1b8a, 0x1ba8, 0x1bc6, 0x1be4, 
        0x1c02, 0x1c20, 0x1c3e, 0x1c5c, 0x1c7a, 0x1c98, 0x1cb6, 0x1cd4, 
        0x1cf2, 0x1d10, 0x1d2e, 0x1d4c, 0x1d6a, 0x1d88, 0x1da6, 0x0000, 
    },
    pgl_fontbitmap12x20, // pointer to bitmap data array
    NULL                // reserved
};

/* --------------------------------------------------------------------------
  PGL_getfixedfont12x20 - returns a pointer to the PGL internal 12x20 font

  This function returns a "PGL_font" pointer to the PGL's internal 12x20 font
  structure. This function is useful if loading a font file is not desired as
  with PGL_loadfont(). It is also always available. It should be noted that
  using this function will add the static font structure to the size of the
  application. Since this function returns a pointer instead of filling a
  given PGL_font structure, the application must access the font structure
  elements using '->' (instead of '.' as with PGL_loadfont()).
-------------------------------------------------------------------------- */
PGL_font *PGL_getfixedfont12x20(void)
{
    return (pgl_fixedfont12x20);
}

