/*==========================================================================
* PACKPIX.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL function to set packed pixel mode.                                   *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  pgl_setpackedpixel - set VGA controller into packed pixel mode
  
  This function programs the VGA controller to enable packed pixel mode so
  that the 32K VGA apertures can be used for data transfer. Also, the VGA
  controller size is set to 128K to enable access to the GUI memory mapped
  registers.
-------------------------------------------------------------------------- */
void pgl_setpackedpixel(void)
{
    // set VGA controller into packed pixel mode with 128K (A0000h-BFFFFh)
    outpw(0x3c4, 0xf02);        // seq02  = 0f  (enable all maps)
    outpw(0x3c4, 0xa04);        // seq04  = 0a  (memory mode for 256 color)
    outpw(0x3ce, 0x1000);       // graf00 = 10  (standard set/reset)
    outpw(0x3ce, 0x0001);       // graf01 = 00  (standard enable set/reset)
    outpw(0x3ce, 0x0002);       // graf02 = 00  (standard color compare)
    outpw(0x3ce, 0x0003);       // graf03 = 00  (standard data rotate)
    outpw(0x3ce, 0x0004);       // graf04 = 00  (read mode 0)
    outpw(0x3ce, 0x0005);       // graf05 = 00  (write mode 0)
    outpw(0x3ce, 0x0106);       // graf06 = 01  (128K, graphics mode)
    outpw(0x3ce, 0x0f07);       // graf07 = 0f  (pass all planes)
    outpw(0x3ce, 0xff08);       // graf08 = ff  (pass all bits through mask)

    if ((PGL_modecfg.chip_type == CHIP_CT_ID) ||
        (PGL_modecfg.chip_type == CHIP_DT_ID))
    {
        // CT, DT

        // enable linear addressing through VGA aperture
        iow8(ioCRTC_GEN_CNTL + 3, ior8(ioCRTC_GEN_CNTL + 3) | 0x08);
    }
    else
    {
        // GX, CX
        outpw(0x1ce, 0x28b0);       // ATIB0  = 28  (512K, 256 color enable)
        outpw(0x1ce, 0x04b6);       // ATIB6  = 04  (linear addr 256 color mode)
    }
}

