/*==========================================================================
* SAVECUR.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to save and restore the hardware cursor colors             *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

// hardware cursor color save global variables
int PGL_save_red0;
int PGL_save_green0;
int PGL_save_blue0;
int PGL_save_red1;
int PGL_save_green1;
int PGL_save_blue1;
unsigned long PGL_save_cur_clr0;
unsigned long PGL_save_cur_clr1;

/* --------------------------------------------------------------------------
  pgl_savecursorcolors - save the hardware cursor colors
-------------------------------------------------------------------------- */
void pgl_savecursorcolors(void)
{
    int index;

    // save cursor colors
    if ((PGL_modecfg.dac_attribute == DAC_SP_ATI68860) ||
        (PGL_modecfg.dac_attribute == DAC_SP_TVP3026) ||
        (PGL_modecfg.dac_attribute == DAC_SP_IBM514))
    {
        // special setup for ATI68860, TVP3026, and IBM514 DACs

        // access cursor color registers
        iow8(ioDAC_CNTL, (ior8(ioDAC_CNTL) & 0xfc) | 1);

        // select 1st cursor color register to save
        switch(PGL_modecfg.dac_attribute)
        {
            case DAC_SP_ATI68860:
                iow8(ioDAC_REGS + DAC_R_INDEX, 0);
                index = DAC_DATA;
                break;

            case DAC_SP_TVP3026:
                // skip OVERSCAN color register on TVP3026 DAC
                iow8(ioDAC_REGS + DAC_R_INDEX, 1);
                index = DAC_DATA;
                break;

            case DAC_SP_IBM514:
                iow8(ioDAC_REGS + DAC_R_INDEX, 1);      // auto-increment
                iow8(ioDAC_REGS + DAC_W_INDEX, 0x40);
                iow8(ioDAC_REGS + DAC_DATA, 0);         // index = 0x40
                index = DAC_MASK;
                break;
        }

        // read 1st cursor color
        PGL_save_red0 = ior8(ioDAC_REGS + index);
        PGL_save_green0 = ior8(ioDAC_REGS + index);
        PGL_save_blue0 = ior8(ioDAC_REGS + index);

        // read 2nd cursor color
        PGL_save_red1 = ior8(ioDAC_REGS + index);
        PGL_save_green1 = ior8(ioDAC_REGS + index);
        PGL_save_blue1 = ior8(ioDAC_REGS + index);

        // return DAC register set to palette registers
        iow8(ioDAC_CNTL, ior8(ioDAC_CNTL) & 0xfc);
    }
    else
    {
        // save cursor colors on other dacs
        PGL_save_cur_clr0 = regr(CUR_CLR0);
        PGL_save_cur_clr1 = regr(CUR_CLR1);
    }
}

/* --------------------------------------------------------------------------
  pgl_restorecursorcolors - restore the hardware cursor colors
-------------------------------------------------------------------------- */
void pgl_restorecursorcolors(void)
{
    int index;

    // restore cursor colors
    if ((PGL_modecfg.dac_attribute == DAC_SP_ATI68860) ||
        (PGL_modecfg.dac_attribute == DAC_SP_TVP3026) ||
        (PGL_modecfg.dac_attribute == DAC_SP_IBM514))
    {
        // special setup for ATI68860, TVP3026, and IBM514 DACs

        // access cursor color registers
        iow8(ioDAC_CNTL, (ior8(ioDAC_CNTL) & 0xfc) | 1);

        // select 1st cursor color register to restore
        switch(PGL_modecfg.dac_attribute)
        {
            case DAC_SP_ATI68860:
                iow8(ioDAC_REGS + DAC_W_INDEX, 0);
                index = DAC_DATA;
                break;

            case DAC_SP_TVP3026:
                // skip OVERSCAN color register on TVP3026 DAC
                iow8(ioDAC_REGS + DAC_W_INDEX, 1);
                index = DAC_DATA;
                break;

            case DAC_SP_IBM514:
                iow8(ioDAC_REGS + DAC_R_INDEX, 1);      // auto-increment
                iow8(ioDAC_REGS + DAC_W_INDEX, 0x40);
                iow8(ioDAC_REGS + DAC_DATA, 0);         // index = 0x40
                index = DAC_MASK;
                break;
        }

        // restore 1st cursor color
        iow8(ioDAC_REGS + index, PGL_save_red0);
        iow8(ioDAC_REGS + index, PGL_save_green0);
        iow8(ioDAC_REGS + index, PGL_save_blue0);

        // restore 2nd cursor color
        iow8(ioDAC_REGS + index, PGL_save_red1);
        iow8(ioDAC_REGS + index, PGL_save_green1);
        iow8(ioDAC_REGS + index, PGL_save_blue1);

        // return DAC register set to palette registers
        iow8(ioDAC_CNTL, ior8(ioDAC_CNTL) & 0xfc);
    }
    else
    {
        // restore cursor colors on other dacs
        regw(CUR_CLR0, PGL_save_cur_clr0);
        regw(CUR_CLR1, PGL_save_cur_clr1);
    }
}

