title		Program Options in Scratch Pads (Module options.asm)
;****************************************************************
;
;	$Workfile:   options.asm  $
; 
; 
;	Contents:
;
; 	Modification History:
; 	$Log:   M:/vcs/vga/64xx/options.asv  $
;      
;      
;****************************************************************

cgroup		group	VGA_Segment

	.XLIST
	include		config.inc
	include		options.inc
	include		struc.inc
	INCLUDE 	VGADATA.INC
	.LIST

	%OUT	Assembling OPTIONS


VGA_Segment	SEGMENT PUBLIC BYTE

	ASSUME	CS:cgroup
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

ifdef SCRIDX
		extrn	getscr:near		; read a scratch pad
		extrn	setscr:near		; write a scratch pad
endif	;SCRIDX
		extrn	pgm_ext:near	; write to extension register from a table
		extrn	_writeprom:near

;----------------------------------------------------------------------
;
;	program_reg()
;
;	Function:
;	   Programs register with pass-in value and mask.
;
;	Input:
;	   DX	= I/O port
;	   AL	= register index
;	   BH	= value mask
;	   BL	= value to be set
;
;	Returns:
;	   DX	= pass-in I/O port
;
;----------------------------------------------------------------------
	public	program_SCR

program_SCR	proc	near
	push	dx
	mov	dx, SCRIDX
	and	bl, bh		;mask out pass-in value
	call	getscr
	not	bh		;reverse mask
	and	ah, bh
	or	ah, bl
	call	setscr
	pop	dx
	ret
program_SCR	endp
;
;
;-----------------------------------------------------------------------
;
;	set_option()
;
;	Function:
;	   Sets the option in scratch pads.
;
;	Input:
;	   AL	= value to be set
;	   AH	= register index
;	   BH	= value mask
;
;	Returns:
;
;	Remarks:
;	   This procedure always clears bit 7 of the argument in AL prior
;	to setting the scratch pad register.  The argument in AX is preserved.
;
;-----------------------------------------------------------------------
set_option 	proc	near
		public	set_option

		push	ax
		push	bx
		push	cx
		mov	bl, al
		mov	al, ah
		call	program_SCR

		call	pgm_eeprom		; yes, save value in eeprom

set_option_exit:
		pop	cx			; restore registers
		pop	bx
		pop	ax			

		ret				; return to caller
set_option 	endp

;-----------------------------------------------------------------------
;
;	pgm_eeprom()
;
;	Function:
;
;	Input:
;
;	Returns:
;
;	Remarks:
;
;-----------------------------------------------------------------------
pgm_eeprom	proc	near

		push	bx
		push	cx
		push	dx
		mov	al,SP_OPT1
		call	getscr
		mov	bl,ah
		mov	al,SP_OPT2
		call	getscr
		mov	bh,ah
if 0
ifdef (ALP_NEW)
		mov	al,SP_OPT4
		call	getscr
		mov	cl,ah
endif	; (ALP_NEW)
endif


		call	_writeprom

		pop	dx
		pop	cx
		pop	bx
		ret

pgm_eeprom	endp

if 0
;-----------------------------------------------------------------------
;
;	set_user_opts()
;
;	Function:
;	   Currently just programs VGA to 8-bit or 16-bit according to 
;	   scratch register value.
;
;	Input:
;	   Nothing.
;
;	Remarks:
;	   None.
;
;-----------------------------------------------------------------------
set_user_opts	proc	near
		public	set_user_opts

		mov	al, SP_OPT2
		call	getscr
		mov	al, ah			;program 8bit/16bit only
		xor	al, 1			;reverse definition for HW bit
		ror	al, 1
		ror	al, 1			;shift value to bit6
		mov	bl, al			;value
		mov	bh, 40h			;bit mask
		mov	al, 8			;reg. index for 16/8 bit
		call	program_SCR
		ret				; return to caller
set_user_opts 	endp
endif	; 0

VGA_Segment		ends
		end


