	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module C
;****************************************************************
;
;	$Workfile:   vgac.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the routines to set the cursor type,
;	set the cursor position, read the cursor position, and
;	the select page routine.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgac.asv  $
;      
;         Rev 1.0   21 Dec 1990 11:00:18   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to Video_Set_Cursor.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling VGA BIOS Module C

VGA_Segment SEGMENT PUBLIC WORD

	PUBLIC	Cursor_Emulation
	PUBLIC	Video_Cursor_Type
	PUBLIC	Video_Light_Pen
	PUBLIC	Video_Set_Cursor
	PUBLIC	Video_Get_Cursor
	PUBLIC	Video_Select_Page

	EXTRN	Get_Extended_Mode_Info:NEAR
	EXTRN	Get_Current_Mode_Info:NEAR	;gdl:01/14/92

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

;****************************************************************
;   AH = 01	Set cursor type (start and end)
;		CL - Cursor end line
;		CH - Cursor start line
;****************************************************************

;gdl	ALIGN	4

Video_Cursor_Type PROC NEAR
	MOV	Cursor_Size,CX			;Save the cursor start and end
	MOV	DX,M6845_Address		;Get 6845 base address
	CALL	Cursor_Emulation
	MOV	AX_Stack,AX			;This is for compatibility
	RET

;gdl	ALIGN	4

Cursor_Emulation:
	TEST	EGA_StatusA,EGA_Passive 	;Test if we are active
	JNE	Write_Cursor_Regs		;No -Go write cursor directly
	MOV	AX,CX				;Get cursor setting
	AND	AH,060H 			;Test for cursor off
	CMP	AH,020H 			;Is the cursor off
	JNE	Cursor_On			;No -Go translate cursor
	MOV	CX,01E00H			;Yes-Set to 1E00H
	JMP	SHORT Write_Cursor_Regs 	;Start will get decrement

Cursor_On:
	TEST	EGA_StatusA,No_Emulation	;Test if we are to emulate
	JNE	Write_Cursor_Regs		;No -Go write cursor directly
	MOV	AX,CX				;Get cursor setting
	AND	AX,0E0E0H			;If either larger than 1F then
	JNE	Write_Cursor_Regs		;then dont emulate
	MOV	AL,Video_Mode			;Get current video mode
	CMP	AL,04				;Are we in text mode
	JB	Emulate_Cursor			;Yes-Emulate cursor
	CMP	AL,07				;How about mono text mode
	JE	Emulate_Cursor			;Yes-Emulate cursor
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	CALL	Get_Extended_Mode_Info		;Are we extended video mode
;	JNE	Write_Cursor_Regs		;No -Go write cursor regs
	TEST	AL,EVM_Text			;Are we extended text mode
	JE	Write_Cursor_Regs		;No -Go write cursor regs

Emulate_Cursor:
	CMP	CL,CH				;Is end line >= start line
	JAE	End_Is_Larger			;Go handle normal cursor
	OR	CL,CL				;No -Handle split cursor
	JE	Write_Cursor_Regs		;If end is zero then Ok
	MOV	CH,CL
	MOV	CL,BYTE PTR Char_Length
	DEC	CL
	JMP	SHORT Write_Cursor_Regs

End_Is_Larger:
	MOV	BL,BYTE PTR Char_Length 	;Get character length and
	MOV	BH,BL				;and Char_Length - 1 in
	DEC	BL				;registers for speed
	MOV	AL,CL				;Test if either start or
	OR	AL,CH				;end is larger than char
	CMP	AL,BH				;length
	JAE	Larger_Than_Char
	CMP	CL,BL				;If end   is char_length-2
	JE	Write_Cursor_Regs		;or start is char_length-1
	DEC	BL				;then assume proper cursor
	CMP	CH,BL				;size and dont translate
	JE	Write_Cursor_Regs
	INC	BL

Larger_Than_Char:
	CMP	CL,03				;Is the end smaller than 3
	JBE	Write_Cursor_Regs		;Yes-Below thres. Dont trans
	MOV	AL,CH				;No -Get start line
	ADD	AL,02				;Translate by adding 2
	CMP	AL,CL				;Are we larger than end
	JAE	Could_Be_Small_char		;Go check char box
	CMP	CH,02				;Was the original start 0
	JA	Translate_Cursor		;Go translate cursor
	MOV	CL,BL				;No -Set end to char_Length-1

Write_Cursor_Regs:
	MOV	AH,CH				;Get high byte to write
	MOV	AL,0AH				;Get register to write
	OUT	DX,AX				;Write CRT cursor start
	MOV	AH,CL				;Get low cursor size
	MOV	AL,0BH				;Get CRT register
	OUT	DX,AX				;Write CRT cursor end
	RET

Translate_Cursor:
	MOV	CL,BL				;Set half sizse block cursor
	MOV	CH,BH				;Set start to half the
	SHR	CH,1				;size of char_Length
	JMP	SHORT Write_Cursor_Regs 	;Go write the registers

Could_Be_Small_Char:
	CMP	BH,0EH				;Are we smaller than 8x14
	JB	Translate_8x8_Cursor		;Yes-Go translate
	DEC	BL				;Backup 1 for compatibility

Translate_8x8_Cursor:
	SUB	CH,CL				;Set standard size cursor
	ADD	CH,BL
	MOV	CL,BL				;Set end to char_length-2 or 1
	JMP	SHORT Write_Cursor_Regs 	;Go write the registers
Video_Cursor_Type	ENDP

;****************************************************************
;   AH = 02	Set cursor position
;		BH - Page to set cursor
;		DL - Character column position
;		DH - Character row position
;****************************************************************

;gdl	ALIGN	4

Video_Set_Cursor PROC NEAR
	MOV	AL,BH				;Save page for cursor
	XCHG	BL,BH				;Convert to offset
	XOR	BH,BH				;Extend to BX
	SHL	BX,1				;Double for cursor table
	MOV	Cursor_Location[BX],DX		;Save the new cursor position
	CMP	Active_Page,AL			;Test if set in active page
	JNE	Exit_VSC			;No -Dont update cursor

Set_Cursor:
	MOV	AL,BYTE PTR Video_Columns	;Get column size
	MUL	DH				;Multiply by row number
	ADD	AL,DL				;Add columns to value
	ADC	AH,00				;Add in any carry
	MOV	BX,Video_Start			;Get the start of the video
	SHR	BX,1				;Remove attribute count
	ADD	BX,AX				;Add rel position to base
	MOV	AL,0EH				;Cursor start register
	MOV	DX,M6845_Address		;Get CRT base address
	MOV	AH,BH				;Get cursor high address
	OUT	DX,AX				;Write to CRT register
	MOV	AH,BL				;Get cursor lo byte
	INC	AL				;Advance to CRT address
	OUT	DX,AX				;Write low CRT register

Exit_VSC:
	RET
Video_Set_Cursor ENDP

;****************************************************************
;   AH = 03	Get cursor position of page
;		BH - Page to return cursor
;		Exit:	DL - Character column position
;			DH - Character row position
;			CL - Cursor end line
;			CH - Cursor start line
;****************************************************************

;gdl	ALIGN	4

Video_Get_Cursor PROC NEAR
	XCHG	BL,BH				;Setup page for offset
	XOR	BH,BH				;into cursor table
	ADD	BX,BX				;Double for cursor table
	MOV	DX,Cursor_Location[BX]		;Read cursor position for page
	MOV	CX,Cursor_Size			;Get cursor size
	MOV	CX_Stack,CX			;Save cursor size
	MOV	DX_Stack,DX			;Save cursor position
	RET
Video_Get_Cursor ENDP

;****************************************************************
;   AH = 04	Return light pen position
;		Exit:	DL - Char column of light pen
;			DH - Char row of light pen
;			CH - Raster line (compatibility modes)
;			CX - Raster line (enhanced modes)
;			BX - Pixel column
;			AH - Light pen trigger (1 - pressed)
;
;   This routine will return AX = 00 if the light pen request
;   is for the VGA adapter, since light pen is not supported.
;****************************************************************

Video_Light_Pen PROC NEAR
IFDEF ADAPTER
	TEST	EGA_StatusA,EGA_Passive 	;Is the VGA passive
	JE	Return_AX_Zero			;Yes-Always return AX=0
	INT	42H				;No -Send to alternate card
	MOV	DX_Stack,DX			;Save row/column
	MOV	CX_Stack,CX			;Save pixel row
	MOV	BX_Stack,BX			;Save pixel column
	MOV	AX_Stack,AX			;Save light pen status
	RET

Return_AX_Zero:
ENDIF
	XOR	AX,AX				;Return AX=0 if request
	MOV	AX_Stack,AX			;made for VGA adapter
	RET
Video_Light_Pen ENDP

;****************************************************************
;   AH = 05	Change displayed (active) page			*
;		AL - Page number to display			*
;****************************************************************

;gdl	ALIGN	4

Video_Select_Page PROC NEAR
	XOR	AH,AH				;Extend page to AX
	AND	AL,07				;Between 0 and 7
	MOV	DI,AX				;Save for later use
	MOV	Active_Page,AL			;Save new active page
	MUL	Video_Length			;Compute new start address
	MOV	Video_Start,AX			;Save new video start in BIOS
	MOV	BX,AX				;Save character screen start
	MOV	AL,Video_Mode			;Test for VGA mode
	CMP	AL,07H				;Test for VGA mode
	JBE	Set_Text_Page			;Set page start
	CMP	AL,13H				;Test for extended mode
	JBE	Set_Physical_Page		;Go if standard vga mode
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	CALL	Get_Extended_Mode_Info		;Are we extended mode
;	JNE	Set_Physical_Page		;No -Go set as is
	TEST	AL,EVM_Text			;Are we text mode
	JE	Set_Physical_Page		;No -Go set as is

Set_Text_Page:
	SHR	BX,1				;Divide by 2 to remove attr

Set_Physical_Page:
	MOV	DX,M6845_Address		;Get CRT base address
	MOV	AL,0CH				;Write new screen address
	MOV	AH,BH				;Get high byte of start addr
	OUT	DX,AX				;Write hi byte to CRT
	MOV	AH,BL				;Get lo byte of start addr
	INC	AL				;Advance to lo CRT byte
	OUT	DX,AX				;Write lo start byte
	SHL	DI,1				;Mult by 2 for cursor table
	MOV	DX,Cursor_Location[DI]		;Read cursor pos for this page
	JMP	Set_Cursor			;Go update cursor registers
Video_Select_Page ENDP

;****************************************************************

VGA_Segment ENDS

	END

