	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module F
;****************************************************************
;
;	$Workfile:   vgaf.asm  $
;
;	Copyright 1989, 1990 Quadtel Corporation.
;	All rights reserved.
;
;	Contents:
;	This module contains the read dot function, the write dot
;	function, teletype write, and return video params function.
;
;	Modification History:
;	$Log:   M:/vcs/vga/vgaf.asv  $
;      
;         Rev 1.1   23 Jul 1991 20:50:52   dale
;      Function 0EH (TTY output) was enhanced
;
;	  Rev 1.0   21 Dec 1990 11:00:32   Darryl
;      Initial checkin to VCS.
;
;	01/02/90  The Teletype write function was not using
;		  the active page when the video was scrolled
;		  and the attribute from the last line is read.
;
;	07/08/89  Speed optimizations made to read and write
;		  dot and the teletype functions.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling VGA BIOS Module F

VGA_Segment SEGMENT PUBLIC	WORD

	PUBLIC	Beep
	PUBLIC	Default_VGA_Read_Dot
	PUBLIC	Default_VGA_Write_Dot
	PUBLIC	Do_Extended_Read_Dot
	PUBLIC	Do_Extended_Write_Dot
	PUBLIC	Set_Palette
	PUBLIC	Save_Palette_Value
	PUBLIC	VGA_Read_Dot
	PUBLIC	VGA_Write_Dot
	PUBLIC	Video_Parameters
	PUBLIC	Video_Read_Dot
	PUBLIC	Video_Write_Dot
	PUBLIC	Video_Set_Palette
	PUBLIC	Video_Teletype_Write

	EXTRN	BIOS_Read_Char_Attr:NEAR
	EXTRN	Extended_Read_Dot:NEAR
	EXTRN	Extended_Write_Dot:NEAR
	EXTRN	Gate_Timer:NEAR
	EXTRN	Get_Extended_Mode_Info:NEAR
	EXTRN	Get_Current_Mode_Info:NEAR	;gdl:01/14/92
	EXTRN	Get_Mode_Table:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Segment_A000:WORD
	EXTRN	Video_Set_Cursor:NEAR
	EXTRN	Video_Write_Char:NEAR
	EXTRN	Video_Cursor_Type:NEAR
	EXTRN	Video_Scroll_Up:NEAR
	EXTRN	Scroll_Up_One_Line:NEAR
	extrn	get_crtc_addr:near

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

;****************************************************************
;   AH = 0B	Write color palette
;		BL - Color value for palette
;		BH - Palette color ID (0-127)
;****************************************************************

;	ALIGN	4

Video_Set_Palette PROC NEAR
	CMP	M6845_Address,03B4H		;Test if we are mono
	JE	Done_Old_Palette		;Yes-Just ignore command
IFDEF ADAPTER	;gdl
	TEST	EGA_StatusA,EGA_Passive 	;No -Is VGA mono
	JE	Do_Set_Palette			;No -Must do command

;gdl IFDEF ADAPTER
	INT	42H				;Yes-Let CG card do function
	RET					;And were done
ENDIF

;gdl	RET					;And were done

Do_Set_Palette:
	CMP	BH,00				;Test for background
	JE	Background			;Handle background

Palette_Handler:
	MOV	AL,Video_Mode			;Get current video mode
	CMP	AL,04				;Test for text mode
	JB	Done_Old_Palette		;Exit - text mode
	CMP	AL,13H				;Test for non-standard mode
	JBE	Graphics_Palette		;Go -If mode 4-13H
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	CALL	Get_Extended_Mode_Info		;Get extended video mode info
	TEST	AL,EVM_Text			;Is it a text mode
	JNE	Done_Old_Palette		;Yes-handle as text mode

Graphics_Palette:
	MOV	BH,Video_Palette		;Get palette value
	AND	BH,0DFH 			;Reset bit
	AND	BL,01				;Test bit
	JE	Set_Comp_Palette		;Set compatibility palette
	OR	BH,020H 			;Set palette bit

Set_Comp_Palette:
	MOV	Video_Palette,BH		;Save palette value
	AND	BH,10H				;Isolate bit
	OR	BH,BL				;Set color bits
	OR	BX,0201H			;Set bit and register

ifdef SYSTEM
	TEST	EGA_StatusA,EGA_Passive 	;Is VGA active?
	JNE	Do_Set_Palette_6845		;No -Just do 3X9
endif	;SYSTEM

Comp_Palette_Loop:
	CALL	Set_Palette			;Set palette register
	CALL	Save_Palette_Value		;Save value in table
	ADD	BH,2				;Next value
	INC	BL				;Next register
	CMP	BL,3				;Test for last register
	JBE	Comp_Palette_Loop		;Write next register

ifdef SYSTEM
Do_Set_Palette_6845:				;Just do 3X9
endif	;SYSTEM
	MOV	DX,CRT_3D4 + 5			;Write color select
	MOV	AL,Video_Palette		;for compatibility
	OUT	DX,AL

Done_Old_Palette:
	RET

Background:
	MOV	AH,Video_Palette		;Get palette register
	AND	AH,0E0H 			;Isolate bits
	MOV	BH,BL				;Get color value
	AND	BH,01FH 			;Mask color bits
	OR	AH,BH				;Set bit mask
	MOV	Video_Palette,AH		;Set new palette value
	MOV	AL,BL_Stack			;Restore color from stack
	AND	AL,008H 			;Isolate bit
	SHL	AL,1				;Shift down
	AND	BH,07				;Isolate color bits
	OR	BH,AL				;Set in color mask

Background_Set:
	MOV	BL,011H 			;Actual write in 11H
	CALL	Set_Palette			;Set palette register

Background_Palette:
	MOV	BL,010H 			;16th place for compatibility
	CALL	Save_Palette_Value		;Save value in table
	MOV	AL,Video_Mode			;Get current video mode
	CMP	AL,03				;Test for text mode
	JBE	Overscan_Only			;Skip setting palette zero
	CMP	AL,13H				;Test for standard VGA mode
	JBE	Set_VGA_Background		;Yes-Go set as VGA mode
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	CALL	Get_Extended_Mode_Info		;Get extended mode info
	TEST	AL,EVM_Text			;Is it text mode
	JNE	Overscan_Only			;Yes-Go set overscan

Set_VGA_Background:
	XOR	BL,BL				;Set palette zero
	CALL	Set_Palette			;Set palette register
	CALL	Save_Palette_Value		;Save value in table

Overscan_Only:
	MOV	BL,Video_Palette		;Get video palette
	AND	BL,020H 			;Isolate bit
	MOV	CL,05				;Shift number
	SHR	BL,CL				;Shift down
	JMP	Palette_Handler 		;Go handle palette
Video_Set_Palette ENDP

;****************************************************************
;   Place the palette value into the attribute table in the
;   specified location.
;
;	Entry:	BH - Value to save
;		BL - Address offset in table
;****************************************************************

Save_Palette_Value PROC NEAR
	PUSH	AX				;Save registers
	PUSH	DI
	PUSH	ES
	LES	DI,Env_Ptr			;Get pointer to environment
	LES	DI,ES:[DI+4]			;Get pointer to variable area
	MOV	AX,ES				;Get segment
	OR	AX,DI				;Test for no pointer
	JE	No_Palette_Table		;No table defined
	MOV	AL,BL				;Get offset
	MOV	AH,00				;Reset high byte
	ADD	DI,AX				;Add to offset
	MOV	AL,BH				;Get value
	STOSB					;Store byte in table

No_Palette_Table:
	POP	ES				;Restore registers
	POP	DI
	POP	AX
	RET
Save_Palette_Value ENDP

;****************************************************************
;   Write the palette value to the attribute controller after
;   waiting for the vertical retrace to start.
;
;	Entry:	BH - Value to write
;		BL - Address offset
;****************************************************************

Set_Palette PROC NEAR
	PUSH	AX				;Save registers
	push	cx
	PUSH	DX
	call	get_crtc_addr
;	MOV	DX,M6845_Address		;Get offset address
	ADD	DL,6				;Vertical retrace status

	xor	cx,cx
Wait_Vertical_Retrace:
	IN	AL,DX				;Get status
	AND	AL,08H				;Test for retrace active
	loopz	Wait_Vertical_Retrace		;Wait for retrace
;	AND	AL,08H				;Test for retrace active
;	JE	Wait_Vertical_Retrace		;Wait for retrace
	MOV	DX,Attribute_Controller 	;Get attribute controller
	MOV	AL,BL				;Get address to write
	pushf
	CLI					;No interrupts now
	OUT	DX,AL				;Write to address
	MOV	AL,BH				;Get value to write
	JMP	SHORT $+2			;Delay briefly
	OUT	DX,AL				;Write value to controller
	MOV	AL,020H 			;Reenable palette
	OUT	DX,AL				;Write to reenable
	popf					;Allow interrupts again
	POP	DX				;Restore registers
	pop	cx
	POP	AX
	RET
Set_Palette ENDP

;****************************************************************
;  Mode 13 Write Dot
;****************************************************************

;	ALIGN	4

VGA_Mode13_Write_Dot:
	JA	Goto_Extended_Write_Dot
	PUSH	ES
	PUSH	DI
	PUSH	AX
	PUSH	DX				;Save registers
	MOV	DI,AX				;Save dot to write
;	 MOV	 AX,0A000H			 ;Setup Regen segmen
	MOV	ES,Segment_A000 		;Setup for ES:DI write
	MOV	AX,140H 			;Get length of line
	MUL	DX				;Compute start of line
	ADD	AX,CX				;Add offset to pixel
	XCHG	DI,AX				;Set for write
	STOSB					;Write to video
	POP	DX				;Restore registers
	POP	AX
	POP	DI
	POP	ES
	POP	DS
	IRET

Goto_Extended_Write_Dot:
	JMP	Extended_Write_Dot

;****************************************************************
;  Mode 4, 5, 6  Write Dot
;****************************************************************

;	ALIGN	4

CGA_Write_Dot:
	CMP	AH,04				;Test for text modes
	JB	Exit_VWD			;Yes-Just exit
	CMP	AH,07				;Test for mono text
	JE	Exit_VWD			;Yes-Just exit
	CMP	AH,08H				;Test for high res mode
	JAE	VGA_Write_Dot			;Write high res dot
	PUSH	ES
	PUSH	DI
	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save registers
	MOV	BX,AX				;Save dot value
	CALL	Dot_Position			;Calculate pel location
	MOV	AL,AH				;Get bit mask
	ROR	AL,CL				;Move to low order bits
	NOT	AL				;Invert mask
	AND	AL,BL				;and isolate value to write
	SHL	AL,CL				;Move to proper bit location
	OR	BL,BL				;Test for XOR function
	JS	XOR_CGA_Dot			;If bit 7 set then Do XOR
	AND	AH,ES:[DI]			;No -Clear old value
	OR	AL,AH				;Merge in new value
	STOSB					;Write back to screen

Ret_VWD:
	MOV	AX,BX				;restore AX
	POP	DX				;Restore registers
	POP	CX
	POP	BX
	POP	DI
	POP	ES

Exit_VWD:
	POP	DS
	IRET

XOR_CGA_Dot:
	XOR	ES:[DI],AL			;XOR value on screen
	JMP	SHORT Ret_VWD

;****************************************************************
;   AH = 0C	Write graphics pixel
;		AL - Color value for pixel (XORed if bit7=1)
;		CX - Column to write pixel
;		DX - Row to write pixel
;****************************************************************

;	ALIGN	4

Video_Write_Dot PROC	NEAR
	PUSH	DS				;Save global registers
	MOV	DS,INT_Address			;Set DS to BIOS data area
	MOV	AH,Video_Mode			;Get current video mode
	CMP	AH,0DH				;Test for text/CGA modes
	JB	CGA_Write_Dot			;Go handle modes 0-7
	CMP	AH,13H				;Test for mode 13 and above
	JAE	VGA_Mode13_Write_Dot		;Go handle mode 13/ext modes

;****************************************************************
;  Mode D, E, F, 10, 11, 12  Write Dot
;****************************************************************

VGA_Write_Dot:
	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save Write Dot registers

Default_VGA_Write_Dot:
	XCHG	BX,CX				;Keep offset in BX
	MOV	CL,BL				;CL=bit position, CH=Page number
	SHR	BX,1				;Divide offset by
	SHR	BX,1				;eight since there
	SHR	BX,1				;are 8 pixels/byte
	OR	CH,CH				;Are we page zero
	JNE	Add_PageWD			;No -Go compute page offset

Cont_PageWD:
	MOV	CH,AL				;Save pixel value in CH
	MOV	AX,Video_columns		;Get row position
	MUL	DX				;Compute row offset
	ADD	BX,AX				;Add row offset into BX

Do_Extended_Write_Dot:
	MOV	DX,Sequencer			; must set all planes every
	MOV	AL,02h				; writedot
	extrn	GETREG:near
	CALL	GETREG
	OR	AH,0Fh
	OUT	DX,AX
	MOV	DX,Graphics_Controller
	XOR	AX,AX
	OUT	DX,AX				;Clear set/reset register
	MOV	AX,00F01H
	OUT	DX,AX				;Enable all Set/Reset Regs
	AND	CL,07H				;Isolate offset within byte
	MOV	AX,08008H			;Get mask and bit mask reg
	SHR	AH,CL				;Adjust bit mask
	OUT	DX,AX				;Set bit mask register
	MOV	AX,0A000H			;THIS ALSO SETS AL=00
	MOV	DS,AX				;Setup DS to video regen
	OR	CH,CH				;Test for XOR function
	JS	Do_XOR_Dot			;Yes-Go to XOR function
	OR	[BX],AL 			;Clear old color
	MOV	AH,CH				;Get new color
	OUT	DX,AX				;Select new mask
	OR	[BX],AL 			;Set new color

Exit_Write_VGA_Dot:
	MOV	AX,0FF08H
	OUT	DX,AX				;Set bit mask back to FFH
	XOR	AX,AX				;Set set/reset bits to zero
	OUT	DX,AX
	INC	AL
	OUT	DX,AX				;Clear enable set/reset reg
	MOV	AL,CH				;Return dot in AL
	MOV	AH,0CH				;Restore Function number
	POP	DX				;Restore registers
	POP	CX
	POP	BX
	POP	DS
	IRET

;	ALIGN	4

Add_PageWD:
	ADD	BX,Video_Length 		;Add for next page
	DEC	CH				;Decrement counter
	JNE	Add_PageWD			;Next page
	JMP	SHORT Cont_PageWD

;	ALIGN	4

Do_XOR_Dot:
	MOV	AX,01803H
	OUT	DX,AX				;Set XOR operation
	MOV	AH,CH				;Get current pixel value
	XOR	AL,AL				;Get set/reset reg index
	OUT	DX,AX				;Put color in Set/reset reg
	OR	[BX],AL 			;XOR the bits in color patern
	MOV	AX,0003H			;Clear XOR function from
	OUT	DX,AX				;the Data Rotate reg
	JMP	Exit_Write_VGA_Dot
Video_Write_Dot ENDP

;****************************************************************
;  Mode 13 Read Dot
;****************************************************************

;	ALIGN	4

VGA_Mode13_Read_Dot:
	JA	Goto_Extended_Read_Dot
	PUSH	DX
	PUSH	DI				;Save registers
;	 MOV	 AX,0A000H			 ;Setup Regen segment
	MOV	DS,Segment_A000 		;Setup for ES:DI write
	MOV	AX,140H 			;Get length of line
	MUL	DX				;Compute start of line
	ADD	AX,CX				;Add offset to pixel
	MOV	DI,AX				;Set for write
	MOV	AL,[DI] 			;Get pixel
	MOV	AH,0DH				;Restore function number
	POP	DI				;Restore registers
	POP	DX
	POP	DS
	IRET

Goto_Extended_Read_Dot:
	JMP	Extended_Read_Dot

;****************************************************************
;  Mode 4, 5, 6  Read Dot
;****************************************************************

;	ALIGN	4

CGA_Read_Dot:
	CMP	AH,04				;Test for text modes
	JB	Exit_VRD			;Yes-Just exit
	CMP	AH,07				;Test for mono text
	JE	Exit_VRD			;Yes-Just exit
	CMP	AH,08H				;Test for high res mode
	JAE	VGA_Read_Dot			;Read high res dot
	PUSH	ES
	PUSH	DI
	PUSH	CX
	PUSH	DX				;Save registers
	CALL	Dot_Position			;Compute pel location
	NOT	AH				;Invert bit mask
	AND	AH,ES:[DI]			;Isolate only the bits we want
	SHR	AH,CL				;Move to low bit locations
	MOV	AL,AH				;Return dot in AL
	MOV	AH,0DH				;Restore AH with function number
	POP	DX				;Restore registers
	POP	CX
	POP	DI
	POP	ES

Exit_VRD:
	POP	DS
	IRET

;****************************************************************
;   AH = 0D	Read graphics pixel
;		CX - Column to read pixel
;		DX - Row to read pixel
;		Exit:	AL - Value of pixel read
;****************************************************************

;	ALIGN	4

Video_Read_Dot PROC NEAR
	PUSH	DS				;Save global registers
	MOV	DS,INT_Address			;Set DS to BIOS data area
	MOV	AH,Video_Mode			;Get current video mode
	CMP	AH,0DH				;Test for text/CGA modes
	JB	CGA_Read_Dot			;Go handle modes 0-7
	CMP	AH,13H				;Test for mode 13 and above
	JAE	VGA_Mode13_Read_Dot		;Go handle mode 13/ext modes

;****************************************************************
;  Mode D, E, F, 10, 11, 12  Read Dot
;****************************************************************

VGA_Read_Dot:
	PUSH	SI
	PUSH	BX
	PUSH	CX
	PUSH	DX				;Save Read Dot registers

Default_VGA_Read_Dot:
	MOV	SI,CX				;Compute offset in SI
	SHR	SI,1				;Divide by 8 since
	SHR	SI,1				;there are eight pixels
	SHR	SI,1				;per byte
	OR	BH,BH				;Are we page zero
	JNE	Add_PageRD			;No -Compute page offset

Cont_PageRD:
	MOV	AX,Video_columns		;Get row position
	MUL	DX				;Compute row offset
	ADD	SI,AX				;Add row offset into BX

Do_Extended_Read_Dot:
	AND	CL,07				;Mask lower bits
	MOV	BL,080H 			;Shift to position
	SHR	BL,CL				;Shift down to position
;	 MOV	 AX,0A000H
	MOV	DS,Segment_A000 		;Setup DS to video regen
	MOV	DX,Graphics_Controller
	XOR	CL,CL				;CL will contain color
	MOV	AX,0304H			;Read from plane 3 to plane 0

Read_VGA_Bits:
	OUT	DX,AX				;Write map select register
	MOV	CH,[SI] 			;Read the pixel
	AND	CH,BL				;Isolate the bit
	NEG	CH				;Set carry if bit is a one
	ROL	CX,1				;Roll into return value
	DEC	AH				;Decrement plane count
	JNS	Read_VGA_Bits			;Repeat for 4 planes
	MOV	AL,CL				;Return pixel color in AL
	MOV	AH,0DH				;Restore function number in AH
	POP	DX				;Restore registers
	POP	CX
	POP	BX
	POP	SI
	POP	DS
	IRET

;	ALIGN	4

Add_PageRD:
	ADD	SI,Video_Length 		;Add for next page
	DEC	BH				;Decrement counter
	JNE	Add_PageRD			;Repeat for each page
	JMP	SHORT Cont_PageRD
Video_Read_Dot	ENDP

;****************************************************************
;   Calculate the pixel location and mask given a row and column
;   position. The pixel location and mask calculation will be based
;   on the current video mode (medium or high res).
;
;   Entry: CX - Column position
;	   DX - Row position
;   Exit:  AH - Bit mask
;	   CL - # of shifts to move to pixel
;	   ES - Segment for write
;****************************************************************

;	ALIGN	4

Dot_Position PROC NEAR
	MOV	AX,0B800H			;Set segment
	MOV	ES,AX				;Compatible graphics segment
	MOV	AL,40				;40 bytes per row
	MUL	DL				;Compute row position
	TEST	AL,08H				;Get odd/even row
	JE	Even_Dot_Row			;Even rows start at 00
	ADD	AX,2000H - 40			;Odd rows are offset 2000H

Even_Dot_Row:
	MOV	DI,AX				;Save start of row in DI
	MOV	AL,CL				;Get column position
	NOT	AL				;Invert for bit location
	CMP	Video_Mode,06			;Are we in low res mode
	JB	Low_Resolution			;Yes-Go compute bit mask
	SHR	CX,1				;No -8 bits per byte
	MOV	AH,0FEH 			;Only 1 bit mask
	AND	AL,07				;Mask unused shift bits
	JMP	SHORT Pixel_Position		;Go compute column position

Low_Resolution:
	MOV	AH,0FCH 			;Use 2 bit mask for med res.
	SHL	AL,1				;Adjust bit mask for 2 bit
	AND	AL,06H				;pel size-always shift even #

Pixel_Position:
	SHR	CX,1				;Divide by either 4 or 8
	SHR	CX,1				;depending on resolution
	ADD	DI,CX				;Advance to byte location
	MOV	CL,AL				;Get bit position in byte
	ROL	AH,CL				;Shift mask to bit position
	RET
Dot_Position	ENDP

;****************************************************************
;   Teletype Write Control Characters
;****************************************************************

;	ALIGN	4

TTY_Control_Char:
	JE	TTY_Carriage_Return		;Yes-Handle special
	CMP	AL,0AH				;Test for linefeed
	JE	TTY_Line_Feed			;Yes-Handle special
	CMP	AL,08H				;Test for backspace
	JE	TTY_Backspace			;Yes-Handle special
	CMP	AL,07H				;Test for bell
	JNE	TTY_Write_Char			;No -Go write the character
	CALL	Beep				;Yes-Go beep bell and exit
	JMP	Exit_TTY_Write

;	ALIGN	4

TTY_Carriage_Return:
	XOR	DL,DL				;Move to start of row
	JMP	Set_TTY_Cursor			;Go set cursor position

;	ALIGN	4

TTY_Backspace:
	DEC	DL				;Backup one column
	JNS	Set_TTY_CursorA 		;Go set cursor if wasnt at 0
	JMP	Exit_TTY_Write

Set_TTY_CursorA:
	JMP	Set_TTY_Cursor

TTY_Page_Not0:
	MOV	CL,Active_Page			;Read active page into CX
	XOR	CH,CH				;Will be used as an index
	MOV	DI,CX				;Move to DI
	SHL	DI,1				;Double for table offset
	MOV	BH,CL				;Put active page into BH
	MOV	DX,Cursor_Location[DI]		;Read cursor position for page
	CMP	AL,0DH				;Test for ASCII character
	JBE	TTY_Control_Char		;Go if control character
	JMP	SHORT TTY_Write_Char

;*****************************************************************
;   AH = 0E	Teletype write character
;		AL - Character to write
;		BL - Foreground color (graphics only)
;*****************************************************************

;	ALIGN	4

Video_Teletype_Write PROC NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS				;Save Registers
	MOV	DS,INT_Address			;Set DS to BIOS data area

	MOV	BH,Active_Page			;Read active page into BX
	OR	BH,BH				;Will be used as an index
	JNZ	TTY_Page_Not0			;Special case
	MOV	DX,Cursor_Location[00]		;Read cursor position for page
	CMP	AL,0DH				;Test for ASCII character
	JBE	TTY_Control_Char		;Go if control character

TTY_Write_Char:
	PUSH	DX				;Save video position
	XOR	CX,CX				;Clear the CX register
	INC	CL				;Set the count to 1
	CALL	Video_Write_Char		;Call write char directly
;	MOV	DS,Int_Address
	POP	DX				;Restore video position
	INC	DL				;Advance column position
	CMP	DL,BYTE PTR Video_Columns	;Test if column is wrapping
	JNE	Set_TTY_Cursor			;No -Go update new position
	XOR	DL,DL				;Yes-Move to start of row
	MOV	BH,Active_Page			;Get active page to read

TTY_Line_Feed:
	INC	DH				;Advance row position
	CMP	DH,Video_Rows			;Do we need to scroll screen
	JBE	Set_TTY_Cursor			;No -Just set cursor position
	DEC	DH				;Yes-Keep row at 24
	PUSH	DX				;Save cursor position
	CALL	BIOS_Read_Char_Attr		;Call BIOS to read attribute
;	MOV	DS,Int_Address
	MOV	BH,AH				;Thats what we'll use
	MOV	AL,Video_Mode			;if were in text mode
	CMP	AL,04				;Test for text modes 0-3
;**	jb	NotCGA
;** HSV bug 07/02/92
	JB	Set_Fill_Byte			;Yes-Go scroll screen
	CMP	AL,07				;Test for mono mode
	je	NotCGA
;*	JE	Set_Fill_Byte			;Yes-Use attribute read
	CMP	AL,13H				;Are we standard VGA mode
	JBE	Use_Zero_Fill			;Yes-Fill with 00
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	CALL	Get_Extended_Mode_Info		;Test for extended mode
;	JNE	Use_Zero_Fill
	TEST	AL,EVM_Text			;Are we text mode
;**	JNE	Set_Fill_Byte			;Yes-Go use attribute
	jne	NotCGA				;yes

Use_Zero_Fill:
	XOR	BH,BH				;Use zero for graphics
	cmp	Video_Mode,6			;CGA modes?
;	ja	NotCGA				;no
	jbe	Set_Fill_Byte			;yes

NotCGA:	
	call	Scroll_Up_One_Line		;special case scrolling	
	jmp	short NotCGACont

Set_Fill_Byte:
	MOV	DL,BYTE PTR Video_Columns	;Get number of columns
	DEC	DL				;Backup for scroll column
	MOV	DH,Video_Rows			;DX is lower right corner
	XOR	CX,CX				;CX is upper left corner
	MOV	AX,0601H			;Get scroll up function
	CALL	Video_Scroll_Up 		;Call scroll up routine
NotCGACont:
	MOV	DS,Int_Address
	POP	DX				;Restore cursor position
;	jmp	short Set_TTY_Cursor
;NotCGA:	
;	call	Scroll_Up_One_Line		;special case scrolling	
;	jmp	short NotCGACont
;;	MOV	DS,Int_Address
;;	POP	DX				;Restore cursor position

Set_TTY_Cursor:
	MOV	AL,Active_Page			;Get current active page
	OR	AL,AL				;Are we page zero
	JNE	Not_Page0_TTY_Cursor		;Handle page zero special case
	MOV	Cursor_Location[00],DX		;Save the new cursor position
;	CMP	Active_Page,AL			;Test if set in active page
;	JNE	Exit_TTY_Write			;No -Dont update cursor

Set_Cursor:
	MOV	AL,BYTE PTR Video_Columns	;Get column size
	MUL	DH				;Multiply by row number
	ADD	AL,DL				;Add columns to value
	ADC	AH,00				;Add in any carry
	MOV	BL,AL
	MOV	AL,0EH				;Cursor start register
	MOV	DX,M6845_Address		;Get CRT base address
	OUT	DX,AX				;Write to CRT register
	MOV	AH,BL				;Get cursor lo byte
	INC	AL				;Advance to CRT address
	OUT	DX,AX				;Write low CRT register

Exit_TTY_Write:
	POP	DS				;Restore registers
	POP	ES
	POP	BP
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET

;	ALIGN	4

Not_Page0_TTY_Cursor:
	MOV	BH,AL				;Get active page
	CALL	Video_Set_Cursor		;Go to set cursor directly
	JMP	short Exit_TTY_Write
Video_Teletype_Write ENDP

;***********************************************************************
;   Ring the bell for the specified duration. The frequency of the
;   tone is approximately 1075MHZ. A duration time of 390 is equivalent
;   to about 1 second.
;
;   Entry: CX - Duration
;***********************************************************************

Beep PROC NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX				;Save destroyed registers
	PUSH	DX				;since raw beep is needed
	MOV	AL,02				;Enable speaker & timer gate
	MOV	CX,580				;Generate tone for 1 second
	CALL	Gate_Timer			;during power on diagnostics
	POP	DX				;when no stack is available
	POP	CX				;Restore callers registers
	POP	BX
	POP	AX
	RET
Beep	ENDP

;****************************************************************
;   AH = 0F	Return Current Video Parameters 		*
;		Exit:	AL - Current video mode 		*
;			AH - Number of character columns	*
;			BH - Active page			*
;****************************************************************

Video_Parameters PROC NEAR
	MOV	AL,EGA_StatusA			;Get VGA status
	AND	AL,EGA_Screen_Clear		;Isolate bit status
	OR	AL,Video_Mode			;Get current video mode
	MOV	AL_Stack,AL			;Return in AL
	MOV	AL,BYTE PTR Video_Columns	;Get number of columns
	MOV	AH_Stack,AL			;Return in AH
	MOV	AL,Active_Page			;Get active page
	MOV	BH_Stack,AL			;Return in BH
	RET
Video_Parameters ENDP

;**********************************************************************

VGA_Segment ENDS

	END

