	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module H
;****************************************************************
;
;	$Workfile:   vgah.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains Functions 12H, 13H, 1AH, and 1BH
;	of the VGA BIOS.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgah.asv  $
;      
;         10 Oct 1991 Keith
;      $Bug fix.  Swapped bytes for active/inactive DCC in Video_State_Information.
;      $
;         Rev 1.1   03 Jun 1991 17:01:10   Darryl
;      $UPDATE:VGA BIOS core revision 11 modifications.
;      VGA BIOS modifications for core hook support.
;      $
;      
;         Rev 1.0   21 Dec 1990 11:00:44   Darryl
;      Initial checkin to VCS.
;
;	01/02/90  Function 13H was not properly calling the
;		  teletype function when handling control
;		  characters.
;
;	10/25/89  Function 1A was modified to return AH with 0
;		  if subfunction 00 or 01 was called.
;
;	07/08/89  Speed optimizations made to the core VGA BIOS.
;		  No code changes to this module.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
;khu
	include argframe.inc
	include	config.inc

	.LIST

	%OUT	Assembling VGA BIOS Module H

VGA_Segment SEGMENT PUBLIC WORD

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

	EXTRN	BIOS_Address:WORD
	EXTRN	Compute_DCC_Index:NEAR
	EXTRN	Establish_Video_Type:NEAR
	EXTRN   Extended_Altsel:NEAR
	EXTRN	Get_Env_Ptr:NEAR
	EXTRN	INT_Address:WORD
	EXTRN	Monitor_Type:NEAR
	EXTRN	Read_DAC:NEAR
	EXTRN	Read_Palette:NEAR
	EXTRN	Read_Reg:NEAR
	EXTRN	Read_Reg_NI:NEAR
	EXTRN	Restore_BIOS_Data_Area:NEAR
	EXTRN	Save_BIOS_Data_Area:NEAR
	EXTRN	Set_VGA_Registers:NEAR
	EXTRN	Setup_Planar_Vectors:NEAR
	EXTRN	VGA_State_Table:BYTE
	EXTRN	VGA_Video_Interface:NEAR
	EXTRN	Video_Set_Cursor:NEAR
	EXTRN	Video_Write_Char_Attr:NEAR
	EXTRN	Video_Teletype_Write:NEAR
	EXTRN	Write_DAC:NEAR
	extrn	ext_alt_sel:near
	extrn	getreg:near

	PUBLIC	Set_Scan_Lines
	PUBLIC	Video_Combination_Code
	PUBLIC	Video_State_Information
	PUBLIC	Video_Write_String
	PUBLIC	Video_VGA_Information

;****************************************************************
;   AH = 12	VGA System Information
;		BL = 10 Return VGA Information
;			Exit:	BH	- Adapter Type
;					0 - 3Dx Base Address
;					1 - 3Bx Base Address
;				BL    - Memory installed
;					0 - 64k
;					1 - 128k
;					2 - 192k
;					3 - 256k
;				CH    - Feature bits
;				CL    - Switch settings
;		BL = 20 Set INT 5 to 43 row print screen
;		BL = 30 Set scan lines for alpha modes
;			AL = 0	200 scan lines
;			AL = 1	350 scan lines
;			AL = 2	400 scan lines
;			Exit:	AL = 12
;		BL = 31 Set default palette loading
;			AL = 0	Enable default palette on mode
;			AL = 1	Disable default palette
;			Exit:	AL = 12
;		BL = 32 Video enable/disable
;			AL = 0	Enable video
;			AL = 1	Disable video
;			Exit:	AL = 12
;		BL = 33 Sum to gray shades enable/disable
;			AL = 0	Enable summing
;			AL = 1	Disable summing
;			Exit:	AL = 12
;		BL = 34 Enable/Disable cursor emulation
;			AL = 0	Enable emulation
;			AL = 1	Disable emulation
;			Exit:	AL = 12
;		BL = 35 Switch active displays
;			AL = 0	Adapter video off
;				ES:DX - Pointer to 128b buffer
;			AL = 1	System board video on
;			AL = 2	Active video off
;				ES:DX - Pointer to 128b buffer
;			AL = 3	Inactive video on
;				ES:DX - Pointer to 128b buffer
;			Exit:	AL = 12
;		BL = 36 Video on/off
;			AL = 0 Video on
;			AL = 1 Video off
;			Exit:	AL = 12
;****************************************************************

;	ALIGN	4

Info_Function_Table	LABEL	WORD
	DW	Set_Scan_Lines			;Sub-Function 30
	DW	Set_Default_Palette		;	      31
	DW	Set_Video_System		;	      32
	DW	Set_Gray_Shades 		;	      33
	DW	Set_Cursor_Emulation		;	      34
	DW	Switch_Active_Displays		;	      35
	DW	Set_Video_On_Off		;	      36

Video_VGA_Information PROC NEAR
;khu
		cmp	bl,80h		; extended alternate select ?
		jb	std_alt_sel	; nope
		call	ext_alt_sel	; go handle extended select
		mov	w_ax[bp],ax	; return value
		jmp	short Digital_Exit12; and return

std_alt_sel:
	SUB	BL,10H				;Test for return information
	JE	Return_VGA_Information		;Return the information
	SUB	BL,10H				;Test for set vector
	JE	Set_Alternate_Print		;Set alt print to INT 5
	SUB	BL,10H				;Subtract to 30H range
	JC	No_Info_Function		;Exit if between 20 and 30H
	CMP	BL,06				;Test if larger than 36H
	JA	No_Info_Function		;Yes-Just exit

IFDEF DIGITAL
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit12			;Yes-Exit immediately
ENDIF

	XOR	BH,BH				;Extend function to BX
	SHL	BX,01				;Double for table offset
	MOV	AL_Stack,012H			;Set successful return for now
	JMP	CS:Info_Function_Table[BX]	;Goto function

No_Info_Function:
        CALL    Extended_AltSel
Digital_Exit12:
	RET
Video_VGA_Information ENDP

;****************************************************************
;   Sub-Function 10 - Return VGA Information
;****************************************************************

Return_VGA_Information	PROC	NEAR

IFDEF EMULATE
	CMP	VGA_DCC_Index,03
	JBE	Exit_RVI			;Yes-Exit immediately
ENDIF

	MOV	CH,EGA_StatusB			;Get status B
	MOV	CL,4				;Number to shift
	MOV	AL,CH				;Save value
	SHR	CH,CL				;Shift down
	MOV	CL,AL				;Get byte
	AND	CL,0FH				;Reset high bytes
	MOV	CX_Stack,CX			;Save on stack
	MOV	AL,EGA_StatusA			;Get status information
	SHR	AL,1				;Shift down one bit
	AND	AL,1				;Isolate bit
	MOV	BH_Stack,AL			;Store on stack
	MOV	AL,EGA_StatusA			;Get status again
	AND	AL,07FH 			;Reset high bit
	MOV	CL,5				;Divide by 32
	SHR	AL,CL				;Shift down
	MOV	BL_Stack,AL			;Return on stack
	MOV	AL_Stack,AL			;Return for compatibility

Exit_RVI:
	RET
Return_VGA_Information ENDP

;****************************************************************
;   Sub-Function 20 - Set Alternate Print Screen
;****************************************************************

Set_Alternate_Print	PROC	NEAR
	PUSH	DS
	MOV	DS,INT_Address			;Set interrupt segment
	pushf
	CLI					;Clear interrupts
	MOV	WORD PTR DS:[5*4+0],OFFSET Print_Screen_Interrupt
	MOV	DS:[5*4+2],CS			;Set code segment
	popf					;Reenable interrupts
	POP	DS
	RET
Set_Alternate_Print	ENDP

;****************************************************************
;   Sub-Function 30 - Set Scan Lines
;****************************************************************

Scan_Line_Table LABEL	WORD
	DW	Set_CGA_200			;Set 200 Scan Mode
	DW	Set_CGA_200_DS
	DW	Set_Invalid_Scans
	DW	Set_Mono_200_DS

	DW	Set_CGA_350			;Set 350 Scan Mode
	DW	Set_CGA_350_NoDS
	DW	Set_Mono_350
	DW	Set_Mono_350_NoDS

	DW	Set_CGA_400			;Set 400 Scan Mode
	DW	Set_CGA_400_NoDS
	DW	Set_Mono_400
	DW	Set_Mono_400_NoDS

Set_Scan_Lines	PROC	NEAR
	CMP	AL,02				;Test for valid range
	JA	Set_Invalid_Scans		;Exit if not 0, 1, or 2
	TEST	EGA_StatusA,EGA_Passive 	;Is VGA not the active mon
	JNE	Set_Invalid_Scans		;Yes-Set function not done
	MOV	BL,AL				;Get scan lines to set
	XOR	BH,BH				;Extend to BX
	SHL	BX,1				;Compute scan table start
	SHL	BX,1				;by multiplying by eight
	SHL	BX,1
	MOV	SI,BX				;Save scan table start
	MOV	BL,EGA_StatusA			;Now use EGA_Monochrome and
	AND	BL,02H				;All_Active to determine
	MOV	AL,VGA_StatusA			;how scan lines should be set
	AND	AL,01H				;Isolate All_Active bit
	OR	BL,AL				;Merge to determine offset
	AND	BL,03H				;Determine offset into scan
	SHL	BX,1				;Double for offset
	JMP	CS:Scan_Line_Table[SI+BX]	;table and go there

Set_Invalid_Scans:
	MOV	AL_Stack,00H			;Set function not completed
	RET

Set_CGA_200_DS:
	OR	VGA_StatusA,Double_Scan 	;Double scan 200 line modes

Set_CGA_200:
	AND	VGA_StatusA,NOT Scans_400	;Clear 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,008H		;Set CGA switches
	RET

Set_Mono_200_DS:
	OR	VGA_StatusA,Double_Scan 	;Double scan 200 line modes
	AND	VGA_StatusA,NOT Scans_400	;Clear 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,00BH		;Set Monochrome switches
	RET

Set_CGA_350_NoDS:
	AND	VGA_StatusA,NOT Double_Scan	;Dont double scan

Set_CGA_350:
	AND	VGA_StatusA,NOT Scans_400	;Clear 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,009H		;Set VGA enhanced switches
	RET

Set_Mono_350_NoDS:
	AND	VGA_StatusA,NOT Double_Scan	;Dont double scan any modes

Set_Mono_350:
	AND	VGA_StatusA,NOT Scans_400	;Clear 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,00BH		;Set VGA monochrome switches
	RET

Set_CGA_400_NoDS:
	AND	VGA_StatusA,NOT Double_Scan	;Dont double scan any modes

Set_CGA_400:
	OR	VGA_StatusA,Scans_400		;Set 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,009H		;Set enhanced VGA switches
	RET

Set_Mono_400_NoDS:
	AND	VGA_StatusA,NOT Double_Scan	;Dont double scan any modes

Set_Mono_400:
	OR	VGA_StatusA,Scans_400		;Set 400 line capability
	AND	EGA_StatusB,0F0H		;Clear old switches
	OR	EGA_StatusB,00BH		;Set Mono switches
	RET
Set_Scan_Lines	ENDP

;****************************************************************
;   Sub-Function 31 - Set Default Palette Loading
;****************************************************************

Set_Default_Palette	PROC	NEAR
	CMP	AL,01				;Test for valid function
	JA	Exit_SGS			;No -Exit with AL=00
	MOV	AL,00				;Yes-Assume no Default_Palette
	JNE	Exit_No_Palettes		;Go set load palette bits
	MOV	AL,Default_Palette		;Dont load palette registers

Exit_No_Palettes:
	AND	VGA_StatusA,NOT Default_Palette ;Clear old value
	OR	VGA_StatusA,AL			;Set new setting
	RET
Set_Default_Palette	ENDP

;****************************************************************
;   Sub-Function 32 - Set Video Enabled / Disabled
;****************************************************************

Set_Video_System	PROC	NEAR

	CMP	AL,01				;Test for valid function
	JA	Exit_SGS			;No -Exit with AL=00

if (CHIP_FAMILY eq CONDOR)
	je	SVSSleep
	call	vs_enable
	jmp	short SVSDone
SVSSleep:
	call	vs_disable
SVSDone:
else	;(CHIP_FAMILY eq CONDOR)
	MOV	AL,00H				;Assume subsystem enabled
	JE	Exit_System_Enabled		;Go enable sub system

IFDEF ADAPTER
  ifdef (MICROCHANNEL_ADAPTER)
	MOV	AL,01H				;Otherwise wakeup sub-system
  else  ;(MICROCHANNEL_ADAPTER)
	MOV	AL,0EH				;Otherwise wakeup sub-system
  endif ;(MICROCHANNEL_ADAPTER)
ELSE

   if (VSEnable eq 3C3h)
	MOV	AL,01H			;used for 3C3h
     else  ;(VSEnable)
	MOV	AL,0EH			;used for 46E8h
   endif   ;(VSEnable)

ENDIF

Exit_System_Enabled:
	mov	dx,VSEnable
	OUT	DX,AL				;Disable sub-system
endif	;(CHIP_FAMILY eq CONDOR)

	RET
Set_Video_System	ENDP

;****************************************************************
;   Sub-Function 33 - Set Gray Summing
;****************************************************************

Set_Gray_Shades PROC	NEAR
	CMP	AL,01				;Test for valid function
	JA	Exit_SGS			;No -Exit with AL=00
	MOV	AL,00				;Assume no gray summing
	JE	Exit_No_Shades			;Go turn off gray summing
	MOV	AL,Gray_Shades			;Set gray summing

Exit_No_Shades:
	AND	VGA_StatusA,NOT Gray_Shades	;Clear old gray summing bit
	OR	VGA_StatusA,AL			;Set new gray summing bit
	RET

Exit_SGS:
	MOV	AL_Stack,00
	RET
Set_Gray_Shades ENDP

;****************************************************************
;   Sub-Function 34 - Set Cursor Emulation On / Off
;****************************************************************

Set_Cursor_Emulation	PROC	NEAR
	CMP	AL,01				;Test for valid function
	JA	Exit_SGS			;No -Exit with AL=00
	MOV	AL,00				;Yes-Assume no Cursor Emul
	JNE	Exit_No_Cursor_Emulation	;Go clear cursor emulation
	MOV	AL,No_Emulation 		;Otherwise set cur emulation

Exit_No_Cursor_Emulation:
	AND	EGA_StatusA,NOT No_Emulation	;Clear old cursor emulation
	OR	EGA_StatusA,AL			;Set new cursor emulation
	RET
Set_Cursor_Emulation	ENDP

;****************************************************************
;   swap_vectors - exchanges int 6d and int 42h
;****************************************************************
swap_vectors	proc	near
		public	swap_vectors

;gdl	push	es
;	push	di
;	les	di,ds:[6dh*4]
;	push	es
;	push	di
;	les	di,ds:[42h*4]
;	mov	ds:[6dh*4  ],di
;	mov	ds:[6dh*4+2],es
;	pop	di
;	pop	es
;	mov	ds:[42h*4  ],di
;	mov	ds:[42h*4+2],es
;	pop	di
;	pop	es

	MOV     ES,INT_Address                  ;Now setup adapter dispatcher

	mov     si,6dh * 4                      ;save current vector
	lodsw
	push    ax
	lodsw
	push    ax
	
	MOV     DI,6DH * 4                      ;Make secondary active
	MOV     SI,42H * 4                      ;by moving int 42H to 6DH
	MOVSW
	MOVSW

	mov     di,42h * 4
	pop     si
	pop     ax
	stosw
	mov     ax,si
	stosw

	ret

swap_vectors	endp

IFDEF ADAPTER
;****************************************************************
;   Sub-Function 35 - Switch Active Displays
;****************************************************************

Switch_Table	LABEL	WORD
	DW	Adapter_Video_Off		;Disable Adapter Video
	DW	Exit_SAD			;System board Video on
	DW	Active_Video_Off		;Turn active video off
	DW	Inactive_Video_On		;Turn inactive video on

Switch_Active_Displays	PROC	NEAR
	MOV	AL_Stack,00H			;Assume operation not done
	CMP	AL,03				;Is sub-function out of range
	JA	Exit_SAD			;Yes-Exit with AL = 00
	MOV	BL,AL				;No -Put function number
	XOR	BH,BH				;into BX
	SHL	BX,1				;Double for table offset
	JMP	Switch_Table[BX]		;Goto sub-function

Adapter_Video_Off:
	MOV	AX,1280H			;Yes-Perform undocumented
	MOV	BL,35H				;planar video call
	INT	42H				;to enable planar board
Active_Video_Off:
	TEST	VGA_StatusA,Planar_Video	;Was the function done ?
	JE	Exit_SAD			;No -Exit, not supported

	MOV	DI,DX				;Get buffer ptr in ES:DI
	CALL	Save_BIOS_Data_Area		;Save BIOS data area

	call	swap_vectors			; exchange int 6d and int 42

	mov     al,1                            ; disable video
	call    Set_Video_System

	MOV	AL_Stack,12H			;successful
Exit_SAD:
	RET

Inactive_Video_On:
	TEST	VGA_StatusA,Planar_Video	;Is the adapter VGA on
	JE	Exit_SAD			;Yes-Just exit
	MOV	SI,DX				;No -Active adapter VGA
	CALL	Restore_BIOS_Data_Area		;Restore BIOS Data Area

	mov     al,0                            ; enable video
	call    Set_Video_System

	MOV	AL_Stack,12H			;successful
	RET
Switch_Active_Displays	ENDP
ELSE
;****************************************************************
;   Sub-Function 35 - Switch Active Displays
;****************************************************************

Switch_Table	LABEL	WORD
	DW	Exit_SAD			;Disable Adapter Video
	DW	System_Video_On 		;System board Video on
	DW	Active_Video_Off		;Turn active video off
	DW	Inactive_Video_On		;Turn inactive video on

Switch_Active_Displays	PROC	NEAR
	MOV	AL_Stack,00H			;Assume operation not done
	CMP	AL,80H				;Test for set planar video
	JE	Set_Planar_Video		;Yes-Go perform function
	TEST	VGA_StatusA,Planar_Video	;Is the adapter VGA on
	JE	Exit_SAD			;Yes-Just exit
	CMP	AL,03				;Is sub-function out of range
	JA	Exit_SAD			;Yes-Exit with AL = 00
	MOV	BL,AL				;No -Put function number
	XOR	BH,BH				;into BX
	SHL	BX,1				;Double for table offset
	JMP	Switch_Table[BX]		;Goto sub-function

Set_Planar_Video:
	OR	VGA_StatusA,Planar_Video	;Set the planar video bit
	MOV	AL_Stack,12H			;Set the function successful

Exit_SAD:
	RET

System_Video_On:
	MOV	DX,VSEnable
	MOV	AL,01H				;Enable the VGA system before
	OUT	DX,AL				;performing any tests
	CALL	Setup_Planar_Vectors		;Setup 1F, 43, and environment
	AND	EGA_StatusA,NOT EGA_Monochrome
	MOV	DX,Read_Miscellaneous
	IN	AL,DX
	MOV	DX,CRT_3D4
	TEST	AL,01
	JNE	Setup_3B4_Base
	MOV	DX,CRT_3B4
	OR	EGA_StatusA,EGA_Monochrome

Setup_3B4_Base:
	MOV	M6845_Address,DX
;gdl:01/27/92 Removed function because it didn't do anything anyway
;***	CALL	Read_Feature_Bits		;Read feature bits
	AND	EGA_StatusB,0FH 		;Clear old feature bits
;***	OR	EGA_StatusB,AL			;Save in bits 4-7
ifdef ADAPTER
	OR	EGA_StatusB,0F0h		;Save in bits 4-7
else	;ADAPTER
	OR	EGA_StatusB,00h			;Save in bits 4-7
endif	;ADAPTER
	AND	VGA_StatusA,NOT (VGA_Monochrome + Gray_Shades)
	CALL	Monitor_Type
	CALL	Establish_Video_Type
	CALL	Compute_DCC_Index
	MOV	AL_Stack,12H			;successful
	RET

Active_Video_Off:
	MOV	DI,DX				;Turn the active video off
	CALL	Save_BIOS_Data_Area		;Save existing BIOS area

	call	swap_vectors			; exchange int 6d and int 42

	mov     al,1                            ; disable video
	call    Set_Video_System

	MOV	AL_Stack,12H
	RET

Inactive_Video_On:
	MOV	SI,DX				;No -Active adapter VGA
	CALL	Restore_BIOS_Data_Area		;Restore BIOS Data Area

	mov     al,0                            ; enable video
	call    Set_Video_System

	MOV	AL_Stack,12H
	RET
Switch_Active_Displays	ENDP
ENDIF

;****************************************************************
;   Sub-Function 36 - Set Video On / Off
;****************************************************************

Set_Video_On_Off	PROC	NEAR
	CMP	AL,01				;Test if the function is
	JA	Exit_SVOO			;in range-No go return AL=00
	MOV	CL,05				;the DAC blank signal.
	SHL	AL,CL				;Move on/off to bit 5
	MOV	BL,AL				;Save temporalily
	MOV	DX,Sequencer			;Get Sequencer base
	MOV	AL,01				;Read clocking mode reg
	CALL	Read_Reg			;Read from sequencer
	AND	AH,NOT 20H			;Clear screen off bit
	OR	AH,BL				;Merge new on/off bit
	MOV	AL,01				;Get clocking register
	OUT	DX,AX				;Turn video on/off
	RET

Exit_SVOO:
	MOV	AL_Stack,00
	RET
Set_Video_On_Off	ENDP

;**********************************************************************
;   The print screen routine will print the current screen contents
;   to LPT1 (the first adapter in the parallel table). All standard
;   BIOS functions calls are used to preserve the structure of the
;   BIOS and to allow other hardware (such as video cards) to function
;   with this routine. This routine is invoked from the interrupt
;   09 keyboard interrupt. Print Screen reached via interrupt 05.
;**********************************************************************

Print_Screen_Interrupt	PROC	FAR
	PUSH	DS
if (VSEnable eq 3c3h)
	pusha
else
	PUSH	BP
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
endif
	MOV	DS,BIOS_Address 		;Access BIOS data area
	MOV	AL,01				;Test for recursive operation
	CMP	Print_Screen_Flag,AL		;Recursive print screen
	JE	Exit_PSI1			;Yes-Dont let it happen
	MOV	Print_Screen_Flag,AL		;No -Now we are in it
	XOR	DX,DX				;Use LPT1
	MOV	AH,02H				;Read Status of INT17H
	INT	17H				;Issue BIOS Interrupt
	MOV	CL,0FFH 			;Assume there is an error
	TEST	AH,10000000B			;Test for Busy
	JE	Exit_PSI2			;Yes-Exit with error
	TEST	AH,00100000B			;No-Is out of paper?
	JNE	Exit_PSI2
	STI					;OK for interrupts
	MOV	AH,0FH				;Now determine # of columns
	INT	10H				;Call BIOS to read columns
	MOV	CL,AH				;Save # of columns in CL
	MOV	CH,Video_Rows			;Get number of rows
	INC	CH				;Make relative to zero
	MOV	AH,03				;First read cursor position
	PUSH	CX				;Save row and columns sizes
	INT	10H				;Call BIOS to read cursor
	POP	CX				;Restore row and column sizes
	PUSH	DX				;Must restore when done
	MOV	BP,SP				;Keep stack mark in BP
	MOV	DH,0FFH 			;DH will contain current row
	JMP	SHORT Do_CRLF			;Go print CR and LF first

Print_Screen_Loop:
	MOV	AX,0200H			;Set the new cursor position
	INT	10H				;Call BIOS to set cursor
	MOV	AX,0800H			;Now read character from
	INT	10H				;current cursor position
	OR	AL,AL				;Test if it is a null
	JNE	Char_Print			;No -Go print it
	MOV	AL,' '                          ;Yes-Convert it to a blank

Char_Print:
	CALL	Print_Character 		;Print the character to LPT1
	INC	DL				;No-Increment column counter
	CMP	DL,CL				;Are we at end of row?
	JNE	Print_Screen_Loop		;No -Keep printing from row

Do_CRLF:
	MOV	AL,0AH				;Yes-Print a linefeed char
	CALL	Print_Character 		;Print the character to LPT1
	MOV	AL,0DH				;Print a carriage return
	CALL	Print_Character 		;Print the character to LPT1
	XOR	DL,DL				;Start at column 0 on next row
	INC	DH				;Increment the row counter
	CMP	DH,CH				;Have we done 25 rows
	JNE	Print_Screen_Loop		;No -Keep printing
	MOV	CL,00				;Yes-Mark print screen done

Exit_PSI:
	MOV	SP,BP				;Restore stack ptr (for error)
	POP	DX				;Restore current cursor pos
	MOV	AX,0200H			;Set original cursor position
	INT	10H				;Call BIOS to set cursor

Exit_PSI2:
	MOV	Print_Screen_Flag,CL		;Signal out of print screen

Exit_PSI1:
if (VSEnable eq 3c3h)
	popa
else
	POP	AX				;Restore callers registers
	POP	BX
	POP	CX
	POP	DX
	POP	BP
endif
	POP	DS
	IRET
Print_Screen_Interrupt	ENDP

;**********************************************************************
;   Print the character in AL to LPT1. If an error occurs then the
;   print screen function will be aborted.
;**********************************************************************

Print_Character PROC	NEAR
	PUSH	DX				;Save callers DX
	XOR	AH,AH				;Get BIOS function code
	XOR	DX,DX				;Use 1st LPT channel
	INT	17H				;Call BIOS to print character
	TEST	AH,25H				;Test for any errors
	POP	DX				;Restore callers DX
	JE	Exit_PC 			;No-Return to caller
	MOV	CL,0FFH 			;Yes-Set error occurred
	JMP	Exit_PSI			;And abort print screen

Exit_PC:
	RET
Print_Character ENDP

;****************************************************************
;   AH = 13	Write string
;		ES:BP - Pointer to string
;		CX	 - Length of string to display
;		DH	 - Character row for display
;		DL	 - Character column for display
;		BL	 - Display attribute
;		BH	 - Active page
;		AL	 - Write string mode
;			0 - Characters only, no cursor update
;			1 - Characters only, update cursor
;			2 - Char, Attrib, no cursor update
;			3 - Char, Attrib, update cursor
;****************************************************************

;	ALIGN	4

Video_Write_String PROC NEAR
	JCXZ	Exit_VWS			;No data to write
	CMP	AL,3				;Test for valid mode
	JA	Exit_VWS			;Valid mode detected
	MOV	AH,BH
	XCHG	Active_Page,BH			;Set active page for
	PUSH	BX				;teletype write, save cur

	TEST	AL,1				;Test for cursor update
	JNE	Start_Write_String		;Don't save cursor
SaveCursorPos:
	MOV	BL,AH
	XOR	BH,BH				;into cursor table
	SHL	BX,1				;Double for cursor table
	MOV	DX,Cursor_Location[BX]		;Read cursor position for page
	PUSH	DX				;Save on stack

Start_Write_String:
	MOV	SI,BP_Stack			;Get BP on entry
	MOV	CX,CX_Stack			;Get counter
	MOV	DX,DX_Stack			;Get cursor position

Write_String_Byte:
	PUSH	CX				;Save chars to write

	MOV	BH,BH_Stack			;Get active page
	MOV	CX,DX
	CALL	Video_Set_Cursor		;Set cursor position
	MOV	DX,CX

	MOV	ES,ES_Stack			;Get string ptr segment
	LODS	BYTE PTR ES:[SI]		;Load byte of string
	CMP	AL,0DH
	JBE	Control_Write

Char_Write:
	MOV	BX,BX_Stack			;Restore BL from stack
	TEST	AL_Stack,2			;Test for char,attrib
	JE	Write_Byte			;No attribute to get
	MOV	BL,ES:[SI]			;Get attribute
	INC	SI				;Next position

Write_Byte:
	PUSH	SI				;Save write string pointer
	PUSH	DX				;Save cursor position
	PUSH	BP				;Save stack mark
	MOV	CX,1				;Write a single character
	CALL	Video_Write_Char_Attr		;Write video char/attr
	MOV	DS,Int_Address
	POP	BP				;Restore stack mark
	POP	DX				;Restore cursor position
	INC	DL				;Next cursor position
	CMP	DL,BYTE PTR Video_Columns	;Test for wrap
	JB	Next_Byte			;Get next byte
	INC	DH				;Next row
	XOR	DL,DL				;Reset column
	CMP	DH,Video_Rows			;Test for overflow
	JBE	Next_Byte			;Not end of screen
	PUSH	DX				;Save cursor position
	MOV	AL,0AH				;Write a line feed
	PUSHF					;Setup for interrupt call
	PUSH	CS
	CALL	Video_Teletype_Write		;Call teletype write
	POP	DX				;Restore cursor position
	DEC	DH				;Set to last row
	JMP	SHORT Next_Byte 		;Get next byte

Exit_VWS:
	RET

Control_Write:
	CMP	AL,07H				;Test for bell character
	JE	Tele_Write			;Write with teletype
	CMP	AL,08H				;Test for backspace
	JE	Tele_Write			;Write with teletype
	CMP	AL,0AH				;Test for line feed
	JE	Tele_Write			;Write with teletype
	CMP	AL,0DH				;Test for carriage return
	JE	Tele_Write			;Write with teletype
	JMP	SHORT Char_Write

Tele_Write:
	PUSH	SI				;Save string pointer
	PUSHF					;Setup for interrupt call
	PUSH	CS
	CALL	Video_Teletype_Write		;Use teletype for control char
	MOV	BL,BH_Stack			;Get page number
	XOR	BH,BH				;into cursor table
	SHL	BX,1				;Double for cursor table
	MOV	DX,Cursor_Location[BX]		;Read cursor position for page

Next_Byte:
	POP	SI				;Restore string pointer
	POP	CX				;Restore counter
	LOOP	Write_String_Byte		;Write byte

	TEST	AL_Stack,1			;Test for cursor update
	JNE	Done_Write			;No cursor restore
	POP	DX				;Restore position

Done_Write:
	MOV	BH,BH_Stack			;Set page number
	CALL	Video_Set_Cursor		;Restore cursor position
	POP	BX				;Get active page
	XCHG	Active_Page,BH			;Restore active page

;gdl:02/05/92 Reprogram CRTC cursor position for active page
	MOV	BL,Active_Page			;Get page number
	XOR	BH,BH				;into cursor table
	SHL	BX,1				;Double for cursor table
	MOV	DX,Cursor_Location[BX]		;Get cursor position for page
	mov	bh,bl
	shr	bh,1
	CALL	Video_Set_Cursor		;Set cursor position

	RET
Video_Write_String ENDP

;****************************************************************
;   AH = 1A	Display Combination Code
;		AL = 0	Read display combination code
;			Exit:	AL = 1A
;				BL - Active display
;				BH - Alternate display
;		AL = 1	Set display combination code
;			BL - Active display
;			BH - Alternate display
;			Exit: AL = 1A
;****************************************************************

;	ALIGN	4

Video_Combination_Code	PROC	NEAR


IFDEF DIGITAL
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit1A			;Yes-Exit immediately
ENDIF

	OR	AL,AL				;Are we function zero
	JNE	Set_New_DCC			;No -Go test for set DCC

;gdl:01/21/92 Made GetDCCCode out of chunk of code that used to be here.
;	GetDCCCode was needed because func 1Bh needs alt/active in SORTED
;	order, and Find_DCC_Pair didn't swap them.
	call	GetDCCCode			;Get CH/CL = alt/active

	MOV	BX_Stack,CX			;Return DCC codes in BX
	MOV	AX_Stack,01AH			;Always return a 1AH in AL

Digital_Exit1A:
	RET

Set_New_DCC:
	DEC	AL				;Must be function 01
	JNE	Exit_VCC			;No -Just exit
	MOV	DL,0FFH 			;Yes-Set FF if cannot
	MOV	BX,10H				;determine DCC pair
	CALL	Get_Env_Ptr			;Get sec env save area
	JE	Set_DCC 			;Set FF if doesnt exist
	LES	BX,ES:[BX+02]			;Get pointer to DCC table
	MOV	AX,ES				;Test if DCC table
	OR	AX,BX				;exists
	JE	Set_DCC 			;No -Set FF
	MOV	CL,ES:[BX]			;Get size of DCC pair table
	XOR	CH,CH				;Extend to CX
	JCXZ	Set_DCC 			;Set FF if zero length
	MOV	DI,BX				;Get ptr to DCC table
	ADD	DI,04				;Move to start of DCC pairs
	MOV	AX,BX_Stack			;Get users specified DCC pair
	REPNZ	SCASW				;Search for DCC pair
	JE	Found_DCC			;Go if found it in table

	MOV	CL,ES:[BX]			;Otherwise get size again
	MOV	DI,BX				;Get start of DCC table
	ADD	DI,04				;Move to start of DCC pairs
	XCHG	AL,AH				;Try swapping DCC codes
	REPNZ	SCASW				;And search again for DCC pair
	JNE	Set_DCC 			;Set DCC to FF if cant find

Found_DCC:
	MOV	DL,0FH				;DCC pair was matched
	SUB	DL,CL				;Compute DCC index

Set_DCC:
	MOV	VGA_DCC_Index,DL		;Set new DCC index
	MOV	AX_Stack,01AH			;Always return a 1AH in AL

Exit_VCC:
	RET

;gdl:01/21/92 Made GetDCCCode out of chunk of code from above.
;	GetDCCCode was needed because func 1Bh needs alt/active in SORTED
;	order, and Find_DCC_Pair didn't swap them.
GetDCCCode	proc	near
	public	GetDCCCode
	CALL	Find_DCC_Pair			;Find the DCC pair code
	JE	Return_DCC			;Exit if didnt find them
	OR	CL,CL				;Is primary zero
	JE	Swap_DCC			;Yes-Return secondary as prim
	MOV	AL,BYTE PTR Equipment_Installed ;No -Get active monitor
	AND	AL,030H 			;Isolate monitor bits
	CMP	AL,030H 			;Are we currently monochrome
	JE	DCC_Mono_Primary		;Yes-Return mono DCC in BL
	TEST	CL,01H				;CGA is active, is active DCC
	JNE	Swap_DCC			;CGA. No -Go swap them
	JMP	SHORT Return_DCC		;Yes-Then return as is

DCC_Mono_Primary:
	TEST	CL,01H				;Is Mono DCC active
	JNE	Return_DCC			;Yes-Return DCC as is

Swap_DCC:
	XCHG	CL,CH				;Swap active and alternate
Return_DCC:
	ret

GetDCCCode	endp



Video_Combination_Code	ENDP

;****************************************************************
;   Return the DCC pair using VGA_DCC_Index. Return a pair
;   value of FFFFH if the DCC environment does not exist or
;   the VGA_DCC_Index is outside the range of the DCC table.
;
;   Exit: CX - DCC pair value (FFFFH if not available)
;	   Z - DCC pair value not available
;****************************************************************

Find_DCC_Pair	PROC	NEAR
	PUSH	ES
	MOV	CX,0FFFFH			;Yes-Return FFFF if cannot
	MOV	BX,10H				;determine DCC
	CALL	Get_Env_Ptr			;Get sec env save area
	JE	Exit_FDP			;Return FFFF if doesnt exist
	LES	BX,ES:[BX+02]			;Get pointer to DCC table
	MOV	AX,ES				;Test if DCC table
	OR	AX,BX				;exists
	JE	Exit_FDP			;No -Return FFFF
	MOV	AL,VGA_DCC_Index		;Yes-Get length of table
	CMP	AL,ES:[BX]			;Is the current DCC in range
	JAE	Exit_FDP			;No -Return FFFF
	XOR	AH,AH				;Yes-Extend to AX
	SHL	AX,1				;DCC codes are two bytes
	ADD	AX,04				;Move to DCC types
	MOV	SI,AX				;SI is offset to entry
	MOV	CX,ES:[BX+SI]			;Get DCC from table

Exit_FDP:
	CMP	CX,0FFFFH			;Test for DCC found
	POP	ES
	RET
Find_DCC_Pair	ENDP

;****************************************************************
;   AH = 1B	Return VGA state information
;		BX    - Implementation byte (zero)
;		ES:DI - Pointer to buffer
;			Exit: AL = 1B
;****************************************************************

;	ALIGN	4

Mode_Color_Table	LABEL	WORD
	DW	010H, 010H, 010H, 010H		;Number of colors supported
	DW	004H, 004H, 002H, 000H		;for each video mode
	DW	000H, 000H, 000H, 000H
	DW	000H, 010H, 010H, 000H
	DW	010H, 002H, 010H, 100H

Mode_Page_Table 	LABEL	BYTE
	DB	008H, 008H, 008H, 008H		;Number of pages supported
	DB	001H, 001H, 001H, 008H		;for each video mode
	DB	000H, 000H, 000H, 000H
	DB	000H, 008H, 004H, 002H
	DB	002H, 001H, 001H, 001H

Video_State_Information PROC	NEAR

IFDEF DIGITAL
	CMP	VGA_DCC_Index,07		;Are we a digital monitor
	JBE	Digital_Exit1B			;Yes-Exit immediately
ENDIF

	OR	BX,BX				;Is implementation byte zero
	JE	Get_Video_State 		;Yes-Continue command
	MOV	AL_Stack,000H			;No -Return function not done

Digital_Exit1B:
	RET

Get_Video_State:
	MOV	AL_Stack,01BH			;Set function completed
	MOV	AX,OFFSET VGA_State_Table	;ES:DI is buffer area
	STOSW					;Save pointer to DCC tabl
	MOV	AX,CS				;Get DCC table segment
	STOSW					;Save segment address
	MOV	CX,01EH/2			;Move 1E bytes from BIOS
	MOV	SI,OFFSET Video_Mode		;data area. Start at mode
	REP	MOVSW				;Move the data
	MOV	AL,Video_Rows			;Now transfer video rows
	INC	AL				;Set actual number of rows
	STOSB					;Save at offset 22H
	MOV	AX,Char_Length			;Get character size
	STOSW					;Save at offset 23H
;gdl:01/21/92 Get alt/active in right order!  Find_DCC_Pair didn't!
	call	GetDCCCode			;Find the DCC pair
;	CALL	Find_DCC_Pair			;Find the DCC pair
	MOV	AX,CX				;FFFF means no DCC pair avail
;	OR	AL,AL				;If active DCC zero
;	JNE	Have_Active_DCC 		;No -Return as is

;gdl:01/21/92  We do need the XCHG, it's just that Find_DCC_Pair was the
;	wrong one to call.  GetDCCCode fixes that.
;khu 10-5-91 bug fix.  When you STOSW the high byte goes first!!!!!
;	XCHG	AL,AH				;Yes-Return alt as active
;
;Have_Active_DCC:
;	XCHG	AL,AH				;Yes-Return alt as active
	STOSW					;Save at offset 25H
	MOV	AL,Video_Mode			;Get current video mode
	XOR	AH,AH				;Extend to AX
	SHL	AX,1				;Double for color table
	MOV	BX,AX				;Move to BX for indexing
	MOV	AX,CS:Mode_Color_Table[BX]	;Get # of colors for mode
	STOSW					;Save at offset 27H
	SHR	BX,1				;Adjust for byte table
	MOV	AL,CS:Mode_Page_Table[BX]	;Get video pages for mode
	STOSB					;Save at offset 29H

	MOV	BL,03				;Determine scan lines
	MOV	AL,Video_Mode			;Get video mode
	CMP	AL,11H				;Test for mode 11
	JE	Set_Scans			;Go if 480 lines
	CMP	AL,12H				;Test for mode 12
	JE	Set_Scans			;Go if 480 lines
	MOV	BL,00				;Handle 200 scan line modes
	CMP	AL,13H				;Are we mode 13
	JE	Set_Scans			;Yes-Set 200 line mode
	CMP	AL,04H				;Are we text mode
	JB	Text_Lines			;Yes-Go handle differently
	CMP	AL,06H				;Are we modes 4, 5 or 6
	JBE	Set_Scans			;Yes-Set to a 200 line mode
	CMP	AL,09H				;Are we 7 or 8
	JB	Text_Lines			;Yes-Handle as text mode
	CMP	AL,0EH				;Are we 9 through E
	JBE	Set_Scans			;Yes-Set 200 line mode
	MOV	BL,01				;Isolate modes F and 10
	CMP	AL,10H				;which are 350 scan lines
	JBE	Set_Scans			;Yes-Go set 350 lines

Text_Lines:
	MOV	BL,02				;No -Test for 400 lines
	TEST	VGA_StatusA,Scans_400		;Can we do 400 lines
	JNE	Set_Scans			;Yes-We have scan lines
	MOV	BL,01				;No -Can we do 350 lines
	TEST	EGA_StatusA,EGA_Monochrome	;Are we functioning as mono
	JNE	Set_Scans			;Yes-Return 350 scans
	MOV	AH,EGA_StatusB			;Get switch settings
	AND	AH,0FH				;Isolate switches
	CMP	AH,03H				;Check for VGA enhanced
	JE	Set_Scans			;Yes-We can do 350 lines
	CMP	AH,09H				;Check VGA enhanced primary
	JE	Set_Scans			;Yes-We can do 250 lines
	CMP	AL,07H				;Test for mode 7
	JE	Set_Scans			;Yes-Since mode 7 is mono
	MOV	BL,00				;Must use 200 line table

Set_Scans:
	MOV	AL,BL				;Get code for scan lines
	STOSB					;Save at offset 2AH

	MOV	DX,Sequencer			;Return primary and 2ndary
	MOV	AL,03				;character blocks
	CALL	Read_Reg			;Read map select register
	MOV	AL,AH				;Make another copy
	AND	AL,03H				;Isolate primary
	TEST	AH,10H				;Is char map select hi set
	JE	Not_Select_HighB		;No -Dont set extended bit
	OR	AL,04H				;Return extended char map

Not_Select_HighB:
	STOSB					;Save secondary char block
	MOV	AL,AH				;Get map select again
	AND	AL,0CH				;Isolate secondary
	SHR	AL,1				;Move to bits 0 and 1
	SHR	AL,1				;And save
	TEST	AH,20H				;Is char map selech hi set
	JE	Not_Select_HighA		;No -Dont set extended bit
	OR	AL,04H				;Return extended char map

Not_Select_HighA:
	STOSB					;Save at offset 2B
	MOV	BL,010H 			;Read attribute mode reg
	CALL	Read_Palette			;Wait for vertical retrace
	MOV	AL,BH				;Put value in AL

;gdl:12/30/91 Fix PC Tech Journal error.  Core was getting wrong bit
	AND	AL,08H				;Isolate blink enable
	shl	al,1
	shl	al,1				;Shift to bit 5
	mov	cl,4				;Prepare for cursor emul bit
;***	AND	AL,04H				;Isolate enable line graphics
;***	MOV	CL,03				;character codes.
;***	SHL	AL,CL				;Move it to bit 5
;***	INC	CL

	MOV	AH,VGA_StatusA			;Get current VGA_StatusA
	AND	AH,00FH 			;Clear bits 4-7 fixed 5/08/89
	OR	AH,AL				;Merge line graphics bit
	MOV	AL,EGA_StatusA			;Merge the Emulation bit
	AND	AL,01				;Isolate emulation bit
	SHL	AL,CL				;Move to bit 4
	XOR	AL,10H				;Not the bit
	OR	AL,AH				;Or in previous result
	STOSB					;Save at offset 2DH

;+2Eh	Video that requires the video adapter interface driver to support modes
;	outside the current VGA range
;	[0] - 1=BIOS supports AI information return
;	[1] - 1=AI driver required
;	[2] - 1=16-bit VGA graphics present
;	[3] - 1=MFI attributes
;	      0=VGA attributes
;	[4] - 132-column mode supported
;	[7:5] reserved
  ifdef (XGA_BUG)
	mov	al,04h		; Assume 16-bit
	extrn	is_chip_unlocked:near
	call	is_chip_unlocked	
	jne	skip_memcs16_read
  endif  ;(XGA_BUG)
	mov	al,08h		; Read SR08 for MEMCS16
	mov	dx,SEQIDX
	call	getreg
	and	ah,040h
	xor	ah,40h
	mov	cl,4
	shr	ah,cl
	mov	al,ah
skip_memcs16_read:

ifdef VESAVBEVERSION
 if (MODE14TEXT eq YES)
	or	al,11h		;We support VESA VBE/132-columns
 else	;(MODE14TEXT eq YES)
	or	al,01h		;We support VESA VBE
 endif	;(MODE14TEXT eq YES)
endif	;VESAVBEVERSION
	stosb			;Store it at offset 2Eh
	XOR	AX,AX				;The next 2 bytes are
	STOSW					;reserved. Write them
						;as zero
	MOV	AL,EGA_StatusA			;Get memory size
	MOV	CL,05				;Memory size is in bits 5,6
	SHR	AL,CL				;Move to bits 0 and 1
	AND	AL,03				;Isolate memory size
	STOSB					;Save at offset 31H

	XOR	CH,CH				;CH will have bit map
	PUSH	ES				;Save buffer segment
	LES	BX,Env_Ptr			;Get enviroment pointer
	MOV	AX,ES:[BX+04]			;Roll bits in from right
	OR	AX,ES:[BX+06]			;Test for Dynamic save area
	CMP	AX,01				;C = exists, NC = doesn't
	RCR	CH,1				;Roll into result
	MOV	AX,ES:[BX+08H]			;Test for Text mode aux
	OR	AX,ES:[BX+0AH]			;character set
	CMP	AX,1				;C = exists, NC = doesn't
	RCR	CH,1				;Roll into result
	MOV	AX,ES:[BX+0CH]			;Test for graphics mode
	OR	AX,ES:[BX+0EH]			;auxiliary char set
	CMP	AX,1				;C = exists, NC = doesn't
	RCR	CH,1				;Roll into result
	LES	BX,ES:[BX+10H]			;Get pointer to 2ndary save
	MOV	CL,04				;Shift right 4 or 2
	SHR	CH,CL				;Move to proper position
	MOV	AX,ES				;Does the secodary pointer
	OR	AX,BX				;exists
	JE	Set_Ptr_Status			;No -Cant check those dwords
	SHL	CH,CL				;Otherwise move back
	MOV	CL,02				;Yes-Check 2 and shift 2
	MOV	AX,ES:[BX+0AH]			;Get User palette table
	OR	AX,ES:[BX+0CH]			;Doest it exist
	CMP	AX,1				;C = exists, NC = doesn't
	RCR	CH,1				;Roll into result
	MOV	AX,CS				;Test if DCC table is
	CMP	ES:[BX+04H],AX			;pointing into VGA BIOS
	CLC					;NC = pointing into BIOS
	JE	DCC_Is_In_BIOS			;Go if segments match
	CMC					;Otherwise set C condition

DCC_Is_In_BIOS:
	RCR	CH,1				;Roll bit into result
	SHR	CH,CL				;Shift bits to position
	MOV	AX,ES:[BX+06H]			;Get secondary text mode
	OR	AX,ES:[BX+08H]			;character generator
	CMP	AX,1				;C = exists, NC = doesn't
	ADC	CH,0				;Set bit 0 if C condition

Set_Ptr_Status:
	POP	ES				;Restore buffer pointer
	STOSB					;Save pointer status

	MOV	CX,0DH				;The last 0DH bytes are
	XOR	AL,AL				;reserved. Write then zero
	REP	STOSB				;Start at offset 33H
	RET
Video_State_Information ENDP

;****************************************************************

VGA_Segment ENDS

	END
