/*----------------------------------------------------------*/
/*																				*/
/*	  CONFIG.CPP - controls the Config Menu	    				*/
/*	  Copyright (c) 1992 by Cirrus Logic Inc.					   */
/*																				*/
/*   MV:1/2/92 - file created                               */
/*----------------------------------------------------------*/

#ifndef DESKTOP
#define USE_RAW_KEYS				// For accelarator key definitions.
#define USE_HELP_CONTEXTS
#include <ui_win.hpp>
#include "clview.hpp"
#include "clmode.hpp"

byte getDisplayStatus(int);
int isPeaven();
int is6410();
void setConfig();

boolean closeError;
boolean escFlag;
byte sbTimer;							// stand-by timer value
extern int minTimer;
extern int maxTimer;
extern OPTION_INFO tbl[];


static EVENT_TYPE Exit_Vgaconf(UI_WINDOW_OBJECT *data, UI_EVENT &, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *item = (UIW_BUTTON *)data;

	switch (item->value) {
		case S_CLOSE:
			tbl[TIMER].value = sbTimer; 		// update the new timer
			setConfig();					 		// and set the options
			if (closeError == FALSE)	 		// error window has been
				return(ccode);				 		// activated by the <ALT-K>
		case S_CANCEL:
			item->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		case L_HELP:
			item->eventManager->Put(UI_EVENT(L_HELP));
			break;
	}

	return(ccode);
}

// Implemented my own error window instead of using the library error
// system.  Needed to revise the button so that it's consistent with
// the rest of the application's user interface.
void Window_Error()
{
	UIW_WINDOW *window = new UIW_WINDOW(25, 6, 38, 7, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE );

	UI_WINDOW_OBJECT *object = NULL;

	char *range6410BE="the range 3..63 minutes";
	char *range="the range 2..63 minutes.";

	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE(" Error ")
		+ new UIW_TEXT(6, 1, 26, 1,
		"Stand-by timer must be in",
		26, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE);

	if (is6410())
	*window
		+ new UIW_TEXT(6, 2, 26, 1,
		range6410BE,
		26, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE);
	else
	*window
		+ new UIW_TEXT(6, 2, 26, 1,
		range,
		26, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE);
	*window
		+ new UIW_BUTTON(12, 4, 10, "OK", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_JUSTIFY_CENTER, Exit_Vgaconf, S_CLOSE);

	object->windowManager->Add(window);
}

EVENT_TYPE CheckTimer(UI_WINDOW_OBJECT *object, UI_EVENT &, EVENT_TYPE ccode)
{

	// Only look for non-current message.
	if (ccode != S_NON_CURRENT)
		return(0);

	if (escFlag)				// the ESC/ALT-A has been pressed
	{								// just close the current window
		escFlag=FALSE;			// reset it
		return(0);
	}

	// Check the range of the number
	UIW_INTEGER *data = (UIW_INTEGER *)object;
	int value = data->DataGet();

	if ((value >= minTimer) && (value <= maxTimer))
	{
		sbTimer = (byte) value;  	// let's not update the timer yet,
		return(0);		  				// since the cancel button could be pressed
	}

	closeError=FALSE;
	Window_Error();

	return(-1);
}

UI_WINDOW_OBJECT *CONTROL_WINDOW::Window_Vgaconf(void)
{
	int left=4, right=35;
	int top=10, topBus=4, topW=1;
	int height=19, last=16;

	if ((getDisplayStatus(DISPLAY) == CRT) || (isPeaven()))
	{
		left+=31;
		top-=4;
		right-=31;
		topBus+=5;
		topW++;
		height-=3;
		last-=3;
	}

	for(int i = TEXT_REVERSE; i <= POWER; i++)	
		tbl[i].value = getDisplayStatus(i);	

	if (tbl[TIMER].value < minTimer) 
		tbl[TIMER].value  = minTimer;
	else if (tbl[TIMER].value > maxTimer)
		tbl[TIMER].value  = maxTimer;

	sbTimer = tbl[TIMER].value;

	UIW_GROUP *enhancement = new UIW_GROUP(4, 0, 26, 3, " ENHANCEMENT ", WNF_SELECT_MULTIPLE);
	*enhancement
		+ new CHECK_BOX(2, 1, 22, " Expanded mode      ", EXPAND)
		+ new CHECK_BOX(2, 2, 22, " Full height cursor ", CURSOR);
															
	UIW_GROUP *font = new UIW_GROUP(4, 3, 26, 3, " FONT ", WNF_SELECT_MULTIPLE);
	*font
		+ new CHECK_BOX(2, 1, 21, " Bold              ", BOLD)
		+ new CHECK_BOX(2, 2, 21, " Inhibit Font Load ", INHIBIT);

	UIW_GROUP *reverse = new UIW_GROUP(4, 6, 26, 3, " REVERSE VIDEO ", WNF_SELECT_MULTIPLE);
	*reverse
		+ new CHECK_BOX(2, 1, 21, " Text reverse     ", TEXT_REVERSE)
		+ new CHECK_BOX(2, 2, 21, " Graphics reverse ", GRFX_REVERSE);

	COMBO_BOX *contrast = new COMBO_BOX (left, top, 29, 5, CONTRAST, 5);
	*contrast
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL )
		+ new COMBO_BOX_ITEM(26, "Black & White          ", CONTRAST_0, CONTRAST)
		+ new COMBO_BOX_ITEM(26, "Gray Scale/Color       ", CONTRAST_1, CONTRAST)
		+ new COMBO_BOX_ITEM(26, "Background Enhancement ", CONTRAST_2, CONTRAST)
		+ new COMBO_BOX_ITEM(26, "Text Enhancement       ", CONTRAST_3, CONTRAST)
		+ new COMBO_BOX_ITEM(26, "Text/Back. Enhancement ", CONTRAST_4, CONTRAST);

	COMBO_BOX *position = new COMBO_BOX (left, top+2, 29, 4, POSITION, 3);
	*position
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL)
		+ new COMBO_BOX_ITEM(10, "Center ", CENTER, POSITION)
		+ new COMBO_BOX_ITEM(10, "Top    ", TOP   , POSITION)
		+ new COMBO_BOX_ITEM(10, "Bottom ", BOTTOM, POSITION);
										
	COMBO_BOX *rgb = new COMBO_BOX (left, top+4, 29, 4, RGB, 6);
	*rgb
		+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL)
		+ new COMBO_BOX_ITEM(22, "RGB(11%  30%  59%) ", RGB_0, RGB)
		+ new COMBO_BOX_ITEM(22, "RGB(30%  11%  59%) ", RGB_1, RGB)
		+ new COMBO_BOX_ITEM(22, "RGB(11%  59%  30%) ", RGB_2, RGB)
		+ new COMBO_BOX_ITEM(22, "RGB(30%  59%  11%) ", RGB_3, RGB)
		+ new COMBO_BOX_ITEM(22, "RGB(59%  11%  30%) ", RGB_4, RGB)
		+ new COMBO_BOX_ITEM(22, "RGB(59%  30%  11%) ", RGB_5, RGB);
							                  	
	UIW_GROUP *display = new UIW_GROUP(35, 0, 26, 4, " DISPLAY ");
	*display
		+ new RADIO_BUTTON(2, 1, 16, " Panel     ", LCD		  , DISPLAY, NULL)
		+ new RADIO_BUTTON(2, 2, 16, " CRT       ", CRT		  , DISPLAY, NULL)
		+ new RADIO_BUTTON(2, 3, 16, " SimulSCAN ", SIMULSCAN, DISPLAY, NULL);

	UIW_GROUP *bus = new UIW_GROUP(right, topBus, 26, 2, " BUS WIDTH ", WNF_SELECT_MULTIPLE);
  	*bus 
		+ new CHECK_BOX(2, 1, 16, " 16-bit bus ", BUS );

	UIW_GROUP *power = new UIW_GROUP(35, 7, 26, 4, " POWER MANAGEMENT ");
	*power
		+ new RADIO_BUTTON(2, 1, 23, " Disable             ", PM_0, POWER, NULL)
		+ new RADIO_BUTTON(2, 2, 23, " Stand-by (memory)   ", PM_3, POWER, NULL)
		+ new RADIO_BUTTON(2, 3, 23, " Stand-by (keyboard) ", PM_4, POWER, NULL);

// Create the window.
UIW_WINDOW *window = new UIW_WINDOW(12, topW, 68, height, WOF_NO_FLAGS, 
			WOAF_MODAL | WOAF_NO_SIZE );

*window
	+ new UIW_BORDER
	+ new UIW_SYSTEM_BUTTON
	+ new UIW_TITLE(" VGA Configuration ")
	+ enhancement
	+ font
	+ reverse;

if ((getDisplayStatus(DISPLAY) == CRT) || (isPeaven()))
{
*window
	+ bus
	+ display
	+ new UIW_PROMPT(left, top-1, "Co~ntrast:")
	+ contrast
	+ new UIW_PROMPT(left, top+1, "~Vertical Position:")
	+ position;

	if (!isPeaven()) {
*window
	+ new UIW_PROMPT(left, top+3, "~RGB Weighting:")
	+ rgb;
	}
}
else
{
	int timer = (int) tbl[TIMER].value;
*window
	+ new UIW_PROMPT(left, top-1, "Co~ntrast:")
	+ contrast
	+ new UIW_PROMPT(left, top+1, "~Vertical Position:")
	+ position
	+ new UIW_PROMPT(left, top+3, "~RGB Weighting:")
	+ rgb
	+ display
	+ bus
	+ power
	+ new UIW_PROMPT(36, 12, "~Timer (minutes): ")
	+ new UIW_INTEGER(53, 12, 5, &timer, NULL, NMF_NO_FLAGS,
	WOF_BORDER | WOF_AUTO_CLEAR, 	CheckTimer);
}

*window
	+ new UIW_BUTTON(8, last, 10, "O&K", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Vgaconf, S_CLOSE)
	+ new UIW_BUTTON(27, last, 10, "C&ancel", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Vgaconf, S_CANCEL)
	+ new UIW_BUTTON(46, last, 10, "&Help", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Vgaconf, L_HELP);

	//   Return the window pointer.
		return(window);
}
#endif

