/*---------------------------------------------------------*/
/*                                                         */
/*   CLBIOS.CPP                                            */
/*   Copyright (c) 1991 by Cirrus Logic Inc.               */
/*                                                         */
/*   Mai Vu:12/26/91 - file created                        */
/*                                                         */
/*                                                         */
/*   Modifications:                                        */
/*                                                         */
/*   MOD1:  ALPINE II MODES, ID,.... STEVE C. 8-12-93      */
/*   MOD2:  542X/3X CENTERING        STEVE C. 9-07-93      */
/*   MOD3:  NEW ALPINE II ID,        STEVE C. 9-13-93      */
/*   MOD4:  Added Polarity           STEVE C. 10-21-93     */
/*   MOD5:  Added 5429 & 5452/53 ID  STEVE C. 10-21-93     */
/*                                                         */
/*---------------------------------------------------------*/

#define USE_RAW_KEYS                            // For accelarator key definitions.
#include <ui_win.hpp>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <bios.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include "clview.hpp"


#ifndef DESKTOP
extern KEYWORD_INFO confKey[MAXKEYWORD];
extern char keyword[];
extern int minTimer;
extern int maxTimer;
#endif

#ifdef DESKTOP  // MOD2, MOD4
unsigned int CenteringTable [100]; // large enough to accomodate more modes MOD2
char ptableA [0x400];             // 64 * 16 SLOTS, Extended Standard
char ptableB [0x1B0];             // 27 * 16 SLOTS, Extended Supplemental
char CtableTotal,CurrentOffset,DEFAULT_MISC,POLARITY;
int far *ADDR_6845 = (int far *)0x00400063;
static char* poltype[4] = {"+/+","+/-","-/+","-/-"};
#endif

extern byte BANKIDX, BANKSIZE;
extern byte NOT_AVAILABLE;
extern byte dosMode;
extern char filename[];                         // "filename".EXE for CLMODE
extern char filepath[];                         // the path where "filename".EXE is at
extern int help;
extern modeRec *modeList;                       // link list of all the modes supported
extern boolean isMontypeProduct;        // montype-product
extern boolean isHiFreqProduct;         // supports hi-frequency modes
extern boolean isVesaProduct;           // Vesa-product
extern OPTION_INFO tbl[];
extern unsigned int MouseDriverStatus;  /* 2.30 beta 2 */

byte getDisplayStatus(int);

modeRec *mode16List=NULL;                       // list of 16-color modes
char *CirrusID;                                         // chipID string
word char_segment, char_8x16_offset, char_8x14_offset, char_8x8_offset;
int updatedMessage=FALSE;
unsigned int GRX;  // MOD1

union
  {
  char far *pixels;
  struct
  {
    unsigned byte;
    unsigned segment;
  } plane;
} mem;

static modeRec stdmode[MAXSTD] =
{
{ 0, 0, 2, 4, 40, 25, 9, 16, TEXT,     "40x25        16        Text        9x16      0        -"    , 0 },
{ 1, 0, 2, 4, 40, 25, 9, 16, TEXT,     "40x25        16        Text        9x16      1        -", 0 },
{ 2, 0, 2, 4, 80, 25, 9, 16, TEXT,     "80x25        16        Text        9x16      2        -", 0 },
{ 3, 0, 2, 4, 80, 25, 9, 16, TEXT,     "80x25        16        Text        9x16      3        -", 0 },
{ 4, 0, 0, 2, 320, 200, 8, 8, GRFX,        "320x200       4      Graphics      8x8       4        -", 0 },
{ 5, 0, 0, 2, 320, 200, 8, 8, GRFX,        "320x200       4      Graphics      8x8       5        -", 0 },
{ 6, 0, 0, 1, 640, 200, 8, 8, GRFX,        "640x200       2      Graphics      8x8       6        -", 0 },
{ 7, 0, 2, 0, 80, 25, 9, 16, TEXT,     "80x25       mono       Text        9x16      7        -", 0 },
{0x0d, 0, 0, 4, 320, 200, 8, 8, GRFX,  "320x200      16      Graphics      8x8       D        -", 0 },
{0x0e, 0, 1, 4, 640, 200, 8, 8, GRFX,  "640x200      16      Graphics      8x14      E        -", 0 },
{0x0f, 0, 1, 0, 640, 350, 8, 14, GRFX, "640x350     mono     Graphics      8x14      F        -", 0 },
{0x10, 0, 1, 4, 640, 350, 8, 14, GRFX, "640x350      16      Graphics      8x14      10       -", 0 },
{0x11, 0, 2, 1, 640, 480, 8, 16, GRFX, "640x480       2      Graphics      8x16      11       -", 0 },
{0x12, 0, 2, 4, 640, 480, 8, 16, GRFX, "640x480      16      Graphics      8x16      12       -", 0 },
{0x13, 0, 0, 8, 320, 200, 8, 8, GRFX,  "320x200     256      Graphics      8x8       13       -", 0 } };

static char* colorTbl[25] = { "Monochrome", "2", "4", "8", "16", "32", "64", " ", "256",
			    " ", " ", " ", " ", " ", " ", "32K", "64K", " ",
			    " ", " ", " ", " ", " ", " ", "16M"};

static char* typeTbl[2] = {"  Text  ", "Graphics"};
static char ID[22];

#ifndef DESKTOP
int lookup[4] = { 2, 0, 3, 1};          // reverse option bits
char *displayOpts[72] = 
{ { "Text reverse video is enabled" },
{ "Text reverse video is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Graphics reverse video is enabled" },
{ "Graphics reverse video is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Bold font is enabled" },
{ "Bold font is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Contrast enhancement is set to Black & White" },
{ "Contrast enhancement is set to Gray Scale/Color" },
{ "Contrast enhancement is set to enable background" },
{ "Contrast enhancement is set to enable text" },
{ "Contrast enhancement is set to enable text & background" },
{ NULL },
{ "Expanded mode is enabled" },
{ "Expanded mode is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Vertical position is set to center unexpanded mode" },
{ "Vertical position is set to display unexpanded mode at the top" },
{ "Vertical position is set to display unexpanded mode at the bottom" },
{ NULL },{ NULL },{ NULL },
{ "Display type is set to panel" },
{ "Display type is set to CRT" },
{ "Display type is set to SimulSCAN" },
{ NULL },{ NULL },{ NULL },
{ "16 bit ram access is enabled" },
{ "16 bit ram access is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Inhibit font load is enabled" },
{ "Inhibit font load is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "Full height cursor is enabled" },
{ "Full height cursor is disabled" },
{ NULL },{ NULL },{ NULL },{ NULL },
{ "RGB weighting is set to 2:5:9" },
{ "RGB weighting is set to 5:2:9" },
{ "RGB weighting is set to 2:9:5" },
{ "RGB weighting is set to 5:9:2" },
{ "RGB weighting is set to 9:2:5" },
{ "RGB weighting is set to 9:5:2" }, 
{ "Stand-by mode is disabled" }, 
{ NULL },
{ NULL },
{ "Stand-by mode (memory) is enabled" },
{ "Stand-by mode (keyboard) is enabled" },
{ NULL } };
#endif

/*---------------------------------------------------------*/
/*      returns the Chip ID and revison number                                    */
/*         ex: "CL-GD5410"                                                                                        */
/*---------------------------------------------------------*/
char* getChipID()
{
	byte offset;
	char ch, ch1, ch2;
   unsigned seg = 0xc000;

	for (int i=0; i < 22; i++)
      ID[i] = ' ';
   i = 0;
	offset = *((byte far*) MK_FP(seg, 0x8));
	ch1 = *((char far*) MK_FP(seg, offset));
	ch2 = *((char far*) MK_FP(seg, offset+1));

	// if the Cirrus Logic signature is not in C000
	// assume that it's in E000
   if ((ch1 != 'C') && (ch2 != 'L') && (ch1 != 'G') && (ch2 != 'D'))
   {
      seg = 0xe000;
	offset = *((byte far*) MK_FP(seg, 0x8));
   }

	do                              // get the chipID message "CL-GD...."
	{
		ch = *((char far*) MK_FP(seg, offset));
		ID[i] = ch;
		i++; offset++;
	} while (ch != ' ');            // until we hit the space character

	return(&ID[0]);
}

/*---------------------------------------------------------*/
/*      returns the BIOS Version Number                                                   */
/*              ex: "BIOS Version 2.01"                                                                           */
/*---------------------------------------------------------*/
char* getBIOSVersion()
{
   union REGS   regs;
	char *biosVer, *majorVer, *minorVer;

   regs.h.ah = 0x12;
   regs.h.al = 0x0;                             // reset bit 7 of al for exerended function call --Sean
   regs.h.bl = 0x81;                                                    // calls BIOS extended function
   int86(0x10,&regs,&regs);                             // Inquire BIOS Version Number

   biosVer = new char[19];
   majorVer = new char[4];
   minorVer = new char[4];
	strcpy(biosVer,"BIOS Version ");
	itoa(regs.h.ah, majorVer, 10);                  // get major BIOS version
	strcat(biosVer, majorVer);
	strcat(biosVer,".");

	itoa(regs.h.al, minorVer, 16);          // get minor BIOS version
	if (regs.h.al < 0x10)
		strcat(biosVer,"0");
	strcat(biosVer,minorVer);
	return(biosVer);
}

/*---------------------------------------------------------*/
/*      returns the amount of Video Memory present                        */
/*    ex: 1024                                                                                               */
/*---------------------------------------------------------*/
int getVideoMemory()
{
   union REGS   regs;

   regs.h.ah = 0x12;
   regs.h.bl = 0x85;                                                    // calls BIOS extended function
   regs.h.al = 0x0;                                     // reset bit 7 of al for exerended function call --sean
   int86(0x10,&regs,&regs);                             // Return Installed Memory
	return(regs.h.al * 64);
}

#ifdef DESKTOP                 /* SGC, 2-25-93 */
/*---------------------------------------------------------*/
/*              Checks for 5420                            */
/*              returns : 1/0 - yes/no                     */
/*---------------------------------------------------------*/
int is5420()
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x80;                                               // inquire VGA type
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	if (regs.h.al == 0x12 || regs.h.al == 0x16) // we found a 5420
		return(1);
	return(0);
}

/*---------------------------------------------------------*/
/*              Checks for 542X/3X/5X ID                   */
/*              returns : chiptype                         */
/*---------------------------------------------------------*/
int is54XX()
{
   union REGS   regs;
   unsigned int GD54XX,vmode;

	vmode = *((byte far*) MK_FP(0, 0x449));
	regs.h.ah = 0x00;
	regs.h.al = 3;
	int86(0x10,&regs,&regs);
	outp (0x3c4,6);    /* try to unlock AVGA3 extended registers */
	outp (0x3c5,0x12);
	outp (0x3d4,0x27); /* see if AVGA3 or 2M part ID is there */
	GD54XX = (inp (0x3d5) >> 2);
	regs.h.ah = 0x00;
	regs.h.al = vmode;
	int86(0x10,&regs,&regs);

	switch (GD54XX) { // Check for cases where BIOS does not yet ID....
	  case 0x26:
	    return (6);  /* 5428 NEW REV BF  */
	  case 0x29:
	  case 0x2A:
	    return (8);  // ALPINE II (REV AA, AB...)
	  case 0x27:     // MOD5: 5429
	    return (9);
	  case 0x38:     // MOD5: NORTHSTAR I 5452/53
	    return (10);
	}

	regs.h.ah = 0x12;
	regs.h.bl = 0x80;                                               // inquire VGA type
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	switch (regs.h.al){
	  case 0x10:
	    // we found a 5401
	    return(1);
	  case 0x11:
	    // we found a 5402
	    return(2);
	  case 0x12:
	  case 0x16:
	    // we found a 5420
	    return(3);
	  case 0x13:
	    // we found a 5422
	    return(4);
	  case 0x14:
	    // we found a 5424
	    return(4);
	  case 0x15:
	    // we found a 5426 or 5428
	    regs.h.ah = 0x00;
	    regs.h.al = 3;
	    int86(0x10,&regs,&regs);
	    outp (0x3c4,6);    /* try to unlock AVGA3 extended registers */
	    outp (0x3c5,0x12);
	    outp (0x3d4,0x27); /* see if AVGA3 or 2M part ID is there */
	    GD54XX = inp (0x3d5);
	    GD54XX &= 1;
	    regs.h.ah = 0x00;
	    regs.h.al = vmode;
	    int86(0x10,&regs,&regs);
	    if (GD54XX == 0)  /* It's a 5426 */
	      return (5);
	    else
	      return (6);
	  case 0x18:
	    // we found a 5428
	    return(6);
	  case 0x17:
	    // we found a 5402r1
	    return(2);
	  case 0x30:
	    // we found a 5432              // MOD 1
	    return(7);
	  case 0x31:
	    // we found a 5434, ALPINE II   // MOD 1, and change above code to case
	    return(8);
	  }
	return(0); // Controller type unknown, 54XX
}
#endif

/*---------------------------------------------------------*/
/*              sets the horizontal monitor type                     */
/*---------------------------------------------------------*/
void setHorzMontype(byte montype)
{
   union REGS   regs;

	// don't set advanced monitor type (it doesn't exist in the BIOS)
	if (montype != (byte) MONTYPE_8) {
	   regs.h.ah = 0x12;
	   regs.h.al = montype;
		regs.h.bl = 0xA2;
	   int86(0x10,&regs,&regs);
	}
}

/*---------------------------------------------------------*/
/*              sets the vertical monitor type                       */
/*---------------------------------------------------------*/
void setVertMontype(byte f640, byte f800, byte f1024, byte f1280)
{
   union REGS   regs;
	byte max = ((f1280 == NOT_AVAILABLE) ? 2 : 3);

	regs.h.al = (f640 << 4) | max;
	regs.h.bh = (f1024 << 4) | f800;
	regs.h.ch = f1280 << 4;

   regs.h.ah = 0x12;
	regs.h.bl = 0xA4;
   int86(0x10,&regs,&regs);
}

/*---------------------------------------------------------*/
/*      checks whether the active adapter is ours            */
/*              returns : 1/0 - yes/no                               */
/*---------------------------------------------------------*/
int isCLActive()
{
   byte far *p1;
   byte egainfo;
   union REGS   regs;

	CirrusID = new char[22];
	strcpy(CirrusID, getChipID());
   if ((*CirrusID != 'C') && (*CirrusID != 'L') && (*CirrusID != 'G') && (*CirrusID != 'D'))
      return(0);

   p1 = (byte far*) MK_FP(0x00, 0x487);
   egainfo = (*p1 & 0x08) >> 3;

   if (egainfo)                                 // VGA active ?
		return(0);                                      // no

	// we're either at C000/E000 or both
	// now check to see if we're active

	// let's check function Return memory installed first
	regs.h.ah = 0x12;
	regs.h.bl = 0x85;
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	if ((regs.h.al < 4) || (regs.h.al > 64))                // < 256K or > 4M
		return(0);

	// let's check function Query video mode availability
	regs.h.ah = 0x12;
	regs.h.al = 3;                                                          // mode 3
	regs.h.bl = 0xa0;
	int86(0x10, &regs, &regs);
	if ((regs.h.ah & 1) == 0)                               // mode 3 not supported
		return(0);
	return(1);
}

/*---------------------------------------------------------------*/
/*      checks whether the Set Monitor Type function is supported  */
/*              returns : 1/0 - supported/not supported                                           */
/*---------------------------------------------------------------*/
int isMonitorTypeSupported()
{
	int supported = FALSE;

	byte monitorType = getDisplayStatus(HMONITOR);  // save current monitor type
	setHorzMontype(MONTYPE_2);
	if (getDisplayStatus(HMONITOR) == MONTYPE_2)            // did the BIOS set it ?
		supported = TRUE;                                               // sure did
	setHorzMontype(monitorType);                    // restore monitor type

	return(supported);
}

/*---------------------------------------------------------*/
/*              checks whether BIOS supports 76Hz for 1024 modes &   */
/*              60,70 Hz for 1280x1024 modes                         */
/*              returns : 1/0 - yes/no                               */
/*---------------------------------------------------------*/
int isHiFreqSupported()
{
	int support=FALSE,GD54XX;


	GD54XX = is54XX(); // MOD1, Determine if ALPINE II or not
	if (GD54XX == 8 || GD54XX >= 10)     // We found ALPINE II, 5434 (8)
	  support = TRUE;

	// if Alpine and above, hi-frequency is supported
	// you need to include this in later, call function 80h
	// get the controller type (it hasn't been define yet)
	// otherwise, use the code below with more testing

//      setVertMontype(tbl[FREQ_640].value,     tbl[FREQ_800].value,
//              F1024_76, tbl[FREQ_1280].value);
//      if (getDisplayStatus(FREQ_1024) == F1024_76)
//              support = TRUE;
//      if (tbl[HMONITOR].value != MONTYPE_8)
//              setHorzMontype(tbl[HMONITOR].value);
//      setVertMontype(tbl[FREQ_640].value,     tbl[FREQ_800].value,
//                      tbl[FREQ_1024].value, tbl[FREQ_1280].value);
	return(support);
}

/*---------------------------------------------------------*/
/*              send out the control 8 times for I/O delays          */
/*---------------------------------------------------------*/
void sendOut(byte data)
{
	for(int count=0; count < 8; count++)
		outp(0x3c5, data);
}

#ifdef DESKTOP                  // advance monitor is not supported in lap top --sean
/*---------------------------------------------------------*/
/*              checks whether an EEPROM is present by reading       */
/*              address 0 and looking for the 'CL' signature         */
/*              returns: 1/0 => Yes/No                               */
/*---------------------------------------------------------*/
int isEEPROMPresent()
{
	byte data, bit;
	word value=0;
	byte readCmd[10] = { 0, 8, 8, 0, 0, 0, 0, 0, 0, 0 };

	// For 64xx products, especially Peaven products bypass the code
	// below, since they dont have eeproms.  Peaven extd registers
	// are at 3c4, the screen will black out if you run the code below.
	if (BANKIDX == 0xE)             // 64xx
		return(0);                              // eeprom not supported

	// Enable the EEPROM
	outp(0x3c4, 8);
	data = inport(0x3c5);                   // get SR8
	data |= 0x20;                                           // latch ESYNC and EVIDEO inputs
	sendOut(data);
	data |= 0x12;                                           // enable EEPROM data and SK
	sendOut(data);
	data |= 1;                                                      // enable EEPROM CS
	sendOut(data);

	// Send Read Command to EEPROM (0110 D5..D0)
	data |= 0x33;                                           // EEPROM control
	for (int i=0; i < 10; i++) {
		data &= ~8;
		data |= readCmd[i];                     // write data bit into SR8[3]
		sendOut(data);
		data |= 4;                                              // set SK high (SR8[2]=1)
		sendOut(data);
		data &= ~4;                                             // set SK low (SR8[2]=0)
	}

	// Read EEPROM data D15..D0
	for(i=15; i >= 0; i--) {
		data &= 0x40;
		data |= 0x33;                                                   // send clock bit low
		sendOut(data);
		data |= 4;                                                              // set SK high (SR8[2]=1)
		sendOut(data);
		bit = (inp(0x3c5) & 0x80) >> 7; // SR8[7] = data
		value |= (bit << i);
	}
	outp(0x3c5, data & ~1);                 // set chip select low SR8[0] = 0

	// Disable EEPROM control
	data = (data & 0x40) | 0x33;    // send clock bit low
	sendOut(data);
	data &= ~1;                                                     // disable EEPROM CS
	sendOut(data);
	data &= ~0x12;                                          // disable EEPROM data out and CS
	sendOut(data);
	data &= ~0x20;                                          // disable EEPROM latch
	sendOut(data);

	if (value == 0x434C)                            // address 0 has 'CL' signature
		return(1);
	else return(0);                                 // EEPROM not present
}

#endif                          // desktop

/*---------------------------------------------------------*/
/*              checks to see whether any changes were made          */
/*              returns : 1/0 - yes/no                               */
/*---------------------------------------------------------*/
int isModified()
{
	if (isMontypeProduct){
		if (((tbl[HMONITOR].value == MONTYPE_8) &&
			((tbl[FREQ_640].value != tbl[FREQ_640].oldValue) ||
			 (tbl[FREQ_800].value != tbl[FREQ_800].oldValue) ||
			 (tbl[FREQ_1024].value != tbl[FREQ_1024].oldValue) ||
			 (tbl[FREQ_1280].value != tbl[FREQ_1280].oldValue)))
			|| (tbl[HMONITOR].value != tbl[HMONITOR].oldValue))
				return(1);
	}

#ifndef DESKTOP
		for(int i=TEXT_REVERSE; i <= POWER; i++)
		{
			if (tbl[i].value != tbl[i].oldValue)
				return(1);
		}                               
		if ((tbl[TIMER].value != tbl[TIMER].oldValue)
			&& (tbl[POWER].value != PM_0))
				return(1);
#endif
	return(0);
}

/*---------------------------------------------------------*/
/*              checks to see whether Vesa is supported              */
/*              returns : 1/0 - supported/not supported                           */
/*---------------------------------------------------------*/
int isVesaSupported()
{
   union REGS   regs;
   struct SREGS sregs;
   VesaInfoStruc pvesainfo;

	regs.x.ax = 0x4f00;
   regs.x.di = FP_OFF(&pvesainfo);
   sregs.es  = FP_SEG(&pvesainfo);
   int86x(0x10,&regs,&regs,&sregs);
	if (regs.h.al == 0x4f)
		return(1);
	else return(0);
}

/*---------------------------------------------------------*/
/*              Search through the list of availble modes            */
/*              returns : 0 = not supported                                                               */
/*                                       1 = supported                              */
/*              2 = non-DOS supported mode                 */
/*---------------------------------------------------------*/
int isModeSupported(int mode)
{
	modeRec *tmp;

	for (tmp = modeList; tmp != NULL; tmp = tmp->next)
	{
		if ((tmp->modenum == mode) || (tmp->vesamode == mode))
		{
			if (tmp->colors > 8)                            // non-DOS supported mode
				return(2);
			else return(1);
		}
	}
	return(0);
}

#ifndef DESKTOP
/*---------------------------------------------------------*/
/*              Checks for 6410/6420 below rev BE                    */
/*              returns : 1/0 - yes/no                                         */
/*---------------------------------------------------------*/
int is6410()
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x80;                                               // inquire VGA type
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	if ((regs.h.al != GD6410) && (regs.h.al != GD6420))
		return(0);

	regs.h.ah = 0x12;
	regs.h.bl = 0x82;                                               // inquire GD64xx revision code
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	if (regs.h.al > 0x7d)                           // rev BE
		return(1);
	return(0);
}

/*---------------------------------------------------------*/
/*              returns : 1/0 - 6341 or 6342/not Peaven product      */
/*---------------------------------------------------------*/
int isPeaven()
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x80;                               // inquire VGA type
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);

	if ((regs.h.ah & 0x02) >> 1)
		return(1);
	else return(0);
}
#endif

/*---------------------------------------------------------*/
/*      calls the BIOS to see if the mode is available       */
/*    exit: inserts mode record to linked list if found   */
/*---------------------------------------------------------*/
void getExtdMode(int mode)
{
   union REGS   regs;
   struct SREGS segregs;
   byte far *color;
   word far *horz;
   word far *vert;
   byte far *hght;
   byte far *wdth;
   byte far *type;
   char vr[5], hr[5], charwd[2], charht[3];
   char res[12];
	char m[4], font[6];

   regs.h.ah = 0x12;
   regs.h.al = (byte) mode;
   regs.h.bl = 0xA0;                                                                    // calls BIOS extended function
   int86x(0x10, &regs, &regs, &segregs);

   if ((regs.h.ah & 0x01) != 0)                                 // mode is supported
   {
      horz = (word far*) MK_FP(segregs.es, regs.x.di+3);        // horzres
      vert = (word far*) MK_FP(segregs.es, regs.x.di+5);        // vertres
      color = (byte far*) MK_FP(segregs.es, regs.x.di+7);       // #colors
      wdth = (byte far*) MK_FP(segregs.es, regs.x.di+8);                // char height
      hght = (byte far*) MK_FP(segregs.es, regs.x.di+9);                // char width
      type = (byte far*) MK_FP(segregs.ds, regs.x.si+62);

		modeRec *ptr = new modeRec;

      ptr->modenum = mode;
		if (isVesaProduct)
			ptr->vesamode = *((word far*) MK_FP(segregs.es, regs.x.di+1));
		else ptr->vesamode = 0;
		ptr->scanline = 2;                                      // 400 scanlines
      ptr->type = *type & 1;

      ptr->horzres = (int) (*horz);
      ptr->vertres = (int) (*vert);
		ptr->cellwidth = *wdth;
		ptr->cellheight = *hght;

      if (ptr->type == TEXT)
      {
			 ptr->horzres /= (int) ptr->cellwidth;
			 ptr->vertres /= (int) ptr->cellheight;
      }
      itoa(ptr->vertres, vr, 10);
      itoa(ptr->horzres, hr, 10);

	strcpy(res, hr);
      strcat(res,"x");
      strcat(res, vr);

      itoa((int)(*wdth), charwd, 10);
      itoa((int)(*hght), charht, 10);
      strcpy(font, charwd);
      strcat(font, "x");
      strcat(font, charht);
		if (strlen(font) < 4)
			strcat(font, " ");

      ptr->colors = *color;

		int spaces = 13 - (strlen(res) + strlen(colorTbl[int(*color)]));
		for(int i=0; i < spaces; i++)
			strcat(res, " ");
      strcpy(ptr->info, res);

      strcat(ptr->info, "  ");
      strcat(ptr->info, colorTbl[int(*color)]);
      strcat(ptr->info, "      ");
      strcat(ptr->info, typeTbl[int(ptr->type)]);
      strcat(ptr->info, "      ");
      strcat(ptr->info, font);
      strcat(ptr->info, "      ");
      strcat(ptr->info, itoa(mode, m, 16));
      strcat(ptr->info, "      ");
		if (ptr->vesamode != 0)
			strcat(ptr->info, itoa(ptr->vesamode, m, 16));
		else strcat(ptr->info, " -");
      if (modeList == NULL)     // first record in linked list
      {
			modeList = ptr;
			modeList->next = NULL;
      }
      else
      {
			ptr->next = modeList;
			modeList = ptr;
      }
   }            // mode available
}

/*-------------------------------------------------------------*/
/*    inserts mode record to linked list if availble                            */
/*-------------------------------------------------------------*/
void getStdmode(int i)
{
   byte far *p1;
   byte far *p2;
   byte egainfo, misc, cores;

   p1 = (byte far*) MK_FP(0x00, 0x489);
   egainfo = *p1 & 0x01;

   p2 = (byte far*) MK_FP(0x00, 0x487);
   misc = (*p2 & 0x02) >> 1;

   if (egainfo)
      cores = 0;                                                // no co-res adapter present
   else
   {
      if (!misc) cores = 1;             // monochrome co-res adapter present
      else cores = 2;                           // color co-res adapter present
   }

	// if (co_res = NONE)
	//              then standard_modes_list = ALL
	//              else if (co_res = MONOCHOROME)
	//                         then standard_modes_list = ALL except MONO_MODES
	//                              else if (co_res = COLOR)
	//                                        then standard_modes_list = MONO_MODES only

   if ((cores == 1) && (stdmode[i].colors == 0))
	      ;                 // don't include monochrome modes in the linked list
	else if ((cores == 2) && (stdmode[i].colors >= 1))
	      ;                 // don't include color modes in the linked list
   else 
		{
		   modeRec *ptr = new modeRec;
	 ptr->modenum = stdmode[i].modenum;
			ptr->vesamode = stdmode[i].vesamode;
			ptr->scanline = stdmode[i].scanline;
			ptr->colors =  stdmode[i].colors;
			ptr->horzres = stdmode[i].horzres;
			ptr->vertres = stdmode[i].vertres;
			ptr->cellwidth = stdmode[i].cellwidth;
			ptr->cellheight = stdmode[i].cellheight;
			ptr->type =  stdmode[i].type;
			strcpy(ptr->info, stdmode[i].info);
	 ptr->next = modeList;
			modeList = ptr;
	   }
}

/*---------------------------------------------------------*/
/*              gets the #scanlines from the BIOS Data Area          */
/*---------------------------------------------------------*/
byte getScanlines()
{
   byte far *p1;
	byte charheight;

   p1 = (byte far*) MK_FP(0x00, 0x485);
   charheight = *p1;
	if (charheight == 16)
		return(2);                                      // 400 scanlines
	else if (charheight == 14)
		return(1);                                      // 350 scanlines
	else return(0);                         // 200 scanlines
}

/*---------------------------------------------------------*/
/*              displays application name and copyright message      */
/*---------------------------------------------------------*/
void printHeader()
{
	system("cls");
#ifndef DESKTOP
	printf("%s%s\n", filename, " Utility Program Version 2.30p Beta2"); // laptop
#else
	printf("%s%s\n", filename, " Utility Program Version 2.33d"); // desktop
#endif
   printf("Copyright (C) Cirrus Logic Inc., 1992-1993.\n\n");
}

/*---------------------------------------------------------*/
/*              sets the mode by calling int 10h                                                          */
/*              flag=TRUE => display Header & mode#                  */
/*---------------------------------------------------------*/
void setMode(int mode, byte lines, boolean flag)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.al = lines;                                      // 0/1/2 = 200/350/400 scanlines
	regs.h.bl = 0x30;
	int86(0x10, &regs, &regs);                      // sets the scanlines

	if (mode >= 0x100)
	{
		regs.h.ah = 0x4f;                                       // Super VGA support
		regs.h.al = 0x02;                                       // set vesa mode
	   regs.x.bx = mode;
	}
	else
	{
		regs.h.ah = 0x00;
	   regs.h.al = (byte) mode;
	}
   int86(0x10,&regs,&regs);

	if (flag) {
		printHeader();
		printf("Mode %x has been set.\n", mode);
	}
}

/*---------------------------------------------------------*/
/*              waits for a keyboard interrupt                       */
/*---------------------------------------------------------*/
void haltScreen()
{
		printf("\nPress almost any key to continue...\n");
		bioskey(0);
}

/*---------------------------------------------------------*/
/*         prints the list of modes supported                   */
/*---------------------------------------------------------*/
void printModeHelp()
{
	delete modeList;                                // free the pointer to be safe
	modeList = NULL;                                // initialize it
	// Get the list of modes available
    for(int mode=0x7f; mode >= 0x14; mode--)
       getExtdMode(mode);
    for(mode=(MAXSTD-1); mode >= 0; mode--)
	    getStdmode(mode);

	modeRec *ptr = modeList;
	printf("\nSupported video modes:\n");
	for (int i=0; ptr != NULL; ptr=ptr->next, i++) {
		if ((dosMode != 0x5f) && (dosMode > 0x13) && ((i % 10) == 0)) printf("\n");
		printf("%4x    ", ptr->modenum);
	}

	for(ptr=modeList; ptr != NULL; ptr=ptr->next) {
		if (ptr->vesamode != 0) {
		if ((dosMode != 0x5f) && (dosMode > 0x13) && ((i % 10) == 0))
			printf("\n");
			printf("%4x    ", ptr->vesamode);
			i++;
		}
	}

	printf("\n");
}

#ifndef DESKTOP
void printConfHelp()
{
	printf("\nValid VGA Configuration user options keywords:\n");
   printf("TEXT/NOTEXT\t\t\tEnable/Disable text reverse video\n");
   printf("GRFX/NOG\t\t\tEnable/Disable graphics reverse video\n");
   printf("BOLD/NOBOLD\t\t\tEnable/Disable bold mode\n");
   printf("BLACK\t\t\t\tEnable Black & White enhancement\n");
   printf("GRAY\t\t\t\tEnable Gray Scale/Color enhancement\n");
   printf("BACK\t\t\t\tEnable backgound enhancement\n");
   printf("TXT\t\t\t\tEnable text enhancement\n");
   printf("BKFRGND\t\t\t\tEnable text/background enhancement\n");
   printf("EXPAND/NOEXPAND\t\t\tEnable/Disable expand mode\n");
   printf("CENTER\t\t\t\tCenter unexpanded mode\n");
   printf("TOP\t\t\t\tDisplay unexpanded mode from top\n");
   printf("BOTTOM\t\t\t\tDisplay unexpanded mode from bottom\n");
   printf("PANEL\t\t\t\tSwitch the display to panel\n");
   printf("CRT\t\t\t\tSwitch the display to CRT\n");
   printf("SimulSCAN\t\t\tDisplay on CRT and panel simultaneously\n");
   printf("16BIT/NO16BIT\t\t\tEnable/Disable 16 bit operation\n");
   printf("NOI/INHFONT\t\t\tEnable/Disable font load when switch display\n");
   printf("FULLHGT/NOFULLHGT\t\tEnable/Disable full height cursor\n");
	if (!isPeaven())
	   printf("W259/W529/W295/W925/W952\tSelect RGB weighting\n");
}
#endif

void printMonitorHelp()
{
		printf("\nValid monitor types:\n");
		printf(" 0  VGA\n");
		printf(" 1  8514\n");
		printf(" 2  Super VGA\n");
		printf(" 3  Extended Super VGA\n");
		printf(" 4  Multifrequency\n");
		printf(" 5  Extended Multifrequency\n");
		printf(" 6  Super Multifrequency\n");
		printf(" 7  Extended Super Multifrequency\n");
}

void printHelp()
{
#ifndef DESKTOP
	if (isMontypeProduct)
		printf("\nUsage: %s%s\n", filename, " [[modenum][+*-]] [m[montype] | t6=x t8=x t1=x t2=x] [[s n k=xx c=xx] | v[option]]\n");
	else
		printf("\nUsage: %s%s\n", filename, " [modenum][+*-] [[s n k=xx c=xx] | v[option]]");
#else
	if (isMontypeProduct)
		printf("\nUsage: %s%s\n", filename, " [[modenum][+*-]] [m[montype] | t6=x t8=x t1=x t2=x] \n");
	else
		printf("\nUsage: %s%s\n", filename, " [modenum][+*-]\n");
#endif

   printf("[modenum]    mode number\n");
   printf("[+*-]        + selects 400 lines (default) \n");
   printf("             * selects 350 lines \n");
   printf("             - selects 200 lines \n");

	if (isMontypeProduct) {
	   printf("[montype]    monitor type\n");
		printf("t6=x(Hz)     640x480   @ (0 = 60, 1 = 72)\n");          
		printf("t8=x(Hz)     800x600   @ (0 = 56, 1 = 60, 2 = 72)\n");
		if (isHiFreqProduct) {
			printf("t1=x(Hz)     1024x768  @ (0 = 87i, 1 = 60, 2 = 70, 3 = 72)\n");  // MOD1
			printf("t2=x(Hz)     1280x1024 @ (0 = 87i, 1 = 60, 2 = Not available)\n"); // MOD1
		}
		else {
#ifdef DESKTOP        /* SGC, 2-26-93 */
		      if (is5420() == 0){
#endif
			printf("t1=x(Hz)     1024x768  @ (0 = 87i, 1 = 60, 2 = 70, 3 = 72)\n");
			printf("t2=x(Hz)     1280x1024 @ (0 = 87i, 1 = Not available)\n");              
#ifdef DESKTOP        /* SGC, 2-26-93 */
		      }
		      else
			printf("t1=x(Hz)     1024x768  @ (0 = 87i, 1 = 60, 2 = 70)\n");
#endif
		}
	}

#ifndef DESKTOP
	char *str=itoa(minTimer,str, 10);
	printf("[option]     VGA Configuration user option\n");
	printf("s            Give status information.\n");
	printf("n            Disable power save mode and back to normal operation.\n");
	if (isMontypeProduct)
		haltScreen();
	printf("k=xx         Set stand-by timer for keyboard to xx minutes.\n");
	printf("c=xx         Set stand-by timer for no CPU video access to xx minutes.\n");
	printf("             (xx = %s..63 minutes.)\n",str);
#endif

#ifdef DESKTOP
	if (isMontypeProduct)
		haltScreen();
#endif

	printf("\nExample:\n");
	printf("%s%s\n", filename, " 3+              (sets mode 3+)");
	if (isMontypeProduct) {
		printf("%s%s\n", filename, " m2              (sets Super VGA monitor type)");
		printf("%s%s\n", filename, " t6=0 t8=2       (sets 640x480 at 60 Hz, 800x600 at 72 Hz)");
	}                                    /* 2.30 beta 2, t6, t8 use to be f6, f8 above */

#ifndef DESKTOP
		printf("%s%s\n", filename, " vBOLD vTEXT     (enable bold mode and text reverse video)");
#endif

	if (isMontypeProduct)
		printMonitorHelp();

#ifndef DESKTOP
	if (isMontypeProduct)
		haltScreen();
		printConfHelp();
#endif
}

#ifndef DESKTOP
/*---------------------------------------------------------*/
/*              sets Text Reverse Video option                       */
/*              entry   : 0/1 = enabled/disabled                                                          */
/*---------------------------------------------------------*/
void setTextReverse(byte text)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x89;
	byte value = (text << 1) | tbl[GRFX_REVERSE].value;
	regs.h.al = lookup[value];
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Graphics Reverse Video option                   */
/*              entry   : 0/1 = enabled/disabled                                                          */
/*---------------------------------------------------------*/
void setGrfxReverse(byte grfx)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x89;
	grfx |= (tbl[TEXT_REVERSE].value << 1);
	regs.h.al = lookup[grfx];
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Bold Mode option                                */
/*---------------------------------------------------------*/
void setBold(byte bold)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x8b;
	regs.h.al = bold;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Contrast Enhancement option                     */
/*---------------------------------------------------------*/
void setContrast(byte contrast)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x8c;
	regs.h.al = contrast;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Expand Mode option                              */
/*---------------------------------------------------------*/
void setExpand(byte expand)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x8f;
	regs.h.al = expand;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Vertical Positioning Control                    */
/*---------------------------------------------------------*/
void setPosition(byte position)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x90;
	regs.h.al = position;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Display type                                    */
/*---------------------------------------------------------*/
void setDisplay(byte dmode)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x92;
	regs.h.al = dmode;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Force 8-bit operation option                    */
/*---------------------------------------------------------*/
void setBus(byte bus)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x93;
	regs.h.al = bus;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Full Height Cursor                              */
/*---------------------------------------------------------*/
void setCursor(byte cursor)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x97;
	regs.h.al = cursor;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Power Management mode                           */
/*---------------------------------------------------------*/
void setPowerManagement(byte powerMode)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x94;
	regs.h.al = powerMode;
	regs.h.al &= 0x7f;              // reset bit 7 of al for exerended function call --sean

	if (powerMode == PM_0)
		tbl[TIMER].value = minTimer;

	regs.h.bh = tbl[TIMER].value;

	if (is6410())
	{
		if (tbl[TIMER].value == minTimer)
			regs.h.bh+=2;
		else if ((tbl[TIMER].value % 4) != 3)
			regs.h.bh++;
	}
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets RGB Weighting                                   */
/*---------------------------------------------------------*/
void setRGBWeight(byte rgb)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x95;
	regs.h.al = rgb;
	int86(0x10, &regs, &regs);
}

/*---------------------------------------------------------*/
/*              sets Inhibit Font Load                               */
/*---------------------------------------------------------*/
void setInhibitFont(byte font)
{
   union REGS   regs;

	regs.h.ah = 0x12;
	regs.h.bl = 0x96;
	regs.h.al = font;
	int86(0x10, &regs, &regs);
}
#endif

/*---------------------------------------------------------*/
/*              gets current display status                          */
/*---------------------------------------------------------*/
byte getDisplayStatus(int option)
{
   union REGS   regs;
	int value;

	regs.h.ah = 0x12;
	regs.h.bl = 0x9a;
	regs.h.al = 0x0;                        // reset bit 7 of al for exerended function call --sean
	int86(0x10, &regs, &regs);
	
	switch (option)
	{
		case HMONITOR :
			value = ((regs.x.ax >> 2) & 0x07);
			if ((tbl[HMONITOR].value == MONTYPE_8) || ((value == 0) && ((tbl[FREQ_640].value != 0) || (tbl[FREQ_800].value != 0)
				|| (tbl[FREQ_1024].value != 0) || (tbl[FREQ_1280].value != 0))))
				value = MONTYPE_8;
			break;
		case FREQ_640 :
			value = ((regs.h.ah & 0x40) >> 6);
			break;
		case FREQ_800 :
			value = ((regs.h.ch & 0x18) >> 3);
			break;
		case FREQ_1024 :
			value = ((regs.h.ch & 0xe0) >> 5);
			break;
		case FREQ_1280 :
			byte vres = (regs.h.al & 0x60) >> 5;
			if (vres < 2)                   // 480 or 600 scanlines
				value = 0;
			else if (vres == 2)     // 768 scanlines
				value = NOT_AVAILABLE;
			else                                            // 1024 scanlines
				value = (regs.h.cl & 0x30) >> 4;
			break;
#ifndef DESKTOP
		case TEXT_REVERSE :
			value = ((regs.h.ah & 0x08) >> 3);              // 0 = enable, 1 = disable
			break;
		case GRFX_REVERSE :
			value = ((regs.h.bl & 0x80) >> 7);              // 0 = enable, 1 = disable
			break;
		case  BOLD :
			value = ((regs.h.ah & 0x20) >> 5);              // 0 = enable, 1 = disable
			break;
		case CONTRAST :
			value = (regs.h.bl & 0x07);
			break;
		case EXPAND :
			value = ((regs.h.ah & 0x02) >> 1);              // 0 = enable, 1 = disable
			break;
		case POSITION :
			value = (regs.h.al & 0x03);
			break;
		case DISPLAY :
			value = ((regs.h.bh & 0x02) >> 1);
			value = ( (value == 0) ?        2 : (regs.h.ah & 0x01));
			break;
		case BUS :                                                                                      
			value = ((regs.h.ah & 0x04) >> 2);              // 0 = enable, 1 = disable
			break;
		case INHIBIT :                                                                                  
			value = ((regs.h.bh & 0x08) >> 3);              // 0 = enable, 1 = disable
			break;
		case CURSOR :
			value = ((regs.h.bh & 0x04) >> 2);              // 0 = enable, 1 = disable
			break;
		case RGB :
			value = ((regs.h.bl & 0x38) >> 3);              
			break;
		case POWER :
			value = (regs.h.ch & 0x07);
			break;
		case TIMER :
			value = (regs.h.cl & 0x3f);
			break;
#endif
	}

	return(value);
}

#ifndef DESKTOP
/*---------------------------------------------------------*/
/*              prints current display status                        */
/*---------------------------------------------------------*/
void printDisplayStatus(boolean all)
{
	int opt;

	for(int i=TEXT_REVERSE; i <= POWER; i++)
	{
		if ((all) || (tbl[i].value != tbl[i].oldValue))
		{
			// RGB option is not supported for Peaven products
			if (isPeaven() && (i == RGB)) ;
			else {
				opt = (i-5) * 6 + getDisplayStatus(i);
				printf("%s\n", displayOpts[opt]);
			}
		}
	}

	// display standby timer if power management is enabled
	if ((!all) && (tbl[POWER].value != PM_0))
	{
		char str[4];
		int sbtimer = (int) tbl[TIMER].value;
		itoa(sbtimer, str, 10);
		printf("Power Save Timer = %s minutes\n", str);

	}
}
#endif

/*---------------------------------------------------------*/
/*              returns the command-line keyword options             */
/*              ex: C:\UTIL\CLMODE m5 vCRT vBOL vTEX c=12            */ 
/*---------------------------------------------------------*/
char* getUpdate()
{
	int opt;
	char *str = new char[MAXLINE];
	char mt[7], ft[21];
	strcpy(str, filepath);
	strcat(str, filename);

#ifndef DESKTOP
	for(int i=TEXT_REVERSE; i <= RGB; i++) {
		if ((tbl[i].value != tbl[i].oldValue) || (tbl[i].bootupValue != 0xff)) {
			if (tbl[i].value != tbl[i].oldValue)
			opt = (i-2) * 6 + getDisplayStatus(i);
			else    opt = (i-2) * 6 + tbl[i].bootupValue;
				strcat(str, " v");
				strcat(str, confKey[opt].string);
		}
	}

	char timer[2];
	byte value;

	// power management option changed or timer is changed
	if ((tbl[POWER].value != tbl[POWER].oldValue) ||
		((tbl[TIMER].value != tbl[TIMER].oldValue) && 
		(tbl[POWER].value != PM_0)))
	{
		value = tbl[POWER].value;
		strcpy(timer,itoa((int) getDisplayStatus(TIMER), timer, 10));
	}       // insert pm with bootup value
	else if (tbl[POWER].bootupValue != 0xff)
	{
		value = tbl[POWER].bootupValue;
		strcpy(timer,itoa((int) tbl[TIMER].bootupValue, timer, 10));
	}       // don't do anything
	else value = 0xff;

	switch (value)
	{
		case PM_0:
			strcat(str, " n");
			break;
		case PM_1:
		case PM_2:
			break;
		case PM_3:
			strcat(str, " c=");
			strcat(str, timer);
			break;
		case PM_4:
			strcat(str, " k=");
			strcat(str, timer);
		default:
			break;
	}
#endif

	// user wants to save montype or montype is being saved in autoexec.bat
	if      (isMontypeProduct) 
	{
		if (tbl[HMONITOR].value == MONTYPE_8) {
			for(int q=0, t=FREQ_640; t <= FREQ_1280; t++){
			       // if ((tbl[t].oldValue != tbl[t].value) || (tbl[t].bootupValue != 0xff)){  // 232d, 6-23-93
					ft[q++] = ' '; ft[q++] = 't';                                      // put all the time
					switch (t){
						case FREQ_640:
							ft[q++] = '6';
							break;
						case FREQ_800:
							ft[q++] = '8';
							break;
						case FREQ_1024:
							ft[q++] = '1';
							break;
						case FREQ_1280:
							ft[q++] = '2';
							break;
					};
					ft[q++] = '=';

					// get display status all the time 232d, 6-23-93
					//if (tbl[t].oldValue != tbl[t].value)

						ft[q++] = (int) getDisplayStatus(t) + 0x30;

					//else
					//        ft[q++] = tbl[t].bootupValue;
			     //   }     // end if statement
			}               // end for loop
			ft[q++] = '\n'; ft[q] = 0;
			strcat(str, ft);
		}               // end if statement
		else if ((tbl[HMONITOR].oldValue != tbl[HMONITOR].value) || (tbl[HMONITOR].bootupValue != 0xff)) {
			if (tbl[HMONITOR].oldValue != tbl[HMONITOR].value)
				mt[2] = (int) tbl[HMONITOR].value + 0x30;
			else
				mt[2] = tbl[HMONITOR].bootupValue;
			mt[0] = ' '; mt[1] = 'm'; mt[3] = '\n'; mt[4] = 0;
			strcat(str, mt);
		}
	}
	else    strcat(str, "\n");
	return(str);
}

/*---------------------------------------------------------*/
/*              returns: 0/1 - not clmode line/ clmode line          */
/*---------------------------------------------------------*/
int findLine(char* line)
{
#ifndef DESKTOP
	boolean foundKey=FALSE;
	char stimer[2]="  ";
	int k=0;
#endif
	char ch;
	int i=0,j=0;
	boolean foundLine=FALSE;

	// line is commented out
	if (((line[0] == 'r') || (line[0] == 'R')) && ((line[1] == 'e') || (line[1] == 'E')) && ((line[2] == 'm') || (line[2] == 'M')))
		return(0);
	for(; i <= strlen(line); i++, j++)
	{
		if (islower(line[i])) ch = line[i] - 0x20;
			else ch = line[i];
		if (ch == filename[0])          // found a match on the first char
		{
			j=0;
			do{
				i++;j++;
				if (islower(line[i])) ch = line[i] - 0x20;
					else ch = line[i];
			} while ((j < strlen(filename)) && (ch == filename[j]));

			if ((j >= strlen(filename)) && (line[i] == ' '))
			{                                                               // found the string "filename"
			foundLine = TRUE;
				do {
					switch (line[i])
					{
						case 'm':               // monitor type
						case 'M':
							i++;
							tbl[HMONITOR].bootupValue = line[i++];
							break;
						case 't':               // vertical monitor timings
						case 'T':
							i++;
							if (line[i] == '6')                     // 640x480
								tbl[FREQ_640].bootupValue = line[i+2];
							else if (line[i] == '8')        // 800x600
								tbl[FREQ_800].bootupValue = line[i+2];
							else if (line[i] == '1')        // 1024x768
								tbl[FREQ_1024].bootupValue = line[i+2];
							else if (line[i] == '2')        // 1280x1024
								tbl[FREQ_1280].bootupValue = line[i+2];
							i+=2;
							break;
#ifndef DESKTOP
						case 'v':
						case 'V':
							i++;
							keyword[0] = line[i++];
							keyword[1] = line[i++];
							keyword[2] = line[i++];
							k=0;
							foundKey=FALSE;
							do
							{
								if ((stricmp(keyword, confKey[k].string)) == 0) foundKey=TRUE;
								else k++;
							} while ((!foundKey) && (k < MAXKEYWORD));
							if (foundKey)
								tbl[confKey[k].option].bootupValue = confKey[k].value;
							break;
						case 'n':
						case 'N':
							tbl[POWER].bootupValue = PM_0;
							i++;
							break;
						case 'c':
						case 'C':
						case 'k':
						case 'K':
							if ((line[i] == 'c') || (line[i] == 'C'))
								tbl[POWER].bootupValue = PM_3;
							else tbl[POWER].bootupValue = PM_4;
							i+=2;           // skip the '='
							stimer[0] = line[i++];
							if (line[i] != ' ') stimer[1] = line[i];
							tbl[TIMER].bootupValue = (byte) atoi(stimer);
							break;
#endif
						case ' ':
						default:
							i++;
							break;
					};      // switch case
				} while (i <= strlen(line));
			}               // end foundKey
		}
	}
	if (foundLine)
		return(1);
	return(0);
}

/*-------------------------------------------------------------*/
/*              includes the new monitor type settings in autoexec.bat  */
/*-------------------------------------------------------------*/
void updateAutoexec()
{
	FILE *in, *out;
	char inFile[16] =  " :\\AUTOEXEC.BAT";
	char outFile[16] = " :\\AUTOEXEC.TMP";
	char *s = getenv("COMSPEC");

	// if comspec environment not at drive A/B/C, default to be drive C
	char drive = (s[0] > 'C') ? 'C' : s[0];
	inFile[0] = outFile[0] = drive;

	char newline[MAXLINE];
	if ((in = fopen(inFile, "rt+")) == NULL)
	{       // autoexec.bat file doesn't exist, open one
		in = fopen(inFile, "wt+");
		strcpy(newline, getUpdate());
		fwrite(newline, strlen(newline), 1, in);
		fclose(in);
	}
	else 
	{
		if ((out = fopen(outFile, "wt+")) == NULL)
			printf("Cannot open %s\n", outFile);

		int addline = TRUE;                             // add clmode line to autoexec.bat
		char *line=new char[MAXLINE];
		while (fgets(line,MAXLINE,in))
		{
			if (!findLine(line))            // copy the same line to output file
				fwrite(line, strlen(line), 1, out);
			else            // update clmode line to output file
			{
				addline = FALSE;
				strcpy(newline, getUpdate());
				fwrite(newline, strlen(newline), 1, out);
			}
		}

		if (addline)
		{
			strcpy(newline, getUpdate());
			fwrite(newline, strlen(newline), 1, out);
		}

		fclose(in);
		fclose(out);
		if (remove(inFile) != 0)
			perror("remove");
		if (rename(outFile, inFile))
			perror("rename");
	}
	updatedMessage = TRUE;
}

/*---------------------------------------------------------*/
/*              sets the cursor position to (x,y)                    */
/*---------------------------------------------------------*/
void setCursor(int x, int y)
{
    union REGS  regs;

    regs.h.ah = 2;
    regs.h.bh = 0;
    regs.h.dh = y;
    regs.h.dl = x;
    int86(0x10,&regs,&regs);
}

/*---------------------------------------------------------*/
/*              writes a dot at coordinate (x,y)                     */
/*---------------------------------------------------------*/
void writeDot(int x, int y, int color)
{
   union REGS   regs;

	regs.h.ah = 0x0c;
	regs.h.al = color;
	regs.h.bh = 0;
	regs.x.cx = x;
	regs.x.dx = y;
   int86(0x10,&regs,&regs);

}

/*---------------------------------------------------------*/
/*              writes character and attribute at cursor             */
/*---------------------------------------------------------*/
void writeChar(char ch,int count)
{
    union REGS  regs;

    regs.h.ah = 9;
    regs.h.al = ch;
    regs.h.bh = 0;
    regs.h.bl = 0x07;
    regs.x.cx = count;
    int86(0x10,&regs,&regs);
}

/*---------------------------------------------------------*/
/*              sets the 64K bank                                    */
/*---------------------------------------------------------*/
void setBank (byte bank)
{
	outp(0x3ce, BANKIDX);
	outp(0x3cf, bank);
}

/*---------------------------------------------------------*/
/*              draws a box around the screen                        */
/*---------------------------------------------------------*/
void drawBox(int wColumns, int bRows, int wFont, byte type)
{
	int x,y;

	if (type > 1)                           // for Hi-color modes type = byteperpixel
	{                                                               // otherwise, type = GRFX or TEXT
		word byte_per_scan = ((type == 3) ? 0x800 : wColumns*8*type);
		byte WHITE = ((type == 2) ? 0x7f : 0xff);
		byte bank = 0;
		word lastoffset=0, offset;
		if (bRows == 37) bRows++;                       // for 800x??? modes

		setBank(0);
		mem.plane.byte = 0;

		for(int i=0; i < wColumns*8*type; i++, mem.plane.byte++)
			*mem.pixels = WHITE;

		for(y=0; y < bRows*wFont; y++)
		{
			mem.plane.byte = y * byte_per_scan;
			if (lastoffset > mem.plane.byte) { bank++; setBank(bank*BANKSIZE); }
			lastoffset = mem.plane.byte;
			for(i=0; i < type; i++, mem.plane.byte++)
				*mem.pixels = WHITE;
			mem.plane.byte += (wColumns*8-1)*type - type;
			if (lastoffset > mem.plane.byte) { bank++; setBank(bank*BANKSIZE); }
			lastoffset = mem.plane.byte;
			for(i=0; i < type; i++, mem.plane.byte++)
				*mem.pixels = WHITE;
		}
		mem.plane.byte = (bRows*wFont-1)*byte_per_scan;
		if (bRows == 38) mem.plane.byte=0x9fc0;
		for(i=0; i < wColumns*8*type; i++, mem.plane.byte++)
			*mem.pixels = WHITE;
	}
	else if (type == TEXT)
	{
	   setCursor(0x00,0x00);
	   writeChar('',1);
	   setCursor(0x01,0x00);
	   writeChar('',wColumns-2);
	   setCursor(wColumns-1,0x00);
	   writeChar('',1);

	   setCursor(0x00,bRows-1);
	   writeChar('',1);
	   setCursor(0x01,bRows-1);
	   writeChar('',wColumns-2);
	   setCursor(wColumns-1,bRows-1);
	   writeChar('',1);

	   for(int i=1;i<bRows-1;i++)
		{
			setCursor(0x00,i);
			writeChar('',1);
			setCursor(wColumns-1,i);
		   writeChar('',1);
	   }
	}
	else                            // graphics mode with write dot BIOS support
	{
		for(x=0; x < wColumns*8; x++) {
			writeDot(x,0,0x0f);
			writeDot(x,bRows*wFont-1,0x0f);
		}               
		for(y=0; y < bRows*wFont; y++) {
			writeDot(0,y,0x0f);
			writeDot(wColumns*8-1,y,0x0f);
		}               
	}
}

/*---------------------------------------------------------*/
/*              displays CGA color bars                              */
/*---------------------------------------------------------*/
void displayCGAColors(int wColumns)
{
	for(word color=0, i= 0x1590; color <= 0xff; color+=0x55,i+=19)
		for(int j=0; j < 13; j++) {
			for(int k=0; k < 19; k++, mem.plane.byte++) {
				mem.plane.byte = i+j*wColumns*2+k;
				*mem.pixels = color;
			}
			for(k=0; k < 19; k++, mem.plane.byte++) {
				mem.plane.byte = i+j*wColumns*2+0x2000+k;
				*mem.pixels = color;
			}
		}
}

/*---------------------------------------------------------*/
/*              displays 16 color bars                               */
/*---------------------------------------------------------*/
void display16Colors(int wColumns, int wRows)
{
	int lines = ((wRows > 25 ) ? 50 : 25);
	int i_init = ((wColumns > 80) ? wColumns*50+4 : 28/8+16*wColumns);
	int width = 8, i=i_init;

	outp(0x3ce, 5);
	byte value = inport(0x3cf);
	outp(0x3cf, 2);                                 // write mode 2

	for(byte color=0; color < 16; color++, i=i+width)
	{
		if ((color % 4) == 0)
			i = wColumns * (lines/3) * color + i_init;

		for(int j=0; j < lines; j++) {
			for(int k=0; k < width-1; k++, mem.plane.byte++) {
				mem.plane.byte = i+j*wColumns+k;
				*mem.pixels = color;
			}
		}
	}

	outp(0x3ce,5);
	outp(0x3cf, value);                             // restore write mode
}

/*---------------------------------------------------------*/
/*              writes a dot a (x,y) for extd 256-color modes        */
/*---------------------------------------------------------*/
void extended256WriteDot(int x, int y, word wColumns, word color)
{
asm {
		push    es
		push    di
		push    ax
		push    cx
		push    dx

		mov     cx,x
		mov     dx,y
		mov     ax,0a000h                       // video memory segment
		mov     es,ax                                   // setup for ES:DI write
		mov     ax,wColumns                     // get bytes/scanline
		shl     ax,1                                    // multiply #columns
		shl     ax,1                                    // by 8 to get the 
		shl     ax,1                                    // bytes per scanline
		mul     dx                                              // compute start of line
		add     ax,cx                                   // add offset to pixel
		adc     dl,0                                    // get the bank#
		mov     di,ax                                   // offset of pixel

		mov     al, BANKSIZE
		mul     dl
		mov     ah, al                          // bank #
		mov     al, BANKIDX
		mov     dx, 3ceh
		out     dx,ax

		mov     ax,color
		mov     es:[di],al                      // and write it

		pop     dx
		pop     cx
		pop     ax
		pop     di
		pop     es
	}
}

/*---------------------------------------------------------*/
/*              displays 256 color bars                              */
/*---------------------------------------------------------*/
void display256Colors(int wColumns, int bRows)
{
	int lines = ((wColumns > 40) ? bRows/2-1 : 9);
	int width = ((wColumns > 40) ? wColumns*8/32 : 20);
	int i, xline=0, yline = 0;

	for(word color=0, x=0, y=0; color < 256; color++, xline+=width)
	{
		if (((color % (wColumns*8/width)) == 0) && (color > 0))
			{       xline = 0; yline+=(lines+1); }
		for(y=yline; y < yline+lines; y++)
			for (x=xline, i=0; i < width-1; i++, x++) {
				extended256WriteDot(x, y, wColumns, color);
		}
	}
}

/*---------------------------------------------------------*/
/*              displays 15 and 16-bit colors                        */
/*---------------------------------------------------------*/
void displayHiColors(int maxbank, int maxcolors, word horzres)
{
	byte hi_byte, lo_byte, bank=0;
	word count;

	switch (horzres) {
		case 1280:          // MOD1, added for ALPINE II,Mode 75h
			count = 4;
			break;
		case 1024:
			count = 4;
			break;
		case 800:
			count = 5;
			break;
		case 640:
			count = 2;
			break;
		default:
			count = 1;
			break;
	}

   mem.plane.byte = 0;

	for(word colors=0; bank <= maxbank; colors++)
	{
		lo_byte = (colors & 0x00ff);
		hi_byte = ((colors & 0xff00) >> 8);

		for(int i=0; i < count*2; i++) {
			*mem.pixels = lo_byte;
			 mem.plane.byte++;
			if (mem.plane.byte == 0)
				{       bank++; setBank(bank*BANKSIZE); }
			*mem.pixels = hi_byte;
			 mem.plane.byte++;
			if (mem.plane.byte == 0)
				{       bank++; setBank(bank*BANKSIZE); }
		}
		if ((maxcolors == 15) && (colors >= 0x7fff)) colors=0;
	}                                                                 
}
/*---------------------------------------------------------*/
/*              displays 24-bit colors                               */
/*---------------------------------------------------------*/
void display16MColors(byte vmode)
{
	word R,G,B,B2,toff,loop,offset,L,loop_end,lines;
	byte bank;

	switch (vmode){
		case 0x70:
			loop_end = 0;
			L = 2;
	lines = 0xC7; /* 200 lines */
		break;
	   case 0x71:
	loop_end = 1;
	L = 1;
	lines = 0xFF; /* 480 lines */
		   break;
	}

	mem.plane.byte = 0;
	bank = 0;
   R = G = B = B2 = 0;
   offset = 0xFF;
   for (B = 0; B <= lines; B++) {
		for (loop = 0; loop <= loop_end; loop ++) {
			R = G = 0;
			for (R = 0; R <= 0xFF; R+=L) {
				*mem.pixels = B;
				mem.plane.byte += 1;
				*mem.pixels = G;
				mem.plane.byte += 1;
				*mem.pixels = R;
				if (mem.plane.byte >= 0xfffd)
					{ bank++; setBank(bank*BANKSIZE); }
				mem.plane.byte += 1;
	      }
	   for (G = 0; G <= 0xFF; G+=L) {
				*mem.pixels = B;
				mem.plane.byte += 1;
				*mem.pixels = G;
				mem.plane.byte += 1;
				*mem.pixels = 0xFF;
				if (mem.plane.byte >= 0xfffd)
					{ bank++; setBank(bank*BANKSIZE); }
				mem.plane.byte += 1;
	      }
      G = R = 0xFF;
      for (B2 = 0; B2 <= 0xFF; B2+=(L*2)) {
			*mem.pixels = B;
			mem.plane.byte += 1;
			*mem.pixels = G;
			mem.plane.byte += 1;
			*mem.pixels = R;
			if (B2 <= offset)
			  R -= L;
			if (mem.plane.byte >= 0xfffd)
				{ bank++; setBank(bank*BANKSIZE); }
			mem.plane.byte += 1;
      }
	    if(vmode == 0x70){
	   toff = mem.plane.byte;
	mem.plane.byte += 1088;
	      if (mem.plane.byte < toff)
				{ bank++; setBank(bank*BANKSIZE); }
	    }
	 if(vmode == 0x71){
	      toff = mem.plane.byte;
	      mem.plane.byte += 128;
	      if (mem.plane.byte < toff)
				{ bank++; setBank(bank*BANKSIZE); }
	    }
    }
    offset -= 1;
  }
}

#ifdef DESKTOP
// MOD1, added all 32-bit code that follows
/*---------------------------------------------------------*/
/*              displays 32-bit colors                               */
/*---------------------------------------------------------*/
// 32Bit support routines:

unsigned int GetTrueColorFullOffset ()  // derived from CR13 & CR1B
  {                        // for 32-bit, this may require X2
  unsigned int t1,t2,SR7;

  outp (0x3d4,0x1b);
  t1 = inp (0x3d5) & 0x10;
  if (t1 == 0x10)
    t1 = 2048;
  else
    t1 = 0;
  outp (0x3d4,0x13);
  t2 = inp (0x3d5) * 8;  // by character width
  t1 = t1 + t2;
  outp (0x3c4,0x7);
  SR7 = inp (0x3c5) & 8;  // see if 32bit overlay mode is set
  if (SR7 == 8)
    t1 *= 2;    // If 32-bit, hardware multiples CR1B & CR13 by 2
  return t1;
  }

void CheckPageBoundaryB (int psize) // Check for and set page boundary
  {
  if (mem.plane.byte == 0xffff){
    GRX = GRX + psize; /* adjust for each pass */
    setBank (GRX);
    mem.plane.byte = 0;
  }
  else
    mem.plane.byte += 1;
  }

void display32BitColors(int horzres,int vertres)
{
    unsigned int x,y,xres,yres,voffset,bpp,b1,b2,b3,GRB;
    unsigned int temp,temp2,vpage,tbytes,ebytes,CR1B,page_size;
    unsigned int fbytes;

    outp (0x3ce,0xb);
    GRB = inp (0x3cf) & 0x20;  /* find if granularity has been changed */
    if (GRB == 0x20)           /* 2 or 4 Meg modes have 16K pages */
      page_size = 4;
    else                       /* modes <= 1 Meg have 64K pages */
      page_size = 0x10;
    vpage = 0;
    setBank (vpage);

    ebytes = 0;

    x = tbytes = horzres;
    y = vertres;
    fbytes = GetTrueColorFullOffset ();
    bpp = 32;
    tbytes *= 4;
    ebytes = fbytes - tbytes;

    GRX = 0;
    mem.plane.segment = 0xA000;
    mem.plane.byte = b1 = b2 = b3 = 0;
    for (yres = 0;yres < y;yres++) {
      for (xres = 0;xres < x;xres++){
       if(yres == 0 || yres == (y-1) || xres == 0 || xres == (x-1)){
	 *mem.pixels = 0xff;
	 CheckPageBoundaryB (page_size);
	 *mem.pixels = 0xff;
	 CheckPageBoundaryB (page_size);
	 *mem.pixels = 0xff;
	 CheckPageBoundaryB (page_size);
	   // SKIP WRITE OF ALPHA BYTE LAST
	 CheckPageBoundaryB (page_size);
       }
       else {
	 *mem.pixels = b1;
	 CheckPageBoundaryB (page_size);
	 *mem.pixels = b2;
	 CheckPageBoundaryB (page_size);
	 *mem.pixels = b3;
	 CheckPageBoundaryB (page_size);
	   // SKIP WRITE OF ALPHA BYTE LAST
	 CheckPageBoundaryB (page_size);
       }
       b1 += 1;
      }
      b1 = 0;
      b2 += 1;
      if (b2 == 256)
	b2 = 0;
      if (b2 == 0)
	b3 ^= 0xff;
      if (bpp == 24 || bpp == 32){
	for (temp2 = 0;temp2 < ebytes;temp2++) {
	  temp = mem.plane.byte;
	  mem.plane.byte += 1;
	  if (mem.plane.byte < temp)
	    setBank (vpage += page_size);
	}
      }
    }

  setBank (0);
}

#endif

/*---------------------------------------------------------*/
/*              displays the character set                           */
/*---------------------------------------------------------*/
void displayFont(int wColumns, int bRows, byte type)
{
	int x,y;
	int ch;
	int xStart = ((type) ? wColumns/2 : wColumns/2 - 17);
	int yStart = ((bRows > 25) ? bRows/4+2 : 2);
	word offset;
	byte attr=0;

	if ((wColumns == 40) && (bRows == 25)) xStart=3;
	if (type && (wColumns == 80) && (bRows == 25)) yStart=5;
	for (ch=0,x=xStart,y=yStart; ch < 256; ch++,x++)
	{
		if (type == TEXT) {
			mem.plane.byte = (x + y*wColumns) * 2;
			*mem.pixels = ch;
			mem.plane.byte++;
			*mem.pixels = attr;
		}
		else {
			setCursor(x, y);
			writeChar(ch, 1);
		}
		if ((ch % 16) == 0) attr++;
		if (x >= (xStart+32)) { x = xStart; y+=2; }
	}
}

/*---------------------------------------------------------*/
/*              gets the font pointer from ROM BIOS                  */
/*---------------------------------------------------------*/
void getFontOffset()
{
	struct REGPACK regs;

	regs.r_ax = 0x1130;                                     // get 8x16 font
	regs.r_bx = 0x0600;
   intr(0x10, &regs);
	char_segment = regs.r_es;
	char_8x16_offset = regs.r_bp;

	regs.r_ax = 0x1130;                                     // get 8x14 font
	regs.r_bx = 0x0200;
   intr(0x10, &regs);
   char_8x14_offset = regs.r_bp;

	regs.r_ax = 0x1130;                                     // get 8x8 font
	regs.r_bx = 0x0300;
   intr(0x10, &regs);
   char_8x8_offset = regs.r_bp;

}

/*---------------------------------------------------------*/
/*              calculates 2^x                                       */
/*---------------------------------------------------------*/
int pow2(int x)
{
	int value=1;
	for(int i=0; i < x; i++)
		value   *= 2;
	return(value);
}

/*---------------------------------------------------------*/
/*              writes a character in Hi-Color mode                  */
/*---------------------------------------------------------*/
void writeHCChar(int x, int y, int ch, int font, byte colors, 
				byte byte_per_pixel, int columns)
{
	word char_offset;
	byte data, expon, bit, bank, pixel;
	byte BLACK=0, WHITE = ((colors == 15) ? 0x7f : 0xff);
	word byte_per_scan = ((colors == 24) ? 0x800 : columns*8*byte_per_pixel);
#ifdef DESKTOP                    // MOD1, for 32-bit modes
	unsigned int SR7,GR9;
	outp (0x3c4,7);
	SR7 = inp (0x3c5) & 8;
	if (SR7 == 8) {  // 32 bit mode set
	  byte_per_scan = GetTrueColorFullOffset ();
	  columns = byte_per_scan / 8;
	  byte_per_pixel = 4;
	  outp (0x3ce,0xb);
	  GR9 = inp (0x3cf) & 0x20;
	  if (GR9 == 0x20)
	    BANKSIZE = 4;
	  else
	    BANKSIZE = 0x10;
	}
#endif
	double offset = (double)x*(double)byte_per_pixel + (double)y*(double)columns*8;
	bank = offset/65536;

	setBank(bank*BANKSIZE);                         // last bank

	if (font == 16)
		char_offset = (char_8x16_offset + (ch * font));
	else if (font == 14)
		char_offset = char_8x14_offset + ch * font;
	else 
		char_offset = char_8x8_offset + ch * font;

	for(int i=0; i < font; i++, char_offset++)
	{
		data = *((byte far*) MK_FP(char_segment, char_offset));
		for(int j=7, offs=offset, lastoffs=offs; j >= 0; j--) {
			expon = (unsigned char) pow2(j);
			bit = (data & expon) >> j;
			if (bit)        pixel = WHITE;
			else pixel = BLACK;
			for (int i=0; i < byte_per_pixel; i++, offs++) {
				if (lastoffs > offs) { bank++; setBank(bank*BANKSIZE); }
				lastoffs = offs;
				mem.plane.byte = offs;
				*mem.pixels = pixel;
			}
		}
		offset += byte_per_scan;
		if (offset/65536 >= (bank+1)) { bank++; setBank(bank*BANKSIZE); }
	}
}

/*---------------------------------------------------------*/
/*              writes a string in Hi-Color mode                     */
/*---------------------------------------------------------*/
void writeHCString(int x, int y, char *str, int font, byte color, int columns)
{
	int i=0;
	byte byte_per_pixel;

	if (color == 24) {
		y*=font;
		byte_per_pixel = 3;
		columns = 0x100;
	}
	else {
		byte_per_pixel = 2;
		y = y*font*byte_per_pixel;
	}

	while (str[i]) {
		writeHCChar(x*8, y, str[i], font, color, byte_per_pixel, columns);
		x++; i++;
	}
}

/*---------------------------------------------------------*/
/*              inserts 16-color graphics modes above mode 12 into   */
/*    the mode16List for verifying monitor frequency       */
/*---------------------------------------------------------*/
void getmode16List()
{
	delete modeList;                                // free the pointer to be safe
	modeList = NULL;                                // initialize it
	// Get the list of modes available
    for(int mode=0x7f; mode >= 0x14; mode--)
       getExtdMode(mode);
    for(mode=(MAXSTD-1); mode >= 0; mode--)
	    getStdmode(mode);

	delete mode16List;
	mode16List = NULL;
	modeRec *last=NULL;
	for (modeRec *pt = modeList; pt != NULL; pt = pt->next) {
		if ((pt->modenum >= 0x12) && (pt->colors == 4) && (pt->type == GRFX)) {
			modeRec *tmp = new modeRec;
			tmp->modenum = pt->modenum;
			tmp->vesamode = pt->vesamode;
			tmp->scanline = pt->scanline;
			tmp->colors = pt->colors;
			tmp->horzres = pt->horzres;
			tmp->vertres = pt->vertres;
			tmp->cellwidth = pt->cellwidth;
			tmp->cellheight = pt->cellheight;
			tmp->type = pt->type;
			if (mode16List == NULL) {
				mode16List = tmp;
				mode16List->next = NULL;
				last = tmp;
			}
			else {
				last->next = tmp;
				tmp->next = NULL;
				last = tmp;
			}
		}
	}
}

#ifdef DESKTOP   // MOD2, CENTERING FOR DESKTOP ONLY

/*---------------------------------------------------------*/
/*              get default regs & set limits              */
/*---------------------------------------------------------*/
unsigned int SetRegsFromTable(byte mode)
{
unsigned int DEFAULT_CR10CR4,CR4,CR11,CR10,MISC,CT,i;  // MOD4

outp (0x3d4,0x11);
CR11 = inp (0x3d5);
if ((CR11 & 0x80) == 0x80){
  outp (0x3d5,CR11 ^ 0x80);
}
outp (0x3d4,4);    // horizontal
DEFAULT_CR10CR4 = inp (0x3d5);
outp (0x3d4,0x10); // vertical
DEFAULT_CR10CR4 = (inp (0x3d5) << 8) + DEFAULT_CR10CR4;

DEFAULT_MISC = inp (0x3CC);  // MOD4, Misc. Output Reg. (Polarity)

// check table here first, changing montype should erase this table

CT = i = 0;
while (CT != 0xFF) {          // TABLE = MODE#,CR10 Value,CR4 Value,
  CT = CenteringTable [i];            // Polarity (bits 7:6 of 3C2)
  if (CT == 0xFF){
    CR10 = (DEFAULT_CR10CR4 & 0xFF00) >> 8;
    CR4 = DEFAULT_CR10CR4 & 0xFF;
    MISC = DEFAULT_MISC;
    break;
  }
  if (CT == mode){
    CR10 = CenteringTable [i+1];
    CR4 = CenteringTable [i+2];
    MISC = CenteringTable [i+3]; // MOD4, Polarity
    break;
  }
  else
    i += 4;
}

outp (0x3d4,4);
outp (0x3d5,CR4);
outp (0x3d4,0x10);
outp (0x3d5,CR10);
outp (0x3d4,0x11);
outp (0x3d5,CR11);
outp (0x3C2,MISC); // MOD4, misc. output, polarity...

POLARITY = ((inp(0x3CC)) & 0xC0) >> 6;  // get polarity bits

return(DEFAULT_CR10CR4);
}

/*---------------------------------------------------------*/
/*              adjusts the mode requested                 */
/*---------------------------------------------------------*/
void MonitorAdjust(int key,byte mode,int horzres,byte colors,unsigned int DCR10CR4)
{
unsigned int CR4,CR11,CR10,MISC,CT;

unsigned int     R640 = 0x53;     // CR4 LOW LIMITS, 542X, 3X
unsigned int R640_64K = 0x54;
unsigned int     R800 = 0x68;
unsigned int    R1024 = 0x85;
unsigned int    R1280 = 0xA5;

unsigned int RIGHTLIMIT,LEFTLIMIT,TOPLIMIT, BOTTOMLIMIT;

CurrentOffset = 0;
for (CT = 0; CT < 80; CT+=4){
  if (CenteringTable [CT] == 0xFF){
    CenteringTable [CT] = mode;
    CenteringTable [CT+4] = 0xFF; // new end of table
    CT += 1;
    CtableTotal++;
    break;
  }
  if (CenteringTable [CT] == mode){
    CenteringTable [CT] = mode;
    CT += 1;
    break;
  }
  CurrentOffset++;
}

// VERTICAL FIRST

  TOPLIMIT = ((DCR10CR4 & 0xFF00) >> 8) + 10;  // CR10 LIMIT of +-10 from BIOS default
  BOTTOMLIMIT = ((DCR10CR4 & 0xFF00) >> 8) - 10;
  outp (0x3d4,0x10);     // if mode value in table, get table value, not BIOS value
  CR10 = inp (0x3d5);
  switch (key) {
   case 72:      // UP
    if (CR10 < TOPLIMIT)
      CR10++;
  break;
  case 80:      // DOWN
    if (CR10 > BOTTOMLIMIT)
      CR10--;
  break;
  }
  CenteringTable [CT] = CR10;
  outp (0x3d4,0x10);
  outp (0x3d5,CR10);


// HORIZONTAL SECOND

CT += 1;
switch (horzres) {
  case 640:
    if (colors != 16)
      RIGHTLIMIT = R640;
    else
      RIGHTLIMIT = R640_64K;
  break;
  case 800:
    RIGHTLIMIT = R800;
  break;
  case 1024:
    RIGHTLIMIT = R1024;
  break;
  case 1280:
    RIGHTLIMIT = R1280;
  break;
}
LEFTLIMIT = (DCR10CR4 & 0xFF) + 3;  // CR4 LIMIT of 3+ from BIOS default

outp (0x3d4,0x11);
CR11 = inp (0x3d5);
if ((CR11 & 0x80) == 0x80){
  outp (0x3d5,CR11 ^ 0x80);
}

outp (0x3d4,4);     // if mode value in table, get table value, not BIOS value
CR4 = inp (0x3d5);
switch (key)
  {
  case 75:      // LEFT
    if (CR4 < LEFTLIMIT)
      CR4++;
  break;
  case 77:      // RIGHT
    if (CR4 > RIGHTLIMIT)
      CR4--;
  break;
  }
CenteringTable [CT] = CR4;

// POLARITY THIRD   // MOD 4:

CT += 1;
MISC = inp (0x3CC); // MISC OUTPUT REGISTER (7:6 = V:H polarity)
POLARITY = (MISC & 0xC0) >> 6;
switch (key)
  {
  case 73:      // PGUP
    if (POLARITY < 3)
      POLARITY++;
    else
      POLARITY = 0; // wraparound
  break;
  case 81:      // PGDN
    if (POLARITY > 0)
      POLARITY--;
    else
      POLARITY = 3; // wraparound
  break;
  }
MISC = MISC & 0x3F;  // AND off 7:6 bits
MISC = (POLARITY << 6) + MISC;  // Add on new polarity
CenteringTable [CT] = MISC;  // MOD4 END


outp (0x3c2,MISC); // MOD4, Polarity
outp (0x3d4,4);
outp (0x3d5,CR4);
outp (0x3d4,0x11);
outp (0x3d5,CR11);
}

int getBIOSVersionNum () // Get number, not string
{
   union REGS   regs;

   regs.h.ah = 0x12;
   regs.h.al = 0x0;                             // reset bit 7 of al for exerended function call --Sean
   regs.h.bl = 0x81;                            // calls BIOS extended function
   int86(0x10,&regs,&regs);                     // Inquire BIOS Version Number
   return(regs.x.ax);
}

GetCRTCReg(int r)                                      /* read a CRTC register */
{
	outp( *ADDR_6845, r );
	return inp( *ADDR_6845+1 );
}

GetATCReg(int r)                    /* get an Attribute Controller register */
{
union REGS regs;
struct SREGS sregs;

	regs.x.ax = 0x1007;
	regs.h.bh = 0;
	regs.h.bl = r;
	int86x(0x10,&regs,&regs,&sregs);
	return regs.h.bh;
}

void GetAndSetPtableB (int k) // Get the Supplemental table & save to COM
  {
  byte far *p1,*p2,*p3,*p4;
  unsigned int STSEG,STOFF;
  unsigned int i,vmode,SRE;

  p1 = (byte far*) MK_FP(0x0, 0x449); // GET MODE NUMBER SET
  vmode = *p1;
  if (vmode == 0x58)
    vmode = 0x6A;   // Mode 58h uses VESA 6A tables when set
  p1 = (byte far*) MK_FP(0x40, 0xA8);
  p2 = (byte far*) MK_FP(0x40, 0xA9);
  p3 = (byte far*) MK_FP(0x40, 0xAA);
  p4 = (byte far*) MK_FP(0x40, 0xAB);
  STOFF = ((*p2 << 8) + *p1) - 0xC;   // PTR To SUPP PTR
  STSEG = (*p4 << 8) + *p3;
  p1 = (byte far*) MK_FP(STSEG, STOFF);
  p2 = (byte far*) MK_FP(STSEG, STOFF+1);
  p3 = (byte far*) MK_FP(STSEG, STOFF+2);
  p4 = (byte far*) MK_FP(STSEG, STOFF+3);
  STOFF = (*p2 << 8) + *p1;    // PTR TO FIRST ENTRY IN SUPP TABLE (MODE)
  STSEG = (*p4 << 8) + *p3;
  for (i = 0; i < 0x500; i+=28){  // FIND MODE FIRST
    p1 = (byte far*) MK_FP(STSEG, STOFF);
    if (*p1 == vmode) {
      STOFF += 0x13;  // check if SRE = was currently set
      p1 = (byte far*) MK_FP(STSEG, STOFF);
      STOFF -= 0x13;
      outp (0x3c4,0xE);
      SRE = inp (0x3c5);
      if (*p1 == SRE)
	goto TableFound;
    }
    STOFF += 28;
  }
  goto TableNotFound;
  TableFound:
  for (i = 0;i <= 27;i++) {
    p1 = (byte far*) MK_FP(STSEG, STOFF);
    ptableB [i+k] = *p1;
    if (i == 0xC)  // Adjust this value, so BIOS doesn't fixup RAM table
      ptableB [i+k] = 0xF0 + CurrentOffset; // Fixup off---offset to param table
    STOFF++;
  }
  TableNotFound:
  STSEG = STOFF = 0;
  }

void GetAndSaveModeParameters (int columns,int rows,int charheight)
  {                                           // Originally Based on RC.EXE code
  int i,j,k;

  j = CurrentOffset * 64;
  k = CurrentOffset * 28;

  //------------------ PTABLEA, EXTENDED STANDARD PARAMETERS -----------------

  ptableA [0+j] = columns;    // Get and store extended standard table first
  ptableA [1+j] = rows-1;     // This already has CR4 adjusted value....
  ptableA [2+j] = charheight;
  ptableA [3+j] = 0xFF;  /* page size 0 */
  ptableA [4+j] = 0xFF;  /* page size 1 */
  for (i = 5;i <= 8;i++) {        /* get sequencer registers */
    outp (0x3c4,i-4);
    ptableA [i+j] = inp (0x3c5);
  }
  ptableA [9+j] = inp (0x3CC);  /* misc reg */
  for(i=0x00;i<=0x18;i++)         /* get CRTC regs */
    ptableA[(i+10)+j] = GetCRTCReg(i);
  for(i=0x00;i<=0x13;i++)         /* get ATC regs */
    ptableA[(i+35)+j] = GetATCReg(i);
  for(i=0x00;i<=0x08;i++){        /* get GRC regs */
    outp(0x3CE,i);
    ptableA[(i+55)+j] = inp(0x3CF);
  }

  //------------------ PTABLEB, SUPPLEMENTAL PARAMETERS ----------------------

  GetAndSetPtableB (k);
  }

int Is_RAMTableLoaded (void)  // Determine if TSR CENTER.COM is active
  {
  byte far *p1,*p2,*p3,*p4,*p5,*p6;
  unsigned int STSEG,STOFF;

  p1 = (byte far*) MK_FP(0x40, 0xA8);
  p2 = (byte far*) MK_FP(0x40, 0xA9);
  p3 = (byte far*) MK_FP(0x40, 0xAA);
  p4 = (byte far*) MK_FP(0x40, 0xAB);
  STOFF = ((*p2 << 8) + *p1) - 0x14;   // PTR To ROM table, if it's there
  STSEG = (*p4 << 8) + *p3;
  p5 = (byte far*) MK_FP(STSEG, STOFF+4);
  p6 = (byte far*) MK_FP(STSEG, STOFF+5);

  if ((*p5 + *p6) != 0)  // Unload TSR, 40:A8 points back to ROM tables
    return (TRUE);
  else
    return (FALSE);
  }

void TSR_unload (void)  // Determine if TSR CENTER.COM is active & unload now
  {
  byte far *p1,*p2,*p3,*p4,*p5,*p6;
  unsigned int STSEG,STOFF;
  union REGS   regs;
  struct SREGS sregs;

  p1 = (byte far*) MK_FP(0x40, 0xA8);
  p2 = (byte far*) MK_FP(0x40, 0xA9);
  p3 = (byte far*) MK_FP(0x40, 0xAA);
  p4 = (byte far*) MK_FP(0x40, 0xAB);
  STOFF = ((*p2 << 8) + *p1) - 0x14;   // PTR To ROM table, if it's there
  STSEG = (*p4 << 8) + *p3;
  p1 = (byte far*) MK_FP(STSEG, STOFF);
  p2 = (byte far*) MK_FP(STSEG, STOFF+1);
  p3 = (byte far*) MK_FP(STSEG, STOFF+2);
  p4 = (byte far*) MK_FP(STSEG, STOFF+3);
  p5 = (byte far*) MK_FP(STSEG, STOFF+4);
  p6 = (byte far*) MK_FP(STSEG, STOFF+5);

  if ((*p5 + *p6) != 0){  // Unload TSR, 40:A8 points back to ROM tables
    pokeb (0x40,0xA8,*p1);
    pokeb (0x40,0xA9,*p2);
    pokeb (0x40,0xAA,*p3);
    pokeb (0x40,0xAB,*p4);
    regs.x.ax = 0x4900;   // Unload TSR from memory
    sregs.es  = STSEG;
    int86x(0x21,&regs,&regs,&sregs);
  }
  }

void ClearAllTables (void) // Clear CR4 table, and PTABLES A & B for Centering
  {                      // In CLMODE, CENTER.COM, & TSR (if active)
  unsigned int toffset;

  CtableTotal = CurrentOffset = 0;
  CenteringTable [0] = 0xFF;
  for (toffset = 0; toffset < 0x400; toffset++){
    ptableA [toffset] = 0;
    if (toffset < 0x1B0)
      ptableB [toffset] = 0;
  }
  }

#endif

/*---------------------------------------------------------*/
/*              previews the mode requested                          */
/*---------------------------------------------------------*/
void preview(byte mode, boolean only16)
{
	byte colors, cellwidth, cellheight, type;
	int horzres, vertres, exit, key, swcurs, ckey; // MOD2 (ckey)
	boolean found=FALSE;
	union REGS regs;
	modeRec *pt;
	unsigned int SR7, DEFAULT_CR10CR4,RTL;
	int x,y;

#ifdef DESKTOP
	char *PolarityInfo=new char[32]; // MOD4
	ckey = FALSE;
#endif
	if (only16 == FALSE)
		pt = modeList;
	else 
		pt = mode16List;

	do {
		if (pt->modenum == mode) {
			cellheight = pt->cellheight;
			cellwidth = pt->cellwidth;
			type = pt->type;
			horzres = pt->horzres;
			vertres = pt->vertres;
			colors = pt->colors;
			found = TRUE;
		}
		else pt = pt->next;
	} while (!found);

	setMode(mode, 2, FALSE);

#ifdef DESKTOP     // MOD2, for CENTERING
	if (mode >= 0x58)
	  DEFAULT_CR10CR4 = SetRegsFromTable (mode);
	RTL = Is_RAMTableLoaded ();
#endif

	int columns = (type ? horzres/cellwidth : horzres);
	int rows = (type ? vertres/cellheight : vertres);

	if (mode == 7)
		mem.plane.segment = 0xB000;
	else if ((mode <= 6) || (type == TEXT))
		mem.plane.segment = 0xB800;
	else mem.plane.segment = 0xA000;

	byte byte_per_pixel = ((colors == 24) ? 3 : 2);
	if ((colors == 15) || (colors == 16))
		byte_per_pixel = 2;
	else if (colors == 24) 
		byte_per_pixel = 3;
	else byte_per_pixel = 1;

	double banks = ((double)horzres*(double)vertres)*(double)byte_per_pixel;
	banks /= ((double)65536);
	if (banks >= 16)                // 4K page for 2M modes
		BANKSIZE = 4;
	else BANKSIZE = 16;     // otherwise 16K page

	switch(colors) {
		case 2:                 // 4-color
			displayCGAColors(columns);
			break;
		case 4:                 // 16-color
			if (type == GRFX)
				display16Colors(columns, rows);
			break;
		case 8:                 // 256-color
			display256Colors(columns, rows);
			break;
		case 15:
		case 16:
			displayHiColors(banks, colors, horzres);
			break;
		case 24:
#ifdef DESKTOP
			outp (0x3c4,7);         // MOD1, for 32-bit modes
			SR7 = inp (0x3c5) & 8;  // Determine if 24 or 32 bit
			if (SR7 != 8)
			  display16MColors(mode);
			else
			  display32BitColors(horzres,vertres);
#else
			display16MColors(mode);
#endif
			break;
	}

	x = ((columns > 40) ? columns/3 : 3);
#ifdef DESKTOP  // MOD4, add line for Polarity Adjust
	if (mode < 0x58)
	  y = rows - 4;
	else
	  y = rows - 5; // Only add a line for modes 58h or higher
	if (mode >= 0x58){   // MOD 4
	  strcpy(PolarityInfo, "Polarity (V/H):   ");
	  strcat(PolarityInfo,poltype [POLARITY]);
	}
#else
	y = rows - 4;
#endif

	if (colors <= 8) {
		drawBox(columns, rows, cellheight, type);
		if ((mode != 0x13) && (mode != 0xd))
			displayFont(columns, rows, type);
		setCursor(x, y);
		printf("Mode %x %dx%d %s", mode, horzres, vertres, colorTbl[colors]);
		if (colors > 0) printf(" colors");
		setCursor(x, y+1);
		printf("Press ENTER to continue         ");
		setCursor(x, y+2);
		printf("Press ESC to return to main menu");
#ifdef DESKTOP
		if (mode >= 0x58){
		  setCursor(x, y+3);
		  printf("%s",PolarityInfo);
		}
#endif
	}
	else {                          // enter here for Hi-color modes
		getFontOffset();
#ifdef DESKTOP
		if (SR7 != 8)  // MOD1
		  drawBox(columns, rows, cellheight, byte_per_pixel);
#else
		drawBox(columns, rows, cellheight, byte_per_pixel);
#endif

		char s1[4], *info=new char[32];
		strcpy(info, "Mode ");
		strcat(info, itoa(mode, s1, 16));
		strcat(info, " ");
		strcat(info, itoa(horzres, s1, 10));
		strcat(info, "x");
		strcat(info, itoa(vertres, s1, 10));
		strcat(info, " ");
		strcat(info, colorTbl[colors]);
		strcat(info, " colors ");

		writeHCString(x, y,   "                                ", cellheight, colors, columns);
		writeHCString(x, y, info, cellheight, colors, columns);
		writeHCString(x, y+1, "Press ENTER to continue         ", cellheight, colors, columns);
		writeHCString(x, y+2, "Press ESC to return to main menu", cellheight, colors, columns);
#ifdef DESKTOP
		if (mode >= 0x58){
		  writeHCString(x, y+3,   "                                ", cellheight, colors, columns);
		  writeHCString(x, y+3, PolarityInfo, cellheight, colors, columns);
		}
#endif
	}

	// wait for the Enter key, Escape key or left mouse button
	// exit = 0 => keep waiting for one of the above
	//      = 1 => Enter or left mouse button (continue previewing next mode)
	//      = 2 => Esc or right mouse button (return to main menu)

	exit = key = 0;
	do {
		if (MouseDriverStatus == 0xFFFF) {  /* 2.30 beta 2 */
		 regs.x.ax = 3;                     /* section changed */
		 int86(0x33,&regs,&regs);
		 if ((regs.x.bx & 2) >> 1)
			exit = 2;
		 else if (regs.x.bx & 1)
			exit = 1;
		}
#ifndef DESKTOP                                  // MOD2
		if (kbhit())    key = getch();
#else
		if (kbhit()) {
		  key = getch();            // CENTERING
		  if (getBIOSVersionNum () >= 0x130){ // Must use BIOS v.1.30 or later
		    if (mode >= 0x58 && key == 0 && RTL == FALSE) {  // Extended Graphics modes only
		      key = getch ();
		      if (key == 75 || key == 77 || key == 72 || key == 80 ||
			  key == 73 || key == 81) {       // left or right arrow keys, MOD4: PgUP & PgDN keys
			if (CtableTotal <= 16) {          // Limit of 16 redefined modes
			  if (CenteringTable [0] == 0xFF){
			    ClearAllTables ();
			    TSR_unload ();
			  }
			  MonitorAdjust (key,mode,horzres,colors,DEFAULT_CR10CR4); // for horz. centering adjustment
			  if (key == 73 || key == 81){  // MOD4: Polarity was adjusted
			    if (colors <= 8) {
			      setCursor(x+18, y+3);
			      printf("%s",poltype[POLARITY]);
			    }
			    else {
			      writeHCString(x+18, y+3,"   ", cellheight, colors, columns);
			      writeHCString(x+18, y+3,poltype[POLARITY], cellheight, colors, columns);
			    }
			  }
			  ckey = TRUE;
			}
			key = 0;
		      }
		    }
		  }
		}
#endif                                           // END MOD2

		if ((key == 0x1b))
		  exit = 2;
		else if ((key == 0x0d))
		  exit = 1;
	} while (exit == 0);

	release_loop:   /* added to 2.30 beta 2 */
	regs.x.ax = 6;  /* int 33 call will clear button release status */
	regs.x.bx = 0;  /* left button */
	int86 (0x33,&regs,&regs);   /* check for mouse button pressed */
	swcurs = regs.x.ax & 1;
	if (swcurs == 1)             /* not released yet ? */
	  goto release_loop;

#ifdef DESKTOP // MOD2 Centering Parameters saved to PTABLE
	if (ckey == TRUE)
	  GetAndSaveModeParameters (horzres/cellwidth,vertres/cellheight,
	  cellheight);
#endif
	if ((exit == 1) && (pt->next != NULL)){
		preview(pt->next->modenum, only16);
	}

setMode(0x12, 2, FALSE);                                // restore desktop mode
}

