/*
Modify is noted by "231p-b5" in file clview.cpp clview.hpp clbios.cpp 
File config.cpp is rewritten

This HPP file is use to define the new data structure for laptop configuration window.
Basic concept is assume new product going to have new or different features, so we need dynamic 
configuration window layoutand dynamic feature set up for future product.
--Fab 25 ,1993  by Sean
This also take care of Help message print out and status report and command line option setting as well
--March 11,1993 by Sean

Process to add new option:
1. Setup OPTIONS & PRODT MAXOPTIONS in clview.hpp
2. Setup tbl[].option_flag in clview.cpp to specify this new function works in which enviorment
3. Setup promptCapt[] and msgCapt[] in config.hpp for window layout
4. Setup xxTokenPool[] & xxPool[] in config.hpp for operation information
5. Setup value array in config.hpp if it is not continue integer 
6. Setup objStruct in config.hpp
7. Put in new bios call and getDisplayStatus() in clbios()
8. Delete *.obj and recompiler everything.
*/
#define	value_0	0
#define	value_1	1
#define	value_2	2
#define	value_3	3
#define	value_4	4
#define	value_5	5
#define	value_6	6
#define	value_7	7
#define	value_8	8
#define	value_9	9
#define	value_A	10
#define	value_B	11

#define prodtNum 3

int dispMaskout = 0xe000;

int dispMask[3]= {
	0x4000,				// LCD available
	0x8000,				// CRT available
	0x2000				// Simul available
	};
int layoutMaskOut = 0x1800;

int layoutMask[3]= {
	0x0800,				// check button
	0x1000,				// combo box available
	0x1000				// radio button
	};

int prodtMask[4] = {
	0x0001,
	0x0002,
	0x0004,
	0x0008
     };	
int maxtime[4] ={
	64,				// 64xx 
	15,				// 62x5
	64,				// 644x
	64				// 634x
     };					 
int mintime[4] ={
	1,				// 64xx 
	1,				// 62x5
	2,				// 644x
	2				// 634x
     };					 

int comboBoxMask[9] = {
	0x0000,
	0x0000,
	0x07e0,
	0x03e0,
	0x01e0,
	0x00e0,
	0x0060,
	0x0020,
	0x0000
     };	
	
	
// ============================================
// Caption pool for all item
//

char * textRevPool[1] = {  {"Panel text reverse"} 		};
char * grfxRevPool[1] = {  {"Panel graphics reverse"}	};
char * inhibitPool[1] = {  {"Font load in disp switch"}	};
char * expdPool[1] = 	{  {"Panel expanded mode"}	};
char * cursorPool[1] =  {  {"Full height cursor"}	};
char * boldPool[1] =  	{  {"Panel bold mode"}		};
char * busPool[1] =  	{  {"16-bits bus width"}		};
char * blkwitPool[1] =  {  {"B/W enhancement"}		};
char * CRTFreqPool[1] =  {  {"CRT high refresh"}		};
char * hifreqPool[1] =  {  {"Panel low-power usage"}		};

char * textshdPool[3] = {
 	 {"NTSC"},
	 {"Green only"},
	 {"Direct mapping"}
	};

char * contrastPool[5] = {
 	 {"Black & White"},
	 {"GrayScale/Color"},
	 {"Backgnd Enh"},
	 {"Text Enh"},
	 {"Text/Bgnd Enh"}
	};

char * postPool[3] = {
	 {"Center"},
	 {"Top"},
	 {"Bottom"}
	};

char * powerPool[10] = {
	 {"Disable Power mgt"},
	 {"Standby-mem"},
	 {"Standby-keybd"},
	 {"Standby-mem & keybd"},				// gd62x5(opt 7)
	 {"Backlight-mem"},			   			// gd62x5(opt 9)
	 {"Backlight-keybd"},					// gd62x5(opt a)
	 {"Backlight-mem & keybd"},					// gd62x5(opt b)
	 {"Standby-immed"},    					// 
	 {"Backlight-immed"},					// gd62x5(opt 8)
	 {"Enable suspend"}    					// 
	};

char * dispPool[3] = {
	 {"PANEL"},
	 {"CRT"},
	 {"SIMULSCAN"}
	};

char * rgbPool[6]={
	 {"RGB(11%  30%  59%)"},
	 {"RGB(30%  11%  59%)"},
	 {"RGB(11%  59%  30%)"},
	 {"RGB(30%  59%  11%)"},
	 {"RGB(59%  11%  30%)"},
	 {"RGB(59%  30%  11%)"}
	};

char * Disable = "disable";
char * Enable = "enable";
//generical token pool
char * textTokenRevPool[4] = {  {"TRE"},{Enable},
				{"TRD"},{Disable} };

char * grfxTokenRevPool[4] = {  {"GRE"},{Enable}
				,{"GRD"},{Disable} };

char * inhibitTokenPool[4] = {  {"FLE"},{Enable},
				{"FLD"},{Disable} };

char * expdTokenPool[4] =    {  {"EXE"},{Enable},
				{"EXD"},{Disable} };

char * cursorTokenPool[4] =  {  {"FHT"},{Enable}
				,{"NFT"},{Disable} };

char * boldTokenPool[4] =    {  {"BOE"},{Enable},
				{"BOD"},{Disable} };

char * busTokenPool[4] =     {  {"16E"},{Enable},
				{"16D"},{Disable} };

char * blkwitTokenPool[4] =  {  {"BWE"},{Enable},
				{"BWD"},{Disable} };

char * CRTFreqTokenPool[4] =  {  {"HRE"},{Enable},
				{"HRD"},{Disable} };

char * hifreqTokenPool[4] =  {  {"LOW"},{"Low-power"},
				{"STD"},{"Standard"} };


char * gfxshdTokenPool[4] = {
 	 {"GNT"},{"NTSC"},
	 {"GGO"},{textshdPool[1]}
	};

char * textshdTokenPool[6] = {
 	 {"TNT"},{"NTSC"},
	 {"TGO"},{textshdPool[1]},
	 {"TDM"},{textshdPool[2]}
	};

char * contrastTokenPool[10] = {
 	 {"BLK"},{contrastPool[0]},
	 {"GRY"},{contrastPool[1]},
	 {"BAK"},{contrastPool[2]},
	 {"TXT"},{contrastPool[3]},
	 {"BKG"},{contrastPool[4]}
	};

char * postTokenPool[6] = {
	 {"CEN"},{"center"},
	 {"TOP"},{"top"},
	 {"BOT"},{"bottom"}
	};

char * powerTokenPool[18] = {
	 {"PMD"},  {powerPool[0]},
	 {"STM"},  {powerPool[1]},
	 {"STK"},  {powerPool[2]},
	 {"STB"},  {powerPool[3]},				// gd62x5(opt 7)
	 {"BLM"},  {powerPool[4]},	   			// gd62x5(opt 9)
	 {"BLK"},  {powerPool[5]},			// gd62x5(opt a)
	 {"BLB"},  {powerPool[6]}, 				// gd62x5(opt b)
	 {"STI"},  {powerPool[7]}, 				// gd62x5(opt 2)
	 {"BLI"},  {powerPool[8]}				// gd62x5(opt b)
	};

char * dispTokenPool[6] = {
	 {"PAN"}, {"panel"},
	 {"CRT"}, {"monitor"},
	 {"SIM"}, {"SimulSCAN"}
	};

char * rgbTokenPool[12]={
	 {"136"},{"RGB-1:3:6"},
	 {"316"},{"RGB-3:1:6"},
	 {"163"},{"RGB-1:6:3"},
	 {"361"},{"RGB-3:6:1"},
	 {"613"},{"RGB-6:1:3"},
	 {"631"},{"RGB-6:3:1"}
	};

// Caption for prompt
char * promptCapt[MAXOPTIONS] = {
	{NULL},				//	FREQ_640,
	{NULL},				//	FREQ_800,
	{NULL},				//	FREQ_1024,
	{NULL},				//	FREQ_1280,
	{NULL},				//	HMONITOR,
	{" REVERSE VIDEO "},		//	TEXT_REVERS
	{NULL},				//	GRFX_REVERS
	{" BOLD FONT "},		//	BOLD,
	{" CURSOR "},			//	CURSOR,
	{" EXPAND "},			//	EXPAND,
	{" FONT LOAD"},			//	INHIBIT,
	{" BUS WIDTH "},		//	BUS,
	{" PANEL POWER "},		//	HIFREQ,
	{" ENHANCEMENT "},		//	BLKWIT,
	{" 640x480 CRT Refresh"},	//	CRTFREQ,
	{"~Display"},			//	DISPLAY,
	{"Co~ntrast "},			//	CONTRAST,
	{"~Graphics Shading"},		//	GFXSHD,
	{"T~ext Shading"},		//	TEXTSHD,
	{"~Vertical Position"},		//	POSITION,
	{"~RGB Weighting"},		//	RGB,
	{"~Power Management "},		//	POWER,
//	{"~Timer (minutes): "}		//	TIMER
	{"~Timer ("}		//	TIMER
	};
	
// Caption for status and help messageprompt
char * msgCapt[MAXOPTIONS] = {
	{NULL},					//	FREQ_640,
	{NULL},					//	FREQ_800,
	{NULL},					//	FREQ_1024,
	{NULL},					//	FREQ_1280,
	{NULL},					//	HMONITOR,
	{textRevPool[0]},			//	TEXT_REVERS
	{grfxRevPool[0]},			//	GRFX_REVERS
	{boldPool[0]},				//	BOLD,
	{cursorPool[0]},			//	CURSOR,
	{expdPool[0]},				//	EXPAND,
	{inhibitPool[0]},			//	INHIBIT,
	{busPool[0]},				//	BUS,
	{hifreqPool[0]},			//	HIFREQ
	{blkwitPool[0]},			//	BLKWIT,
	{CRTFreqPool[0]},			//	BLKWIT,
	{"Display type"},			//	DISPLAY,
	{"Contrast Enh"},			//	CONTRAST,
	{"Mono panel graphics shading"},			//	GFXSHD,
	{"Mono panel text shading"},			//	TEXTSHD,
	{"Panel vertical position"},			//	POSITION,
	{"RGB weighting"},			//	RGB,
	{"Power management"},			//	POWER,
	{"Sleeping time:"}			//	TIMER
	};
	


// ============================================
//
// generic value 
//
int  gen_inhibit_Value[2] =  { value_1	 ,value_0  };
int  gen_Value[8] =  { value_0	 ,value_1  , value_2   ,  value_3  , value_4   , value_5 ,value_6, value_7 };

char * gen_textRevPool[7] = {textTokenRevPool[0] ,textTokenRevPool[1] ,textTokenRevPool[2] ,textTokenRevPool[3] ,NULL,textRevPool[0] ,NULL};

char * gen_grfxRevPool[7] = {grfxTokenRevPool[0] ,grfxTokenRevPool[1] ,grfxTokenRevPool[2] ,grfxTokenRevPool[3] ,NULL, grfxRevPool[0],NULL};

char * gen_boldPool[7]    = { boldTokenPool[0] ,boldTokenPool[1] ,boldTokenPool[2] ,boldTokenPool[3] ,NULL,boldPool[0],NULL};

char * gen_expdPool[7]    = { expdTokenPool[0] ,expdTokenPool[1] ,expdTokenPool[2] ,expdTokenPool[3] ,NULL,expdPool[0],NULL};

char * gen_busPool[7]    = { busTokenPool[0] ,busTokenPool[1] ,busTokenPool[2] ,busTokenPool[3] ,NULL,busPool[0],NULL};

char * gen_blkwitPool[7]    = { blkwitTokenPool[0] ,blkwitTokenPool[1] ,blkwitTokenPool[2] ,blkwitTokenPool[3] ,NULL,blkwitPool[0],NULL};

char * gen_CRTFreqPool[7]    = { CRTFreqTokenPool[0] ,CRTFreqTokenPool[1] ,CRTFreqTokenPool[2] ,CRTFreqTokenPool[3] ,NULL,CRTFreqPool[0],NULL};

char * gen_inhibitPool[7]    = {inhibitTokenPool[0] ,inhibitTokenPool[1] ,inhibitTokenPool[2] ,inhibitTokenPool[3] ,NULL, inhibitPool[0],NULL};

char * gen_cursorPool[7]    = { cursorTokenPool[0] ,cursorTokenPool[1] ,cursorTokenPool[2] ,cursorTokenPool[3] ,NULL,cursorPool[0],NULL};

char * gen_hifreqPool[7]    = { hifreqTokenPool[0] ,hifreqTokenPool[1] ,hifreqTokenPool[2] ,hifreqTokenPool[3] ,NULL,hifreqPool[0],NULL};

char * gen_gfxshdPool[8]	=   {gfxshdTokenPool[0] ,gfxshdTokenPool[1] ,gfxshdTokenPool[2] ,gfxshdTokenPool[3] ,NULL, textshdPool[0], textshdPool[1],NULL};			//	GFXSHD
char * gen_textshdPool[11]	=   {textshdTokenPool[0] ,textshdTokenPool[1] ,textshdTokenPool[2] ,textshdTokenPool[3] ,textshdTokenPool[4] ,textshdTokenPool[5] ,NULL
				     ,textshdPool[0],textshdPool[1],textshdPool[2],NULL};			//	TEXTSHD


char * gen_contrastPool[18] = { contrastTokenPool[0] ,contrastTokenPool[1] ,contrastTokenPool[2] ,contrastTokenPool[3] ,
				contrastTokenPool[4] ,contrastTokenPool[5] ,contrastTokenPool[6] ,contrastTokenPool[7] ,
				contrastTokenPool[8] ,contrastTokenPool[9],NULL,
				contrastPool[0], contrastPool[1], contrastPool[2], contrastPool[3], contrastPool[4], NULL };	

char * gen_postPool[12] = {    postTokenPool[0] ,postTokenPool[1] ,postTokenPool[2] ,postTokenPool[3] ,
			       postTokenPool[4] ,postTokenPool[5] ,NULL,
			       postPool[0], postPool[1], postPool[2], NULL};

char * gen_dispPool[11] = {    dispTokenPool[0] ,dispTokenPool[1] ,dispTokenPool[2] ,dispTokenPool[3] ,
			       dispTokenPool[4] ,dispTokenPool[5] ,NULL,
			       dispPool[LCD], dispPool[CRT], dispPool[SIMULSCAN], NULL};

char * gen_rgbPool[21] = {     rgbTokenPool[0] ,rgbTokenPool[1] ,rgbTokenPool[2] ,rgbTokenPool[3] ,
			       rgbTokenPool[4] ,rgbTokenPool[5] ,rgbTokenPool[6] ,rgbTokenPool[7] ,
			       rgbTokenPool[8] ,rgbTokenPool[9] ,rgbTokenPool[10] ,rgbTokenPool[11],NULL,
			       rgbPool[0], rgbPool[1], rgbPool[2], rgbPool[3], rgbPool[4], rgbPool[5],NULL };	

char * gen_powerPool[12] = {   powerTokenPool[0] ,powerTokenPool[1] ,powerTokenPool[2] ,powerTokenPool[3] ,
			       powerTokenPool[4] ,powerTokenPool[5] ,NULL,
			       powerPool[0], powerPool[1], powerPool[2], NULL};

// ============================================
//
// Condor family data area
//

// ============================================
//
// Terminator family data area
//
char * gd62x5powerPool[29] = {  powerTokenPool[0] ,powerTokenPool[1] ,powerTokenPool[2] ,powerTokenPool[3] ,
			        powerTokenPool[4] ,powerTokenPool[5] ,powerTokenPool[6] ,powerTokenPool[7] ,
				powerTokenPool[8] ,powerTokenPool[9] ,powerTokenPool[10] ,powerTokenPool[11] ,
				powerTokenPool[12] ,powerTokenPool[13] ,powerTokenPool[14] ,powerTokenPool[15], 
				powerTokenPool[16] ,powerTokenPool[17] ,NULL,
			        powerPool[0], powerPool[1], powerPool[2], powerPool[3], powerPool[4], powerPool[5],
				powerPool[6], NULL};
int  gd62x5powerValue[10] = {  value_0	 ,value_3  , value_4 ,value_7,	value_9, value_A, value_B, value_1,value_8  };



char * gd62x5postPool[8] = {    postTokenPool[0] ,postTokenPool[1] ,postTokenPool[2] ,postTokenPool[3]
			       ,NULL,
			       postPool[0], postPool[1], NULL};


/*
int  gd62x5_contrastValue[5] = {
 	 value_0,
 	 value_1,
 	 value_2,
 	 value_3,
 	 value_4
	};

char * gd62x5_contrastPool[6] = {
 	 contrastPool[0],
 	 contrastPool[1],
 	 contrastPool[2],
 	 contrastPool[3],
 	 contrastPool[4],
	 NULL
	};
*/
// ============================================
//
// Macow family data area
//
/*
int  gd644x_contrastValue[5] = {
 	 value_0,
 	 value_1,
 	 value_2,
 	 value_3,
 	 value_4
	};

char * gd644x_contrastPool[4] = {
 	 contrastPool[0],
 	 contrastPool[1],
 	 contrastPool[2],
	 NULL
	};
*/

// ============================================
//
//	Option struct area
//

objStruct  objectStruct[MAXOPTIONS*prodtNum] = { 
	// 64xx pointer area
    	{NULL			,NULL},			//	FREQ_640,
	{NULL			,NULL},			//	FREQ_800,
	{NULL			,NULL},			//	FREQ_1024,
	{NULL			,NULL},			//	FREQ_1280,
	{NULL			,NULL},			//	HMONITOR,
	{gen_textRevPool	,gen_Value},		//	TEXT_REVERS
	{gen_grfxRevPool	,gen_Value},		//	GRFX_REVERS
	{gen_boldPool		,gen_Value},		//	BOLD,
	{gen_cursorPool		,gen_Value},		//	CURSOR,
	{gen_expdPool		,gen_Value},		//	EXPAND,
	{gen_inhibitPool	,gen_inhibit_Value},		//	INHIBIT,
	{gen_busPool		,gen_Value},		//	BUS,
	{NULL			,NULL},			//	HIFREQ
	{NULL			,NULL},			//	BLKWIT
	{NULL			,NULL},			//	CRTFREQ
	{gen_dispPool		,gen_Value},		//	DISPLAY,
	{gen_contrastPool	,gen_Value},		//	CONTRAST,
	{NULL			,NULL},			//	GFXSHD
	{NULL			,NULL},			//	TEXTSHD
	{gen_postPool		,gen_Value},		//	POSITION,
	{gen_rgbPool		,gen_Value},		//	RGB,
	{gen_powerPool		,gd62x5powerValue},	//	POWER,
	{NULL			,NULL},			//	TIMER
	// 62x5 pointer area
    	{NULL			,NULL},			//	FREQ_640,
	{NULL			,NULL},			//	FREQ_800,
	{NULL			,NULL},			//	FREQ_1024,
	{NULL			,NULL},			//	FREQ_1280,
	{NULL			,NULL},			//	HMONITOR,
	{gen_textRevPool	,gen_Value},		//	TEXT_REVERS
	{gen_grfxRevPool	,gen_Value},		//	GRFX_REVERS
	{gen_boldPool		,gen_Value},		//	BOLD,
	{NULL			,NULL},			//	CURSOR,
	{gen_expdPool		,gen_Value},		//	EXPAND,
	{gen_inhibitPool	,gen_inhibit_Value},		//	INHIBIT,
	{NULL			,NULL},			//	BUS,
	{gen_hifreqPool		,gen_Value},  		//	HIFREQ
	{gen_blkwitPool		,gen_Value},  		//	BLKWIT
	{gen_CRTFreqPool	,gen_inhibit_Value},  		//	CRTFREQ
	{gen_dispPool		,gen_Value},		//	DISPLAY,
	{NULL			,NULL},			//	CONTRAST,
	{gen_gfxshdPool		,gen_Value},		//	GFXSHD
	{gen_textshdPool 	,gen_Value},		//	TEXTSHD
	{gd62x5postPool		,gen_Value},		//	POSITION,
	{NULL			,NULL},			//	RGB,
	{gd62x5powerPool	,gd62x5powerValue},	//	POWER,
	{NULL			,NULL},			//	TIMER
	// 644x pointer area
    	{NULL			,NULL},			//	FREQ_640,
	{NULL			,NULL},			//	FREQ_800,
	{NULL			,NULL},			//	FREQ_1024,
	{NULL			,NULL},			//	FREQ_1280,
	{NULL			,NULL},			//	HMONITOR,
	{gen_textRevPool	,gen_Value},		//	TEXT_REVERS
	{gen_grfxRevPool	,gen_Value},		//	GRFX_REVERS
	{gen_boldPool		,gen_Value},		//	BOLD,
	{gen_cursorPool		,gen_Value},		//	CURSOR,
	{gen_expdPool		,gen_Value},		//	EXPAND,
	{gen_inhibitPool	,gen_inhibit_Value},		//	INHIBIT,
	{gen_busPool		,gen_Value},		//	BUS,
	{NULL			,NULL},			//	HIFREQ
	{NULL			,NULL},			//	BLKWIT
	{NULL			,NULL},			//	CRTFREQ
	{gen_dispPool		,gen_Value},		//	DISPLAY,
	{gen_contrastPool	,gen_Value},		//	CONTRAST,
	{NULL			,NULL},			//	GFXSHD
	{NULL			,NULL},			//	TEXTSHD
	{gen_postPool		,gen_Value},		//	POSITION,
	{gen_rgbPool		,gen_Value},		//	RGB,
	{gen_powerPool		,gen_Value},		//	POWER,
	{NULL			,NULL}			//	TIMER
	};



// ============================================
//
//	Option Class declaration area
//
void configObj::init(objStruct * instr ,  char *msgcaption,char *caption, int count)
{					 
    tblnum = count;	
    txt = msgcaption;
    prompt = caption;
    item = instr->string;	
    itemValue=instr->value;
    int tmp;
    for ( tmp =0; item[tmp] != NULL ; tmp++ ){}
    tmp++;	
    for ( size =0; item[tmp] != NULL ; tmp++, size++ ){} 
};





