using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SX_GPIO_Demo_Cs
{
    public partial class Form1 : Form
    {
        [DllImport("SX_GPIO.dll")]
        public static extern void SetPortDir(int nPort, byte dbDir);

        [DllImport("SX_GPIO.dll")]
        public static extern byte GetPortDir(int nPort);

        [DllImport("SX_GPIO.dll")]
        public static extern byte ReadPort(int nPort);

        [DllImport("SX_GPIO.dll")]
        public static extern void WritePort(int nPort, byte dbValue);

        public const int MAX_ASCII_LENGTH = 2;
        public byte data_mark = 0;

        public int Ascii2Hex(char p)
        {
            if ((p >= '0') && (p <= '9'))
            {
                return (p - 0x30);

            }
            if ((p >= 'A') && (p <= 'F'))
            {
                return (p - 'A' + 0xa);

            }
            if (p >= 'a' && p <= 'f')
            {
                return (p - 'a' + 0xa);
            }
            return -1;
        }
        //////////////////////////////////////////////////////////////////////



        public Form1()
        {
            InitializeComponent();
        }

        private void panel1_GotFocus(object sender, EventArgs e)
        {

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            comboBox1.Text = "0";
            textBox1.Text  = "0";
            textBox2.Text  = "";
            textBox3.Text  = "0";
            textBox4.Text  = "";
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (textBox1.Text.Length == 0 || textBox1.Text.Length > MAX_ASCII_LENGTH)
            {
                MessageBox.Show("Please input 00~FF.");
                textBox1.Text = "0";
            }
        }

        private void textBox4_TextChanged(object sender, EventArgs e)
        {

        }

        private void textBox3_TextChanged(object sender, EventArgs e)
        {
            if (textBox3.Text.Length == 0 || textBox3.Text.Length > MAX_ASCII_LENGTH)
            {
                MessageBox.Show("Please input 00~FF.");
                textBox3.Text = "0";
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            byte dbDir;
            int nPort = int.Parse(comboBox1.Text);
            if (textBox1.Text != "")
            {
                if (2==textBox1.Text.Length)
                {

                    char first_ch  = Convert.ToChar(textBox1.Text.Substring(0, 1));
                    char second_ch = Convert.ToChar(textBox1.Text.Substring(1, 1));
                    int first_num  = Ascii2Hex(first_ch);
                    int second_num = Ascii2Hex(second_ch);
                    if (first_num >= 0 && second_num >= 0)
                    {
                        dbDir = byte.Parse(Convert.ToString(first_num * 16 + second_num));
                        data_mark = dbDir;
                        SetPortDir(nPort, dbDir);
                    }
                    else
                    {
                        MessageBox.Show("Please input 00~FF.");
                        textBox1.Text = "0";
                    }

                }
                if (1==textBox1.Text.Length)
                {
                    int last_num = Ascii2Hex(Convert.ToChar(textBox1.Text.Substring(0, 1)));
                    if (last_num >= 0)
                    {
                        dbDir = byte.Parse(Convert.ToString(last_num));
                        data_mark = dbDir;
                        SetPortDir(nPort, dbDir);
                    }
                    else
                    {
                        MessageBox.Show("Please input 00~FF.");
                        textBox1.Text = "0";
                    }
                }
            }
            else
            {
                textBox1.Text = "0";
                MessageBox.Show("Please input 00~FF.");
            }


        }

        private void button2_Click(object sender, EventArgs e)
        {
            byte get_data;
            int nPort = int.Parse(comboBox1.Text);
            get_data = GetPortDir(nPort);
            if (get_data >= 0 && get_data <= 255)
            {
                textBox2.Text = get_data.ToString("X"); ;
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            byte wdata;
            int nPort = int.Parse(comboBox1.Text);
            if (textBox3.Text != "")
            {
                if (2==textBox3.Text.Length)
                {
                    char first_ch  = Convert.ToChar(textBox3.Text.Substring(0, 1));
                    char second_ch = Convert.ToChar(textBox3.Text.Substring(1, 1));
                    int first_num  = Ascii2Hex(first_ch);
                    int second_num = Ascii2Hex(second_ch);
                    if (first_num >= 0 && second_num >= 0)
                    {
                        wdata = byte.Parse(Convert.ToString(first_num * 16 + second_num));
                        wdata &= data_mark;
                        WritePort(nPort, wdata);
                    }
                    else
                    {
                        MessageBox.Show("Please input 00~FF.");
                        textBox3.Text = "0";
                    }

                }
                if (1==textBox3.Text.Length)
                {
                    int last_num= Ascii2Hex(Convert.ToChar(textBox3.Text.Substring(0, 1)));
                    if (last_num >= 0)
                    {
                        wdata = byte.Parse(Convert.ToString(last_num));
                        wdata &= data_mark;
                        WritePort(nPort, wdata);
                    }
                    else
                    {
                        MessageBox.Show("Please input 00~FF.");
                        textBox3.Text = "0";
                    }
                }
            }
            else
            {
                textBox3.Text = "0";
                MessageBox.Show("Please input 00~FF.");
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            byte rdata;
            int nPort = int.Parse(comboBox1.Text);
            rdata = ReadPort(nPort);
            rdata &= (byte)(~data_mark);

            if (rdata >= 0 && rdata <= 255)
            {
                textBox4.Text = rdata.ToString("X");
            }
        }
    }
}